/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.ViewGroup;
import androidx.collection.ArrayMap;
import androidx.core.content.res.TypedArrayUtils;
import androidx.transition.ArcMotion;
import androidx.transition.AutoTransition;
import androidx.transition.ChangeBounds;
import androidx.transition.ChangeClipBounds;
import androidx.transition.ChangeImageTransform;
import androidx.transition.ChangeScroll;
import androidx.transition.ChangeTransform;
import androidx.transition.Explode;
import androidx.transition.Fade;
import androidx.transition.PathMotion;
import androidx.transition.PatternPathMotion;
import androidx.transition.Scene;
import androidx.transition.Slide;
import androidx.transition.Styleable;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import androidx.transition.TransitionSet;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TransitionInflater {
    private static final ArrayMap<String, Constructor<?>> CONSTRUCTORS;
    private static final Class<?>[] CONSTRUCTOR_SIGNATURE;
    private final Context mContext;

    static {
        CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class};
        CONSTRUCTORS = new ArrayMap();
    }

    private TransitionInflater(Context context) {
        this.mContext = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object createCustom(AttributeSet object, Class<?> clazz, String constructor) {
        ArrayMap<String, Constructor<?>> arrayMap;
        String string2 = object.getAttributeValue(null, "class");
        if (string2 == null) {
            object = new StringBuilder();
            object.append((String)((Object)constructor));
            object.append(" tag must have a 'class' attribute");
            throw new InflateException(object.toString());
        }
        try {
            arrayMap = CONSTRUCTORS;
            synchronized (arrayMap) {
            }
        }
        catch (Exception exception) {
            constructor = new StringBuilder();
            ((StringBuilder)((Object)constructor)).append("Could not instantiate ");
            ((StringBuilder)((Object)constructor)).append(clazz);
            ((StringBuilder)((Object)constructor)).append(" class ");
            ((StringBuilder)((Object)constructor)).append(string2);
            throw new InflateException(((StringBuilder)((Object)constructor)).toString(), (Throwable)exception);
        }
        {
            Constructor constructor2 = (Constructor)arrayMap.get(string2);
            constructor = constructor2;
            if (constructor2 == null) {
                Class<?> clazz2 = Class.forName(string2, false, this.mContext.getClassLoader()).asSubclass(clazz);
                constructor = constructor2;
                if (clazz2 != null) {
                    constructor = clazz2.getConstructor(CONSTRUCTOR_SIGNATURE);
                    constructor.setAccessible(true);
                    arrayMap.put(string2, constructor);
                }
            }
            return constructor.newInstance(this.mContext, object);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Transition createTransitionFromXml(XmlPullParser xmlPullParser, AttributeSet object, Transition transition) throws XmlPullParserException, IOException {
        Object object2;
        int n = xmlPullParser.getDepth();
        TransitionSet transitionSet = transition instanceof TransitionSet ? (TransitionSet)transition : null;
        block0: while (true) {
            int n2;
            object2 = null;
            while (((n2 = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n) && n2 != 1) {
                if (n2 != 2) continue;
                Object object3 = xmlPullParser.getName();
                if ("fade".equals(object3)) {
                    object3 = new Fade(this.mContext, (AttributeSet)object);
                } else if ("changeBounds".equals(object3)) {
                    object3 = new ChangeBounds(this.mContext, (AttributeSet)object);
                } else if ("slide".equals(object3)) {
                    object3 = new Slide(this.mContext, (AttributeSet)object);
                } else if ("explode".equals(object3)) {
                    object3 = new Explode(this.mContext, (AttributeSet)object);
                } else if ("changeImageTransform".equals(object3)) {
                    object3 = new ChangeImageTransform(this.mContext, (AttributeSet)object);
                } else if ("changeTransform".equals(object3)) {
                    object3 = new ChangeTransform(this.mContext, (AttributeSet)object);
                } else if ("changeClipBounds".equals(object3)) {
                    object3 = new ChangeClipBounds(this.mContext, (AttributeSet)object);
                } else if ("autoTransition".equals(object3)) {
                    object3 = new AutoTransition(this.mContext, (AttributeSet)object);
                } else if ("changeScroll".equals(object3)) {
                    object3 = new ChangeScroll(this.mContext, (AttributeSet)object);
                } else if ("transitionSet".equals(object3)) {
                    object3 = new TransitionSet(this.mContext, (AttributeSet)object);
                } else if ("transition".equals(object3)) {
                    object3 = (Transition)this.createCustom((AttributeSet)object, Transition.class, "transition");
                } else if ("targets".equals(object3)) {
                    this.getTargetIds(xmlPullParser, (AttributeSet)object, transition);
                    object3 = object2;
                } else if ("arcMotion".equals(object3)) {
                    if (transition == null) {
                        throw new RuntimeException("Invalid use of arcMotion element");
                    }
                    transition.setPathMotion(new ArcMotion(this.mContext, (AttributeSet)object));
                    object3 = object2;
                } else if ("pathMotion".equals(object3)) {
                    if (transition == null) {
                        throw new RuntimeException("Invalid use of pathMotion element");
                    }
                    transition.setPathMotion((PathMotion)this.createCustom((AttributeSet)object, PathMotion.class, "pathMotion"));
                    object3 = object2;
                } else {
                    if (!"patternPathMotion".equals(object3)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Unknown scene name: ");
                        ((StringBuilder)object).append(xmlPullParser.getName());
                        throw new RuntimeException(((StringBuilder)object).toString());
                    }
                    if (transition == null) {
                        throw new RuntimeException("Invalid use of patternPathMotion element");
                    }
                    transition.setPathMotion(new PatternPathMotion(this.mContext, (AttributeSet)object));
                    object3 = object2;
                }
                object2 = object3;
                if (object3 == null) continue;
                if (!xmlPullParser.isEmptyElementTag()) {
                    this.createTransitionFromXml(xmlPullParser, (AttributeSet)object, (Transition)object3);
                }
                if (transitionSet != null) {
                    transitionSet.addTransition((Transition)object3);
                    continue block0;
                }
                if (transition != null) {
                    throw new InflateException("Could not add transition to another transition.");
                }
                object2 = object3;
            }
            break;
        }
        return object2;
    }

    private TransitionManager createTransitionManagerFromXml(XmlPullParser xmlPullParser, AttributeSet object, ViewGroup viewGroup) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        TransitionManager transitionManager = null;
        while (((n = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n2) && n != 1) {
            if (n != 2) continue;
            String string2 = xmlPullParser.getName();
            if (string2.equals("transitionManager")) {
                transitionManager = new TransitionManager();
                continue;
            }
            if (string2.equals("transition") && transitionManager != null) {
                this.loadTransition((AttributeSet)object, xmlPullParser, viewGroup, transitionManager);
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unknown scene name: ");
            ((StringBuilder)object).append(xmlPullParser.getName());
            throw new RuntimeException(((StringBuilder)object).toString());
        }
        return transitionManager;
    }

    public static TransitionInflater from(Context context) {
        return new TransitionInflater(context);
    }

    /*
     * Loose catch block
     */
    private void getTargetIds(XmlPullParser xmlPullParser, AttributeSet object, Transition transition) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        while (((n = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n2) && n != 1) {
            if (n != 2) continue;
            if (xmlPullParser.getName().equals("target")) {
                String string2;
                TypedArray typedArray;
                block15: {
                    typedArray = this.mContext.obtainStyledAttributes((AttributeSet)object, Styleable.TRANSITION_TARGET);
                    n = TypedArrayUtils.getNamedResourceId(typedArray, xmlPullParser, "targetId", 1, 0);
                    if (n != 0) {
                        transition.addTarget(n);
                    } else {
                        n = TypedArrayUtils.getNamedResourceId(typedArray, xmlPullParser, "excludeId", 2, 0);
                        if (n != 0) {
                            transition.excludeTarget(n, true);
                        } else {
                            string2 = TypedArrayUtils.getNamedString(typedArray, xmlPullParser, "targetName", 4);
                            if (string2 != null) {
                                transition.addTarget(string2);
                            } else {
                                string2 = TypedArrayUtils.getNamedString(typedArray, xmlPullParser, "excludeName", 5);
                                if (string2 != null) {
                                    transition.excludeTarget(string2, true);
                                } else {
                                    String string3 = TypedArrayUtils.getNamedString(typedArray, xmlPullParser, "excludeClass", 3);
                                    if (string3 != null) {
                                        string2 = string3;
                                        transition.excludeTarget(Class.forName(string3), true);
                                    }
                                    string2 = string3;
                                    string3 = TypedArrayUtils.getNamedString(typedArray, xmlPullParser, "targetClass", 0);
                                    if (string3 == null) break block15;
                                    string2 = string3;
                                    transition.addTarget(Class.forName(string3));
                                }
                            }
                        }
                    }
                }
                typedArray.recycle();
                continue;
                catch (ClassNotFoundException classNotFoundException) {
                    typedArray.recycle();
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Could not create ");
                    ((StringBuilder)object).append(string2);
                    throw new RuntimeException(((StringBuilder)object).toString(), classNotFoundException);
                }
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unknown scene name: ");
            ((StringBuilder)object).append(xmlPullParser.getName());
            throw new RuntimeException(((StringBuilder)object).toString());
        }
    }

    private void loadTransition(AttributeSet object, XmlPullParser object2, ViewGroup object3, TransitionManager transitionManager) throws Resources.NotFoundException {
        TypedArray typedArray = this.mContext.obtainStyledAttributes((AttributeSet)object, Styleable.TRANSITION_MANAGER);
        int n = TypedArrayUtils.getNamedResourceId(typedArray, object2, "transition", 2, -1);
        int n2 = TypedArrayUtils.getNamedResourceId(typedArray, object2, "fromScene", 0, -1);
        Object var8_8 = null;
        object = n2 < 0 ? null : Scene.getSceneForLayout(object3, n2, this.mContext);
        n2 = TypedArrayUtils.getNamedResourceId(typedArray, object2, "toScene", 1, -1);
        object2 = n2 < 0 ? var8_8 : Scene.getSceneForLayout(object3, n2, this.mContext);
        if (n >= 0 && (object3 = this.inflateTransition(n)) != null) {
            if (object2 != null) {
                if (object == null) {
                    transitionManager.setTransition((Scene)object2, (Transition)object3);
                } else {
                    transitionManager.setTransition((Scene)object, (Scene)object2, (Transition)object3);
                }
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append("No toScene for transition ID ");
                ((StringBuilder)object).append(n);
                throw new RuntimeException(((StringBuilder)object).toString());
            }
        }
        typedArray.recycle();
    }

    /*
     * Exception decompiling
     */
    public Transition inflateTransition(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 37->96)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public TransitionManager inflateTransitionManager(int var1_1, ViewGroup var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 36->102)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

