/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TypeEvaluator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Picture;
import android.graphics.RectF;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.transition.ViewUtils;

class TransitionUtils {
    private static final boolean HAS_IS_ATTACHED_TO_WINDOW;
    private static final boolean HAS_OVERLAY;
    private static final boolean HAS_PICTURE_BITMAP;
    private static final int MAX_IMAGE_SIZE = 0x100000;

    static {
        int n = Build.VERSION.SDK_INT;
        boolean bl = true;
        boolean bl2 = n >= 19;
        HAS_IS_ATTACHED_TO_WINDOW = bl2;
        bl2 = Build.VERSION.SDK_INT >= 18;
        HAS_OVERLAY = bl2;
        bl2 = Build.VERSION.SDK_INT >= 28 ? bl : false;
        HAS_PICTURE_BITMAP = bl2;
    }

    private TransitionUtils() {
    }

    static View copyViewImage(ViewGroup viewGroup, View view, View view2) {
        Matrix matrix = new Matrix();
        matrix.setTranslate((float)(-view2.getScrollX()), (float)(-view2.getScrollY()));
        ViewUtils.transformMatrixToGlobal(view, matrix);
        ViewUtils.transformMatrixToLocal((View)viewGroup, matrix);
        RectF rectF = new RectF(0.0f, 0.0f, (float)view.getWidth(), (float)view.getHeight());
        matrix.mapRect(rectF);
        int n = Math.round(rectF.left);
        int n2 = Math.round(rectF.top);
        int n3 = Math.round(rectF.right);
        int n4 = Math.round(rectF.bottom);
        view2 = new ImageView(view.getContext());
        view2.setScaleType(ImageView.ScaleType.CENTER_CROP);
        viewGroup = TransitionUtils.createViewBitmap(view, matrix, rectF, viewGroup);
        if (viewGroup != null) {
            view2.setImageBitmap((Bitmap)viewGroup);
        }
        view2.measure(View.MeasureSpec.makeMeasureSpec((int)(n3 - n), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(n4 - n2), (int)0x40000000));
        view2.layout(n, n2, n3, n4);
        return view2;
    }

    private static Bitmap createViewBitmap(View view, Matrix matrix, RectF rectF, ViewGroup viewGroup) {
        int n;
        ViewGroup viewGroup2;
        boolean bl;
        boolean bl2;
        block10: {
            block9: {
                block8: {
                    if (!HAS_IS_ATTACHED_TO_WINDOW) break block8;
                    bl2 = view.isAttachedToWindow() ^ true;
                    if (viewGroup == null) break block9;
                    bl = viewGroup.isAttachedToWindow();
                    break block10;
                }
                bl2 = false;
            }
            bl = false;
        }
        boolean bl3 = HAS_OVERLAY;
        Picture picture = null;
        if (bl3 && bl2) {
            if (!bl) {
                return null;
            }
            viewGroup2 = (ViewGroup)view.getParent();
            n = viewGroup2.indexOfChild(view);
            viewGroup.getOverlay().add(view);
        } else {
            viewGroup2 = null;
            n = 0;
        }
        int n2 = Math.round(rectF.width());
        int n3 = Math.round(rectF.height());
        Picture picture2 = picture;
        if (n2 > 0) {
            picture2 = picture;
            if (n3 > 0) {
                float f = Math.min(1.0f, 1048576.0f / (float)(n2 * n3));
                n2 = Math.round((float)n2 * f);
                n3 = Math.round((float)n3 * f);
                matrix.postTranslate(-rectF.left, -rectF.top);
                matrix.postScale(f, f);
                if (HAS_PICTURE_BITMAP) {
                    picture2 = new Picture();
                    rectF = picture2.beginRecording(n2, n3);
                    rectF.concat(matrix);
                    view.draw((Canvas)rectF);
                    picture2.endRecording();
                    picture2 = Bitmap.createBitmap((Picture)picture2);
                } else {
                    picture2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    rectF = new Canvas((Bitmap)picture2);
                    rectF.concat(matrix);
                    view.draw((Canvas)rectF);
                }
            }
        }
        if (bl3 && bl2) {
            viewGroup.getOverlay().remove(view);
            viewGroup2.addView(view, n);
        }
        return picture2;
    }

    static Animator mergeAnimators(Animator animator2, Animator animator3) {
        if (animator2 == null) {
            return animator3;
        }
        if (animator3 == null) {
            return animator2;
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{animator2, animator3});
        return animatorSet;
    }

    static class MatrixEvaluator
    implements TypeEvaluator<Matrix> {
        final float[] mTempEndValues;
        final Matrix mTempMatrix;
        final float[] mTempStartValues = new float[9];

        MatrixEvaluator() {
            this.mTempEndValues = new float[9];
            this.mTempMatrix = new Matrix();
        }

        public Matrix evaluate(float f, Matrix object, Matrix object2) {
            object.getValues(this.mTempStartValues);
            object2.getValues(this.mTempEndValues);
            for (int i = 0; i < 9; ++i) {
                object2 = this.mTempEndValues;
                Matrix matrix = object2[i];
                object = this.mTempStartValues;
                Matrix matrix2 = object[i];
                object2[i] = object[i] + (matrix - matrix2) * f;
            }
            this.mTempMatrix.setValues(this.mTempEndValues);
            return this.mTempMatrix;
        }
    }
}

