/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.os.Build;
import android.view.ViewGroup;
import androidx.transition.ViewGroupOverlayApi14;
import androidx.transition.ViewGroupOverlayApi18;
import androidx.transition.ViewGroupOverlayImpl;
import androidx.transition.ViewGroupUtilsApi14;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ViewGroupUtils {
    private static Method sGetChildDrawingOrderMethod;
    private static boolean sGetChildDrawingOrderMethodFetched = false;
    private static boolean sTryHiddenSuppressLayout = true;

    private ViewGroupUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getChildDrawingOrder(ViewGroup viewGroup, int n) {
        Method method;
        if (Build.VERSION.SDK_INT >= 29) {
            return viewGroup.getChildDrawingOrder(n);
        }
        if (!sGetChildDrawingOrderMethodFetched) {
            try {
                sGetChildDrawingOrderMethod = method = ViewGroup.class.getDeclaredMethod("getChildDrawingOrder", Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            sGetChildDrawingOrderMethodFetched = true;
        }
        if ((method = sGetChildDrawingOrderMethod) == null) return n;
        try {
            return (Integer)method.invoke((Object)viewGroup, viewGroup.getChildCount(), n);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return n;
        }
    }

    static ViewGroupOverlayImpl getOverlay(ViewGroup viewGroup) {
        if (Build.VERSION.SDK_INT >= 18) {
            return new ViewGroupOverlayApi18(viewGroup);
        }
        return ViewGroupOverlayApi14.createFrom(viewGroup);
    }

    private static void hiddenSuppressLayout(ViewGroup viewGroup, boolean bl) {
        if (sTryHiddenSuppressLayout) {
            try {
                viewGroup.suppressLayout(bl);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                sTryHiddenSuppressLayout = false;
            }
        }
    }

    static void suppressLayout(ViewGroup viewGroup, boolean bl) {
        if (Build.VERSION.SDK_INT >= 29) {
            viewGroup.suppressLayout(bl);
        } else if (Build.VERSION.SDK_INT >= 18) {
            ViewGroupUtils.hiddenSuppressLayout(viewGroup, bl);
        } else {
            ViewGroupUtilsApi14.suppressLayout(viewGroup, bl);
        }
    }
}

