/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.content.res.TypedArrayUtils;
import androidx.transition.AnimatorUtils;
import androidx.transition.R;
import androidx.transition.Styleable;
import androidx.transition.Transition;
import androidx.transition.TransitionListenerAdapter;
import androidx.transition.TransitionUtils;
import androidx.transition.TransitionValues;
import androidx.transition.ViewGroupUtils;
import androidx.transition.ViewUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.xmlpull.v1.XmlPullParser;

public abstract class Visibility
extends Transition {
    public static final int MODE_IN = 1;
    public static final int MODE_OUT = 2;
    private static final String PROPNAME_PARENT = "android:visibility:parent";
    private static final String PROPNAME_SCREEN_LOCATION = "android:visibility:screenLocation";
    static final String PROPNAME_VISIBILITY = "android:visibility:visibility";
    private static final String[] sTransitionProperties = new String[]{"android:visibility:visibility", "android:visibility:parent"};
    private int mMode = 3;

    public Visibility() {
    }

    public Visibility(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        context = context.obtainStyledAttributes(attributeSet, Styleable.VISIBILITY_TRANSITION);
        int n = TypedArrayUtils.getNamedInt((TypedArray)context, (XmlPullParser)((XmlResourceParser)attributeSet), "transitionVisibilityMode", 0, 0);
        context.recycle();
        if (n != 0) {
            this.setMode(n);
        }
    }

    private void captureValues(TransitionValues transitionValues) {
        int n = transitionValues.view.getVisibility();
        transitionValues.values.put(PROPNAME_VISIBILITY, n);
        transitionValues.values.put(PROPNAME_PARENT, transitionValues.view.getParent());
        int[] nArray = new int[2];
        transitionValues.view.getLocationOnScreen(nArray);
        transitionValues.values.put(PROPNAME_SCREEN_LOCATION, nArray);
    }

    private VisibilityInfo getVisibilityChangeInfo(TransitionValues transitionValues, TransitionValues transitionValues2) {
        VisibilityInfo visibilityInfo = new VisibilityInfo();
        visibilityInfo.mVisibilityChange = false;
        visibilityInfo.mFadeIn = false;
        if (transitionValues != null && transitionValues.values.containsKey(PROPNAME_VISIBILITY)) {
            visibilityInfo.mStartVisibility = (Integer)transitionValues.values.get(PROPNAME_VISIBILITY);
            visibilityInfo.mStartParent = (ViewGroup)transitionValues.values.get(PROPNAME_PARENT);
        } else {
            visibilityInfo.mStartVisibility = -1;
            visibilityInfo.mStartParent = null;
        }
        if (transitionValues2 != null && transitionValues2.values.containsKey(PROPNAME_VISIBILITY)) {
            visibilityInfo.mEndVisibility = (Integer)transitionValues2.values.get(PROPNAME_VISIBILITY);
            visibilityInfo.mEndParent = (ViewGroup)transitionValues2.values.get(PROPNAME_PARENT);
        } else {
            visibilityInfo.mEndVisibility = -1;
            visibilityInfo.mEndParent = null;
        }
        if (transitionValues != null && transitionValues2 != null) {
            if (visibilityInfo.mStartVisibility == visibilityInfo.mEndVisibility && visibilityInfo.mStartParent == visibilityInfo.mEndParent) {
                return visibilityInfo;
            }
            if (visibilityInfo.mStartVisibility != visibilityInfo.mEndVisibility) {
                if (visibilityInfo.mStartVisibility == 0) {
                    visibilityInfo.mFadeIn = false;
                    visibilityInfo.mVisibilityChange = true;
                } else if (visibilityInfo.mEndVisibility == 0) {
                    visibilityInfo.mFadeIn = true;
                    visibilityInfo.mVisibilityChange = true;
                }
            } else if (visibilityInfo.mEndParent == null) {
                visibilityInfo.mFadeIn = false;
                visibilityInfo.mVisibilityChange = true;
            } else if (visibilityInfo.mStartParent == null) {
                visibilityInfo.mFadeIn = true;
                visibilityInfo.mVisibilityChange = true;
            }
        } else if (transitionValues == null && visibilityInfo.mEndVisibility == 0) {
            visibilityInfo.mFadeIn = true;
            visibilityInfo.mVisibilityChange = true;
        } else if (transitionValues2 == null && visibilityInfo.mStartVisibility == 0) {
            visibilityInfo.mFadeIn = false;
            visibilityInfo.mVisibilityChange = true;
        }
        return visibilityInfo;
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        VisibilityInfo visibilityInfo = this.getVisibilityChangeInfo(transitionValues, transitionValues2);
        if (visibilityInfo.mVisibilityChange && (visibilityInfo.mStartParent != null || visibilityInfo.mEndParent != null)) {
            if (visibilityInfo.mFadeIn) {
                return this.onAppear(viewGroup, transitionValues, visibilityInfo.mStartVisibility, transitionValues2, visibilityInfo.mEndVisibility);
            }
            return this.onDisappear(viewGroup, transitionValues, visibilityInfo.mStartVisibility, transitionValues2, visibilityInfo.mEndVisibility);
        }
        return null;
    }

    public int getMode() {
        return this.mMode;
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    @Override
    public boolean isTransitionRequired(TransitionValues object, TransitionValues transitionValues) {
        boolean bl;
        block5: {
            block6: {
                boolean bl2 = false;
                if (object == null && transitionValues == null) {
                    return false;
                }
                if (object != null && transitionValues != null && transitionValues.values.containsKey(PROPNAME_VISIBILITY) != ((TransitionValues)object).values.containsKey(PROPNAME_VISIBILITY)) {
                    return false;
                }
                object = this.getVisibilityChangeInfo((TransitionValues)object, transitionValues);
                bl = bl2;
                if (!((VisibilityInfo)object).mVisibilityChange) break block5;
                if (((VisibilityInfo)object).mStartVisibility == 0) break block6;
                bl = bl2;
                if (((VisibilityInfo)object).mEndVisibility != 0) break block5;
            }
            bl = true;
        }
        return bl;
    }

    public boolean isVisible(TransitionValues transitionValues) {
        boolean bl = false;
        if (transitionValues == null) {
            return false;
        }
        int n = (Integer)transitionValues.values.get(PROPNAME_VISIBILITY);
        transitionValues = (View)transitionValues.values.get(PROPNAME_PARENT);
        boolean bl2 = bl;
        if (n == 0) {
            bl2 = bl;
            if (transitionValues != null) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public Animator onAppear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return null;
    }

    public Animator onAppear(ViewGroup viewGroup, TransitionValues transitionValues, int n, TransitionValues transitionValues2, int n2) {
        if ((this.mMode & 1) == 1 && transitionValues2 != null) {
            if (transitionValues == null) {
                View view = (View)transitionValues2.view.getParent();
                if (this.getVisibilityChangeInfo((TransitionValues)this.getMatchedTransitionValues((View)view, (boolean)false), (TransitionValues)this.getTransitionValues((View)view, (boolean)false)).mVisibilityChange) {
                    return null;
                }
            }
            return this.onAppear(viewGroup, transitionValues2.view, transitionValues, transitionValues2);
        }
        return null;
    }

    public Animator onDisappear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Animator onDisappear(final ViewGroup var1_1, TransitionValues var2_2, int var3_3, TransitionValues var4_4, int var5_5) {
        block21: {
            block23: {
                block22: {
                    block20: {
                        if ((this.mMode & 2) != 2) {
                            return null;
                        }
                        if (var2_2 == null) {
                            return null;
                        }
                        var6_6 = var2_2.view;
                        var7_7 /* !! */  = var4_4 != null ? var4_4.view : null;
                        var8_8 = (View)var6_6.getTag(R.id.save_overlay_view);
                        if (var8_8 == null) break block20;
                        var7_7 /* !! */  = null;
                        var3_3 = 1;
                        break block21;
                    }
                    if (var7_7 /* !! */  == null || var7_7 /* !! */ .getParent() == null) break block22;
                    if (var5_5 /* !! */  != 4 && var6_6 != var7_7 /* !! */ ) ** GOTO lbl-1000
                    var8_8 = var7_7 /* !! */ ;
                    var3_3 = 0;
                    var7_7 /* !! */  = null;
                    break block23;
                }
                if (var7_7 /* !! */  != null) {
                    var8_8 = null;
                    var3_3 = 0;
                } else lbl-1000:
                // 2 sources

                {
                    var8_8 = var7_7 /* !! */  = null;
                    var3_3 = 1;
                }
            }
            var9_9 = var7_7 /* !! */ ;
            if (var3_3 == 0) ** GOTO lbl-1000
            if (var6_6.getParent() == null) ** GOTO lbl-1000
            var9_9 = var7_7 /* !! */ ;
            if (var6_6.getParent() instanceof View) {
                var10_10 = (View)var6_6.getParent();
                if (!this.getVisibilityChangeInfo((TransitionValues)this.getTransitionValues((View)var10_10, (boolean)true), (TransitionValues)this.getMatchedTransitionValues((View)var10_10, (boolean)true)).mVisibilityChange) {
                    var9_9 = TransitionUtils.copyViewImage(var1_1, var6_6, var10_10);
                } else {
                    var3_3 = var10_10.getId();
                    var9_9 = var7_7 /* !! */ ;
                    if (var10_10.getParent() == null) {
                        var9_9 = var7_7 /* !! */ ;
                        if (var3_3 != -1) {
                            var9_9 = var7_7 /* !! */ ;
                            if (var1_1.findViewById(var3_3) != null) {
                                var9_9 = var7_7 /* !! */ ;
                                ** if (!this.mCanRemoveViews) goto lbl-1000
                            }
                        }
                    }
                }
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                var7_7 /* !! */  = var8_8;
                var3_3 = 0;
                var8_8 = var6_6;
                ** GOTO lbl54
            }
lbl-1000:
            // 4 sources

            {
                var3_3 = 0;
                var7_7 /* !! */  = var8_8;
                var8_8 = var9_9;
            }
        }
        if (var8_8 != null) {
            if (var3_3 == 0) {
                var7_7 /* !! */  = (View)((int[])var2_2.values.get("android:visibility:screenLocation"));
                var5_5 /* !! */  = (int)var7_7 /* !! */ [0];
                var11_11 = var7_7 /* !! */ [1];
                var7_7 /* !! */  = (View)new int[2];
                var1_1.getLocationOnScreen((int[])var7_7 /* !! */ );
                var8_8.offsetLeftAndRight(var5_5 /* !! */  - var7_7 /* !! */ [0] - var8_8.getLeft());
                var8_8.offsetTopAndBottom((int)(var11_11 - var7_7 /* !! */ [1] - var8_8.getTop()));
                ViewGroupUtils.getOverlay(var1_1).add(var8_8);
            }
            var2_2 = this.onDisappear(var1_1, var8_8, (TransitionValues)var2_2, var4_4);
            if (var3_3 == 0) {
                if (var2_2 == null) {
                    ViewGroupUtils.getOverlay(var1_1).remove(var8_8);
                } else {
                    var6_6.setTag(R.id.save_overlay_view, (Object)var8_8);
                    this.addListener(new TransitionListenerAdapter(){

                        @Override
                        public void onTransitionEnd(Transition transition) {
                            var6_6.setTag(R.id.save_overlay_view, null);
                            ViewGroupUtils.getOverlay(var1_1).remove(var8_8);
                            transition.removeListener(this);
                        }

                        @Override
                        public void onTransitionPause(Transition transition) {
                            ViewGroupUtils.getOverlay(var1_1).remove(var8_8);
                        }

                        @Override
                        public void onTransitionResume(Transition transition) {
                            if (var8_8.getParent() == null) {
                                ViewGroupUtils.getOverlay(var1_1).add(var8_8);
                            } else {
                                Visibility.this.cancel();
                            }
                        }
                    });
                }
            }
            return var2_2;
        }
        if (var7_7 /* !! */  != null) {
            var3_3 = var7_7 /* !! */ .getVisibility();
            ViewUtils.setTransitionVisibility(var7_7 /* !! */ , 0);
            var1_1 = this.onDisappear(var1_1, var7_7 /* !! */ , (TransitionValues)var2_2, var4_4);
            if (var1_1 != null) {
                var2_2 = new DisappearListener(var7_7 /* !! */ , var5_5 /* !! */ , true);
                var1_1.addListener((Animator.AnimatorListener)var2_2);
                AnimatorUtils.addPauseListener((Animator)var1_1, (AnimatorListenerAdapter)var2_2);
                this.addListener((Transition.TransitionListener)var2_2);
            } else {
                ViewUtils.setTransitionVisibility(var7_7 /* !! */ , var3_3);
            }
            return var1_1;
        }
        return null;
    }

    public void setMode(int n) {
        if ((n & 0xFFFFFFFC) == 0) {
            this.mMode = n;
            return;
        }
        throw new IllegalArgumentException("Only MODE_IN and MODE_OUT flags are allowed");
    }

    private static class DisappearListener
    extends AnimatorListenerAdapter
    implements Transition.TransitionListener,
    AnimatorUtils.AnimatorPauseListenerCompat {
        boolean mCanceled = false;
        private final int mFinalVisibility;
        private boolean mLayoutSuppressed;
        private final ViewGroup mParent;
        private final boolean mSuppressLayout;
        private final View mView;

        DisappearListener(View view, int n, boolean bl) {
            this.mView = view;
            this.mFinalVisibility = n;
            this.mParent = (ViewGroup)view.getParent();
            this.mSuppressLayout = bl;
            this.suppressLayout(true);
        }

        private void hideViewWhenNotCanceled() {
            if (!this.mCanceled) {
                ViewUtils.setTransitionVisibility(this.mView, this.mFinalVisibility);
                ViewGroup viewGroup = this.mParent;
                if (viewGroup != null) {
                    viewGroup.invalidate();
                }
            }
            this.suppressLayout(false);
        }

        private void suppressLayout(boolean bl) {
            ViewGroup viewGroup;
            if (this.mSuppressLayout && this.mLayoutSuppressed != bl && (viewGroup = this.mParent) != null) {
                this.mLayoutSuppressed = bl;
                ViewGroupUtils.suppressLayout(viewGroup, bl);
            }
        }

        public void onAnimationCancel(Animator animator2) {
            this.mCanceled = true;
        }

        public void onAnimationEnd(Animator animator2) {
            this.hideViewWhenNotCanceled();
        }

        @Override
        public void onAnimationPause(Animator animator2) {
            if (!this.mCanceled) {
                ViewUtils.setTransitionVisibility(this.mView, this.mFinalVisibility);
            }
        }

        public void onAnimationRepeat(Animator animator2) {
        }

        @Override
        public void onAnimationResume(Animator animator2) {
            if (!this.mCanceled) {
                ViewUtils.setTransitionVisibility(this.mView, 0);
            }
        }

        public void onAnimationStart(Animator animator2) {
        }

        @Override
        public void onTransitionCancel(Transition transition) {
        }

        @Override
        public void onTransitionEnd(Transition transition) {
            this.hideViewWhenNotCanceled();
            transition.removeListener(this);
        }

        @Override
        public void onTransitionPause(Transition transition) {
            this.suppressLayout(false);
        }

        @Override
        public void onTransitionResume(Transition transition) {
            this.suppressLayout(true);
        }

        @Override
        public void onTransitionStart(Transition transition) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }

    private static class VisibilityInfo {
        ViewGroup mEndParent;
        int mEndVisibility;
        boolean mFadeIn;
        ViewGroup mStartParent;
        int mStartVisibility;
        boolean mVisibilityChange;

        VisibilityInfo() {
        }
    }
}

