/*
 * Decompiled with CFR 0.152.
 */
package androidx.vectordrawable.graphics.drawable;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import androidx.vectordrawable.graphics.drawable.PathInterpolatorCompat;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationUtilsCompat {
    private AnimationUtilsCompat() {
    }

    private static Interpolator createInterpolatorFromXml(Context object, Resources object2, Resources.Theme object3, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        object2 = null;
        while (((n = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n2) && n != 1) {
            if (n != 2) continue;
            object2 = Xml.asAttributeSet((XmlPullParser)xmlPullParser);
            object3 = xmlPullParser.getName();
            if (((String)object3).equals("linearInterpolator")) {
                object2 = new LinearInterpolator();
                continue;
            }
            if (((String)object3).equals("accelerateInterpolator")) {
                object2 = new AccelerateInterpolator((Context)object, (AttributeSet)object2);
                continue;
            }
            if (((String)object3).equals("decelerateInterpolator")) {
                object2 = new DecelerateInterpolator((Context)object, (AttributeSet)object2);
                continue;
            }
            if (((String)object3).equals("accelerateDecelerateInterpolator")) {
                object2 = new AccelerateDecelerateInterpolator();
                continue;
            }
            if (((String)object3).equals("cycleInterpolator")) {
                object2 = new CycleInterpolator((Context)object, (AttributeSet)object2);
                continue;
            }
            if (((String)object3).equals("anticipateInterpolator")) {
                object2 = new AnticipateInterpolator((Context)object, (AttributeSet)object2);
                continue;
            }
            if (((String)object3).equals("overshootInterpolator")) {
                object2 = new OvershootInterpolator((Context)object, (AttributeSet)object2);
                continue;
            }
            if (((String)object3).equals("anticipateOvershootInterpolator")) {
                object2 = new AnticipateOvershootInterpolator((Context)object, (AttributeSet)object2);
                continue;
            }
            if (((String)object3).equals("bounceInterpolator")) {
                object2 = new BounceInterpolator();
                continue;
            }
            if (((String)object3).equals("pathInterpolator")) {
                object2 = new PathInterpolatorCompat((Context)object, (AttributeSet)object2, xmlPullParser);
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unknown interpolator name: ");
            ((StringBuilder)object).append(xmlPullParser.getName());
            throw new RuntimeException(((StringBuilder)object).toString());
        }
        return object2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Interpolator loadInterpolator(Context context, int n) throws Resources.NotFoundException {
        Throwable throwable;
        if (Build.VERSION.SDK_INT >= 21) {
            return AnimationUtils.loadInterpolator((Context)context, (int)n);
        }
        Resources.NotFoundException notFoundException = null;
        Object object = null;
        Object object2 = null;
        if (n == 17563663) {
            try {
                return new FastOutLinearInInterpolator();
            }
            catch (IOException iOException) {}
            catch (XmlPullParserException xmlPullParserException) {}
            finally {
            }
        } else {
            if (n == 17563661) {
                return new FastOutSlowInInterpolator();
            }
            if (n == 17563662) {
                return new LinearOutSlowInInterpolator();
            }
            XmlResourceParser xmlResourceParser = context.getResources().getAnimation(n);
            object2 = xmlResourceParser;
            notFoundException = xmlResourceParser;
            object = xmlResourceParser;
            context = AnimationUtilsCompat.createInterpolatorFromXml(context, context.getResources(), context.getTheme(), (XmlPullParser)xmlResourceParser);
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
            return context;
        }
        if (object2 != null) {
            object2.close();
        }
        throw throwable;
    }
}

