/*
 * Decompiled with CFR 0.152.
 */
package androidx.viewpager.widget;

import android.content.Context;
import android.content.res.Resources;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.EdgeEffect;
import android.widget.Scroller;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.customview.view.AbsSavedState;
import androidx.viewpager.widget.PagerAdapter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ViewPager
extends ViewGroup {
    private static final int CLOSE_ENOUGH = 2;
    private static final Comparator<ItemInfo> COMPARATOR;
    private static final boolean DEBUG = false;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int DRAW_ORDER_DEFAULT = 0;
    private static final int DRAW_ORDER_FORWARD = 1;
    private static final int DRAW_ORDER_REVERSE = 2;
    private static final int INVALID_POINTER = -1;
    static final int[] LAYOUT_ATTRS;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int MIN_FLING_VELOCITY = 400;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_SETTLING = 2;
    private static final String TAG = "ViewPager";
    private static final boolean USE_CACHE = false;
    private static final Interpolator sInterpolator;
    private static final ViewPositionComparator sPositionComparator;
    private int mActivePointerId = -1;
    PagerAdapter mAdapter;
    private List<OnAdapterChangeListener> mAdapterChangeListeners;
    private int mBottomPageBounds;
    private boolean mCalledSuper;
    private int mChildHeightMeasureSpec;
    private int mChildWidthMeasureSpec;
    private int mCloseEnough;
    int mCurItem;
    private int mDecorChildCount;
    private int mDefaultGutterSize;
    private int mDrawingOrder;
    private ArrayList<View> mDrawingOrderedChildren;
    private final Runnable mEndScrollRunnable;
    private int mExpectedAdapterCount;
    private long mFakeDragBeginTime;
    private boolean mFakeDragging;
    private boolean mFirstLayout = true;
    private float mFirstOffset = -3.4028235E38f;
    private int mFlingDistance;
    private int mGutterSize;
    private boolean mInLayout;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private OnPageChangeListener mInternalPageChangeListener;
    private boolean mIsBeingDragged;
    private boolean mIsScrollStarted;
    private boolean mIsUnableToDrag;
    private final ArrayList<ItemInfo> mItems = new ArrayList();
    private float mLastMotionX;
    private float mLastMotionY;
    private float mLastOffset;
    private EdgeEffect mLeftEdge;
    private Drawable mMarginDrawable;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private boolean mNeedCalculatePageOffsets = false;
    private PagerObserver mObserver;
    private int mOffscreenPageLimit = 1;
    private OnPageChangeListener mOnPageChangeListener;
    private List<OnPageChangeListener> mOnPageChangeListeners;
    private int mPageMargin;
    private PageTransformer mPageTransformer;
    private int mPageTransformerLayerType;
    private boolean mPopulatePending;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private int mRestoredCurItem = -1;
    private EdgeEffect mRightEdge;
    private int mScrollState = 0;
    private Scroller mScroller;
    private boolean mScrollingCacheEnabled;
    private final ItemInfo mTempItem = new ItemInfo();
    private final Rect mTempRect = new Rect();
    private int mTopPageBounds;
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;

    static {
        LAYOUT_ATTRS = new int[]{16842931};
        COMPARATOR = new Comparator<ItemInfo>(){

            @Override
            public int compare(ItemInfo itemInfo, ItemInfo itemInfo2) {
                return itemInfo.position - itemInfo2.position;
            }
        };
        sInterpolator = new Interpolator(){

            public float getInterpolation(float f) {
                return (f -= 1.0f) * f * f * f * f + 1.0f;
            }
        };
        sPositionComparator = new ViewPositionComparator();
    }

    public ViewPager(Context context) {
        super(context);
        this.mLastOffset = Float.MAX_VALUE;
        this.mEndScrollRunnable = new Runnable(){

            @Override
            public void run() {
                ViewPager.this.setScrollState(0);
                ViewPager.this.populate();
            }
        };
        this.initViewPager();
    }

    public ViewPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mLastOffset = Float.MAX_VALUE;
        this.mEndScrollRunnable = new /* invalid duplicate definition of identical inner class */;
        this.initViewPager();
    }

    private void calculatePageOffsets(ItemInfo itemInfo, int n, ItemInfo itemInfo2) {
        float f;
        int n2;
        int n3;
        float f2;
        int n4 = this.mAdapter.getCount();
        int n5 = this.getClientWidth();
        float f3 = n5 > 0 ? (float)this.mPageMargin / (float)n5 : 0.0f;
        if (itemInfo2 != null) {
            n5 = itemInfo2.position;
            if (n5 < itemInfo.position) {
                f2 = itemInfo2.offset + itemInfo2.widthFactor + f3;
                ++n5;
                n3 = 0;
                while (n5 <= itemInfo.position && n3 < this.mItems.size()) {
                    itemInfo2 = this.mItems.get(n3);
                    while (true) {
                        n2 = n5;
                        f = f2;
                        if (n5 <= itemInfo2.position) break;
                        n2 = n5;
                        f = f2;
                        if (n3 >= this.mItems.size() - 1) break;
                        itemInfo2 = this.mItems.get(++n3);
                    }
                    while (n2 < itemInfo2.position) {
                        f += this.mAdapter.getPageWidth(n2) + f3;
                        ++n2;
                    }
                    itemInfo2.offset = f;
                    f2 = f + (itemInfo2.widthFactor + f3);
                    n5 = n2 + 1;
                }
            } else if (n5 > itemInfo.position) {
                n3 = this.mItems.size() - 1;
                f2 = itemInfo2.offset;
                --n5;
                while (n5 >= itemInfo.position && n3 >= 0) {
                    itemInfo2 = this.mItems.get(n3);
                    while (true) {
                        n2 = n5;
                        f = f2;
                        if (n5 >= itemInfo2.position) break;
                        n2 = n5;
                        f = f2;
                        if (n3 <= 0) break;
                        itemInfo2 = this.mItems.get(--n3);
                    }
                    while (n2 > itemInfo2.position) {
                        f -= this.mAdapter.getPageWidth(n2) + f3;
                        --n2;
                    }
                    itemInfo2.offset = f2 = f - (itemInfo2.widthFactor + f3);
                    n5 = n2 - 1;
                }
            }
        }
        n2 = this.mItems.size();
        f = itemInfo.offset;
        n5 = itemInfo.position - 1;
        f2 = itemInfo.position == 0 ? itemInfo.offset : -3.4028235E38f;
        this.mFirstOffset = f2;
        n3 = itemInfo.position;
        f2 = n3 == --n4 ? itemInfo.offset + itemInfo.widthFactor - 1.0f : Float.MAX_VALUE;
        this.mLastOffset = f2;
        n3 = n - 1;
        f2 = f;
        while (n3 >= 0) {
            itemInfo2 = this.mItems.get(n3);
            while (n5 > itemInfo2.position) {
                f2 -= this.mAdapter.getPageWidth(n5) + f3;
                --n5;
            }
            itemInfo2.offset = f2 -= itemInfo2.widthFactor + f3;
            if (itemInfo2.position == 0) {
                this.mFirstOffset = f2;
            }
            --n3;
            --n5;
        }
        f2 = itemInfo.offset + itemInfo.widthFactor + f3;
        n3 = itemInfo.position + 1;
        n5 = n + 1;
        n = n3;
        while (n5 < n2) {
            itemInfo = this.mItems.get(n5);
            while (n < itemInfo.position) {
                f2 += this.mAdapter.getPageWidth(n) + f3;
                ++n;
            }
            if (itemInfo.position == n4) {
                this.mLastOffset = itemInfo.widthFactor + f2 - 1.0f;
            }
            itemInfo.offset = f2;
            f2 += itemInfo.widthFactor + f3;
            ++n5;
            ++n;
        }
        this.mNeedCalculatePageOffsets = false;
    }

    private void completeScroll(boolean bl) {
        int n;
        boolean bl2 = this.mScrollState == 2;
        if (bl2) {
            this.setScrollingCacheEnabled(false);
            if (this.mScroller.isFinished() ^ true) {
                this.mScroller.abortAnimation();
                int n2 = this.getScrollX();
                int n3 = this.getScrollY();
                int n4 = this.mScroller.getCurrX();
                n = this.mScroller.getCurrY();
                if (n2 != n4 || n3 != n) {
                    this.scrollTo(n4, n);
                    if (n4 != n2) {
                        this.pageScrolled(n4);
                    }
                }
            }
        }
        this.mPopulatePending = false;
        for (n = 0; n < this.mItems.size(); ++n) {
            ItemInfo itemInfo = this.mItems.get(n);
            if (!itemInfo.scrolling) continue;
            itemInfo.scrolling = false;
            bl2 = true;
        }
        if (bl2) {
            if (bl) {
                ViewCompat.postOnAnimation((View)this, this.mEndScrollRunnable);
            } else {
                this.mEndScrollRunnable.run();
            }
        }
    }

    private int determineTargetPage(int n, float f, int n2, int n3) {
        if (Math.abs(n3) > this.mFlingDistance && Math.abs(n2) > this.mMinimumVelocity) {
            if (n2 <= 0) {
                ++n;
            }
        } else {
            float f2 = n >= this.mCurItem ? 0.4f : 0.6f;
            n += (int)(f + f2);
        }
        n2 = n;
        if (this.mItems.size() > 0) {
            ItemInfo itemInfo = this.mItems.get(0);
            Object object = this.mItems;
            object = ((ArrayList)object).get(((ArrayList)object).size() - 1);
            n2 = Math.max(itemInfo.position, Math.min(n, ((ItemInfo)object).position));
        }
        return n2;
    }

    private void dispatchOnPageScrolled(int n, float f, int n2) {
        Object object = this.mOnPageChangeListener;
        if (object != null) {
            object.onPageScrolled(n, f, n2);
        }
        if ((object = this.mOnPageChangeListeners) != null) {
            int n3 = object.size();
            for (int i = 0; i < n3; ++i) {
                object = this.mOnPageChangeListeners.get(i);
                if (object == null) continue;
                object.onPageScrolled(n, f, n2);
            }
        }
        if ((object = this.mInternalPageChangeListener) != null) {
            object.onPageScrolled(n, f, n2);
        }
    }

    private void dispatchOnPageSelected(int n) {
        Object object = this.mOnPageChangeListener;
        if (object != null) {
            object.onPageSelected(n);
        }
        if ((object = this.mOnPageChangeListeners) != null) {
            int n2 = object.size();
            for (int i = 0; i < n2; ++i) {
                object = this.mOnPageChangeListeners.get(i);
                if (object == null) continue;
                object.onPageSelected(n);
            }
        }
        if ((object = this.mInternalPageChangeListener) != null) {
            object.onPageSelected(n);
        }
    }

    private void dispatchOnScrollStateChanged(int n) {
        Object object = this.mOnPageChangeListener;
        if (object != null) {
            object.onPageScrollStateChanged(n);
        }
        if ((object = this.mOnPageChangeListeners) != null) {
            int n2 = object.size();
            for (int i = 0; i < n2; ++i) {
                object = this.mOnPageChangeListeners.get(i);
                if (object == null) continue;
                object.onPageScrollStateChanged(n);
            }
        }
        if ((object = this.mInternalPageChangeListener) != null) {
            object.onPageScrollStateChanged(n);
        }
    }

    private void enableLayers(boolean bl) {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            int n2 = bl ? this.mPageTransformerLayerType : 0;
            this.getChildAt(i).setLayerType(n2, null);
        }
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private Rect getChildRectInPagerCoordinates(Rect rect, View view) {
        Rect rect2 = rect;
        if (rect == null) {
            rect2 = new Rect();
        }
        if (view == null) {
            rect2.set(0, 0, 0, 0);
            return rect2;
        }
        rect2.left = view.getLeft();
        rect2.right = view.getRight();
        rect2.top = view.getTop();
        rect2.bottom = view.getBottom();
        for (rect = view.getParent(); rect instanceof ViewGroup && rect != this; rect = rect.getParent()) {
            rect = (ViewGroup)rect;
            rect2.left += rect.getLeft();
            rect2.right += rect.getRight();
            rect2.top += rect.getTop();
            rect2.bottom += rect.getBottom();
        }
        return rect2;
    }

    private int getClientWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    private ItemInfo infoForCurrentScrollPosition() {
        int n = this.getClientWidth();
        float f = 0.0f;
        float f2 = n > 0 ? (float)this.getScrollX() / (float)n : 0.0f;
        float f3 = n > 0 ? (float)this.mPageMargin / (float)n : 0.0f;
        ItemInfo itemInfo = null;
        float f4 = 0.0f;
        int n2 = -1;
        n = 0;
        boolean bl = true;
        while (n < this.mItems.size()) {
            ItemInfo itemInfo2 = this.mItems.get(n);
            int n3 = n;
            ItemInfo itemInfo3 = itemInfo2;
            if (!bl) {
                int n4 = itemInfo2.position;
                n3 = n;
                itemInfo3 = itemInfo2;
                if (n4 != ++n2) {
                    itemInfo3 = this.mTempItem;
                    itemInfo3.offset = f + f4 + f3;
                    itemInfo3.position = n2;
                    itemInfo3.widthFactor = this.mAdapter.getPageWidth(itemInfo3.position);
                    n3 = n - 1;
                }
            }
            f = itemInfo3.offset;
            f4 = itemInfo3.widthFactor;
            if (!bl && !(f2 >= f)) {
                return itemInfo;
            }
            if (!(f2 < f4 + f + f3) && n3 != this.mItems.size() - 1) {
                n2 = itemInfo3.position;
                f4 = itemInfo3.widthFactor;
                n = n3 + 1;
                bl = false;
                itemInfo = itemInfo3;
                continue;
            }
            return itemInfo3;
        }
        return itemInfo;
    }

    private static boolean isDecorView(View view) {
        boolean bl = view.getClass().getAnnotation(DecorView.class) != null;
        return bl;
    }

    private boolean isGutterDrag(float f, float f2) {
        boolean bl = f < (float)this.mGutterSize && f2 > 0.0f || f > (float)(this.getWidth() - this.mGutterSize) && f2 < 0.0f;
        return bl;
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(n) == this.mActivePointerId) {
            n = n == 0 ? 1 : 0;
            this.mLastMotionX = motionEvent.getX(n);
            this.mActivePointerId = motionEvent.getPointerId(n);
            motionEvent = this.mVelocityTracker;
            if (motionEvent != null) {
                motionEvent.clear();
            }
        }
    }

    private boolean pageScrolled(int n) {
        if (this.mItems.size() == 0) {
            if (this.mFirstLayout) {
                return false;
            }
            this.mCalledSuper = false;
            this.onPageScrolled(0, 0.0f, 0);
            if (this.mCalledSuper) {
                return false;
            }
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
        ItemInfo itemInfo = this.infoForCurrentScrollPosition();
        int n2 = this.getClientWidth();
        int n3 = this.mPageMargin;
        float f = n3;
        float f2 = n2;
        f /= f2;
        int n4 = itemInfo.position;
        f2 = ((float)n / f2 - itemInfo.offset) / (itemInfo.widthFactor + f);
        n = (int)((float)(n2 + n3) * f2);
        this.mCalledSuper = false;
        this.onPageScrolled(n4, f2, n);
        if (this.mCalledSuper) {
            return true;
        }
        throw new IllegalStateException("onPageScrolled did not call superclass implementation");
    }

    private boolean performDrag(float f) {
        boolean bl;
        int n;
        float f2 = this.mLastMotionX;
        this.mLastMotionX = f;
        float f3 = (float)this.getScrollX() + (f2 - f);
        float f4 = this.getClientWidth();
        f = this.mFirstOffset * f4;
        f2 = this.mLastOffset * f4;
        Object object = this.mItems;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        object = ((ArrayList)object).get(0);
        Object object2 = this.mItems;
        object2 = ((ArrayList)object2).get(((ArrayList)object2).size() - 1);
        if (((ItemInfo)object).position != 0) {
            f = ((ItemInfo)object).offset * f4;
            n = 0;
        } else {
            n = 1;
        }
        if (((ItemInfo)object2).position != this.mAdapter.getCount() - 1) {
            f2 = ((ItemInfo)object2).offset * f4;
            bl = false;
        } else {
            bl = true;
        }
        if (f3 < f) {
            if (n != 0) {
                this.mLeftEdge.onPull(Math.abs(f - f3) / f4);
                bl4 = true;
            }
        } else {
            bl4 = bl3;
            f = f3;
            if (f3 > f2) {
                bl4 = bl2;
                if (bl) {
                    this.mRightEdge.onPull(Math.abs(f3 - f2) / f4);
                    bl4 = true;
                }
                f = f2;
            }
        }
        f2 = this.mLastMotionX;
        n = (int)f;
        this.mLastMotionX = f2 + (f - (float)n);
        this.scrollTo(n, this.getScrollY());
        this.pageScrolled(n);
        return bl4;
    }

    private void recomputeScrollPosition(int n, int n2, int n3, int n4) {
        if (n2 > 0 && !this.mItems.isEmpty()) {
            if (!this.mScroller.isFinished()) {
                this.mScroller.setFinalX(this.getCurrentItem() * this.getClientWidth());
            } else {
                int n5 = this.getPaddingLeft();
                int n6 = this.getPaddingRight();
                int n7 = this.getPaddingLeft();
                int n8 = this.getPaddingRight();
                this.scrollTo((int)((float)this.getScrollX() / (float)(n2 - n7 - n8 + n4) * (float)(n - n5 - n6 + n3)), this.getScrollY());
            }
        } else {
            ItemInfo itemInfo = this.infoForPosition(this.mCurItem);
            float f = itemInfo != null ? Math.min(itemInfo.offset, this.mLastOffset) : 0.0f;
            n = (int)(f * (float)(n - this.getPaddingLeft() - this.getPaddingRight()));
            if (n != this.getScrollX()) {
                this.completeScroll(false);
                this.scrollTo(n, this.getScrollY());
            }
        }
    }

    private void removeNonDecorViews() {
        int n = 0;
        while (n < this.getChildCount()) {
            int n2 = n;
            if (!((LayoutParams)this.getChildAt((int)n).getLayoutParams()).isDecor) {
                this.removeViewAt(n);
                n2 = n - 1;
            }
            n = n2 + 1;
        }
    }

    private void requestParentDisallowInterceptTouchEvent(boolean bl) {
        ViewParent viewParent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(bl);
        }
    }

    private boolean resetTouch() {
        this.mActivePointerId = -1;
        this.endDrag();
        this.mLeftEdge.onRelease();
        this.mRightEdge.onRelease();
        boolean bl = this.mLeftEdge.isFinished() || this.mRightEdge.isFinished();
        return bl;
    }

    private void scrollToItem(int n, boolean bl, int n2, boolean bl2) {
        ItemInfo itemInfo = this.infoForPosition(n);
        int n3 = itemInfo != null ? (int)((float)this.getClientWidth() * Math.max(this.mFirstOffset, Math.min(itemInfo.offset, this.mLastOffset))) : 0;
        if (bl) {
            this.smoothScrollTo(n3, 0, n2);
            if (bl2) {
                this.dispatchOnPageSelected(n);
            }
        } else {
            if (bl2) {
                this.dispatchOnPageSelected(n);
            }
            this.completeScroll(false);
            this.scrollTo(n3, 0);
            this.pageScrolled(n3);
        }
    }

    private void setScrollingCacheEnabled(boolean bl) {
        if (this.mScrollingCacheEnabled != bl) {
            this.mScrollingCacheEnabled = bl;
        }
    }

    private void sortChildDrawingOrder() {
        if (this.mDrawingOrder != 0) {
            View view = this.mDrawingOrderedChildren;
            if (view == null) {
                this.mDrawingOrderedChildren = new ArrayList();
            } else {
                view.clear();
            }
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                view = this.getChildAt(i);
                this.mDrawingOrderedChildren.add(view);
            }
            Collections.sort(this.mDrawingOrderedChildren, sPositionComparator);
        }
    }

    public void addFocusables(ArrayList<View> arrayList, int n, int n2) {
        int n3 = arrayList.size();
        int n4 = this.getDescendantFocusability();
        if (n4 != 393216) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ItemInfo itemInfo;
                View view = this.getChildAt(i);
                if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem) continue;
                view.addFocusables(arrayList, n, n2);
            }
        }
        if (n4 != 262144 || n3 == arrayList.size()) {
            if (!this.isFocusable()) {
                return;
            }
            if ((n2 & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
                return;
            }
            if (arrayList != null) {
                arrayList.add((View)this);
            }
        }
    }

    ItemInfo addNewItem(int n, int n2) {
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.position = n;
        itemInfo.object = this.mAdapter.instantiateItem(this, n);
        itemInfo.widthFactor = this.mAdapter.getPageWidth(n);
        if (n2 >= 0 && n2 < this.mItems.size()) {
            this.mItems.add(n2, itemInfo);
        } else {
            this.mItems.add(itemInfo);
        }
        return itemInfo;
    }

    public void addOnAdapterChangeListener(OnAdapterChangeListener onAdapterChangeListener) {
        if (this.mAdapterChangeListeners == null) {
            this.mAdapterChangeListeners = new ArrayList<OnAdapterChangeListener>();
        }
        this.mAdapterChangeListeners.add(onAdapterChangeListener);
    }

    public void addOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        if (this.mOnPageChangeListeners == null) {
            this.mOnPageChangeListeners = new ArrayList<OnPageChangeListener>();
        }
        this.mOnPageChangeListeners.add(onPageChangeListener);
    }

    public void addTouchables(ArrayList<View> arrayList) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i);
            if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem) continue;
            view.addTouchables(arrayList);
        }
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        ViewGroup.LayoutParams layoutParams2 = layoutParams;
        if (!this.checkLayoutParams(layoutParams)) {
            layoutParams2 = this.generateLayoutParams(layoutParams);
        }
        layoutParams = (LayoutParams)layoutParams2;
        layoutParams.isDecor |= ViewPager.isDecorView(view);
        if (this.mInLayout) {
            if (layoutParams != null && layoutParams.isDecor) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            layoutParams.needsMeasure = true;
            this.addViewInLayout(view, n, layoutParams2);
        } else {
            super.addView(view, n, layoutParams2);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean arrowScroll(int var1_1) {
        block16: {
            var2_2 = this.findFocus();
            var3_3 = false;
            if (var2_2 == this) lbl-1000:
            // 2 sources

            {
                while (true) {
                    var4_4 = null;
                    break block16;
                    break;
                }
            }
            var4_4 = var2_2;
            if (var2_2 != null) {
                block17: {
                    var4_4 = var2_2.getParent();
                    while (var4_4 instanceof ViewGroup) {
                        if (var4_4 == this) {
                            var5_5 = 1;
                            break block17;
                        }
                        var4_4 = var4_4.getParent();
                    }
                    var5_5 = 0;
                }
                var4_4 = var2_2;
                if (var5_5 == 0) {
                    var6_6 = new StringBuilder();
                    var6_6.append(var2_2.getClass().getSimpleName());
                    var4_4 = var2_2.getParent();
                    while (var4_4 instanceof ViewGroup) {
                        var6_6.append(" => ");
                        var6_6.append(var4_4.getClass().getSimpleName());
                        var4_4 = var4_4.getParent();
                    }
                    var4_4 = new StringBuilder();
                    var4_4.append("arrowScroll tried to find focus based on non-child current focused view ");
                    var4_4.append(var6_6.toString());
                    Log.e((String)"ViewPager", (String)var4_4.toString());
                    ** continue;
                }
            }
        }
        var2_2 = FocusFinder.getInstance().findNextFocus((ViewGroup)this, (View)var4_4, var1_1);
        if (var2_2 != null && var2_2 != var4_4) {
            if (var1_1 == 17) {
                var5_5 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var2_2).left;
                var7_7 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var4_4).left;
                var3_3 = var4_4 != null && var5_5 >= var7_7 ? this.pageLeft() : var2_2.requestFocus();
            } else if (var1_1 == 66) {
                var5_5 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var2_2).left;
                var7_8 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)var4_4).left;
                var3_3 = var4_4 != null && var5_5 <= var7_8 ? this.pageRight() : var2_2.requestFocus();
            }
        } else if (var1_1 != 17 && var1_1 != 1) {
            if (var1_1 == 66 || var1_1 == 2) {
                var3_3 = this.pageRight();
            }
        } else {
            var3_3 = this.pageLeft();
        }
        if (var3_3) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)var1_1));
        }
        return var3_3;
    }

    public boolean beginFakeDrag() {
        if (this.mIsBeingDragged) {
            return false;
        }
        this.mFakeDragging = true;
        this.setScrollState(1);
        this.mLastMotionX = 0.0f;
        this.mInitialMotionX = 0.0f;
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            velocityTracker.clear();
        }
        long l = SystemClock.uptimeMillis();
        velocityTracker = MotionEvent.obtain((long)l, (long)l, (int)0, (float)0.0f, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement((MotionEvent)velocityTracker);
        velocityTracker.recycle();
        this.mFakeDragBeginTime = l;
        return true;
    }

    protected boolean canScroll(View view, boolean bl, int n, int n2, int n3) {
        boolean bl2 = view instanceof ViewGroup;
        boolean bl3 = true;
        if (bl2) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n4 = view.getScrollX();
            int n5 = view.getScrollY();
            for (int i = viewGroup.getChildCount() - 1; i >= 0; --i) {
                int n6;
                int n7 = n2 + n4;
                View view2 = viewGroup.getChildAt(i);
                if (n7 < view2.getLeft() || n7 >= view2.getRight() || (n6 = n3 + n5) < view2.getTop() || n6 >= view2.getBottom() || !this.canScroll(view2, true, n, n7 - view2.getLeft(), n6 - view2.getTop())) continue;
                return true;
            }
        }
        bl = bl && view.canScrollHorizontally(-n) ? bl3 : false;
        return bl;
    }

    public boolean canScrollHorizontally(int n) {
        PagerAdapter pagerAdapter = this.mAdapter;
        boolean bl = false;
        boolean bl2 = false;
        if (pagerAdapter == null) {
            return false;
        }
        int n2 = this.getClientWidth();
        int n3 = this.getScrollX();
        if (n < 0) {
            if (n3 > (int)((float)n2 * this.mFirstOffset)) {
                bl2 = true;
            }
            return bl2;
        }
        bl2 = bl;
        if (n > 0) {
            bl2 = bl;
            if (n3 < (int)((float)n2 * this.mLastOffset)) {
                bl2 = true;
            }
        }
        return bl2;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        boolean bl = layoutParams instanceof LayoutParams && super.checkLayoutParams(layoutParams);
        return bl;
    }

    public void clearOnPageChangeListeners() {
        List<OnPageChangeListener> list = this.mOnPageChangeListeners;
        if (list != null) {
            list.clear();
        }
    }

    public void computeScroll() {
        this.mIsScrollStarted = true;
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int n = this.getScrollX();
            int n2 = this.getScrollY();
            int n3 = this.mScroller.getCurrX();
            int n4 = this.mScroller.getCurrY();
            if (n != n3 || n2 != n4) {
                this.scrollTo(n3, n4);
                if (!this.pageScrolled(n3)) {
                    this.mScroller.abortAnimation();
                    this.scrollTo(0, n4);
                }
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.completeScroll(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    void dataSetChanged() {
        int n;
        this.mExpectedAdapterCount = n = this.mAdapter.getCount();
        int n2 = this.mItems.size() < this.mOffscreenPageLimit * 2 + 1 && this.mItems.size() < n ? 1 : 0;
        int n3 = this.mCurItem;
        int n4 = 0;
        int n5 = 0;
        while (n4 < this.mItems.size()) {
            int n6;
            int n7;
            int n8;
            block12: {
                block14: {
                    int n9;
                    ItemInfo itemInfo;
                    block13: {
                        block11: {
                            itemInfo = this.mItems.get(n4);
                            n9 = this.mAdapter.getItemPosition(itemInfo.object);
                            if (n9 != -1) break block11;
                            n8 = n3;
                            n7 = n4;
                            n6 = n5;
                            break block12;
                        }
                        if (n9 != -2) break block13;
                        this.mItems.remove(n4);
                        n8 = n4 - 1;
                        n2 = n5;
                        if (n5 == 0) {
                            this.mAdapter.startUpdate(this);
                            n2 = 1;
                        }
                        this.mAdapter.destroyItem(this, itemInfo.position, itemInfo.object);
                        n4 = n8;
                        n5 = n2;
                        if (this.mCurItem == itemInfo.position) {
                            n3 = Math.max(0, Math.min(this.mCurItem, n - 1));
                            n5 = n2;
                            n4 = n8;
                        }
                        break block14;
                    }
                    n8 = n3;
                    n7 = n4;
                    n6 = n5;
                    if (itemInfo.position == n9) break block12;
                    if (itemInfo.position == this.mCurItem) {
                        n3 = n9;
                    }
                    itemInfo.position = n9;
                }
                n2 = 1;
                n8 = n3;
                n7 = n4;
                n6 = n5;
            }
            n4 = n7 + 1;
            n3 = n8;
            n5 = n6;
        }
        if (n5 != 0) {
            this.mAdapter.finishUpdate(this);
        }
        Collections.sort(this.mItems, COMPARATOR);
        if (n2 != 0) {
            n4 = this.getChildCount();
            for (n5 = 0; n5 < n4; ++n5) {
                LayoutParams layoutParams = (LayoutParams)this.getChildAt(n5).getLayoutParams();
                if (layoutParams.isDecor) continue;
                layoutParams.widthFactor = 0.0f;
            }
            this.setCurrentItemInternal(n3, false, true);
            this.requestLayout();
        }
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        boolean bl = super.dispatchKeyEvent(keyEvent) || this.executeKeyEvent(keyEvent);
        return bl;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (accessibilityEvent.getEventType() == 4096) {
            return super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i);
            if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem || !view.dispatchPopulateAccessibilityEvent(accessibilityEvent)) continue;
            return true;
        }
        return false;
    }

    float distanceInfluenceForSnapDuration(float f) {
        return (float)Math.sin((f - 0.5f) * 0.47123894f);
    }

    public void draw(Canvas canvas) {
        PagerAdapter pagerAdapter;
        super.draw(canvas);
        int n = this.getOverScrollMode();
        int n2 = 0;
        int n3 = 0;
        if (n != 0 && (n != 1 || (pagerAdapter = this.mAdapter) == null || pagerAdapter.getCount() <= 1)) {
            this.mLeftEdge.finish();
            this.mRightEdge.finish();
        } else {
            if (!this.mLeftEdge.isFinished()) {
                n2 = canvas.save();
                n3 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                n = this.getWidth();
                canvas.rotate(270.0f);
                canvas.translate((float)(-n3 + this.getPaddingTop()), this.mFirstOffset * (float)n);
                this.mLeftEdge.setSize(n3, n);
                n3 = 0 | this.mLeftEdge.draw(canvas);
                canvas.restoreToCount(n2);
            }
            n2 = n3;
            if (!this.mRightEdge.isFinished()) {
                n = canvas.save();
                int n4 = this.getWidth();
                n2 = this.getHeight();
                int n5 = this.getPaddingTop();
                int n6 = this.getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate((float)(-this.getPaddingTop()), -(this.mLastOffset + 1.0f) * (float)n4);
                this.mRightEdge.setSize(n2 - n5 - n6, n4);
                n2 = n3 | this.mRightEdge.draw(canvas);
                canvas.restoreToCount(n);
            }
        }
        if (n2 != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable2 = this.mMarginDrawable;
        if (drawable2 != null && drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
    }

    public void endFakeDrag() {
        if (this.mFakeDragging) {
            if (this.mAdapter != null) {
                Object object = this.mVelocityTracker;
                object.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int n = (int)object.getXVelocity(this.mActivePointerId);
                this.mPopulatePending = true;
                int n2 = this.getClientWidth();
                int n3 = this.getScrollX();
                object = this.infoForCurrentScrollPosition();
                this.setCurrentItemInternal(this.determineTargetPage(object.position, ((float)n3 / (float)n2 - object.offset) / object.widthFactor, n, (int)(this.mLastMotionX - this.mInitialMotionX)), true, true, n);
            }
            this.endDrag();
            this.mFakeDragging = false;
            return;
        }
        throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
    }

    public boolean executeKeyEvent(KeyEvent keyEvent) {
        boolean bl;
        block4: {
            block0: {
                block1: {
                    block2: {
                        block3: {
                            if (keyEvent.getAction() != 0) break block0;
                            int n = keyEvent.getKeyCode();
                            if (n == 21) break block1;
                            if (n == 22) break block2;
                            if (n != 61) break block0;
                            if (!keyEvent.hasNoModifiers()) break block3;
                            bl = this.arrowScroll(2);
                            break block4;
                        }
                        if (!keyEvent.hasModifiers(1)) break block0;
                        bl = this.arrowScroll(1);
                        break block4;
                    }
                    bl = keyEvent.hasModifiers(2) ? this.pageRight() : this.arrowScroll(66);
                    break block4;
                }
                bl = keyEvent.hasModifiers(2) ? this.pageLeft() : this.arrowScroll(17);
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public void fakeDragBy(float f) {
        if (this.mFakeDragging) {
            if (this.mAdapter == null) {
                return;
            }
            this.mLastMotionX += f;
            float f2 = (float)this.getScrollX() - f;
            float f3 = this.getClientWidth();
            f = this.mFirstOffset * f3;
            float f4 = this.mLastOffset * f3;
            ItemInfo itemInfo = this.mItems.get(0);
            Object object = this.mItems;
            object = ((ArrayList)object).get(((ArrayList)object).size() - 1);
            if (itemInfo.position != 0) {
                f = itemInfo.offset * f3;
            }
            if (((ItemInfo)object).position != this.mAdapter.getCount() - 1) {
                f4 = ((ItemInfo)object).offset * f3;
            }
            if (!(f2 < f)) {
                f = f2;
                if (f2 > f4) {
                    f = f4;
                }
            }
            f4 = this.mLastMotionX;
            int n = (int)f;
            this.mLastMotionX = f4 + (f - (float)n);
            this.scrollTo(n, this.getScrollY());
            this.pageScrolled(n);
            long l = SystemClock.uptimeMillis();
            itemInfo = MotionEvent.obtain((long)this.mFakeDragBeginTime, (long)l, (int)2, (float)this.mLastMotionX, (float)0.0f, (int)0);
            this.mVelocityTracker.addMovement((MotionEvent)itemInfo);
            itemInfo.recycle();
            return;
        }
        throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return this.generateDefaultLayoutParams();
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    protected int getChildDrawingOrder(int n, int n2) {
        int n3 = n2;
        if (this.mDrawingOrder == 2) {
            n3 = n - 1 - n2;
        }
        return ((LayoutParams)this.mDrawingOrderedChildren.get((int)n3).getLayoutParams()).childIndex;
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    ItemInfo infoForAnyChild(View view) {
        ViewParent viewParent;
        while ((viewParent = view.getParent()) != this) {
            if (viewParent != null && viewParent instanceof View) {
                view = (View)viewParent;
                continue;
            }
            return null;
        }
        return this.infoForChild(view);
    }

    ItemInfo infoForChild(View view) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo itemInfo = this.mItems.get(i);
            if (!this.mAdapter.isViewFromObject(view, itemInfo.object)) continue;
            return itemInfo;
        }
        return null;
    }

    ItemInfo infoForPosition(int n) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo itemInfo = this.mItems.get(i);
            if (itemInfo.position != n) continue;
            return itemInfo;
        }
        return null;
    }

    void initViewPager() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        float f = context.getResources().getDisplayMetrics().density;
        this.mTouchSlop = viewConfiguration.getScaledPagingTouchSlop();
        this.mMinimumVelocity = (int)(400.0f * f);
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mLeftEdge = new EdgeEffect(context);
        this.mRightEdge = new EdgeEffect(context);
        this.mFlingDistance = (int)(25.0f * f);
        this.mCloseEnough = (int)(2.0f * f);
        this.mDefaultGutterSize = (int)(f * 16.0f);
        ViewCompat.setAccessibilityDelegate((View)this, new MyAccessibilityDelegate());
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, 1);
        }
        ViewCompat.setOnApplyWindowInsetsListener((View)this, new OnApplyWindowInsetsListener(){
            private final Rect mTempRect = new Rect();

            @Override
            public WindowInsetsCompat onApplyWindowInsets(View object, WindowInsetsCompat windowInsetsCompat) {
                if (((WindowInsetsCompat)(object = ViewCompat.onApplyWindowInsets((View)object, windowInsetsCompat))).isConsumed()) {
                    return object;
                }
                Rect rect = this.mTempRect;
                rect.left = ((WindowInsetsCompat)object).getSystemWindowInsetLeft();
                rect.top = ((WindowInsetsCompat)object).getSystemWindowInsetTop();
                rect.right = ((WindowInsetsCompat)object).getSystemWindowInsetRight();
                rect.bottom = ((WindowInsetsCompat)object).getSystemWindowInsetBottom();
                int n = ViewPager.this.getChildCount();
                for (int i = 0; i < n; ++i) {
                    windowInsetsCompat = ViewCompat.dispatchApplyWindowInsets(ViewPager.this.getChildAt(i), (WindowInsetsCompat)object);
                    rect.left = Math.min(windowInsetsCompat.getSystemWindowInsetLeft(), rect.left);
                    rect.top = Math.min(windowInsetsCompat.getSystemWindowInsetTop(), rect.top);
                    rect.right = Math.min(windowInsetsCompat.getSystemWindowInsetRight(), rect.right);
                    rect.bottom = Math.min(windowInsetsCompat.getSystemWindowInsetBottom(), rect.bottom);
                }
                return ((WindowInsetsCompat)object).replaceSystemWindowInsets(rect.left, rect.top, rect.right, rect.bottom);
            }
        });
    }

    public boolean isFakeDragging() {
        return this.mFakeDragging;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mEndScrollRunnable);
        Scroller scroller = this.mScroller;
        if (scroller != null && !scroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
        super.onDetachedFromWindow();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPageMargin > 0 && this.mMarginDrawable != null && this.mItems.size() > 0 && this.mAdapter != null) {
            int n = this.getScrollX();
            int n2 = this.getWidth();
            float f = this.mPageMargin;
            float f2 = n2;
            float f3 = f / f2;
            Object object = this.mItems;
            int n3 = 0;
            object = ((ArrayList)object).get(0);
            f = ((ItemInfo)object).offset;
            int n4 = this.mItems.size();
            int n5 = this.mItems.get((int)(n4 - 1)).position;
            for (int i = ((ItemInfo)object).position; i < n5; ++i) {
                float f4;
                while (i > ((ItemInfo)object).position && n3 < n4) {
                    object = this.mItems;
                    object = ((ArrayList)object).get(++n3);
                }
                if (i == ((ItemInfo)object).position) {
                    f4 = (((ItemInfo)object).offset + ((ItemInfo)object).widthFactor) * f2;
                    f = ((ItemInfo)object).offset + ((ItemInfo)object).widthFactor + f3;
                } else {
                    float f5 = this.mAdapter.getPageWidth(i);
                    f4 = f + (f5 + f3);
                    f5 = (f + f5) * f2;
                    f = f4;
                    f4 = f5;
                }
                if ((float)this.mPageMargin + f4 > (float)n) {
                    this.mMarginDrawable.setBounds(Math.round(f4), this.mTopPageBounds, Math.round((float)this.mPageMargin + f4), this.mBottomPageBounds);
                    this.mMarginDrawable.draw(canvas);
                }
                if (f4 > (float)(n + n2)) break;
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction() & 0xFF;
        if (n != 3 && n != 1) {
            if (n != 0) {
                if (this.mIsBeingDragged) {
                    return true;
                }
                if (this.mIsUnableToDrag) {
                    return false;
                }
            }
            if (n != 0) {
                if (n != 2) {
                    if (n == 6) {
                        this.onSecondaryPointerUp(motionEvent);
                    }
                } else {
                    n = this.mActivePointerId;
                    if (n != -1) {
                        n = motionEvent.findPointerIndex(n);
                        float f = motionEvent.getX(n);
                        float f2 = f - this.mLastMotionX;
                        float f3 = Math.abs(f2);
                        float f4 = motionEvent.getY(n);
                        float f5 = Math.abs(f4 - this.mInitialMotionY);
                        float f6 = f2 - 0.0f;
                        float f7 = f6 == 0.0f ? 0 : (f6 > 0.0f ? 1 : -1);
                        if (f7 != false && !this.isGutterDrag(this.mLastMotionX, f2) && this.canScroll((View)this, false, (int)f2, (int)f, (int)f4)) {
                            this.mLastMotionX = f;
                            this.mLastMotionY = f4;
                            this.mIsUnableToDrag = true;
                            return false;
                        }
                        n = this.mTouchSlop;
                        if (f3 > (float)n && f3 * 0.5f > f5) {
                            this.mIsBeingDragged = true;
                            this.requestParentDisallowInterceptTouchEvent(true);
                            this.setScrollState(1);
                            f2 = this.mInitialMotionX;
                            f5 = this.mTouchSlop;
                            f5 = f7 > 0 ? f2 + f5 : f2 - f5;
                            this.mLastMotionX = f5;
                            this.mLastMotionY = f4;
                            this.setScrollingCacheEnabled(true);
                        } else if (f5 > (float)n) {
                            this.mIsUnableToDrag = true;
                        }
                        if (this.mIsBeingDragged && this.performDrag(f)) {
                            ViewCompat.postInvalidateOnAnimation((View)this);
                        }
                    }
                }
            } else {
                float f;
                this.mInitialMotionX = f = motionEvent.getX();
                this.mLastMotionX = f;
                this.mInitialMotionY = f = motionEvent.getY();
                this.mLastMotionY = f;
                this.mActivePointerId = motionEvent.getPointerId(0);
                this.mIsUnableToDrag = false;
                this.mIsScrollStarted = true;
                this.mScroller.computeScrollOffset();
                if (this.mScrollState == 2 && Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) > this.mCloseEnough) {
                    this.mScroller.abortAnimation();
                    this.mPopulatePending = false;
                    this.populate();
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                } else {
                    this.completeScroll(false);
                    this.mIsBeingDragged = false;
                }
            }
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            this.mVelocityTracker.addMovement(motionEvent);
            return this.mIsBeingDragged;
        }
        this.resetTouch();
        return false;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        Object object;
        int n5;
        Object object2;
        int n6;
        int n7 = this.getChildCount();
        int n8 = n3 - n;
        int n9 = n4 - n2;
        n2 = this.getPaddingLeft();
        n = this.getPaddingTop();
        n4 = this.getPaddingRight();
        n3 = this.getPaddingBottom();
        int n10 = this.getScrollX();
        int n11 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            int n12;
            int n13;
            int n14;
            int n15;
            block10: {
                block14: {
                    block15: {
                        block11: {
                            block12: {
                                block13: {
                                    object2 = this.getChildAt(n6);
                                    n15 = n2;
                                    n14 = n;
                                    n13 = n4;
                                    n12 = n3;
                                    n5 = n11;
                                    if (object2.getVisibility() == 8) break block10;
                                    object = (LayoutParams)object2.getLayoutParams();
                                    n15 = n2;
                                    n14 = n;
                                    n13 = n4;
                                    n12 = n3;
                                    n5 = n11;
                                    if (!object.isDecor) break block10;
                                    n5 = object.gravity & 7;
                                    n13 = object.gravity & 0x70;
                                    if (n5 == 1) break block11;
                                    if (n5 == 3) break block12;
                                    if (n5 == 5) break block13;
                                    n5 = n2;
                                    n12 = n2;
                                    n2 = n5;
                                    break block14;
                                }
                                n5 = n8 - n4 - object2.getMeasuredWidth();
                                n4 += object2.getMeasuredWidth();
                                break block15;
                            }
                            n5 = object2.getMeasuredWidth() + n2;
                            n12 = n2;
                            n2 = n5;
                            break block14;
                        }
                        n5 = Math.max((n8 - object2.getMeasuredWidth()) / 2, n2);
                    }
                    n12 = n5;
                }
                if (n13 != 16) {
                    if (n13 != 48) {
                        if (n13 != 80) {
                            n13 = n;
                            n5 = n;
                            n = n13;
                        } else {
                            n5 = n9 - n3 - object2.getMeasuredHeight();
                            n3 += object2.getMeasuredHeight();
                        }
                    } else {
                        n13 = object2.getMeasuredHeight() + n;
                        n5 = n;
                        n = n13;
                    }
                } else {
                    n5 = Math.max((n9 - object2.getMeasuredHeight()) / 2, n);
                }
                object2.layout(n12 += n10, n5, object2.getMeasuredWidth() + n12, n5 + object2.getMeasuredHeight());
                n5 = n11 + 1;
                n12 = n3;
                n13 = n4;
                n14 = n;
                n15 = n2;
            }
            n2 = n15;
            n = n14;
            n4 = n13;
            n3 = n12;
            n11 = n5;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            ItemInfo itemInfo;
            object = this.getChildAt(n5);
            if (object.getVisibility() == 8) continue;
            object2 = (LayoutParams)object.getLayoutParams();
            if (object2.isDecor || (itemInfo = this.infoForChild((View)object)) == null) continue;
            float f = n8 - n2 - n4;
            n6 = (int)(itemInfo.offset * f) + n2;
            if (object2.needsMeasure) {
                object2.needsMeasure = false;
                object.measure(View.MeasureSpec.makeMeasureSpec((int)((int)(f * object2.widthFactor)), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(n9 - n - n3), (int)0x40000000));
            }
            object.layout(n6, n, object.getMeasuredWidth() + n6, object.getMeasuredHeight() + n);
        }
        this.mTopPageBounds = n;
        this.mBottomPageBounds = n9 - n3;
        this.mDecorChildCount = n11;
        if (this.mFirstLayout) {
            this.scrollToItem(this.mCurItem, false, 0, false);
        }
        this.mFirstLayout = false;
    }

    /*
     * Unable to fully structure code
     */
    protected void onMeasure(int var1_1, int var2_2) {
        this.setMeasuredDimension(ViewPager.getDefaultSize((int)0, (int)var1_1), ViewPager.getDefaultSize((int)0, (int)var2_2));
        var1_1 = this.getMeasuredWidth();
        this.mGutterSize = Math.min(var1_1 / 10, this.mDefaultGutterSize);
        var1_1 = var1_1 - this.getPaddingLeft() - this.getPaddingRight();
        var2_2 = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        var3_3 = this.getChildCount();
        var4_4 = 0;
        while (true) {
            block12: {
                block13: {
                    var5_5 = 1;
                    var6_6 = 0x40000000;
                    if (var4_4 >= var3_3) break;
                    var7_7 = this.getChildAt(var4_4);
                    var8_8 = var1_1;
                    var9_9 = var2_2;
                    if (var7_7.getVisibility() == 8) break block12;
                    var10_10 = (LayoutParams)var7_7.getLayoutParams();
                    var8_8 = var1_1;
                    var9_9 = var2_2;
                    if (var10_10 == null) break block12;
                    var8_8 = var1_1;
                    var9_9 = var2_2;
                    if (!var10_10.isDecor) break block12;
                    var9_9 = var10_10.gravity & 7;
                    var8_8 = var10_10.gravity & 112;
                    var11_11 = var8_8 == 48 || var8_8 == 80;
                    var12_12 = var5_5;
                    if (var9_9 != 3) {
                        var12_12 = var9_9 == 5 ? var5_5 : 0;
                    }
                    var9_9 = -2147483648;
                    if (!var11_11) break block13;
                    var8_8 = 0x40000000;
                    ** GOTO lbl-1000
                }
                var8_8 = var9_9;
                if (var12_12 != 0) {
                    var5_5 = 0x40000000;
                    var8_8 = var9_9;
                    var9_9 = var5_5;
                } else lbl-1000:
                // 2 sources

                {
                    var9_9 = -2147483648;
                }
                if (var10_10.width != -2) {
                    var8_8 = var10_10.width != -1 ? var10_10.width : var1_1;
                    var13_13 = 0x40000000;
                    var5_5 = var8_8;
                    var8_8 = var13_13;
                } else {
                    var5_5 = var1_1;
                }
                if (var10_10.height != -2) {
                    var9_9 = var10_10.height != -1 ? var10_10.height : var2_2;
                } else {
                    var13_13 = var2_2;
                    var6_6 = var9_9;
                    var9_9 = var13_13;
                }
                var7_7.measure(View.MeasureSpec.makeMeasureSpec((int)var5_5, (int)var8_8), View.MeasureSpec.makeMeasureSpec((int)var9_9, (int)var6_6));
                if (var11_11) {
                    var9_9 = var2_2 - var7_7.getMeasuredHeight();
                    var8_8 = var1_1;
                } else {
                    var8_8 = var1_1;
                    var9_9 = var2_2;
                    if (var12_12 != 0) {
                        var8_8 = var1_1 - var7_7.getMeasuredWidth();
                        var9_9 = var2_2;
                    }
                }
            }
            ++var4_4;
            var1_1 = var8_8;
            var2_2 = var9_9;
        }
        this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)var1_1, (int)0x40000000);
        this.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)var2_2, (int)0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        var9_9 = this.getChildCount();
        for (var2_2 = 0; var2_2 < var9_9; ++var2_2) {
            var7_7 = this.getChildAt(var2_2);
            if (var7_7.getVisibility() == 8 || (var10_10 = (LayoutParams)var7_7.getLayoutParams()) != null && var10_10.isDecor) continue;
            var7_7.measure(View.MeasureSpec.makeMeasureSpec((int)((int)((float)var1_1 * var10_10.widthFactor)), (int)0x40000000), this.mChildHeightMeasureSpec);
        }
    }

    protected void onPageScrolled(int n, float f, int n2) {
        View view;
        int n3 = this.mDecorChildCount;
        int n4 = 0;
        if (n3 > 0) {
            int n5 = this.getScrollX();
            n3 = this.getPaddingLeft();
            int n6 = this.getPaddingRight();
            int n7 = this.getWidth();
            int n8 = this.getChildCount();
            for (int i = 0; i < n8; ++i) {
                view = this.getChildAt(i);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (!layoutParams.isDecor) continue;
                int n9 = layoutParams.gravity & 7;
                if (n9 != 1) {
                    int n10;
                    if (n9 != 3) {
                        if (n9 != 5) {
                            n10 = n3;
                            n9 = n3;
                            n3 = n10;
                        } else {
                            n9 = n7 - n6 - view.getMeasuredWidth();
                            n6 += view.getMeasuredWidth();
                        }
                    } else {
                        n10 = view.getWidth() + n3;
                        n9 = n3;
                        n3 = n10;
                    }
                } else {
                    n9 = Math.max((n7 - view.getMeasuredWidth()) / 2, n3);
                }
                n9 = n9 + n5 - view.getLeft();
                if (n9 == 0) continue;
                view.offsetLeftAndRight(n9);
            }
        }
        this.dispatchOnPageScrolled(n, f, n2);
        if (this.mPageTransformer != null) {
            n2 = this.getScrollX();
            n3 = this.getChildCount();
            for (n = n4; n < n3; ++n) {
                view = this.getChildAt(n);
                if (((LayoutParams)view.getLayoutParams()).isDecor) continue;
                f = (float)(view.getLeft() - n2) / (float)this.getClientWidth();
                this.mPageTransformer.transformPage(view, f);
            }
        }
        this.mCalledSuper = true;
    }

    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        int n2;
        int n3 = this.getChildCount();
        int n4 = -1;
        if ((n & 2) != 0) {
            n4 = n3;
            n3 = 0;
            n2 = 1;
        } else {
            --n3;
            n2 = -1;
        }
        while (n3 != n4) {
            ItemInfo itemInfo;
            View view = this.getChildAt(n3);
            if (view.getVisibility() == 0 && (itemInfo = this.infoForChild(view)) != null && itemInfo.position == this.mCurItem && view.requestFocus(n, rect)) {
                return true;
            }
            n3 += n2;
        }
        return false;
    }

    public void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState((Parcelable)object);
            return;
        }
        SavedState savedState = (SavedState)object;
        super.onRestoreInstanceState(savedState.getSuperState());
        object = this.mAdapter;
        if (object != null) {
            ((PagerAdapter)object).restoreState(savedState.adapterState, savedState.loader);
            this.setCurrentItemInternal(savedState.position, false, true);
        } else {
            this.mRestoredCurItem = savedState.position;
            this.mRestoredAdapterState = savedState.adapterState;
            this.mRestoredClassLoader = savedState.loader;
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.position = this.mCurItem;
        PagerAdapter pagerAdapter = this.mAdapter;
        if (pagerAdapter != null) {
            savedState.adapterState = pagerAdapter.saveState();
        }
        return savedState;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n != n3) {
            n2 = this.mPageMargin;
            this.recomputeScrollPosition(n, n3, n2, n2);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        block16: {
            block20: {
                block17: {
                    block18: {
                        block19: {
                            if (this.mFakeDragging) {
                                return true;
                            }
                            var2_2 = var1_1.getAction();
                            var3_3 = false;
                            if (var2_2 == 0 && var1_1.getEdgeFlags() != 0) {
                                return false;
                            }
                            var4_4 = this.mAdapter;
                            if (var4_4 == null || var4_4.getCount() == 0) break block16;
                            if (this.mVelocityTracker == null) {
                                this.mVelocityTracker = VelocityTracker.obtain();
                            }
                            this.mVelocityTracker.addMovement(var1_1);
                            var2_2 = var1_1.getAction() & 255;
                            if (var2_2 == 0) break block17;
                            if (var2_2 == 1) break block18;
                            if (var2_2 == 2) break block19;
                            if (var2_2 != 3) {
                                if (var2_2 != 5) {
                                    if (var2_2 == 6) {
                                        this.onSecondaryPointerUp(var1_1);
                                        this.mLastMotionX = var1_1.getX(var1_1.findPointerIndex(this.mActivePointerId));
                                    }
                                } else {
                                    var2_2 = var1_1.getActionIndex();
                                    this.mLastMotionX = var1_1.getX(var2_2);
                                    this.mActivePointerId = var1_1.getPointerId(var2_2);
                                }
                            } else if (this.mIsBeingDragged) {
                                this.scrollToItem(this.mCurItem, true, 0, false);
                                var3_3 = this.resetTouch();
                            }
                            break block20;
                        }
                        if (this.mIsBeingDragged) ** GOTO lbl52
                        var2_2 = var1_1.findPointerIndex(this.mActivePointerId);
                        if (var2_2 == -1) {
                            var3_3 = this.resetTouch();
                        } else {
                            var5_5 = var1_1.getX(var2_2);
                            var6_8 = Math.abs(var5_5 - this.mLastMotionX);
                            var7_9 = var1_1.getY(var2_2);
                            var8_11 = Math.abs(var7_9 - this.mLastMotionY);
                            if (var6_8 > (float)this.mTouchSlop && var6_8 > var8_11) {
                                this.mIsBeingDragged = true;
                                this.requestParentDisallowInterceptTouchEvent(true);
                                var6_8 = this.mInitialMotionX;
                                var5_5 = var5_5 - var6_8 > 0.0f ? var6_8 + (float)this.mTouchSlop : var6_8 - (float)this.mTouchSlop;
                                this.mLastMotionX = var5_5;
                                this.mLastMotionY = var7_9;
                                this.setScrollState(1);
                                this.setScrollingCacheEnabled(true);
                                var4_4 = this.getParent();
                                if (var4_4 != null) {
                                    var4_4.requestDisallowInterceptTouchEvent(true);
                                }
                            }
lbl52:
                            // 6 sources

                            if (this.mIsBeingDragged) {
                                var3_3 = false | this.performDrag(var1_1.getX(var1_1.findPointerIndex(this.mActivePointerId)));
                            }
                        }
                        break block20;
                    }
                    if (this.mIsBeingDragged) {
                        var4_4 = this.mVelocityTracker;
                        var4_4.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                        var9_12 = (int)var4_4.getXVelocity(this.mActivePointerId);
                        this.mPopulatePending = true;
                        var2_2 = this.getClientWidth();
                        var10_13 = this.getScrollX();
                        var4_4 = this.infoForCurrentScrollPosition();
                        var7_10 = this.mPageMargin;
                        var5_6 = var2_2;
                        this.setCurrentItemInternal(this.determineTargetPage(var4_4.position, ((float)var10_13 / var5_6 - var4_4.offset) / (var4_4.widthFactor + (var7_10 /= var5_6)), var9_12, (int)(var1_1.getX(var1_1.findPointerIndex(this.mActivePointerId)) - this.mInitialMotionX)), true, true, var9_12);
                        var3_3 = this.resetTouch();
                    }
                    break block20;
                }
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mInitialMotionX = var5_7 = var1_1.getX();
                this.mLastMotionX = var5_7;
                this.mInitialMotionY = var5_7 = var1_1.getY();
                this.mLastMotionY = var5_7;
                this.mActivePointerId = var1_1.getPointerId(0);
            }
            if (var3_3) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
            return true;
        }
        return false;
    }

    boolean pageLeft() {
        int n = this.mCurItem;
        if (n > 0) {
            this.setCurrentItem(n - 1, true);
            return true;
        }
        return false;
    }

    boolean pageRight() {
        PagerAdapter pagerAdapter = this.mAdapter;
        if (pagerAdapter != null && this.mCurItem < pagerAdapter.getCount() - 1) {
            this.setCurrentItem(this.mCurItem + 1, true);
            return true;
        }
        return false;
    }

    void populate() {
        this.populate(this.mCurItem);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void populate(int var1_1) {
        block20: {
            block21: {
                block26: {
                    block18: {
                        var2_2 = this.mCurItem;
                        if (var2_2 != var1_1) {
                            var3_3 = this.infoForPosition(var2_2);
                            this.mCurItem = var1_1;
                        } else {
                            var3_3 = null;
                        }
                        if (this.mAdapter == null) {
                            this.sortChildDrawingOrder();
                            return;
                        }
                        if (this.mPopulatePending) {
                            this.sortChildDrawingOrder();
                            return;
                        }
                        if (this.getWindowToken() == null) {
                            return;
                        }
                        this.mAdapter.startUpdate(this);
                        var1_1 = this.mOffscreenPageLimit;
                        var4_4 = Math.max(0, this.mCurItem - var1_1);
                        var5_5 = this.mAdapter.getCount();
                        var6_6 = Math.min(var5_5 - 1, this.mCurItem + var1_1);
                        if (var5_5 != this.mExpectedAdapterCount) break block20;
                        for (var1_1 = 0; var1_1 < this.mItems.size(); ++var1_1) {
                            var7_7 /* !! */  = this.mItems.get(var1_1);
                            if (var7_7 /* !! */ .position < this.mCurItem) continue;
                            if (var7_7 /* !! */ .position != this.mCurItem) break;
                            break block18;
                        }
                        var7_7 /* !! */  = null;
                    }
                    var8_10 = var7_7 /* !! */ ;
                    if (var7_7 /* !! */  == null) {
                        var8_10 = var7_7 /* !! */ ;
                        if (var5_5 > 0) {
                            var8_10 = this.addNewItem(this.mCurItem, var1_1);
                        }
                    }
                    if (var8_10 == null) break block21;
                    var2_2 = var1_1 - 1;
                    var7_7 /* !! */  = var2_2 >= 0 ? this.mItems.get(var2_2) : null;
                    var9_11 = this.getClientWidth();
                    var10_12 = var9_11 <= 0 ? 0.0f : 2.0f - var8_10.widthFactor + (float)this.getPaddingLeft() / (float)var9_11;
                    var12_14 = 0.0f;
                    for (var11_13 = this.mCurItem - 1; var11_13 >= 0; --var11_13) {
                        block23: {
                            block24: {
                                block25: {
                                    block22: {
                                        if (!(var12_14 >= var10_12) || var11_13 >= var4_4) break block22;
                                        if (var7_7 /* !! */  == null) break;
                                        var13_15 = var1_1;
                                        var14_16 = var2_2;
                                        var15_17 /* !! */  = var7_7 /* !! */ ;
                                        var16_18 = var12_14;
                                        if (var11_13 != var7_7 /* !! */ .position) break block23;
                                        var13_15 = var1_1--;
                                        var14_16 = var2_2;
                                        var15_17 /* !! */  = var7_7 /* !! */ ;
                                        var16_18 = var12_14;
                                        if (var7_7 /* !! */ .scrolling) break block23;
                                        this.mItems.remove(var2_2);
                                        this.mAdapter.destroyItem(this, var11_13, var7_7 /* !! */ .object);
                                        var14_16 = var1_1;
                                        var13_15 = --var2_2;
                                        var16_18 = var12_14;
                                        if (var2_2 < 0) ** GOTO lbl-1000
                                        var7_7 /* !! */  = this.mItems.get(var2_2);
                                        var16_18 = var12_14;
                                        break block24;
                                    }
                                    if (var7_7 /* !! */  == null || var11_13 != var7_7 /* !! */ .position) break block25;
                                    var14_16 = var1_1;
                                    var13_15 = --var2_2;
                                    var16_18 = var12_14 += var7_7 /* !! */ .widthFactor;
                                    if (var2_2 < 0) ** GOTO lbl-1000
                                    var7_7 /* !! */  = this.mItems.get(var2_2);
                                    var16_18 = var12_14;
                                    break block24;
                                }
                                var14_16 = ++var1_1;
                                var13_15 = var2_2;
                                var16_18 = var12_14 += this.addNewItem((int)var11_13, (int)(var2_2 + 1)).widthFactor;
                                if (var2_2 >= 0) {
                                    var7_7 /* !! */  = this.mItems.get(var2_2);
                                    var16_18 = var12_14;
                                } else lbl-1000:
                                // 3 sources

                                {
                                    var7_7 /* !! */  = null;
                                    var2_2 = var13_15;
                                    var1_1 = var14_16;
                                }
                            }
                            var15_17 /* !! */  = var7_7 /* !! */ ;
                            var14_16 = var2_2;
                            var13_15 = var1_1;
                        }
                        var1_1 = var13_15;
                        var2_2 = var14_16;
                        var7_7 /* !! */  = var15_17 /* !! */ ;
                        var12_14 = var16_18;
                    }
                    var12_14 = var8_10.widthFactor;
                    var14_16 = var1_1 + 1;
                    if (!(var12_14 < 2.0f)) break block26;
                    var7_7 /* !! */  = var14_16 < this.mItems.size() ? this.mItems.get(var14_16) : null;
                    var10_12 = var9_11 <= 0 ? 0.0f : (float)this.getPaddingRight() / (float)var9_11 + 2.0f;
                    var2_2 = this.mCurItem;
                    var15_17 /* !! */  = var7_7 /* !! */ ;
                    while ((var13_15 = var2_2 + 1) < var5_5) {
                        block19: {
                            block29: {
                                block27: {
                                    block28: {
                                        if (!(var12_14 >= var10_12) || var13_15 <= var6_6) break block27;
                                        if (var15_17 /* !! */  == null) break;
                                        var16_18 = var12_14;
                                        var2_2 = var14_16;
                                        var7_7 /* !! */  = var15_17 /* !! */ ;
                                        if (var13_15 != var15_17 /* !! */ .position) break block19;
                                        var16_18 = var12_14;
                                        var2_2 = var14_16;
                                        var7_7 /* !! */  = var15_17 /* !! */ ;
                                        if (var15_17 /* !! */ .scrolling) break block19;
                                        this.mItems.remove(var14_16);
                                        this.mAdapter.destroyItem(this, var13_15, var15_17 /* !! */ .object);
                                        var16_18 = var12_14;
                                        var2_2 = var14_16;
                                        if (var14_16 >= this.mItems.size()) break block28;
                                        var7_7 /* !! */  = this.mItems.get(var14_16);
                                        var16_18 = var12_14;
                                        var2_2 = var14_16;
                                        break block19;
                                    }
lbl121:
                                    // 3 sources

                                    while (true) {
                                        var7_7 /* !! */  = null;
                                        break block19;
                                        break;
                                    }
                                }
                                if (var15_17 /* !! */  == null || var13_15 != var15_17 /* !! */ .position) break block29;
                                var16_18 = var12_14 += var15_17 /* !! */ .widthFactor;
                                var2_2 = ++var14_16;
                                if (var14_16 >= this.mItems.size()) ** GOTO lbl121
                                var7_7 /* !! */  = this.mItems.get(var14_16);
                                var16_18 = var12_14;
                                var2_2 = var14_16;
                                break block19;
                            }
                            var7_7 /* !! */  = this.addNewItem(var13_15, var14_16);
                            var16_18 = var12_14 += var7_7 /* !! */ .widthFactor;
                            var2_2 = ++var14_16;
                            if (var14_16 >= this.mItems.size()) ** continue;
                            var7_7 /* !! */  = this.mItems.get(var14_16);
                            var2_2 = var14_16;
                            var16_18 = var12_14;
                        }
                        var12_14 = var16_18;
                        var14_16 = var2_2;
                        var15_17 /* !! */  = var7_7 /* !! */ ;
                        var2_2 = var13_15;
                    }
                }
                this.calculatePageOffsets(var8_10, var1_1, (ItemInfo)var3_3);
                this.mAdapter.setPrimaryItem(this, this.mCurItem, var8_10.object);
            }
            this.mAdapter.finishUpdate(this);
            var2_2 = this.getChildCount();
            for (var1_1 = 0; var1_1 < var2_2; ++var1_1) {
                var3_3 = this.getChildAt(var1_1);
                var7_7 /* !! */  = (LayoutParams)var3_3.getLayoutParams();
                var7_7 /* !! */ .childIndex = var1_1;
                if (var7_7 /* !! */ .isDecor || var7_7 /* !! */ .widthFactor != 0.0f || (var3_3 = this.infoForChild((View)var3_3)) == null) continue;
                var7_7 /* !! */ .widthFactor = var3_3.widthFactor;
                var7_7 /* !! */ .position = var3_3.position;
            }
            this.sortChildDrawingOrder();
            if (this.hasFocus() && ((var7_7 /* !! */  = (var7_7 /* !! */  = this.findFocus()) != null ? this.infoForAnyChild((View)var7_7 /* !! */ ) : null) == null || var7_7 /* !! */ .position != this.mCurItem)) {
                for (var1_1 = 0; !(var1_1 >= this.getChildCount() || (var7_7 /* !! */  = this.infoForChild((View)(var3_3 = this.getChildAt(var1_1)))) != null && var7_7 /* !! */ .position == this.mCurItem && var3_3.requestFocus(2)); ++var1_1) {
                }
            }
            return;
        }
        try {
            var7_8 = this.getResources().getResourceName(this.getId());
        }
        catch (Resources.NotFoundException var7_9) {
            var7_8 = Integer.toHexString(this.getId());
        }
        var3_3 = new StringBuilder();
        var3_3.append("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: ");
        var3_3.append(this.mExpectedAdapterCount);
        var3_3.append(", found: ");
        var3_3.append(var5_5);
        var3_3.append(" Pager id: ");
        var3_3.append(var7_8);
        var3_3.append(" Pager class: ");
        var3_3.append(this.getClass());
        var3_3.append(" Problematic adapter: ");
        var3_3.append(this.mAdapter.getClass());
        throw new IllegalStateException(var3_3.toString());
    }

    public void removeOnAdapterChangeListener(OnAdapterChangeListener onAdapterChangeListener) {
        List<OnAdapterChangeListener> list = this.mAdapterChangeListeners;
        if (list != null) {
            list.remove(onAdapterChangeListener);
        }
    }

    public void removeOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        List<OnPageChangeListener> list = this.mOnPageChangeListeners;
        if (list != null) {
            list.remove(onPageChangeListener);
        }
    }

    public void removeView(View view) {
        if (this.mInLayout) {
            this.removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    public void setAdapter(PagerAdapter pagerAdapter) {
        int n;
        Object object = this.mAdapter;
        int n2 = 0;
        if (object != null) {
            ((PagerAdapter)object).setViewPagerObserver(null);
            this.mAdapter.startUpdate(this);
            for (n = 0; n < this.mItems.size(); ++n) {
                object = this.mItems.get(n);
                this.mAdapter.destroyItem(this, ((ItemInfo)object).position, ((ItemInfo)object).object);
            }
            this.mAdapter.finishUpdate(this);
            this.mItems.clear();
            this.removeNonDecorViews();
            this.mCurItem = 0;
            this.scrollTo(0, 0);
        }
        PagerAdapter pagerAdapter2 = this.mAdapter;
        this.mAdapter = pagerAdapter;
        this.mExpectedAdapterCount = 0;
        if (pagerAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new PagerObserver();
            }
            this.mAdapter.setViewPagerObserver(this.mObserver);
            this.mPopulatePending = false;
            boolean bl = this.mFirstLayout;
            this.mFirstLayout = true;
            this.mExpectedAdapterCount = this.mAdapter.getCount();
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else if (!bl) {
                this.populate();
            } else {
                this.requestLayout();
            }
        }
        if ((object = this.mAdapterChangeListeners) != null && !object.isEmpty()) {
            int n3 = this.mAdapterChangeListeners.size();
            for (n = n2; n < n3; ++n) {
                this.mAdapterChangeListeners.get(n).onAdapterChanged(this, pagerAdapter2, pagerAdapter);
            }
        }
    }

    public void setCurrentItem(int n) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n, this.mFirstLayout ^ true, false);
    }

    public void setCurrentItem(int n, boolean bl) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n, bl, false);
    }

    void setCurrentItemInternal(int n, boolean bl, boolean bl2) {
        this.setCurrentItemInternal(n, bl, bl2, 0);
    }

    void setCurrentItemInternal(int n, boolean bl, boolean bl2, int n2) {
        PagerAdapter pagerAdapter = this.mAdapter;
        boolean bl3 = false;
        if (pagerAdapter != null && pagerAdapter.getCount() > 0) {
            int n3;
            if (!bl2 && this.mCurItem == n && this.mItems.size() != 0) {
                this.setScrollingCacheEnabled(false);
                return;
            }
            if (n < 0) {
                n3 = 0;
            } else {
                n3 = n;
                if (n >= this.mAdapter.getCount()) {
                    n3 = this.mAdapter.getCount() - 1;
                }
            }
            n = this.mOffscreenPageLimit;
            int n4 = this.mCurItem;
            if (n3 > n4 + n || n3 < n4 - n) {
                for (n = 0; n < this.mItems.size(); ++n) {
                    this.mItems.get((int)n).scrolling = true;
                }
            }
            bl2 = bl3;
            if (this.mCurItem != n3) {
                bl2 = true;
            }
            if (this.mFirstLayout) {
                this.mCurItem = n3;
                if (bl2) {
                    this.dispatchOnPageSelected(n3);
                }
                this.requestLayout();
            } else {
                this.populate(n3);
                this.scrollToItem(n3, bl, n2, bl2);
            }
            return;
        }
        this.setScrollingCacheEnabled(false);
    }

    OnPageChangeListener setInternalPageChangeListener(OnPageChangeListener onPageChangeListener) {
        OnPageChangeListener onPageChangeListener2 = this.mInternalPageChangeListener;
        this.mInternalPageChangeListener = onPageChangeListener;
        return onPageChangeListener2;
    }

    public void setOffscreenPageLimit(int n) {
        int n2 = n;
        if (n < 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Requested offscreen page limit ");
            stringBuilder.append(n);
            stringBuilder.append(" too small; defaulting to ");
            stringBuilder.append(1);
            Log.w((String)TAG, (String)stringBuilder.toString());
            n2 = 1;
        }
        if (n2 != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = n2;
            this.populate();
        }
    }

    @Deprecated
    public void setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public void setPageMargin(int n) {
        int n2 = this.mPageMargin;
        this.mPageMargin = n;
        int n3 = this.getWidth();
        this.recomputeScrollPosition(n3, n3, n, n2);
        this.requestLayout();
    }

    public void setPageMarginDrawable(int n) {
        this.setPageMarginDrawable(ContextCompat.getDrawable(this.getContext(), n));
    }

    public void setPageMarginDrawable(Drawable drawable2) {
        this.mMarginDrawable = drawable2;
        if (drawable2 != null) {
            this.refreshDrawableState();
        }
        boolean bl = drawable2 == null;
        this.setWillNotDraw(bl);
        this.invalidate();
    }

    public void setPageTransformer(boolean bl, PageTransformer pageTransformer) {
        this.setPageTransformer(bl, pageTransformer, 2);
    }

    public void setPageTransformer(boolean bl, PageTransformer pageTransformer, int n) {
        int n2 = 1;
        boolean bl2 = pageTransformer != null;
        boolean bl3 = this.mPageTransformer != null;
        boolean bl4 = bl2 != bl3;
        this.mPageTransformer = pageTransformer;
        this.setChildrenDrawingOrderEnabled(bl2);
        if (bl2) {
            if (bl) {
                n2 = 2;
            }
            this.mDrawingOrder = n2;
            this.mPageTransformerLayerType = n;
        } else {
            this.mDrawingOrder = 0;
        }
        if (bl4) {
            this.populate();
        }
    }

    void setScrollState(int n) {
        if (this.mScrollState == n) {
            return;
        }
        this.mScrollState = n;
        if (this.mPageTransformer != null) {
            boolean bl = n != 0;
            this.enableLayers(bl);
        }
        this.dispatchOnScrollStateChanged(n);
    }

    void smoothScrollTo(int n, int n2) {
        this.smoothScrollTo(n, n2, 0);
    }

    void smoothScrollTo(int n, int n2, int n3) {
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        Scroller scroller = this.mScroller;
        int n4 = scroller != null && !scroller.isFinished() ? 1 : 0;
        if (n4 != 0) {
            n4 = this.mIsScrollStarted ? this.mScroller.getCurrX() : this.mScroller.getStartX();
            this.mScroller.abortAnimation();
            this.setScrollingCacheEnabled(false);
        } else {
            n4 = this.getScrollX();
        }
        int n5 = this.getScrollY();
        int n6 = n - n4;
        if (n6 == 0 && (n2 -= n5) == 0) {
            this.completeScroll(false);
            this.populate();
            this.setScrollState(0);
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.setScrollState(2);
        n = this.getClientWidth();
        int n7 = n / 2;
        float f = Math.abs(n6);
        float f2 = n;
        float f3 = Math.min(1.0f, f * 1.0f / f2);
        f = n7;
        f3 = this.distanceInfluenceForSnapDuration(f3);
        n = Math.abs(n3);
        if (n > 0) {
            n = Math.round(Math.abs((f + f3 * f) / (float)n) * 1000.0f) * 4;
        } else {
            f = this.mAdapter.getPageWidth(this.mCurItem);
            n = (int)(((float)Math.abs(n6) / (f2 * f + (float)this.mPageMargin) + 1.0f) * 100.0f);
        }
        n = Math.min(n, 600);
        this.mIsScrollStarted = false;
        this.mScroller.startScroll(n4, n5, n6, n2, n);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        boolean bl = super.verifyDrawable(drawable2) || drawable2 == this.mMarginDrawable;
        return bl;
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface DecorView {
    }

    static class ItemInfo {
        Object object;
        float offset;
        int position;
        boolean scrolling;
        float widthFactor;

        ItemInfo() {
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        int childIndex;
        public int gravity;
        public boolean isDecor;
        boolean needsMeasure;
        int position;
        float widthFactor = 0.0f;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
            this.gravity = context.getInteger(0, 48);
            context.recycle();
        }
    }

    class MyAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        MyAccessibilityDelegate() {
        }

        private boolean canScroll() {
            PagerAdapter pagerAdapter = ViewPager.this.mAdapter;
            boolean bl = true;
            if (pagerAdapter == null || ViewPager.this.mAdapter.getCount() <= 1) {
                bl = false;
            }
            return bl;
        }

        @Override
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            accessibilityEvent.setClassName((CharSequence)ViewPager.class.getName());
            accessibilityEvent.setScrollable(this.canScroll());
            if (accessibilityEvent.getEventType() == 4096 && ViewPager.this.mAdapter != null) {
                accessibilityEvent.setItemCount(ViewPager.this.mAdapter.getCount());
                accessibilityEvent.setFromIndex(ViewPager.this.mCurItem);
                accessibilityEvent.setToIndex(ViewPager.this.mCurItem);
            }
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
            accessibilityNodeInfoCompat.setClassName(ViewPager.class.getName());
            accessibilityNodeInfoCompat.setScrollable(this.canScroll());
            if (ViewPager.this.canScrollHorizontally(1)) {
                accessibilityNodeInfoCompat.addAction(4096);
            }
            if (ViewPager.this.canScrollHorizontally(-1)) {
                accessibilityNodeInfoCompat.addAction(8192);
            }
        }

        @Override
        public boolean performAccessibilityAction(View object, int n, Bundle bundle) {
            if (super.performAccessibilityAction((View)object, n, bundle)) {
                return true;
            }
            if (n != 4096) {
                if (n != 8192) {
                    return false;
                }
                if (ViewPager.this.canScrollHorizontally(-1)) {
                    object = ViewPager.this;
                    ((ViewPager)((Object)object)).setCurrentItem(((ViewPager)((Object)object)).mCurItem - 1);
                    return true;
                }
                return false;
            }
            if (ViewPager.this.canScrollHorizontally(1)) {
                object = ViewPager.this;
                ((ViewPager)((Object)object)).setCurrentItem(((ViewPager)((Object)object)).mCurItem + 1);
                return true;
            }
            return false;
        }
    }

    public static interface OnAdapterChangeListener {
        public void onAdapterChanged(ViewPager var1, PagerAdapter var2, PagerAdapter var3);
    }

    public static interface OnPageChangeListener {
        public void onPageScrollStateChanged(int var1);

        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);
    }

    public static interface PageTransformer {
        public void transformPage(View var1, float var2);
    }

    private class PagerObserver
    extends DataSetObserver {
        PagerObserver() {
        }

        public void onChanged() {
            ViewPager.this.dataSetChanged();
        }

        public void onInvalidated() {
            ViewPager.this.dataSetChanged();
        }
    }

    public static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        Parcelable adapterState;
        ClassLoader loader;
        int position;

        SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            ClassLoader classLoader2 = classLoader;
            if (classLoader == null) {
                classLoader2 = this.getClass().getClassLoader();
            }
            this.position = parcel.readInt();
            this.adapterState = parcel.readParcelable(classLoader2);
            this.loader = classLoader2;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FragmentPager.SavedState{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuilder.append(" position=");
            stringBuilder.append(this.position);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.position);
            parcel.writeParcelable(this.adapterState, n);
        }
    }

    public static class SimpleOnPageChangeListener
    implements OnPageChangeListener {
        @Override
        public void onPageScrollStateChanged(int n) {
        }

        @Override
        public void onPageScrolled(int n, float f, int n2) {
        }

        @Override
        public void onPageSelected(int n) {
        }
    }

    static class ViewPositionComparator
    implements Comparator<View> {
        ViewPositionComparator() {
        }

        @Override
        public int compare(View object, View object2) {
            object = (LayoutParams)object.getLayoutParams();
            object2 = (LayoutParams)object2.getLayoutParams();
            if (object.isDecor != object2.isDecor) {
                int n = object.isDecor ? 1 : -1;
                return n;
            }
            return object.position - object2.position;
        }
    }
}

