/*
 * Decompiled with CFR 0.152.
 */
package androidx.viewpager2.widget;

import androidx.viewpager2.widget.ViewPager2;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

final class CompositeOnPageChangeCallback
extends ViewPager2.OnPageChangeCallback {
    private final List<ViewPager2.OnPageChangeCallback> mCallbacks;

    CompositeOnPageChangeCallback(int n) {
        this.mCallbacks = new ArrayList<ViewPager2.OnPageChangeCallback>(n);
    }

    private void throwCallbackListModifiedWhileInUse(ConcurrentModificationException concurrentModificationException) {
        throw new IllegalStateException("Adding and removing callbacks during dispatch to callbacks is not supported", concurrentModificationException);
    }

    void addOnPageChangeCallback(ViewPager2.OnPageChangeCallback onPageChangeCallback) {
        this.mCallbacks.add(onPageChangeCallback);
    }

    @Override
    public void onPageScrollStateChanged(int n) {
        try {
            Iterator<ViewPager2.OnPageChangeCallback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPageScrollStateChanged(n);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.throwCallbackListModifiedWhileInUse(concurrentModificationException);
        }
    }

    @Override
    public void onPageScrolled(int n, float f, int n2) {
        try {
            Iterator<ViewPager2.OnPageChangeCallback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPageScrolled(n, f, n2);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.throwCallbackListModifiedWhileInUse(concurrentModificationException);
        }
    }

    @Override
    public void onPageSelected(int n) {
        try {
            Iterator<ViewPager2.OnPageChangeCallback> iterator = this.mCallbacks.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPageSelected(n);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.throwCallbackListModifiedWhileInUse(concurrentModificationException);
        }
    }

    void removeOnPageChangeCallback(ViewPager2.OnPageChangeCallback onPageChangeCallback) {
        this.mCallbacks.remove(onPageChangeCallback);
    }
}

