/*
 * Decompiled with CFR 0.152.
 */
package androidx.viewpager2.widget;

import android.view.View;
import android.view.ViewParent;
import androidx.core.util.Preconditions;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;

public final class MarginPageTransformer
implements ViewPager2.PageTransformer {
    private final int mMarginPx;

    public MarginPageTransformer(int n) {
        Preconditions.checkArgumentNonnegative(n, "Margin must be non-negative");
        this.mMarginPx = n;
    }

    private ViewPager2 requireViewPager(View view) {
        ViewParent viewParent = view.getParent();
        view = viewParent.getParent();
        if (viewParent instanceof RecyclerView && view instanceof ViewPager2) {
            return (ViewPager2)view;
        }
        throw new IllegalStateException("Expected the page view to be managed by a ViewPager2 instance.");
    }

    @Override
    public void transformPage(View view, float f) {
        ViewPager2 viewPager2 = this.requireViewPager(view);
        float f2 = (float)this.mMarginPx * f;
        if (viewPager2.getOrientation() == 0) {
            f = f2;
            if (viewPager2.isRtl()) {
                f = -f2;
            }
            view.setTranslationX(f);
        } else {
            view.setTranslationY(f2);
        }
    }
}

