/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import com.android.volley.Network;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AsyncNetwork
implements Network {
    private ExecutorService mBlockingExecutor;
    private ExecutorService mNonBlockingExecutor;
    private ScheduledExecutorService mNonBlockingScheduledExecutor;

    protected AsyncNetwork() {
    }

    protected ExecutorService getBlockingExecutor() {
        return this.mBlockingExecutor;
    }

    protected ExecutorService getNonBlockingExecutor() {
        return this.mNonBlockingExecutor;
    }

    protected ScheduledExecutorService getNonBlockingScheduledExecutor() {
        return this.mNonBlockingScheduledExecutor;
    }

    @Override
    public NetworkResponse performRequest(Request<?> request) throws VolleyError {
        AtomicReference atomicReference;
        block3: {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            final AtomicReference atomicReference2 = new AtomicReference();
            atomicReference = new AtomicReference();
            this.performRequest(request, new OnRequestComplete(){

                @Override
                public void onError(VolleyError volleyError) {
                    atomicReference.set(volleyError);
                    countDownLatch.countDown();
                }

                @Override
                public void onSuccess(NetworkResponse networkResponse) {
                    atomicReference2.set(networkResponse);
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await();
                if (atomicReference2.get() == null) break block3;
            }
            catch (InterruptedException interruptedException) {
                VolleyLog.e(interruptedException, "while waiting for CountDownLatch", new Object[0]);
                Thread.currentThread().interrupt();
                throw new VolleyError(interruptedException);
            }
            return (NetworkResponse)atomicReference2.get();
        }
        if (atomicReference.get() != null) {
            throw (VolleyError)atomicReference.get();
        }
        throw new VolleyError("Neither response entry was set");
    }

    public abstract void performRequest(Request<?> var1, OnRequestComplete var2);

    public void setBlockingExecutor(ExecutorService executorService) {
        this.mBlockingExecutor = executorService;
    }

    public void setNonBlockingExecutor(ExecutorService executorService) {
        this.mNonBlockingExecutor = executorService;
    }

    public void setNonBlockingScheduledExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.mNonBlockingScheduledExecutor = scheduledExecutorService;
    }

    public static interface OnRequestComplete {
        public void onError(VolleyError var1);

        public void onSuccess(NetworkResponse var1);
    }
}

