/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.android.volley.AsyncCache;
import com.android.volley.AsyncNetwork;
import com.android.volley.Cache;
import com.android.volley.ExecutorDelivery;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RequestTask;
import com.android.volley.Response;
import com.android.volley.ResponseDelivery;
import com.android.volley.VolleyError;
import com.android.volley.WaitingRequestManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncRequestQueue
extends RequestQueue {
    private static final int DEFAULT_BLOCKING_THREAD_POOL_SIZE = 4;
    private final AsyncCache mAsyncCache;
    private ExecutorService mBlockingExecutor;
    private final Object mCacheInitializationLock;
    private ExecutorFactory mExecutorFactory;
    private volatile boolean mIsCacheInitialized = false;
    private final AsyncNetwork mNetwork;
    private ExecutorService mNonBlockingExecutor;
    private ScheduledExecutorService mNonBlockingScheduledExecutor;
    private final List<Request<?>> mRequestsAwaitingCacheInitialization;
    private final WaitingRequestManager mWaitingRequestManager = new WaitingRequestManager(this);

    private AsyncRequestQueue(Cache cache, AsyncNetwork asyncNetwork, AsyncCache asyncCache, ResponseDelivery responseDelivery, ExecutorFactory executorFactory) {
        super(cache, asyncNetwork, 0, responseDelivery);
        this.mRequestsAwaitingCacheInitialization = new ArrayList();
        this.mCacheInitializationLock = new Object[0];
        this.mAsyncCache = asyncCache;
        this.mNetwork = asyncNetwork;
        this.mExecutorFactory = executorFactory;
    }

    private void finishRequest(Request<?> request, Response<?> response, boolean bl) {
        if (bl) {
            request.addMarker("network-cache-written");
        }
        request.markDelivered();
        this.getResponseDelivery().postResponse(request, response);
        request.notifyListenerResponseReceived(response);
    }

    private static PriorityBlockingQueue<Runnable> getBlockingQueue() {
        return new PriorityBlockingQueue<Runnable>(11, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable runnable, Runnable runnable2) {
                if (runnable instanceof RequestTask) {
                    if (runnable2 instanceof RequestTask) {
                        return ((RequestTask)runnable).compareTo((RequestTask)runnable2);
                    }
                    return 1;
                }
                int n = runnable2 instanceof RequestTask ? -1 : 0;
                return n;
            }
        });
    }

    private void handleEntry(Cache.Entry entry, Request<?> request) {
        if (entry == null) {
            request.addMarker("cache-miss");
            if (!this.mWaitingRequestManager.maybeAddToWaitingRequests(request)) {
                this.sendRequestOverNetwork(request);
            }
            return;
        }
        long l = System.currentTimeMillis();
        if (entry.isExpired(l)) {
            request.addMarker("cache-hit-expired");
            request.setCacheEntry(entry);
            if (!this.mWaitingRequestManager.maybeAddToWaitingRequests(request)) {
                this.sendRequestOverNetwork(request);
            }
            return;
        }
        this.mBlockingExecutor.execute(new CacheParseTask(request, entry, l));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onCacheInitializationComplete() {
        ArrayList arrayList;
        Iterator iterator = this.mCacheInitializationLock;
        synchronized (iterator) {
            arrayList = new ArrayList(this.mRequestsAwaitingCacheInitialization);
            this.mRequestsAwaitingCacheInitialization.clear();
            this.mIsCacheInitialized = true;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.beginRequest((Request)iterator.next());
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    <T> void beginRequest(Request<T> request) {
        if (!this.mIsCacheInitialized) {
            Object object = this.mCacheInitializationLock;
            synchronized (object) {
                if (!this.mIsCacheInitialized) {
                    this.mRequestsAwaitingCacheInitialization.add(request);
                    return;
                }
            }
        }
        if (!request.shouldCache()) {
            this.sendRequestOverNetwork(request);
            return;
        }
        if (this.mAsyncCache != null) {
            this.mNonBlockingExecutor.execute(new CacheTask<T>(request));
            return;
        }
        this.mBlockingExecutor.execute(new CacheTask<T>(request));
    }

    @Override
    <T> void sendRequestOverNetwork(Request<T> request) {
        this.mNonBlockingExecutor.execute(new NetworkTask<T>(request));
    }

    @Override
    public void start() {
        this.stop();
        this.mNonBlockingExecutor = this.mExecutorFactory.createNonBlockingExecutor(AsyncRequestQueue.getBlockingQueue());
        this.mBlockingExecutor = this.mExecutorFactory.createBlockingExecutor(AsyncRequestQueue.getBlockingQueue());
        this.mNonBlockingScheduledExecutor = this.mExecutorFactory.createNonBlockingScheduledExecutor();
        this.mNetwork.setBlockingExecutor(this.mBlockingExecutor);
        this.mNetwork.setNonBlockingExecutor(this.mNonBlockingExecutor);
        this.mNetwork.setNonBlockingScheduledExecutor(this.mNonBlockingScheduledExecutor);
        if (this.mAsyncCache != null) {
            this.mNonBlockingExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    AsyncRequestQueue.this.mAsyncCache.initialize(new AsyncCache.OnWriteCompleteCallback(){

                        @Override
                        public void onWriteComplete() {
                            AsyncRequestQueue.this.onCacheInitializationComplete();
                        }
                    });
                }
            });
        } else {
            this.mBlockingExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    AsyncRequestQueue.this.getCache().initialize();
                    AsyncRequestQueue.this.mNonBlockingExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            AsyncRequestQueue.this.onCacheInitializationComplete();
                        }
                    });
                }
            });
        }
    }

    @Override
    public void stop() {
        ExecutorService executorService = this.mNonBlockingExecutor;
        if (executorService != null) {
            executorService.shutdownNow();
            this.mNonBlockingExecutor = null;
        }
        if ((executorService = this.mBlockingExecutor) != null) {
            executorService.shutdownNow();
            this.mBlockingExecutor = null;
        }
        if ((executorService = this.mNonBlockingScheduledExecutor) != null) {
            executorService.shutdownNow();
            this.mNonBlockingScheduledExecutor = null;
        }
    }

    public static class Builder {
        private AsyncCache mAsyncCache = null;
        private Cache mCache = null;
        private ExecutorFactory mExecutorFactory = null;
        private final AsyncNetwork mNetwork;
        private ResponseDelivery mResponseDelivery = null;

        public Builder(AsyncNetwork asyncNetwork) {
            if (asyncNetwork != null) {
                this.mNetwork = asyncNetwork;
                return;
            }
            throw new IllegalArgumentException("Network cannot be null");
        }

        private ExecutorFactory getDefaultExecutorFactory() {
            return new ExecutorFactory(){

                private ThreadPoolExecutor getNewThreadPoolExecutor(int n, String string2, BlockingQueue<Runnable> blockingQueue) {
                    return new ThreadPoolExecutor(0, n, 60L, TimeUnit.SECONDS, blockingQueue, this.getThreadFactory(string2));
                }

                private ThreadFactory getThreadFactory(final String string2) {
                    return new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable object) {
                            Thread thread = Executors.defaultThreadFactory().newThread((Runnable)object);
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Volley-");
                            ((StringBuilder)object).append(string2);
                            thread.setName(((StringBuilder)object).toString());
                            return thread;
                        }
                    };
                }

                @Override
                public ExecutorService createBlockingExecutor(BlockingQueue<Runnable> blockingQueue) {
                    return this.getNewThreadPoolExecutor(4, "BlockingExecutor", blockingQueue);
                }

                @Override
                public ExecutorService createNonBlockingExecutor(BlockingQueue<Runnable> blockingQueue) {
                    return this.getNewThreadPoolExecutor(1, "Non-BlockingExecutor", blockingQueue);
                }

                @Override
                public ScheduledExecutorService createNonBlockingScheduledExecutor() {
                    return new ScheduledThreadPoolExecutor(0, this.getThreadFactory("ScheduledExecutor"));
                }
            };
        }

        public AsyncRequestQueue build() {
            Cache cache = this.mCache;
            if (cache == null && this.mAsyncCache == null) {
                throw new IllegalArgumentException("You must set one of the cache objects");
            }
            if (cache == null) {
                this.mCache = new ThrowingCache();
            }
            if (this.mResponseDelivery == null) {
                this.mResponseDelivery = new ExecutorDelivery(new Handler(Looper.getMainLooper()));
            }
            if (this.mExecutorFactory == null) {
                this.mExecutorFactory = this.getDefaultExecutorFactory();
            }
            return new AsyncRequestQueue(this.mCache, this.mNetwork, this.mAsyncCache, this.mResponseDelivery, this.mExecutorFactory);
        }

        public Builder setAsyncCache(AsyncCache asyncCache) {
            this.mAsyncCache = asyncCache;
            return this;
        }

        public Builder setCache(Cache cache) {
            this.mCache = cache;
            return this;
        }

        public Builder setExecutorFactory(ExecutorFactory executorFactory) {
            this.mExecutorFactory = executorFactory;
            return this;
        }

        public Builder setResponseDelivery(ResponseDelivery responseDelivery) {
            this.mResponseDelivery = responseDelivery;
            return this;
        }
    }

    private class CacheParseTask<T>
    extends RequestTask<T> {
        Cache.Entry entry;
        long startTimeMillis;

        CacheParseTask(Request<T> request, Cache.Entry entry, long l) {
            super(request);
            this.entry = entry;
            this.startTimeMillis = l;
        }

        @Override
        public void run() {
            this.mRequest.addMarker("cache-hit");
            Response response = this.mRequest.parseNetworkResponse(new NetworkResponse(200, this.entry.data, false, 0L, this.entry.allResponseHeaders));
            this.mRequest.addMarker("cache-hit-parsed");
            if (!this.entry.refreshNeeded(this.startTimeMillis)) {
                AsyncRequestQueue.this.getResponseDelivery().postResponse(this.mRequest, response);
            } else {
                this.mRequest.addMarker("cache-hit-refresh-needed");
                this.mRequest.setCacheEntry(this.entry);
                response.intermediate = true;
                if (!AsyncRequestQueue.this.mWaitingRequestManager.maybeAddToWaitingRequests(this.mRequest)) {
                    AsyncRequestQueue.this.getResponseDelivery().postResponse(this.mRequest, response, new Runnable(){

                        @Override
                        public void run() {
                            AsyncRequestQueue.this.sendRequestOverNetwork(CacheParseTask.this.mRequest);
                        }
                    });
                } else {
                    AsyncRequestQueue.this.getResponseDelivery().postResponse(this.mRequest, response);
                }
            }
        }
    }

    private class CachePutTask<T>
    extends RequestTask<T> {
        Response<?> response;

        CachePutTask(Request<T> request, Response<?> response) {
            super(request);
            this.response = response;
        }

        @Override
        public void run() {
            if (AsyncRequestQueue.this.mAsyncCache != null) {
                AsyncRequestQueue.this.mAsyncCache.put(this.mRequest.getCacheKey(), this.response.cacheEntry, new AsyncCache.OnWriteCompleteCallback(){

                    @Override
                    public void onWriteComplete() {
                        AsyncRequestQueue.this.finishRequest(CachePutTask.this.mRequest, CachePutTask.this.response, true);
                    }
                });
            } else {
                AsyncRequestQueue.this.getCache().put(this.mRequest.getCacheKey(), this.response.cacheEntry);
                AsyncRequestQueue.this.finishRequest(this.mRequest, this.response, true);
            }
        }
    }

    private class CacheTask<T>
    extends RequestTask<T> {
        CacheTask(Request<T> request) {
            super(request);
        }

        @Override
        public void run() {
            if (this.mRequest.isCanceled()) {
                this.mRequest.finish("cache-discard-canceled");
                return;
            }
            this.mRequest.addMarker("cache-queue-take");
            if (AsyncRequestQueue.this.mAsyncCache != null) {
                AsyncRequestQueue.this.mAsyncCache.get(this.mRequest.getCacheKey(), new AsyncCache.OnGetCompleteCallback(){

                    @Override
                    public void onGetComplete(Cache.Entry entry) {
                        AsyncRequestQueue.this.handleEntry(entry, CacheTask.this.mRequest);
                    }
                });
            } else {
                Cache.Entry entry = AsyncRequestQueue.this.getCache().get(this.mRequest.getCacheKey());
                AsyncRequestQueue.this.handleEntry(entry, this.mRequest);
            }
        }
    }

    public static abstract class ExecutorFactory {
        public abstract ExecutorService createBlockingExecutor(BlockingQueue<Runnable> var1);

        public abstract ExecutorService createNonBlockingExecutor(BlockingQueue<Runnable> var1);

        public abstract ScheduledExecutorService createNonBlockingScheduledExecutor();
    }

    private class NetworkParseTask<T>
    extends RequestTask<T> {
        NetworkResponse networkResponse;

        NetworkParseTask(Request<T> request, NetworkResponse networkResponse) {
            super(request);
            this.networkResponse = networkResponse;
        }

        @Override
        public void run() {
            Response response = this.mRequest.parseNetworkResponse(this.networkResponse);
            this.mRequest.addMarker("network-parse-complete");
            if (this.mRequest.shouldCache() && response.cacheEntry != null) {
                if (AsyncRequestQueue.this.mAsyncCache != null) {
                    AsyncRequestQueue.this.mNonBlockingExecutor.execute(new CachePutTask(this.mRequest, response));
                } else {
                    AsyncRequestQueue.this.mBlockingExecutor.execute(new CachePutTask(this.mRequest, response));
                }
            } else {
                AsyncRequestQueue.this.finishRequest(this.mRequest, response, false);
            }
        }
    }

    private class NetworkTask<T>
    extends RequestTask<T> {
        NetworkTask(Request<T> request) {
            super(request);
        }

        @Override
        public void run() {
            if (this.mRequest.isCanceled()) {
                this.mRequest.finish("network-discard-cancelled");
                this.mRequest.notifyListenerResponseNotUsable();
                return;
            }
            final long l = SystemClock.elapsedRealtime();
            this.mRequest.addMarker("network-queue-take");
            AsyncRequestQueue.this.mNetwork.performRequest(this.mRequest, new AsyncNetwork.OnRequestComplete(){

                @Override
                public void onError(VolleyError volleyError) {
                    volleyError.setNetworkTimeMs(SystemClock.elapsedRealtime() - l);
                    AsyncRequestQueue.this.mBlockingExecutor.execute(new ParseErrorTask(NetworkTask.this.mRequest, volleyError));
                }

                @Override
                public void onSuccess(NetworkResponse networkResponse) {
                    NetworkTask.this.mRequest.addMarker("network-http-complete");
                    if (networkResponse.notModified && NetworkTask.this.mRequest.hasHadResponseDelivered()) {
                        NetworkTask.this.mRequest.finish("not-modified");
                        NetworkTask.this.mRequest.notifyListenerResponseNotUsable();
                        return;
                    }
                    AsyncRequestQueue.this.mBlockingExecutor.execute(new NetworkParseTask(NetworkTask.this.mRequest, networkResponse));
                }
            });
        }
    }

    private class ParseErrorTask<T>
    extends RequestTask<T> {
        VolleyError volleyError;

        ParseErrorTask(Request<T> request, VolleyError volleyError) {
            super(request);
            this.volleyError = volleyError;
        }

        @Override
        public void run() {
            VolleyError volleyError = this.mRequest.parseNetworkError(this.volleyError);
            AsyncRequestQueue.this.getResponseDelivery().postError(this.mRequest, volleyError);
            this.mRequest.notifyListenerResponseNotUsable();
        }
    }

    private static class ThrowingCache
    implements Cache {
        private ThrowingCache() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Cache.Entry get(String string2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void initialize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void invalidate(String string2, boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void put(String string2, Cache.Entry entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(String string2) {
            throw new UnsupportedOperationException();
        }
    }
}

