/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.os.Process;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.ResponseDelivery;
import com.android.volley.VolleyLog;
import com.android.volley.WaitingRequestManager;
import java.util.concurrent.BlockingQueue;

public class CacheDispatcher
extends Thread {
    private static final boolean DEBUG = VolleyLog.DEBUG;
    private final Cache mCache;
    private final BlockingQueue<Request<?>> mCacheQueue;
    private final ResponseDelivery mDelivery;
    private final BlockingQueue<Request<?>> mNetworkQueue;
    private volatile boolean mQuit = false;
    private final WaitingRequestManager mWaitingRequestManager;

    public CacheDispatcher(BlockingQueue<Request<?>> blockingQueue, BlockingQueue<Request<?>> blockingQueue2, Cache cache, ResponseDelivery responseDelivery) {
        this.mCacheQueue = blockingQueue;
        this.mNetworkQueue = blockingQueue2;
        this.mCache = cache;
        this.mDelivery = responseDelivery;
        this.mWaitingRequestManager = new WaitingRequestManager(this, blockingQueue2, responseDelivery);
    }

    private void processRequest() throws InterruptedException {
        this.processRequest(this.mCacheQueue.take());
    }

    void processRequest(final Request<?> request) throws InterruptedException {
        request.addMarker("cache-queue-take");
        request.sendEvent(1);
        try {
            if (request.isCanceled()) {
                request.finish("cache-discard-canceled");
                return;
            }
            Object object = this.mCache.get(request.getCacheKey());
            if (object == null) {
                request.addMarker("cache-miss");
                if (!this.mWaitingRequestManager.maybeAddToWaitingRequests(request)) {
                    this.mNetworkQueue.put(request);
                }
                return;
            }
            long l = System.currentTimeMillis();
            if (((Cache.Entry)object).isExpired(l)) {
                request.addMarker("cache-hit-expired");
                request.setCacheEntry((Cache.Entry)object);
                if (!this.mWaitingRequestManager.maybeAddToWaitingRequests(request)) {
                    this.mNetworkQueue.put(request);
                }
                return;
            }
            request.addMarker("cache-hit");
            Object object2 = new NetworkResponse(((Cache.Entry)object).data, ((Cache.Entry)object).responseHeaders);
            object2 = request.parseNetworkResponse((NetworkResponse)object2);
            request.addMarker("cache-hit-parsed");
            if (!((Response)object2).isSuccess()) {
                request.addMarker("cache-parsing-failed");
                this.mCache.invalidate(request.getCacheKey(), true);
                request.setCacheEntry(null);
                if (!this.mWaitingRequestManager.maybeAddToWaitingRequests(request)) {
                    this.mNetworkQueue.put(request);
                }
                return;
            }
            if (!((Cache.Entry)object).refreshNeeded(l)) {
                this.mDelivery.postResponse(request, (Response<?>)object2);
            } else {
                request.addMarker("cache-hit-refresh-needed");
                request.setCacheEntry((Cache.Entry)object);
                ((Response)object2).intermediate = true;
                if (!this.mWaitingRequestManager.maybeAddToWaitingRequests(request)) {
                    object = this.mDelivery;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CacheDispatcher.this.mNetworkQueue.put(request);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    };
                    object.postResponse(request, (Response<?>)object2, runnable);
                } else {
                    this.mDelivery.postResponse(request, (Response<?>)object2);
                }
            }
            return;
        }
        finally {
            request.sendEvent(2);
        }
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    @Override
    public void run() {
        if (DEBUG) {
            VolleyLog.v("start new dispatcher", new Object[0]);
        }
        Process.setThreadPriority((int)10);
        this.mCache.initialize();
        while (true) {
            try {
                while (true) {
                    this.processRequest();
                }
            }
            catch (InterruptedException interruptedException) {
                if (this.mQuit) {
                    Thread.currentThread().interrupt();
                    return;
                }
                VolleyLog.e("Ignoring spurious interrupt of CacheDispatcher thread; use quit() to terminate it", new Object[0]);
                continue;
            }
            break;
        }
    }
}

