/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;

public class DefaultRetryPolicy
implements RetryPolicy {
    public static final float DEFAULT_BACKOFF_MULT = 1.0f;
    public static final int DEFAULT_MAX_RETRIES = 1;
    public static final int DEFAULT_TIMEOUT_MS = 2500;
    private final float mBackoffMultiplier;
    private int mCurrentRetryCount;
    private int mCurrentTimeoutMs;
    private final int mMaxNumRetries;

    public DefaultRetryPolicy() {
        this(2500, 1, 1.0f);
    }

    public DefaultRetryPolicy(int n, int n2, float f) {
        this.mCurrentTimeoutMs = n;
        this.mMaxNumRetries = n2;
        this.mBackoffMultiplier = f;
    }

    public float getBackoffMultiplier() {
        return this.mBackoffMultiplier;
    }

    @Override
    public int getCurrentRetryCount() {
        return this.mCurrentRetryCount;
    }

    @Override
    public int getCurrentTimeout() {
        return this.mCurrentTimeoutMs;
    }

    protected boolean hasAttemptRemaining() {
        boolean bl = this.mCurrentRetryCount <= this.mMaxNumRetries;
        return bl;
    }

    @Override
    public void retry(VolleyError volleyError) throws VolleyError {
        ++this.mCurrentRetryCount;
        int n = this.mCurrentTimeoutMs;
        this.mCurrentTimeoutMs = n + (int)((float)n * this.mBackoffMultiplier);
        if (this.hasAttemptRemaining()) {
            return;
        }
        throw volleyError;
    }
}

