/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.net.TrafficStats;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import com.android.volley.Cache;
import com.android.volley.Network;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.ResponseDelivery;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import java.util.concurrent.BlockingQueue;

public class NetworkDispatcher
extends Thread {
    private final Cache mCache;
    private final ResponseDelivery mDelivery;
    private final Network mNetwork;
    private final BlockingQueue<Request<?>> mQueue;
    private volatile boolean mQuit = false;

    public NetworkDispatcher(BlockingQueue<Request<?>> blockingQueue, Network network, Cache cache, ResponseDelivery responseDelivery) {
        this.mQueue = blockingQueue;
        this.mNetwork = network;
        this.mCache = cache;
        this.mDelivery = responseDelivery;
    }

    private void addTrafficStatsTag(Request<?> request) {
        if (Build.VERSION.SDK_INT >= 14) {
            TrafficStats.setThreadStatsTag((int)request.getTrafficStatsTag());
        }
    }

    private void parseAndDeliverNetworkError(Request<?> request, VolleyError volleyError) {
        volleyError = request.parseNetworkError(volleyError);
        this.mDelivery.postError(request, volleyError);
    }

    private void processRequest() throws InterruptedException {
        this.processRequest(this.mQueue.take());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processRequest(Request<?> request) {
        Throwable throwable2;
        block11: {
            long l = SystemClock.elapsedRealtime();
            request.sendEvent(3);
            try {
                request.addMarker("network-queue-take");
                if (request.isCanceled()) {
                    request.finish("network-discard-cancelled");
                    request.notifyListenerResponseNotUsable();
                    request.sendEvent(4);
                    return;
                }
                this.addTrafficStatsTag(request);
                Object object = this.mNetwork.performRequest(request);
                request.addMarker("network-http-complete");
                if (((NetworkResponse)object).notModified && request.hasHadResponseDelivered()) {
                    request.finish("not-modified");
                    request.notifyListenerResponseNotUsable();
                    request.sendEvent(4);
                    return;
                }
                object = request.parseNetworkResponse((NetworkResponse)object);
                request.addMarker("network-parse-complete");
                if (request.shouldCache() && ((Response)object).cacheEntry != null) {
                    this.mCache.put(request.getCacheKey(), ((Response)object).cacheEntry);
                    request.addMarker("network-cache-written");
                }
                request.markDelivered();
                this.mDelivery.postResponse(request, (Response<?>)object);
                request.notifyListenerResponseReceived((Response<?>)object);
            }
            catch (Throwable throwable2) {
                break block11;
            }
            catch (Exception exception) {
                VolleyLog.e(exception, "Unhandled exception %s", exception.toString());
                VolleyError volleyError = new VolleyError(exception);
                volleyError.setNetworkTimeMs(SystemClock.elapsedRealtime() - l);
                this.mDelivery.postError(request, volleyError);
                request.notifyListenerResponseNotUsable();
            }
            catch (VolleyError volleyError) {
                volleyError.setNetworkTimeMs(SystemClock.elapsedRealtime() - l);
                this.parseAndDeliverNetworkError(request, volleyError);
                request.notifyListenerResponseNotUsable();
            }
            request.sendEvent(4);
            return;
        }
        request.sendEvent(4);
        throw throwable2;
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            try {
                while (true) {
                    this.processRequest();
                }
            }
            catch (InterruptedException interruptedException) {
                if (this.mQuit) {
                    Thread.currentThread().interrupt();
                    return;
                }
                VolleyLog.e("Ignoring spurious interrupt of NetworkDispatcher thread; use quit() to terminate it", new Object[0]);
                continue;
            }
            break;
        }
    }
}

