/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import com.android.volley.Header;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NetworkResponse {
    public final List<Header> allHeaders;
    public final byte[] data;
    public final Map<String, String> headers;
    public final long networkTimeMs;
    public final boolean notModified;
    public final int statusCode;

    private NetworkResponse(int n, byte[] byArray, Map<String, String> map, List<Header> list, boolean bl, long l) {
        this.statusCode = n;
        this.data = byArray;
        this.headers = map;
        this.allHeaders = list == null ? null : Collections.unmodifiableList(list);
        this.notModified = bl;
        this.networkTimeMs = l;
    }

    @Deprecated
    public NetworkResponse(int n, byte[] byArray, Map<String, String> map, boolean bl) {
        this(n, byArray, map, bl, 0L);
    }

    @Deprecated
    public NetworkResponse(int n, byte[] byArray, Map<String, String> map, boolean bl, long l) {
        this(n, byArray, map, NetworkResponse.toAllHeaderList(map), bl, l);
    }

    public NetworkResponse(int n, byte[] byArray, boolean bl, long l, List<Header> list) {
        this(n, byArray, NetworkResponse.toHeaderMap(list), list, bl, l);
    }

    public NetworkResponse(byte[] byArray) {
        this(200, byArray, false, 0L, Collections.emptyList());
    }

    @Deprecated
    public NetworkResponse(byte[] byArray, Map<String, String> map) {
        this(200, byArray, map, false, 0L);
    }

    private static List<Header> toAllHeaderList(Map<String, String> object2) {
        if (object2 == null) {
            return null;
        }
        if (object2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Header> arrayList = new ArrayList<Header>(object2.size());
        for (Map.Entry entry : object2.entrySet()) {
            arrayList.add(new Header((String)entry.getKey(), (String)entry.getValue()));
        }
        return arrayList;
    }

    private static Map<String, String> toHeaderMap(List<Header> object) {
        if (object == null) {
            return null;
        }
        if (object.isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Iterator<Header> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            treeMap.put(((Header)object).getName(), ((Header)object).getValue());
        }
        return treeMap;
    }
}

