/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;

public abstract class Request<T>
implements Comparable<Request<T>> {
    private static final String DEFAULT_PARAMS_ENCODING = "UTF-8";
    private Cache.Entry mCacheEntry;
    private boolean mCanceled;
    private final int mDefaultTrafficStatsTag;
    private Response.ErrorListener mErrorListener;
    private final VolleyLog.MarkerLog mEventLog;
    private final Object mLock;
    private final int mMethod;
    private NetworkRequestCompleteListener mRequestCompleteListener;
    private RequestQueue mRequestQueue;
    private boolean mResponseDelivered;
    private RetryPolicy mRetryPolicy;
    private Integer mSequence;
    private boolean mShouldCache;
    private boolean mShouldRetryConnectionErrors;
    private boolean mShouldRetryServerErrors;
    private Object mTag;
    private final String mUrl;

    public Request(int n, String string2, Response.ErrorListener errorListener) {
        VolleyLog.MarkerLog markerLog = VolleyLog.MarkerLog.ENABLED ? new VolleyLog.MarkerLog() : null;
        this.mEventLog = markerLog;
        this.mLock = new Object();
        this.mShouldCache = true;
        this.mCanceled = false;
        this.mResponseDelivered = false;
        this.mShouldRetryServerErrors = false;
        this.mShouldRetryConnectionErrors = false;
        this.mCacheEntry = null;
        this.mMethod = n;
        this.mUrl = string2;
        this.mErrorListener = errorListener;
        this.setRetryPolicy(new DefaultRetryPolicy());
        this.mDefaultTrafficStatsTag = Request.findDefaultTrafficStatsTag(string2);
    }

    @Deprecated
    public Request(String string2, Response.ErrorListener errorListener) {
        this(-1, string2, errorListener);
    }

    private byte[] encodeParameters(Map<String, String> entry2, String string2) {
        Serializable serializable = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry2 : entry2.entrySet()) {
                if (entry2.getKey() != null && entry2.getValue() != null) {
                    ((StringBuilder)serializable).append(URLEncoder.encode((String)entry2.getKey(), string2));
                    ((StringBuilder)serializable).append('=');
                    ((StringBuilder)serializable).append(URLEncoder.encode((String)entry2.getValue(), string2));
                    ((StringBuilder)serializable).append('&');
                    continue;
                }
                serializable = new IllegalArgumentException(String.format("Request#getParams() or Request#getPostParams() returned a map containing a null key or value: (%s, %s). All keys and values must be non-null.", entry2.getKey(), entry2.getValue()));
                throw serializable;
            }
            entry2 = (Map.Entry<String, String>)((StringBuilder)serializable).toString().getBytes(string2);
            return entry2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            entry2 = new StringBuilder();
            ((StringBuilder)((Object)entry2)).append("Encoding not supported: ");
            ((StringBuilder)((Object)entry2)).append(string2);
            throw new RuntimeException(((StringBuilder)((Object)entry2)).toString(), unsupportedEncodingException);
        }
    }

    private static int findDefaultTrafficStatsTag(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = Uri.parse((String)string2)) != null && (string2 = string2.getHost()) != null) {
            return string2.hashCode();
        }
        return 0;
    }

    public void addMarker(String string2) {
        if (VolleyLog.MarkerLog.ENABLED) {
            this.mEventLog.add(string2, Thread.currentThread().getId());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCanceled = true;
            this.mErrorListener = null;
            return;
        }
    }

    @Override
    public int compareTo(Request<T> request) {
        Priority priority;
        Priority priority2 = this.getPriority();
        int n = priority2 == (priority = request.getPriority()) ? this.mSequence - request.mSequence : priority.ordinal() - priority2.ordinal();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void deliverError(VolleyError volleyError) {
        Object object = this.mLock;
        // MONITORENTER : object
        Response.ErrorListener errorListener = this.mErrorListener;
        // MONITOREXIT : object
        if (errorListener == null) return;
        errorListener.onErrorResponse(volleyError);
    }

    protected abstract void deliverResponse(T var1);

    void finish(final String string2) {
        RequestQueue requestQueue = this.mRequestQueue;
        if (requestQueue != null) {
            requestQueue.finish(this);
        }
        if (VolleyLog.MarkerLog.ENABLED) {
            final long l = Thread.currentThread().getId();
            if (Looper.myLooper() != Looper.getMainLooper()) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        Request.this.mEventLog.add(string2, l);
                        Request.this.mEventLog.finish(Request.this.toString());
                    }
                });
                return;
            }
            this.mEventLog.add(string2, l);
            this.mEventLog.finish(this.toString());
        }
    }

    public byte[] getBody() throws AuthFailureError {
        Map<String, String> map = this.getParams();
        if (map != null && map.size() > 0) {
            return this.encodeParameters(map, this.getParamsEncoding());
        }
        return null;
    }

    public String getBodyContentType() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("application/x-www-form-urlencoded; charset=");
        stringBuilder.append(this.getParamsEncoding());
        return stringBuilder.toString();
    }

    public Cache.Entry getCacheEntry() {
        return this.mCacheEntry;
    }

    public String getCacheKey() {
        String string2 = this.getUrl();
        int n = this.getMethod();
        CharSequence charSequence = string2;
        if (n != 0) {
            if (n == -1) {
                charSequence = string2;
            } else {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(Integer.toString(n));
                ((StringBuilder)charSequence).append('-');
                ((StringBuilder)charSequence).append(string2);
                charSequence = ((StringBuilder)charSequence).toString();
            }
        }
        return charSequence;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response.ErrorListener getErrorListener() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mErrorListener;
        }
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        return Collections.emptyMap();
    }

    public int getMethod() {
        return this.mMethod;
    }

    protected Map<String, String> getParams() throws AuthFailureError {
        return null;
    }

    protected String getParamsEncoding() {
        return DEFAULT_PARAMS_ENCODING;
    }

    @Deprecated
    public byte[] getPostBody() throws AuthFailureError {
        Map<String, String> map = this.getPostParams();
        if (map != null && map.size() > 0) {
            return this.encodeParameters(map, this.getPostParamsEncoding());
        }
        return null;
    }

    @Deprecated
    public String getPostBodyContentType() {
        return this.getBodyContentType();
    }

    @Deprecated
    protected Map<String, String> getPostParams() throws AuthFailureError {
        return this.getParams();
    }

    @Deprecated
    protected String getPostParamsEncoding() {
        return this.getParamsEncoding();
    }

    public Priority getPriority() {
        return Priority.NORMAL;
    }

    public RetryPolicy getRetryPolicy() {
        return this.mRetryPolicy;
    }

    public final int getSequence() {
        Integer n = this.mSequence;
        if (n != null) {
            return n;
        }
        throw new IllegalStateException("getSequence called before setSequence");
    }

    public Object getTag() {
        return this.mTag;
    }

    public final int getTimeoutMs() {
        return this.getRetryPolicy().getCurrentTimeout();
    }

    public int getTrafficStatsTag() {
        return this.mDefaultTrafficStatsTag;
    }

    public String getUrl() {
        return this.mUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasHadResponseDelivered() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mResponseDelivered;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCanceled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCanceled;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void markDelivered() {
        Object object = this.mLock;
        synchronized (object) {
            this.mResponseDelivered = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void notifyListenerResponseNotUsable() {
        Object object = this.mLock;
        // MONITORENTER : object
        NetworkRequestCompleteListener networkRequestCompleteListener = this.mRequestCompleteListener;
        // MONITOREXIT : object
        if (networkRequestCompleteListener == null) return;
        networkRequestCompleteListener.onNoUsableResponseReceived(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void notifyListenerResponseReceived(Response<?> response) {
        Object object = this.mLock;
        // MONITORENTER : object
        NetworkRequestCompleteListener networkRequestCompleteListener = this.mRequestCompleteListener;
        // MONITOREXIT : object
        if (networkRequestCompleteListener == null) return;
        networkRequestCompleteListener.onResponseReceived(this, response);
    }

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        return volleyError;
    }

    protected abstract Response<T> parseNetworkResponse(NetworkResponse var1);

    void sendEvent(int n) {
        RequestQueue requestQueue = this.mRequestQueue;
        if (requestQueue != null) {
            requestQueue.sendRequestEvent(this, n);
        }
    }

    public Request<?> setCacheEntry(Cache.Entry entry) {
        this.mCacheEntry = entry;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setNetworkRequestCompleteListener(NetworkRequestCompleteListener networkRequestCompleteListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRequestCompleteListener = networkRequestCompleteListener;
            return;
        }
    }

    public Request<?> setRequestQueue(RequestQueue requestQueue) {
        this.mRequestQueue = requestQueue;
        return this;
    }

    public Request<?> setRetryPolicy(RetryPolicy retryPolicy) {
        this.mRetryPolicy = retryPolicy;
        return this;
    }

    public final Request<?> setSequence(int n) {
        this.mSequence = n;
        return this;
    }

    public final Request<?> setShouldCache(boolean bl) {
        this.mShouldCache = bl;
        return this;
    }

    public final Request<?> setShouldRetryConnectionErrors(boolean bl) {
        this.mShouldRetryConnectionErrors = bl;
        return this;
    }

    public final Request<?> setShouldRetryServerErrors(boolean bl) {
        this.mShouldRetryServerErrors = bl;
        return this;
    }

    public Request<?> setTag(Object object) {
        this.mTag = object;
        return this;
    }

    public final boolean shouldCache() {
        return this.mShouldCache;
    }

    public final boolean shouldRetryConnectionErrors() {
        return this.mShouldRetryConnectionErrors;
    }

    public final boolean shouldRetryServerErrors() {
        return this.mShouldRetryServerErrors;
    }

    public String toString() {
        CharSequence charSequence = new StringBuilder();
        charSequence.append("0x");
        charSequence.append(Integer.toHexString(this.getTrafficStatsTag()));
        String string2 = charSequence.toString();
        StringBuilder stringBuilder = new StringBuilder();
        charSequence = this.isCanceled() ? "[X] " : "[ ] ";
        stringBuilder.append((String)charSequence);
        stringBuilder.append(this.getUrl());
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        stringBuilder.append(" ");
        stringBuilder.append((Object)this.getPriority());
        stringBuilder.append(" ");
        stringBuilder.append(this.mSequence);
        return stringBuilder.toString();
    }

    public static interface Method {
        public static final int DELETE = 3;
        public static final int DEPRECATED_GET_OR_POST = -1;
        public static final int GET = 0;
        public static final int HEAD = 4;
        public static final int OPTIONS = 5;
        public static final int PATCH = 7;
        public static final int POST = 1;
        public static final int PUT = 2;
        public static final int TRACE = 6;
    }

    static interface NetworkRequestCompleteListener {
        public void onNoUsableResponseReceived(Request<?> var1);

        public void onResponseReceived(Request<?> var1, Response<?> var2);
    }

    public static final class Priority
    extends Enum<Priority> {
        private static final /* synthetic */ Priority[] $VALUES;
        public static final /* enum */ Priority HIGH;
        public static final /* enum */ Priority IMMEDIATE;
        public static final /* enum */ Priority LOW;
        public static final /* enum */ Priority NORMAL;

        static {
            Priority priority;
            Priority priority2;
            Priority priority3;
            Priority priority4;
            LOW = priority4 = new Priority();
            NORMAL = priority3 = new Priority();
            HIGH = priority2 = new Priority();
            IMMEDIATE = priority = new Priority();
            $VALUES = new Priority[]{priority4, priority3, priority2, priority};
        }

        public static Priority valueOf(String string2) {
            return Enum.valueOf(Priority.class, string2);
        }

        public static Priority[] values() {
            return (Priority[])$VALUES.clone();
        }
    }
}

