/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.os.Handler;
import android.os.Looper;
import com.android.volley.Cache;
import com.android.volley.CacheDispatcher;
import com.android.volley.ExecutorDelivery;
import com.android.volley.Network;
import com.android.volley.NetworkDispatcher;
import com.android.volley.Request;
import com.android.volley.ResponseDelivery;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestQueue {
    private static final int DEFAULT_NETWORK_THREAD_POOL_SIZE = 4;
    private final Cache mCache;
    private CacheDispatcher mCacheDispatcher;
    private final PriorityBlockingQueue<Request<?>> mCacheQueue;
    private final Set<Request<?>> mCurrentRequests;
    private final ResponseDelivery mDelivery;
    private final NetworkDispatcher[] mDispatchers;
    private final List<RequestEventListener> mEventListeners;
    private final List<RequestFinishedListener> mFinishedListeners;
    private final Network mNetwork;
    private final PriorityBlockingQueue<Request<?>> mNetworkQueue;
    private final AtomicInteger mSequenceGenerator = new AtomicInteger();

    public RequestQueue(Cache cache, Network network) {
        this(cache, network, 4);
    }

    public RequestQueue(Cache cache, Network network, int n) {
        this(cache, network, n, new ExecutorDelivery(new Handler(Looper.getMainLooper())));
    }

    public RequestQueue(Cache cache, Network network, int n, ResponseDelivery responseDelivery) {
        this.mCurrentRequests = new HashSet();
        this.mCacheQueue = new PriorityBlockingQueue();
        this.mNetworkQueue = new PriorityBlockingQueue();
        this.mFinishedListeners = new ArrayList<RequestFinishedListener>();
        this.mEventListeners = new ArrayList<RequestEventListener>();
        this.mCache = cache;
        this.mNetwork = network;
        this.mDispatchers = new NetworkDispatcher[n];
        this.mDelivery = responseDelivery;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Request<T> add(Request<T> request) {
        request.setRequestQueue(this);
        Set<Request<?>> set = this.mCurrentRequests;
        synchronized (set) {
            this.mCurrentRequests.add(request);
        }
        request.setSequence(this.getSequenceNumber());
        request.addMarker("add-to-queue");
        this.sendRequestEvent(request, 0);
        this.beginRequest(request);
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addRequestEventListener(RequestEventListener requestEventListener) {
        List<RequestEventListener> list = this.mEventListeners;
        synchronized (list) {
            this.mEventListeners.add(requestEventListener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public <T> void addRequestFinishedListener(RequestFinishedListener<T> requestFinishedListener) {
        List<RequestFinishedListener> list = this.mFinishedListeners;
        synchronized (list) {
            this.mFinishedListeners.add(requestFinishedListener);
            return;
        }
    }

    <T> void beginRequest(Request<T> request) {
        if (!request.shouldCache()) {
            this.sendRequestOverNetwork(request);
        } else {
            this.mCacheQueue.add(request);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancelAll(RequestFilter requestFilter) {
        Set<Request<?>> set = this.mCurrentRequests;
        synchronized (set) {
            Iterator<Request<?>> iterator = this.mCurrentRequests.iterator();
            while (iterator.hasNext()) {
                Request<?> request = iterator.next();
                if (!requestFilter.apply(request)) continue;
                request.cancel();
            }
            return;
        }
    }

    public void cancelAll(final Object object) {
        if (object != null) {
            this.cancelAll(new RequestFilter(){

                @Override
                public boolean apply(Request<?> request) {
                    boolean bl = request.getTag() == object;
                    return bl;
                }
            });
            return;
        }
        throw new IllegalArgumentException("Cannot cancelAll with a null tag");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> void finish(Request<T> request) {
        Collection<Object> collection = this.mCurrentRequests;
        synchronized (collection) {
            this.mCurrentRequests.remove(request);
        }
        collection = this.mFinishedListeners;
        synchronized (collection) {
            Iterator<RequestFinishedListener> iterator = this.mFinishedListeners.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    // MONITOREXIT @DISABLED, blocks:[5, 6, 7] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2 /* !! */ 
                    this.sendRequestEvent(request, 5);
                    return;
                }
                iterator.next().onRequestFinished(request);
            }
        }
    }

    public Cache getCache() {
        return this.mCache;
    }

    public ResponseDelivery getResponseDelivery() {
        return this.mDelivery;
    }

    public int getSequenceNumber() {
        return this.mSequenceGenerator.incrementAndGet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeRequestEventListener(RequestEventListener requestEventListener) {
        List<RequestEventListener> list = this.mEventListeners;
        synchronized (list) {
            this.mEventListeners.remove(requestEventListener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public <T> void removeRequestFinishedListener(RequestFinishedListener<T> requestFinishedListener) {
        List<RequestFinishedListener> list = this.mFinishedListeners;
        synchronized (list) {
            this.mFinishedListeners.remove(requestFinishedListener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendRequestEvent(Request<?> request, int n) {
        List<RequestEventListener> list = this.mEventListeners;
        synchronized (list) {
            Iterator<RequestEventListener> iterator = this.mEventListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onRequestEvent(request, n);
            }
            return;
        }
    }

    <T> void sendRequestOverNetwork(Request<T> request) {
        this.mNetworkQueue.add(request);
    }

    public void start() {
        this.stop();
        Thread thread = new CacheDispatcher(this.mCacheQueue, this.mNetworkQueue, this.mCache, this.mDelivery);
        this.mCacheDispatcher = thread;
        thread.start();
        for (int i = 0; i < this.mDispatchers.length; ++i) {
            thread = new NetworkDispatcher(this.mNetworkQueue, this.mNetwork, this.mCache, this.mDelivery);
            this.mDispatchers[i] = thread;
            thread.start();
        }
    }

    public void stop() {
        CacheDispatcher thread2 = this.mCacheDispatcher;
        if (thread2 != null) {
            thread2.quit();
        }
        for (NetworkDispatcher networkDispatcher : this.mDispatchers) {
            if (networkDispatcher == null) continue;
            networkDispatcher.quit();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestEvent {
        public static final int REQUEST_CACHE_LOOKUP_FINISHED = 2;
        public static final int REQUEST_CACHE_LOOKUP_STARTED = 1;
        public static final int REQUEST_FINISHED = 5;
        public static final int REQUEST_NETWORK_DISPATCH_FINISHED = 4;
        public static final int REQUEST_NETWORK_DISPATCH_STARTED = 3;
        public static final int REQUEST_QUEUED = 0;
    }

    public static interface RequestEventListener {
        public void onRequestEvent(Request<?> var1, int var2);
    }

    public static interface RequestFilter {
        public boolean apply(Request<?> var1);
    }

    @Deprecated
    public static interface RequestFinishedListener<T> {
        public void onRequestFinished(Request<T> var1);
    }
}

