/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import com.android.volley.CacheDispatcher;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.ResponseDelivery;
import com.android.volley.VolleyLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

class WaitingRequestManager
implements Request.NetworkRequestCompleteListener {
    private final CacheDispatcher mCacheDispatcher;
    private final BlockingQueue<Request<?>> mNetworkQueue;
    private final RequestQueue mRequestQueue;
    private final ResponseDelivery mResponseDelivery;
    private final Map<String, List<Request<?>>> mWaitingRequests = new HashMap();

    WaitingRequestManager(CacheDispatcher cacheDispatcher, BlockingQueue<Request<?>> blockingQueue, ResponseDelivery responseDelivery) {
        this.mRequestQueue = null;
        this.mResponseDelivery = responseDelivery;
        this.mCacheDispatcher = cacheDispatcher;
        this.mNetworkQueue = blockingQueue;
    }

    WaitingRequestManager(RequestQueue requestQueue) {
        this.mRequestQueue = requestQueue;
        this.mResponseDelivery = requestQueue.getResponseDelivery();
        this.mCacheDispatcher = null;
        this.mNetworkQueue = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean maybeAddToWaitingRequests(Request<?> request) {
        synchronized (this) {
            String string2 = request.getCacheKey();
            if (this.mWaitingRequests.containsKey(string2)) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList = this.mWaitingRequests.get(string2);
                if (arrayList == null) {
                    arrayList2 = new ArrayList();
                }
                request.addMarker("waiting-for-response");
                arrayList2.add(request);
                this.mWaitingRequests.put(string2, arrayList2);
                if (VolleyLog.DEBUG) {
                    VolleyLog.d("Request for cacheKey=%s is in flight, putting on hold.", string2);
                }
                return true;
            }
            this.mWaitingRequests.put(string2, null);
            request.setNetworkRequestCompleteListener(this);
            if (VolleyLog.DEBUG) {
                VolleyLog.d("new request, sending to network %s", string2);
            }
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onNoUsableResponseReceived(Request<?> request) {
        synchronized (this) {
            BlockingQueue<Request<?>> blockingQueue = request.getCacheKey();
            List<Request<?>> list = this.mWaitingRequests.remove(blockingQueue);
            if (list == null || list.isEmpty()) return;
            if (VolleyLog.DEBUG) {
                VolleyLog.v("%d waiting requests for cacheKey=%s; resend to network", list.size(), blockingQueue);
            }
            request = list.remove(0);
            this.mWaitingRequests.put((String)((Object)blockingQueue), list);
            request.setNetworkRequestCompleteListener(this);
            blockingQueue = this.mRequestQueue;
            if (blockingQueue != null) {
                ((RequestQueue)((Object)blockingQueue)).sendRequestOverNetwork(request);
                return;
            }
            if (this.mCacheDispatcher == null || (blockingQueue = this.mNetworkQueue) == null) return;
            blockingQueue.put(request);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onResponseReceived(Request<?> iterator, Response<?> response) {
        if (response.cacheEntry != null && !response.cacheEntry.isExpired()) {
            Object object = ((Request)((Object)iterator)).getCacheKey();
            // MONITORENTER : this
            iterator = this.mWaitingRequests.remove(object);
            // MONITOREXIT : this
            if (iterator == null) return;
            if (VolleyLog.DEBUG) {
                VolleyLog.v("Releasing %d waiting requests for cacheKey=%s.", iterator.size(), object);
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = (Request)iterator.next();
                this.mResponseDelivery.postResponse((Request<?>)object, response);
            }
            return;
        }
        this.onNoUsableResponseReceived((Request<?>)((Object)iterator));
    }
}

