/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import com.android.volley.AuthFailureError;
import com.android.volley.Header;
import com.android.volley.Request;
import com.android.volley.toolbox.BaseHttpStack;
import com.android.volley.toolbox.HttpResponse;
import com.android.volley.toolbox.HttpStack;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.conn.ConnectTimeoutException;

class AdaptedHttpStack
extends BaseHttpStack {
    private final HttpStack mHttpStack;

    AdaptedHttpStack(HttpStack httpStack) {
        this.mHttpStack = httpStack;
    }

    @Override
    public HttpResponse executeRequest(Request<?> object, Map<String, String> headerArray) throws IOException, AuthFailureError {
        org.apache.http.HttpResponse httpResponse;
        try {
            httpResponse = this.mHttpStack.performRequest((Request<?>)object, (Map<String, String>)headerArray);
        }
        catch (ConnectTimeoutException connectTimeoutException) {
            throw new SocketTimeoutException(connectTimeoutException.getMessage());
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        headerArray = httpResponse.getAllHeaders();
        object = new ArrayList(headerArray.length);
        for (org.apache.http.Header header : headerArray) {
            object.add(new Header(header.getName(), header.getValue()));
        }
        if (httpResponse.getEntity() == null) {
            return new HttpResponse(n, (List<Header>)object);
        }
        long l = httpResponse.getEntity().getContentLength();
        if ((long)((int)l) == l) {
            return new HttpResponse(n, (List<Header>)object, (int)httpResponse.getEntity().getContentLength(), httpResponse.getEntity().getContent());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Response too large: ");
        ((StringBuilder)object).append(l);
        throw new IOException(((StringBuilder)object).toString());
    }
}

