/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.android.volley.AuthFailureError;
import com.android.volley.toolbox.Authenticator;

public class AndroidAuthenticator
implements Authenticator {
    private final Account mAccount;
    private final AccountManager mAccountManager;
    private final String mAuthTokenType;
    private final boolean mNotifyAuthFailure;

    AndroidAuthenticator(AccountManager accountManager, Account account, String string2, boolean bl) {
        this.mAccountManager = accountManager;
        this.mAccount = account;
        this.mAuthTokenType = string2;
        this.mNotifyAuthFailure = bl;
    }

    public AndroidAuthenticator(Context context, Account account, String string2) {
        this(context, account, string2, false);
    }

    public AndroidAuthenticator(Context context, Account account, String string2, boolean bl) {
        this(AccountManager.get((Context)context), account, string2, bl);
    }

    public Account getAccount() {
        return this.mAccount;
    }

    @Override
    public String getAuthToken() throws AuthFailureError {
        CharSequence charSequence;
        StringBuilder stringBuilder;
        Bundle bundle;
        AccountManagerFuture accountManagerFuture = this.mAccountManager.getAuthToken(this.mAccount, this.mAuthTokenType, this.mNotifyAuthFailure, null, null);
        try {
            bundle = (Bundle)accountManagerFuture.getResult();
            stringBuilder = null;
            charSequence = stringBuilder;
        }
        catch (Exception exception) {
            throw new AuthFailureError("Error while retrieving auth token", exception);
        }
        if (accountManagerFuture.isDone()) {
            charSequence = stringBuilder;
            if (!accountManagerFuture.isCancelled()) {
                if (!bundle.containsKey("intent")) {
                    charSequence = bundle.getString("authtoken");
                } else {
                    throw new AuthFailureError((Intent)bundle.getParcelable("intent"));
                }
            }
        }
        if (charSequence != null) {
            return charSequence;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("Got null auth token for type: ");
        ((StringBuilder)charSequence).append(this.mAuthTokenType);
        throw new AuthFailureError(((StringBuilder)charSequence).toString());
    }

    public String getAuthTokenType() {
        return this.mAuthTokenType;
    }

    @Override
    public void invalidateAuthToken(String string2) {
        this.mAccountManager.invalidateAuthToken(this.mAccount.type, string2);
    }
}

