/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.BaseHttpStack;
import com.android.volley.toolbox.HttpResponse;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AsyncHttpStack
extends BaseHttpStack {
    private ExecutorService mBlockingExecutor;
    private ExecutorService mNonBlockingExecutor;

    @Override
    public final HttpResponse executeRequest(Request<?> object, Map<String, String> map) throws IOException, AuthFailureError {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference atomicReference = new AtomicReference();
        this.executeRequest((Request<?>)object, map, new OnRequestComplete(){

            @Override
            public void onAuthError(AuthFailureError object) {
                object = new Response(null, null, (AuthFailureError)object);
                atomicReference.set(object);
                countDownLatch.countDown();
            }

            @Override
            public void onError(IOException object) {
                object = new Response(null, (IOException)object, null);
                atomicReference.set(object);
                countDownLatch.countDown();
            }

            @Override
            public void onSuccess(HttpResponse object) {
                object = new Response((HttpResponse)object, null, null);
                atomicReference.set(object);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            VolleyLog.e(interruptedException, "while waiting for CountDownLatch", new Object[0]);
            Thread.currentThread().interrupt();
            throw new InterruptedIOException(interruptedException.toString());
        }
        object = (Response)atomicReference.get();
        if (((Response)object).httpResponse != null) {
            return ((Response)object).httpResponse;
        }
        if (((Response)object).ioException != null) {
            throw ((Response)object).ioException;
        }
        throw ((Response)object).authFailureError;
    }

    public abstract void executeRequest(Request<?> var1, Map<String, String> var2, OnRequestComplete var3);

    protected ExecutorService getBlockingExecutor() {
        return this.mBlockingExecutor;
    }

    protected ExecutorService getNonBlockingExecutor() {
        return this.mNonBlockingExecutor;
    }

    public void setBlockingExecutor(ExecutorService executorService) {
        this.mBlockingExecutor = executorService;
    }

    public void setNonBlockingExecutor(ExecutorService executorService) {
        this.mNonBlockingExecutor = executorService;
    }

    public static interface OnRequestComplete {
        public void onAuthError(AuthFailureError var1);

        public void onError(IOException var1);

        public void onSuccess(HttpResponse var1);
    }

    private static class Response {
        AuthFailureError authFailureError;
        HttpResponse httpResponse;
        IOException ioException;

        private Response(HttpResponse httpResponse, IOException iOException, AuthFailureError authFailureError) {
            this.httpResponse = httpResponse;
            this.ioException = iOException;
            this.authFailureError = authFailureError;
        }
    }
}

