/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.os.SystemClock;
import com.android.volley.AsyncNetwork;
import com.android.volley.AuthFailureError;
import com.android.volley.Header;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestTask;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.AsyncHttpStack;
import com.android.volley.toolbox.ByteArrayPool;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.HttpResponse;
import com.android.volley.toolbox.NetworkUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class BasicAsyncNetwork
extends AsyncNetwork {
    private final AsyncHttpStack mAsyncStack;
    private final ByteArrayPool mPool;

    private BasicAsyncNetwork(AsyncHttpStack asyncHttpStack, ByteArrayPool byteArrayPool) {
        this.mAsyncStack = asyncHttpStack;
        this.mPool = byteArrayPool;
    }

    private void onRequestFailed(Request<?> request, AsyncNetwork.OnRequestComplete onRequestComplete, IOException invokeRetryPolicyTask, long l, HttpResponse object, byte[] object2) {
        try {
            object2 = NetworkUtility.shouldRetryException(request, (IOException)((Object)invokeRetryPolicyTask), l, (HttpResponse)object, object2);
            object = this.getBlockingExecutor();
            invokeRetryPolicyTask = new InvokeRetryPolicyTask(request, (NetworkUtility.RetryInfo)object2, onRequestComplete);
            object.execute(invokeRetryPolicyTask);
        }
        catch (VolleyError volleyError) {
            onRequestComplete.onError(volleyError);
        }
    }

    private void onRequestSucceeded(Request<?> request, long l, HttpResponse httpResponse, AsyncNetwork.OnRequestComplete onRequestComplete) {
        byte[] byArray;
        int n = httpResponse.getStatusCode();
        List<Header> list = httpResponse.getHeaders();
        if (n == 304) {
            onRequestComplete.onSuccess(NetworkUtility.getNotModifiedNetworkResponse(request, SystemClock.elapsedRealtime() - l, list));
            return;
        }
        Object object = byArray = httpResponse.getContentBytes();
        if (byArray == null) {
            object = byArray;
            if (httpResponse.getContent() == null) {
                object = new byte[]{};
            }
        }
        if (object != null) {
            this.onResponseRead(l, n, httpResponse, request, onRequestComplete, list, (byte[])object);
            return;
        }
        object = httpResponse.getContent();
        this.getBlockingExecutor().execute(new ResponseParsingTask((InputStream)object, httpResponse, request, onRequestComplete, l, list, n));
    }

    private void onResponseRead(long l, int n, HttpResponse httpResponse, Request<?> request, AsyncNetwork.OnRequestComplete onRequestComplete, List<Header> list, byte[] byArray) {
        NetworkUtility.logSlowRequests(SystemClock.elapsedRealtime() - l, request, byArray, n);
        if (n >= 200 && n <= 299) {
            onRequestComplete.onSuccess(new NetworkResponse(n, byArray, false, SystemClock.elapsedRealtime() - l, list));
            return;
        }
        this.onRequestFailed(request, onRequestComplete, new IOException(), l, httpResponse, byArray);
    }

    @Override
    public void performRequest(final Request<?> request, final AsyncNetwork.OnRequestComplete onRequestComplete) {
        if (this.getBlockingExecutor() != null) {
            final long l = SystemClock.elapsedRealtime();
            Map<String, String> map = HttpHeaderParser.getCacheHeaders(request.getCacheEntry());
            this.mAsyncStack.executeRequest(request, map, new AsyncHttpStack.OnRequestComplete(){

                @Override
                public void onAuthError(AuthFailureError authFailureError) {
                    onRequestComplete.onError(authFailureError);
                }

                @Override
                public void onError(IOException iOException) {
                    BasicAsyncNetwork.this.onRequestFailed(request, onRequestComplete, iOException, l, null, null);
                }

                @Override
                public void onSuccess(HttpResponse httpResponse) {
                    BasicAsyncNetwork.this.onRequestSucceeded(request, l, httpResponse, onRequestComplete);
                }
            });
            return;
        }
        throw new IllegalStateException("mBlockingExecuter must be set before making a request");
    }

    @Override
    public void setBlockingExecutor(ExecutorService executorService) {
        super.setBlockingExecutor(executorService);
        this.mAsyncStack.setBlockingExecutor(executorService);
    }

    @Override
    public void setNonBlockingExecutor(ExecutorService executorService) {
        super.setNonBlockingExecutor(executorService);
        this.mAsyncStack.setNonBlockingExecutor(executorService);
    }

    public static class Builder {
        private static final int DEFAULT_POOL_SIZE = 4096;
        private AsyncHttpStack mAsyncStack;
        private ByteArrayPool mPool;

        public Builder(AsyncHttpStack asyncHttpStack) {
            this.mAsyncStack = asyncHttpStack;
            this.mPool = null;
        }

        public BasicAsyncNetwork build() {
            if (this.mPool == null) {
                this.mPool = new ByteArrayPool(4096);
            }
            return new BasicAsyncNetwork(this.mAsyncStack, this.mPool);
        }

        public Builder setPool(ByteArrayPool byteArrayPool) {
            this.mPool = byteArrayPool;
            return this;
        }
    }

    private class InvokeRetryPolicyTask<T>
    extends RequestTask<T> {
        final AsyncNetwork.OnRequestComplete callback;
        final Request<T> request;
        final NetworkUtility.RetryInfo retryInfo;

        InvokeRetryPolicyTask(Request<T> request, NetworkUtility.RetryInfo retryInfo, AsyncNetwork.OnRequestComplete onRequestComplete) {
            super(request);
            this.request = request;
            this.retryInfo = retryInfo;
            this.callback = onRequestComplete;
        }

        @Override
        public void run() {
            try {
                NetworkUtility.attemptRetryOnException(this.request, this.retryInfo);
                BasicAsyncNetwork.this.performRequest(this.request, this.callback);
            }
            catch (VolleyError volleyError) {
                this.callback.onError(volleyError);
            }
        }
    }

    private class ResponseParsingTask<T>
    extends RequestTask<T> {
        AsyncNetwork.OnRequestComplete callback;
        HttpResponse httpResponse;
        InputStream inputStream;
        Request<T> request;
        long requestStartMs;
        List<Header> responseHeaders;
        int statusCode;

        ResponseParsingTask(InputStream inputStream, HttpResponse httpResponse, Request<T> request, AsyncNetwork.OnRequestComplete onRequestComplete, long l, List<Header> list, int n) {
            super(request);
            this.inputStream = inputStream;
            this.httpResponse = httpResponse;
            this.request = request;
            this.callback = onRequestComplete;
            this.requestStartMs = l;
            this.responseHeaders = list;
            this.statusCode = n;
        }

        @Override
        public void run() {
            byte[] byArray;
            try {
                byArray = NetworkUtility.inputStreamToBytes(this.inputStream, this.httpResponse.getContentLength(), BasicAsyncNetwork.this.mPool);
            }
            catch (IOException iOException) {
                BasicAsyncNetwork.this.onRequestFailed(this.request, this.callback, iOException, this.requestStartMs, this.httpResponse, null);
                return;
            }
            BasicAsyncNetwork.this.onResponseRead(this.requestStartMs, this.statusCode, this.httpResponse, this.request, this.callback, this.responseHeaders, byArray);
        }
    }
}

