/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.os.SystemClock;
import com.android.volley.Header;
import com.android.volley.Network;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.AdaptedHttpStack;
import com.android.volley.toolbox.BaseHttpStack;
import com.android.volley.toolbox.ByteArrayPool;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.HttpResponse;
import com.android.volley.toolbox.HttpStack;
import com.android.volley.toolbox.NetworkUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BasicNetwork
implements Network {
    private static final int DEFAULT_POOL_SIZE = 4096;
    private final BaseHttpStack mBaseHttpStack;
    @Deprecated
    protected final HttpStack mHttpStack;
    protected final ByteArrayPool mPool;

    public BasicNetwork(BaseHttpStack baseHttpStack) {
        this(baseHttpStack, new ByteArrayPool(4096));
    }

    public BasicNetwork(BaseHttpStack baseHttpStack, ByteArrayPool byteArrayPool) {
        this.mBaseHttpStack = baseHttpStack;
        this.mHttpStack = baseHttpStack;
        this.mPool = byteArrayPool;
    }

    @Deprecated
    public BasicNetwork(HttpStack httpStack) {
        this(httpStack, new ByteArrayPool(4096));
    }

    @Deprecated
    public BasicNetwork(HttpStack httpStack, ByteArrayPool byteArrayPool) {
        this.mHttpStack = httpStack;
        this.mBaseHttpStack = new AdaptedHttpStack(httpStack);
        this.mPool = byteArrayPool;
    }

    @Deprecated
    protected static Map<String, String> convertHeaders(Header[] headerArray) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < headerArray.length; ++i) {
            treeMap.put(headerArray[i].getName(), headerArray[i].getValue());
        }
        return treeMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NetworkResponse performRequest(Request<?> request) throws VolleyError {
        long l = SystemClock.elapsedRealtime();
        while (true) {
            Object object;
            Object object2;
            Object object3;
            block9: {
                Object object4;
                Collections.emptyList();
                object3 = null;
                try {
                    object4 = HttpHeaderParser.getCacheHeaders(request.getCacheEntry());
                    object2 = this.mBaseHttpStack.executeRequest(request, (Map<String, String>)object4);
                    object4 = object3;
                }
                catch (IOException iOException) {
                    object2 = object = null;
                    object3 = iOException;
                    break block9;
                }
                try {
                    int n = ((HttpResponse)object2).getStatusCode();
                    object4 = object3;
                    object = ((HttpResponse)object2).getHeaders();
                    if (n == 304) {
                        object4 = object3;
                        return NetworkUtility.getNotModifiedNetworkResponse(request, SystemClock.elapsedRealtime() - l, (List<Header>)object);
                    }
                    object4 = object3;
                    InputStream inputStream = ((HttpResponse)object2).getContent();
                    if (inputStream != null) {
                        object4 = object3;
                        object3 = NetworkUtility.inputStreamToBytes(inputStream, ((HttpResponse)object2).getContentLength(), this.mPool);
                    } else {
                        object4 = object3;
                        object3 = new byte[0];
                    }
                    object4 = object3;
                    NetworkUtility.logSlowRequests(SystemClock.elapsedRealtime() - l, request, (byte[])object3, n);
                    if (n >= 200 && n <= 299) {
                        object4 = object3;
                        return new NetworkResponse(n, (byte[])object3, false, SystemClock.elapsedRealtime() - l, (List<Header>)object);
                    }
                    object4 = object3;
                    object4 = object3;
                    object = new IOException();
                    object4 = object3;
                    throw object;
                }
                catch (IOException iOException) {
                    object = object2;
                    object2 = object4;
                }
            }
            NetworkUtility.attemptRetryOnException(request, NetworkUtility.shouldRetryException(request, (IOException)object3, l, (HttpResponse)object, (byte[])object2));
        }
    }
}

