/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ByteArrayPool {
    protected static final Comparator<byte[]> BUF_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] byArray, byte[] byArray2) {
            return byArray.length - byArray2.length;
        }
    };
    private final List<byte[]> mBuffersByLastUse = new ArrayList<byte[]>();
    private final List<byte[]> mBuffersBySize = new ArrayList<byte[]>(64);
    private int mCurrentSize = 0;
    private final int mSizeLimit;

    public ByteArrayPool(int n) {
        this.mSizeLimit = n;
    }

    private void trim() {
        synchronized (this) {
            while (this.mCurrentSize > this.mSizeLimit) {
                byte[] byArray = this.mBuffersByLastUse.remove(0);
                this.mBuffersBySize.remove(byArray);
                this.mCurrentSize -= byArray.length;
            }
            return;
        }
    }

    public byte[] getBuf(int n) {
        synchronized (this) {
            byte[] byArray;
            int n2 = 0;
            while (true) {
                if (n2 >= this.mBuffersBySize.size()) break;
                byArray = this.mBuffersBySize.get(n2);
                if (byArray.length >= n) {
                    this.mCurrentSize -= byArray.length;
                    this.mBuffersBySize.remove(n2);
                    this.mBuffersByLastUse.remove(byArray);
                    return byArray;
                }
                ++n2;
                continue;
                break;
            }
            byArray = new byte[n];
            return byArray;
        }
    }

    public void returnBuf(byte[] byArray) {
        synchronized (this) {
            block5: {
                if (byArray != null) {
                    int n;
                    block6: {
                        int n2;
                        if (byArray.length > this.mSizeLimit) break block5;
                        this.mBuffersByLastUse.add(byArray);
                        n = n2 = Collections.binarySearch(this.mBuffersBySize, byArray, BUF_COMPARATOR);
                        if (n2 >= 0) break block6;
                        n = -n2 - 1;
                    }
                    this.mBuffersBySize.add(n, byArray);
                    this.mCurrentSize += byArray.length;
                    this.trim();
                    return;
                }
            }
            return;
        }
    }
}

