/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.os.SystemClock;
import android.text.TextUtils;
import com.android.volley.Cache;
import com.android.volley.Header;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DiskBasedCache
implements Cache {
    private static final int CACHE_MAGIC = 538247942;
    private static final int DEFAULT_DISK_USAGE_BYTES = 0x500000;
    static final float HYSTERESIS_FACTOR = 0.9f;
    private final Map<String, CacheHeader> mEntries = new LinkedHashMap<String, CacheHeader>(16, 0.75f, true);
    private final int mMaxCacheSizeInBytes;
    private final FileSupplier mRootDirectorySupplier;
    private long mTotalSize = 0L;

    public DiskBasedCache(FileSupplier fileSupplier) {
        this(fileSupplier, 0x500000);
    }

    public DiskBasedCache(FileSupplier fileSupplier, int n) {
        this.mRootDirectorySupplier = fileSupplier;
        this.mMaxCacheSizeInBytes = n;
    }

    public DiskBasedCache(File file) {
        this(file, 0x500000);
    }

    public DiskBasedCache(final File file, int n) {
        this.mRootDirectorySupplier = new FileSupplier(){

            @Override
            public File get() {
                return file;
            }
        };
        this.mMaxCacheSizeInBytes = n;
    }

    private String getFilenameForKey(String string2) {
        int n = string2.length() / 2;
        int n2 = string2.substring(0, n).hashCode();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(n2));
        stringBuilder.append(String.valueOf(string2.substring(n).hashCode()));
        return stringBuilder.toString();
    }

    private void initializeIfRootDirectoryDeleted() {
        if (!this.mRootDirectorySupplier.get().exists()) {
            VolleyLog.d("Re-initializing cache after external clearing.", new Object[0]);
            this.mEntries.clear();
            this.mTotalSize = 0L;
            this.initialize();
        }
    }

    private void pruneIfNeeded() {
        int n;
        if (this.mTotalSize < (long)this.mMaxCacheSizeInBytes) {
            return;
        }
        if (VolleyLog.DEBUG) {
            VolleyLog.v("Pruning old cache entries.", new Object[0]);
        }
        long l = this.mTotalSize;
        long l2 = SystemClock.elapsedRealtime();
        Iterator<Map.Entry<String, CacheHeader>> iterator = this.mEntries.entrySet().iterator();
        int n2 = 0;
        do {
            n = n2;
            if (!iterator.hasNext()) break;
            CacheHeader cacheHeader = iterator.next().getValue();
            if (this.getFileForKey(cacheHeader.key).delete()) {
                this.mTotalSize -= cacheHeader.size;
            } else {
                VolleyLog.d("Could not delete cache entry for key=%s, filename=%s", cacheHeader.key, this.getFilenameForKey(cacheHeader.key));
            }
            iterator.remove();
            n2 = n = n2 + 1;
        } while (!((float)this.mTotalSize < (float)this.mMaxCacheSizeInBytes * 0.9f));
        if (VolleyLog.DEBUG) {
            VolleyLog.v("pruned %d files, %d bytes, %d ms", n, this.mTotalSize - l, SystemClock.elapsedRealtime() - l2);
        }
    }

    private void putEntry(String string2, CacheHeader cacheHeader) {
        if (!this.mEntries.containsKey(string2)) {
            this.mTotalSize += cacheHeader.size;
        } else {
            CacheHeader cacheHeader2 = this.mEntries.get(string2);
            this.mTotalSize += cacheHeader.size - cacheHeader2.size;
        }
        this.mEntries.put(string2, cacheHeader);
    }

    private static int read(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n != -1) {
            return n;
        }
        throw new EOFException();
    }

    static List<Header> readHeaderList(CountingInputStream object) throws IOException {
        int n = DiskBasedCache.readInt((InputStream)object);
        if (n >= 0) {
            List<Header> list = n == 0 ? Collections.emptyList() : new ArrayList();
            for (int i = 0; i < n; ++i) {
                list.add(new Header(DiskBasedCache.readString((CountingInputStream)object).intern(), DiskBasedCache.readString((CountingInputStream)object).intern()));
            }
            return list;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("readHeaderList size=");
        ((StringBuilder)object).append(n);
        throw new IOException(((StringBuilder)object).toString());
    }

    static int readInt(InputStream inputStream) throws IOException {
        int n = DiskBasedCache.read(inputStream);
        int n2 = DiskBasedCache.read(inputStream);
        int n3 = DiskBasedCache.read(inputStream);
        return DiskBasedCache.read(inputStream) << 24 | (n << 0 | 0 | n2 << 8 | n3 << 16);
    }

    static long readLong(InputStream inputStream) throws IOException {
        return ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 0 | 0L | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 8 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 16 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 24 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 32 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 40 | ((long)DiskBasedCache.read(inputStream) & 0xFFL) << 48 | (0xFFL & (long)DiskBasedCache.read(inputStream)) << 56;
    }

    static String readString(CountingInputStream countingInputStream) throws IOException {
        return new String(DiskBasedCache.streamToBytes(countingInputStream, DiskBasedCache.readLong(countingInputStream)), "UTF-8");
    }

    private void removeEntry(String object) {
        if ((object = this.mEntries.remove(object)) != null) {
            this.mTotalSize -= ((CacheHeader)object).size;
        }
    }

    static byte[] streamToBytes(CountingInputStream object, long l) throws IOException {
        int n;
        long l2 = ((CountingInputStream)object).bytesRemaining();
        if (l >= 0L && l <= l2 && (long)(n = (int)l) == l) {
            byte[] byArray = new byte[n];
            new DataInputStream((InputStream)object).readFully(byArray);
            return byArray;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("streamToBytes length=");
        ((StringBuilder)object).append(l);
        ((StringBuilder)object).append(", maxLength=");
        ((StringBuilder)object).append(l2);
        throw new IOException(((StringBuilder)object).toString());
    }

    static void writeHeaderList(List<Header> object, OutputStream outputStream) throws IOException {
        if (object != null) {
            DiskBasedCache.writeInt(outputStream, object.size());
            object = object.iterator();
            while (object.hasNext()) {
                Header header = (Header)object.next();
                DiskBasedCache.writeString(outputStream, header.getName());
                DiskBasedCache.writeString(outputStream, header.getValue());
            }
        } else {
            DiskBasedCache.writeInt(outputStream, 0);
        }
    }

    static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 0 & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >> 24 & 0xFF);
    }

    static void writeLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)(l >>> 0));
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 48));
        outputStream.write((byte)(l >>> 56));
    }

    static void writeString(OutputStream outputStream, String object) throws IOException {
        object = ((String)object).getBytes("UTF-8");
        DiskBasedCache.writeLong(outputStream, ((Object)object).length);
        outputStream.write((byte[])object, 0, ((Object)object).length);
    }

    @Override
    public void clear() {
        synchronized (this) {
            block7: {
                File[] fileArray = this.mRootDirectorySupplier.get().listFiles();
                if (fileArray == null) break block7;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    fileArray[i].delete();
                    continue;
                }
            }
            this.mEntries.clear();
            this.mTotalSize = 0L;
            VolleyLog.d("Cache cleared.", new Object[0]);
            return;
        }
    }

    InputStream createInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    OutputStream createOutputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    /*
     * Loose catch block
     */
    @Override
    public Cache.Entry get(String string2) {
        synchronized (this) {
            CountingInputStream countingInputStream2;
            Object object3;
            block14: {
                block13: {
                    object3 = this.mEntries.get(string2);
                    if (object3 != null) break block13;
                    return null;
                }
                File file = this.getFileForKey(string2);
                Object object2 = new BufferedInputStream(this.createInputStream(file));
                countingInputStream2 = new CountingInputStream((InputStream)object2, file.length());
                try {
                    object2 = CacheHeader.readHeader(countingInputStream2);
                    if (TextUtils.equals((CharSequence)string2, (CharSequence)((CacheHeader)object2).key)) break block14;
                    VolleyLog.d("%s: key=%s, found=%s", file.getAbsolutePath(), string2, ((CacheHeader)object2).key);
                    this.removeEntry(string2);
                }
                catch (Throwable throwable) {
                    countingInputStream2.close();
                    throw throwable;
                    {
                        catch (IOException iOException) {
                            VolleyLog.d("%s: %s", file.getAbsolutePath(), iOException.toString());
                            this.remove(string2);
                            return null;
                        }
                    }
                }
                countingInputStream2.close();
                return null;
            }
            object3 = ((CacheHeader)object3).toCacheEntry(DiskBasedCache.streamToBytes(countingInputStream2, countingInputStream2.bytesRemaining()));
            countingInputStream2.close();
            return object3;
        }
    }

    public File getFileForKey(String string2) {
        return new File(this.mRootDirectorySupplier.get(), this.getFilenameForKey(string2));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize() {
        synchronized (this) {
            File[] fileArray = this.mRootDirectorySupplier.get();
            boolean bl = fileArray.exists();
            int n = 0;
            if (!bl) {
                if (!fileArray.mkdirs()) {
                    VolleyLog.e("Unable to create cache dir %s", fileArray.getAbsolutePath());
                }
                return;
            }
            if ((fileArray = fileArray.listFiles()) == null) {
                return;
            }
            int n2 = fileArray.length;
            while (true) {
                block15: {
                    CountingInputStream countingInputStream;
                    Object object;
                    long l;
                    if (n >= n2) {
                        return;
                    }
                    File file = fileArray[n];
                    try {
                        l = file.length();
                        object = new BufferedInputStream(this.createInputStream(file));
                        countingInputStream = new CountingInputStream((InputStream)object, l);
                    }
                    catch (IOException iOException) {
                        file.delete();
                        break block15;
                    }
                    try {
                        object = CacheHeader.readHeader(countingInputStream);
                        ((CacheHeader)object).size = l;
                        this.putEntry(((CacheHeader)object).key, (CacheHeader)object);
                    }
                    finally {
                        countingInputStream.close();
                    }
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invalidate(String string2, boolean bl) {
        synchronized (this) {
            Cache.Entry entry = this.get(string2);
            if (entry != null) {
                void var2_2;
                entry.softTtl = 0L;
                if (var2_2 != false) {
                    entry.ttl = 0L;
                }
                this.put(string2, entry);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void put(String object, Cache.Entry entry) {
        synchronized (this) {
            int n;
            float f;
            void var2_3;
            if (this.mTotalSize + (long)var2_3.data.length > (long)this.mMaxCacheSizeInBytes && (f = (float)var2_3.data.length) > (float)(n = this.mMaxCacheSizeInBytes) * 0.9f) {
                return;
            }
            File file = this.getFileForKey((String)object);
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.createOutputStream(file));
                CacheHeader cacheHeader = new CacheHeader((String)object, (Cache.Entry)var2_3);
                if (!cacheHeader.writeHeader(bufferedOutputStream)) {
                    bufferedOutputStream.close();
                    VolleyLog.d("Failed to write header for %s", file.getAbsolutePath());
                    object = new IOException();
                    throw object;
                }
                bufferedOutputStream.write(var2_3.data);
                bufferedOutputStream.close();
                cacheHeader.size = file.length();
                this.putEntry((String)object, cacheHeader);
                this.pruneIfNeeded();
            }
            catch (IOException iOException) {
                if (!file.delete()) {
                    VolleyLog.d("Could not clean up file %s", file.getAbsolutePath());
                }
                this.initializeIfRootDirectoryDeleted();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void remove(String string2) {
        synchronized (this) {
            boolean bl = this.getFileForKey(string2).delete();
            this.removeEntry(string2);
            if (!bl) {
                VolleyLog.d("Could not delete cache entry for key=%s, filename=%s", string2, this.getFilenameForKey(string2));
            }
            return;
        }
    }

    static class CacheHeader {
        final List<Header> allResponseHeaders;
        final String etag;
        final String key;
        final long lastModified;
        final long serverDate;
        long size;
        final long softTtl;
        final long ttl;

        CacheHeader(String string2, Cache.Entry entry) {
            this(string2, entry.etag, entry.serverDate, entry.lastModified, entry.ttl, entry.softTtl, CacheHeader.getAllResponseHeaders(entry));
        }

        private CacheHeader(String string2, String string3, long l, long l2, long l3, long l4, List<Header> list) {
            this.key = string2;
            string2 = string3;
            if ("".equals(string3)) {
                string2 = null;
            }
            this.etag = string2;
            this.serverDate = l;
            this.lastModified = l2;
            this.ttl = l3;
            this.softTtl = l4;
            this.allResponseHeaders = list;
        }

        private static List<Header> getAllResponseHeaders(Cache.Entry entry) {
            if (entry.allResponseHeaders != null) {
                return entry.allResponseHeaders;
            }
            return HttpHeaderParser.toAllHeaderList(entry.responseHeaders);
        }

        static CacheHeader readHeader(CountingInputStream countingInputStream) throws IOException {
            if (DiskBasedCache.readInt(countingInputStream) == 538247942) {
                return new CacheHeader(DiskBasedCache.readString(countingInputStream), DiskBasedCache.readString(countingInputStream), DiskBasedCache.readLong(countingInputStream), DiskBasedCache.readLong(countingInputStream), DiskBasedCache.readLong(countingInputStream), DiskBasedCache.readLong(countingInputStream), DiskBasedCache.readHeaderList(countingInputStream));
            }
            throw new IOException();
        }

        Cache.Entry toCacheEntry(byte[] byArray) {
            Cache.Entry entry = new Cache.Entry();
            entry.data = byArray;
            entry.etag = this.etag;
            entry.serverDate = this.serverDate;
            entry.lastModified = this.lastModified;
            entry.ttl = this.ttl;
            entry.softTtl = this.softTtl;
            entry.responseHeaders = HttpHeaderParser.toHeaderMap(this.allResponseHeaders);
            entry.allResponseHeaders = Collections.unmodifiableList(this.allResponseHeaders);
            return entry;
        }

        boolean writeHeader(OutputStream outputStream) {
            String string2;
            block3: {
                try {
                    String string3;
                    DiskBasedCache.writeInt(outputStream, 538247942);
                    DiskBasedCache.writeString(outputStream, this.key);
                    string2 = string3 = this.etag;
                    if (string3 != null) break block3;
                    string2 = "";
                }
                catch (IOException iOException) {
                    VolleyLog.d("%s", iOException.toString());
                    return false;
                }
            }
            DiskBasedCache.writeString(outputStream, string2);
            DiskBasedCache.writeLong(outputStream, this.serverDate);
            DiskBasedCache.writeLong(outputStream, this.lastModified);
            DiskBasedCache.writeLong(outputStream, this.ttl);
            DiskBasedCache.writeLong(outputStream, this.softTtl);
            DiskBasedCache.writeHeaderList(this.allResponseHeaders, outputStream);
            outputStream.flush();
            return true;
        }
    }

    static class CountingInputStream
    extends FilterInputStream {
        private long bytesRead;
        private final long length;

        CountingInputStream(InputStream inputStream, long l) {
            super(inputStream);
            this.length = l;
        }

        long bytesRead() {
            return this.bytesRead;
        }

        long bytesRemaining() {
            return this.length - this.bytesRead;
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (n != -1) {
                ++this.bytesRead;
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((n = super.read(byArray, n, n2)) != -1) {
                this.bytesRead += (long)n;
            }
            return n;
        }
    }

    public static interface FileSupplier {
        public File get();
    }
}

