/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import com.android.volley.Cache;
import com.android.volley.Header;
import com.android.volley.NetworkResponse;
import com.android.volley.VolleyLog;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;

public class HttpHeaderParser {
    private static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String RFC1123_OUTPUT_FORMAT = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String RFC1123_PARSE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";

    static List<Header> combineHeaders(List<Header> list, Cache.Entry iterator) {
        block6: {
            TreeSet<String> treeSet;
            block5: {
                treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                if (!list.isEmpty()) {
                    Iterator<Header> entry = list.iterator();
                    while (entry.hasNext()) {
                        treeSet.add(entry.next().getName());
                    }
                }
                list = new ArrayList<Header>(list);
                if (((Cache.Entry)((Object)iterator)).allResponseHeaders == null) break block5;
                if (((Cache.Entry)((Object)iterator)).allResponseHeaders.isEmpty()) break block6;
                for (Header header : ((Cache.Entry)((Object)iterator)).allResponseHeaders) {
                    if (treeSet.contains(header.getName())) continue;
                    list.add(header);
                }
                break block6;
            }
            if (!((Cache.Entry)((Object)iterator)).responseHeaders.isEmpty()) {
                for (Map.Entry entry : ((Cache.Entry)((Object)iterator)).responseHeaders.entrySet()) {
                    if (treeSet.contains(entry.getKey())) continue;
                    list.add(new Header((String)entry.getKey(), (String)entry.getValue()));
                }
            }
        }
        return list;
    }

    static String formatEpochAsRfc1123(long l) {
        return HttpHeaderParser.newUsGmtFormatter(RFC1123_OUTPUT_FORMAT).format(new Date(l));
    }

    static Map<String, String> getCacheHeaders(Cache.Entry entry) {
        if (entry == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (entry.etag != null) {
            hashMap.put("If-None-Match", entry.etag);
        }
        if (entry.lastModified > 0L) {
            hashMap.put("If-Modified-Since", HttpHeaderParser.formatEpochAsRfc1123(entry.lastModified));
        }
        return hashMap;
    }

    private static SimpleDateFormat newUsGmtFormatter(String object) {
        object = new SimpleDateFormat((String)object, Locale.US);
        ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
        return object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Cache.Entry parseCacheHeaders(NetworkResponse var0) {
        block22: {
            block19: {
                var1_1 = System.currentTimeMillis();
                var3_2 = var0.headers;
                if (var3_2 == null) {
                    return null;
                }
                var4_3 /* !! */  = var3_2.get("Date");
                var5_4 = var4_3 /* !! */  != null ? HttpHeaderParser.parseDateAsEpoch((String)var4_3 /* !! */ ) : 0L;
                var4_3 /* !! */  = var3_2.get("Cache-Control");
                var7_5 = 0;
                if (var4_3 /* !! */  == null) break block19;
                var4_3 /* !! */  = var4_3 /* !! */ .split(",", 0);
                var9_7 = 0;
                var10_8 = 0L;
                var12_9 = 0L;
                block3: for (var8_6 = 0; var8_6 < var4_3 /* !! */ .length; ++var8_6) {
                    block20: {
                        block18: {
                            block21: {
                                var14_10 = var4_3 /* !! */ [var8_6].trim();
                                if (var14_10.equals("no-cache") || var14_10.equals("no-store")) break block20;
                                if (var14_10.startsWith("max-age=")) {
                                    var15_12 = Long.parseLong(var14_10.substring(8));
                                    var17_13 = var12_9;
                                    break block18;
                                }
                                if (var14_10.startsWith("stale-while-revalidate=")) {
                                    var17_13 = Long.parseLong(var14_10.substring(23));
                                    var15_12 = var10_8;
                                    break block18;
                                }
                                if (var14_10.equals("must-revalidate")) break block21;
                                var15_12 = var10_8;
                                var17_13 = var12_9;
                                if (!var14_10.equals("proxy-revalidate")) break block18;
                            }
                            var9_7 = 1;
                            var17_13 = var12_9;
                            var15_12 = var10_8;
                        }
lbl36:
                        // 2 sources

                        while (true) {
                            var10_8 = var15_12;
                            var12_9 = var17_13;
                            continue block3;
                            break;
                        }
                    }
                    return null;
                }
                var8_6 = var9_7;
                var9_7 = 1;
                break block22;
            }
            var9_7 = 0;
            var10_8 = 0L;
            var12_9 = 0L;
            var8_6 = var7_5;
        }
        var4_3 /* !! */  = var3_2.get("Expires");
        var17_13 = var4_3 /* !! */  != null ? HttpHeaderParser.parseDateAsEpoch((String)var4_3 /* !! */ ) : 0L;
        var4_3 /* !! */  = var3_2.get("Last-Modified");
        var15_12 = var4_3 /* !! */  != null ? HttpHeaderParser.parseDateAsEpoch((String)var4_3 /* !! */ ) : 0L;
        var14_10 = var3_2.get("ETag");
        if (var9_7 != 0) {
            var10_8 = var1_1 + var10_8 * 1000L;
            if (var8_6 != 0) {
                var12_9 = var10_8;
            } else {
                Long.signum(var12_9);
                var12_9 = var12_9 * 1000L + var10_8;
            }
            var17_13 = var12_9;
            var12_9 = var10_8;
            var10_8 = var17_13;
        } else {
            var10_8 = 0L;
            if (var5_4 > 0L && var17_13 >= var5_4) {
                var10_8 = var12_9 = var1_1 + (var17_13 - var5_4);
            } else {
                var12_9 = 0L;
            }
        }
        var4_3 /* !! */  = new Cache.Entry();
        var4_3 /* !! */ .data = var0.data;
        var4_3 /* !! */ .etag = var14_10;
        var4_3 /* !! */ .softTtl = var12_9;
        var4_3 /* !! */ .ttl = var10_8;
        var4_3 /* !! */ .serverDate = var5_4;
        var4_3 /* !! */ .lastModified = var15_12;
        var4_3 /* !! */ .responseHeaders = var3_2;
        var4_3 /* !! */ .allResponseHeaders = var0.allHeaders;
        return var4_3 /* !! */ ;
        catch (Exception var14_11) {
            var15_12 = var10_8;
            var17_13 = var12_9;
            ** continue;
        }
    }

    public static String parseCharset(Map<String, String> map) {
        return HttpHeaderParser.parseCharset(map, DEFAULT_CONTENT_CHARSET);
    }

    public static String parseCharset(Map<String, String> stringArray, String string2) {
        if (stringArray == null) {
            return string2;
        }
        if ((stringArray = stringArray.get(HEADER_CONTENT_TYPE)) != null) {
            String[] stringArray2 = stringArray.split(";", 0);
            for (int i = 1; i < stringArray2.length; ++i) {
                stringArray = stringArray2[i].trim().split("=", 0);
                if (stringArray.length != 2 || !stringArray[0].equals("charset")) continue;
                return stringArray[1];
            }
        }
        return string2;
    }

    public static long parseDateAsEpoch(String string2) {
        try {
            long l = HttpHeaderParser.newUsGmtFormatter(RFC1123_PARSE_FORMAT).parse(string2).getTime();
            return l;
        }
        catch (ParseException parseException) {
            if (!"0".equals(string2) && !"-1".equals(string2)) {
                VolleyLog.e(parseException, "Unable to parse dateStr: %s, falling back to 0", string2);
            } else {
                VolleyLog.v("Unable to parse dateStr: %s, falling back to 0", string2);
            }
            return 0L;
        }
    }

    static List<Header> toAllHeaderList(Map<String, String> object2) {
        ArrayList<Header> arrayList = new ArrayList<Header>(object2.size());
        for (Map.Entry entry : object2.entrySet()) {
            arrayList.add(new Header((String)entry.getKey(), (String)entry.getValue()));
        }
        return arrayList;
    }

    static Map<String, String> toHeaderMap(List<Header> object) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Iterator<Header> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            treeMap.put(((Header)object).getName(), ((Header)object).getValue());
        }
        return treeMap;
    }
}

