/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import com.android.volley.Header;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

public final class HttpResponse {
    private final InputStream mContent;
    private final byte[] mContentBytes;
    private final int mContentLength;
    private final List<Header> mHeaders;
    private final int mStatusCode;

    public HttpResponse(int n, List<Header> list) {
        this(n, list, -1, null);
    }

    public HttpResponse(int n, List<Header> list, int n2, InputStream inputStream) {
        this.mStatusCode = n;
        this.mHeaders = list;
        this.mContentLength = n2;
        this.mContent = inputStream;
        this.mContentBytes = null;
    }

    public HttpResponse(int n, List<Header> list, byte[] byArray) {
        this.mStatusCode = n;
        this.mHeaders = list;
        this.mContentLength = byArray.length;
        this.mContentBytes = byArray;
        this.mContent = null;
    }

    public final InputStream getContent() {
        InputStream inputStream = this.mContent;
        if (inputStream != null) {
            return inputStream;
        }
        if (this.mContentBytes != null) {
            return new ByteArrayInputStream(this.mContentBytes);
        }
        return null;
    }

    public final byte[] getContentBytes() {
        return this.mContentBytes;
    }

    public final int getContentLength() {
        return this.mContentLength;
    }

    public final List<Header> getHeaders() {
        return Collections.unmodifiableList(this.mHeaders);
    }

    public final int getStatusCode() {
        return this.mStatusCode;
    }
}

