/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import com.android.volley.AuthFailureError;
import com.android.volley.Header;
import com.android.volley.Request;
import com.android.volley.toolbox.BaseHttpStack;
import com.android.volley.toolbox.HttpResponse;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HurlStack
extends BaseHttpStack {
    private static final int HTTP_CONTINUE = 100;
    private final SSLSocketFactory mSslSocketFactory;
    private final UrlRewriter mUrlRewriter;

    public HurlStack() {
        this(null);
    }

    public HurlStack(UrlRewriter urlRewriter) {
        this(urlRewriter, null);
    }

    public HurlStack(UrlRewriter urlRewriter, SSLSocketFactory sSLSocketFactory) {
        this.mUrlRewriter = urlRewriter;
        this.mSslSocketFactory = sSLSocketFactory;
    }

    private void addBody(HttpURLConnection object, Request<?> request, byte[] byArray) throws IOException {
        ((URLConnection)object).setDoOutput(true);
        if (!((URLConnection)object).getRequestProperties().containsKey("Content-Type")) {
            ((URLConnection)object).setRequestProperty("Content-Type", request.getBodyContentType());
        }
        object = new DataOutputStream(this.createOutputStream(request, (HttpURLConnection)object, byArray.length));
        ((FilterOutputStream)object).write(byArray);
        ((FilterOutputStream)object).close();
    }

    private void addBodyIfExists(HttpURLConnection httpURLConnection, Request<?> request) throws IOException, AuthFailureError {
        byte[] byArray = request.getBody();
        if (byArray != null) {
            this.addBody(httpURLConnection, request, byArray);
        }
    }

    static List<Header> convertHeaders(Map<String, List<String>> entry2) {
        ArrayList<Header> arrayList = new ArrayList<Header>(entry2.size());
        for (Map.Entry<String, List<String>> entry2 : entry2.entrySet()) {
            if (entry2.getKey() == null) continue;
            for (String string2 : (List)entry2.getValue()) {
                arrayList.add(new Header((String)entry2.getKey(), string2));
            }
        }
        return arrayList;
    }

    private static boolean hasResponseBody(int n, int n2) {
        boolean bl = n != 4 && (100 > n2 || n2 >= 200) && n2 != 204 && n2 != 304;
        return bl;
    }

    private static InputStream inputStreamFromConnection(HttpURLConnection object) {
        try {
            InputStream inputStream = ((URLConnection)object).getInputStream();
            object = inputStream;
        }
        catch (IOException iOException) {
            object = ((HttpURLConnection)object).getErrorStream();
        }
        return object;
    }

    private HttpURLConnection openConnection(URL object, Request<?> request) throws IOException {
        HttpURLConnection httpURLConnection = this.createConnection((URL)object);
        int n = request.getTimeoutMs();
        httpURLConnection.setConnectTimeout(n);
        httpURLConnection.setReadTimeout(n);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoInput(true);
        if ("https".equals(((URL)object).getProtocol()) && (object = this.mSslSocketFactory) != null) {
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory((SSLSocketFactory)object);
        }
        return httpURLConnection;
    }

    protected HttpURLConnection createConnection(URL object) throws IOException {
        object = (HttpURLConnection)((URL)object).openConnection();
        ((HttpURLConnection)object).setInstanceFollowRedirects(HttpURLConnection.getFollowRedirects());
        return object;
    }

    protected InputStream createInputStream(Request<?> request, HttpURLConnection httpURLConnection) {
        return new UrlConnectionInputStream(httpURLConnection);
    }

    protected OutputStream createOutputStream(Request<?> request, HttpURLConnection httpURLConnection, int n) throws IOException {
        return httpURLConnection.getOutputStream();
    }

    @Override
    public HttpResponse executeRequest(Request<?> object, Map<String, String> object2) throws IOException, AuthFailureError {
        boolean bl;
        boolean bl2;
        block16: {
            int n;
            block17: {
                Object object3 = ((Request)object).getUrl();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.putAll((Map<String, String>)object2);
                hashMap.putAll(((Request)object).getHeaders());
                Object object4 = this.mUrlRewriter;
                object2 = object3;
                if (object4 != null && (object2 = object4.rewriteUrl((String)object3)) == null) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("URL blocked by rewriter: ");
                    ((StringBuilder)object).append((String)object3);
                    throw new IOException(((StringBuilder)object).toString());
                }
                object2 = this.openConnection(new URL((String)object2), (Request<?>)object);
                bl = bl2 = false;
                object3 = hashMap.keySet().iterator();
                while (true) {
                    bl = bl2;
                    if (!object3.hasNext()) break;
                    bl = bl2;
                    object4 = (String)object3.next();
                    bl = bl2;
                    ((URLConnection)object2).setRequestProperty((String)object4, (String)hashMap.get(object4));
                    continue;
                    break;
                }
                bl = bl2;
                try {
                    this.setConnectionParametersForRequest((HttpURLConnection)object2, (Request<?>)object);
                    bl = bl2;
                }
                catch (Throwable throwable) {
                    if (!bl) {
                        ((HttpURLConnection)object2).disconnect();
                    }
                    throw throwable;
                }
                n = ((HttpURLConnection)object2).getResponseCode();
                if (n == -1) break block16;
                bl = bl2;
                if (HurlStack.hasResponseBody(((Request)object).getMethod(), n)) break block17;
                bl = bl2;
                object = new HttpResponse(n, HurlStack.convertHeaders(((URLConnection)object2).getHeaderFields()));
                ((HttpURLConnection)object2).disconnect();
                return object;
            }
            bl = true;
            return new HttpResponse(n, HurlStack.convertHeaders(((URLConnection)object2).getHeaderFields()), ((URLConnection)object2).getContentLength(), this.createInputStream((Request<?>)object, (HttpURLConnection)object2));
        }
        bl = bl2;
        bl = bl2;
        object = new IOException("Could not retrieve response code from HttpUrlConnection.");
        bl = bl2;
        throw object;
    }

    void setConnectionParametersForRequest(HttpURLConnection httpURLConnection, Request<?> request) throws IOException, AuthFailureError {
        switch (request.getMethod()) {
            default: {
                throw new IllegalStateException("Unknown method type.");
            }
            case 7: {
                httpURLConnection.setRequestMethod("PATCH");
                this.addBodyIfExists(httpURLConnection, request);
                break;
            }
            case 6: {
                httpURLConnection.setRequestMethod("TRACE");
                break;
            }
            case 5: {
                httpURLConnection.setRequestMethod("OPTIONS");
                break;
            }
            case 4: {
                httpURLConnection.setRequestMethod("HEAD");
                break;
            }
            case 3: {
                httpURLConnection.setRequestMethod("DELETE");
                break;
            }
            case 2: {
                httpURLConnection.setRequestMethod("PUT");
                this.addBodyIfExists(httpURLConnection, request);
                break;
            }
            case 1: {
                httpURLConnection.setRequestMethod("POST");
                this.addBodyIfExists(httpURLConnection, request);
                break;
            }
            case 0: {
                httpURLConnection.setRequestMethod("GET");
                break;
            }
            case -1: {
                byte[] byArray = request.getPostBody();
                if (byArray == null) break;
                httpURLConnection.setRequestMethod("POST");
                this.addBody(httpURLConnection, request, byArray);
            }
        }
    }

    static class UrlConnectionInputStream
    extends FilterInputStream {
        private final HttpURLConnection mConnection;

        UrlConnectionInputStream(HttpURLConnection httpURLConnection) {
            super(HurlStack.inputStreamFromConnection(httpURLConnection));
            this.mConnection = httpURLConnection;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.mConnection.disconnect();
        }
    }

    public static interface UrlRewriter
    extends com.android.volley.toolbox.UrlRewriter {
    }
}

