/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.widget.ImageView;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageRequest;
import com.android.volley.toolbox.Threads;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ImageLoader {
    private int mBatchResponseDelayMs = 100;
    private final HashMap<String, BatchedImageRequest> mBatchedResponses;
    private final ImageCache mCache;
    private final Handler mHandler;
    private final HashMap<String, BatchedImageRequest> mInFlightRequests = new HashMap();
    private final RequestQueue mRequestQueue;
    private Runnable mRunnable;

    public ImageLoader(RequestQueue requestQueue, ImageCache imageCache) {
        this.mBatchedResponses = new HashMap();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mRequestQueue = requestQueue;
        this.mCache = imageCache;
    }

    static /* synthetic */ Runnable access$602(ImageLoader imageLoader, Runnable runnable) {
        imageLoader.mRunnable = runnable;
        return runnable;
    }

    private void batchResponse(String object, BatchedImageRequest batchedImageRequest) {
        this.mBatchedResponses.put((String)object, batchedImageRequest);
        if (this.mRunnable == null) {
            this.mRunnable = object = new Runnable(){

                @Override
                public void run() {
                    for (BatchedImageRequest batchedImageRequest : ImageLoader.this.mBatchedResponses.values()) {
                        for (ImageContainer imageContainer : batchedImageRequest.mContainers) {
                            if (imageContainer.mListener == null) continue;
                            if (batchedImageRequest.getError() == null) {
                                ImageContainer.access$502(imageContainer, batchedImageRequest.mResponseBitmap);
                                imageContainer.mListener.onResponse(imageContainer, false);
                                continue;
                            }
                            imageContainer.mListener.onErrorResponse(batchedImageRequest.getError());
                        }
                    }
                    ImageLoader.this.mBatchedResponses.clear();
                    ImageLoader.access$602(ImageLoader.this, null);
                }
            };
            this.mHandler.postDelayed((Runnable)object, (long)this.mBatchResponseDelayMs);
        }
    }

    private static String getCacheKey(String string2, int n, int n2, ImageView.ScaleType scaleType) {
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 12);
        stringBuilder.append("#W");
        stringBuilder.append(n);
        stringBuilder.append("#H");
        stringBuilder.append(n2);
        stringBuilder.append("#S");
        stringBuilder.append(scaleType.ordinal());
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static ImageListener getImageListener(final ImageView imageView, final int n, final int n2) {
        return new ImageListener(){

            @Override
            public void onErrorResponse(VolleyError volleyError) {
                int n3 = n2;
                if (n3 != 0) {
                    imageView.setImageResource(n3);
                }
            }

            @Override
            public void onResponse(ImageContainer imageContainer, boolean bl) {
                if (imageContainer.getBitmap() != null) {
                    imageView.setImageBitmap(imageContainer.getBitmap());
                } else {
                    int n3 = n;
                    if (n3 != 0) {
                        imageView.setImageResource(n3);
                    }
                }
            }
        };
    }

    public ImageContainer get(String string2, ImageListener imageListener) {
        return this.get(string2, imageListener, 0, 0);
    }

    public ImageContainer get(String string2, ImageListener imageListener, int n, int n2) {
        return this.get(string2, imageListener, n, n2, ImageView.ScaleType.CENTER_INSIDE);
    }

    public ImageContainer get(String request, ImageListener object, int n, int n2, ImageView.ScaleType scaleType) {
        Threads.throwIfNotOnMainThread();
        String string2 = ImageLoader.getCacheKey((String)((Object)request), n, n2, scaleType);
        Object object2 = this.mCache.getBitmap(string2);
        if (object2 != null) {
            request = new ImageContainer((Bitmap)object2, (String)((Object)request), null, null);
            object.onResponse((ImageContainer)((Object)request), true);
            return request;
        }
        ImageContainer imageContainer = new ImageContainer(null, (String)((Object)request), string2, (ImageListener)object);
        object.onResponse(imageContainer, true);
        object2 = this.mInFlightRequests.get(string2);
        object = object2;
        if (object2 == null) {
            object = this.mBatchedResponses.get(string2);
        }
        if (object != null) {
            ((BatchedImageRequest)object).addContainer(imageContainer);
            return imageContainer;
        }
        request = this.makeImageRequest((String)((Object)request), n, n2, scaleType, string2);
        this.mRequestQueue.add(request);
        this.mInFlightRequests.put(string2, new BatchedImageRequest(request, imageContainer));
        return imageContainer;
    }

    public boolean isCached(String string2, int n, int n2) {
        return this.isCached(string2, n, n2, ImageView.ScaleType.CENTER_INSIDE);
    }

    public boolean isCached(String string2, int n, int n2, ImageView.ScaleType scaleType) {
        Threads.throwIfNotOnMainThread();
        string2 = ImageLoader.getCacheKey(string2, n, n2, scaleType);
        boolean bl = this.mCache.getBitmap(string2) != null;
        return bl;
    }

    protected Request<Bitmap> makeImageRequest(String string2, int n, int n2, ImageView.ScaleType scaleType, final String string3) {
        return new ImageRequest(string2, new Response.Listener<Bitmap>(){

            @Override
            public void onResponse(Bitmap bitmap) {
                ImageLoader.this.onGetImageSuccess(string3, bitmap);
            }
        }, n, n2, scaleType, Bitmap.Config.RGB_565, new Response.ErrorListener(){

            @Override
            public void onErrorResponse(VolleyError volleyError) {
                ImageLoader.this.onGetImageError(string3, volleyError);
            }
        });
    }

    protected void onGetImageError(String string2, VolleyError volleyError) {
        BatchedImageRequest batchedImageRequest = this.mInFlightRequests.remove(string2);
        if (batchedImageRequest != null) {
            batchedImageRequest.setError(volleyError);
            this.batchResponse(string2, batchedImageRequest);
        }
    }

    protected void onGetImageSuccess(String string2, Bitmap bitmap) {
        this.mCache.putBitmap(string2, bitmap);
        BatchedImageRequest batchedImageRequest = this.mInFlightRequests.remove(string2);
        if (batchedImageRequest != null) {
            BatchedImageRequest.access$002(batchedImageRequest, bitmap);
            this.batchResponse(string2, batchedImageRequest);
        }
    }

    public void setBatchedResponseDelay(int n) {
        this.mBatchResponseDelayMs = n;
    }

    private static class BatchedImageRequest {
        private final List<ImageContainer> mContainers;
        private VolleyError mError;
        private final Request<?> mRequest;
        private Bitmap mResponseBitmap;

        public BatchedImageRequest(Request<?> request, ImageContainer imageContainer) {
            ArrayList<ImageContainer> arrayList = new ArrayList<ImageContainer>();
            this.mContainers = arrayList;
            this.mRequest = request;
            arrayList.add(imageContainer);
        }

        static /* synthetic */ Bitmap access$002(BatchedImageRequest batchedImageRequest, Bitmap bitmap) {
            batchedImageRequest.mResponseBitmap = bitmap;
            return bitmap;
        }

        public void addContainer(ImageContainer imageContainer) {
            this.mContainers.add(imageContainer);
        }

        public VolleyError getError() {
            return this.mError;
        }

        public boolean removeContainerAndCancelIfNecessary(ImageContainer imageContainer) {
            this.mContainers.remove(imageContainer);
            if (this.mContainers.size() == 0) {
                this.mRequest.cancel();
                return true;
            }
            return false;
        }

        public void setError(VolleyError volleyError) {
            this.mError = volleyError;
        }
    }

    public static interface ImageCache {
        public Bitmap getBitmap(String var1);

        public void putBitmap(String var1, Bitmap var2);
    }

    public class ImageContainer {
        private Bitmap mBitmap;
        private final String mCacheKey;
        private final ImageListener mListener;
        private final String mRequestUrl;

        public ImageContainer(Bitmap bitmap, String string2, String string3, ImageListener imageListener) {
            this.mBitmap = bitmap;
            this.mRequestUrl = string2;
            this.mCacheKey = string3;
            this.mListener = imageListener;
        }

        static /* synthetic */ Bitmap access$502(ImageContainer imageContainer, Bitmap bitmap) {
            imageContainer.mBitmap = bitmap;
            return bitmap;
        }

        public void cancelRequest() {
            Threads.throwIfNotOnMainThread();
            if (this.mListener == null) {
                return;
            }
            BatchedImageRequest batchedImageRequest = (BatchedImageRequest)ImageLoader.this.mInFlightRequests.get(this.mCacheKey);
            if (batchedImageRequest != null) {
                if (batchedImageRequest.removeContainerAndCancelIfNecessary(this)) {
                    ImageLoader.this.mInFlightRequests.remove(this.mCacheKey);
                }
            } else {
                batchedImageRequest = (BatchedImageRequest)ImageLoader.this.mBatchedResponses.get(this.mCacheKey);
                if (batchedImageRequest != null) {
                    batchedImageRequest.removeContainerAndCancelIfNecessary(this);
                    if (batchedImageRequest.mContainers.size() == 0) {
                        ImageLoader.this.mBatchedResponses.remove(this.mCacheKey);
                    }
                }
            }
        }

        public Bitmap getBitmap() {
            return this.mBitmap;
        }

        public String getRequestUrl() {
            return this.mRequestUrl;
        }
    }

    public static interface ImageListener
    extends Response.ErrorListener {
        public void onResponse(ImageContainer var1, boolean var2);
    }
}

