/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.widget.ImageView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;

public class ImageRequest
extends Request<Bitmap> {
    public static final float DEFAULT_IMAGE_BACKOFF_MULT = 2.0f;
    public static final int DEFAULT_IMAGE_MAX_RETRIES = 2;
    public static final int DEFAULT_IMAGE_TIMEOUT_MS = 1000;
    private static final Object sDecodeLock = new Object();
    private final Bitmap.Config mDecodeConfig;
    private Response.Listener<Bitmap> mListener;
    private final Object mLock = new Object();
    private final int mMaxHeight;
    private final int mMaxWidth;
    private final ImageView.ScaleType mScaleType;

    @Deprecated
    public ImageRequest(String string2, Response.Listener<Bitmap> listener, int n, int n2, Bitmap.Config config, Response.ErrorListener errorListener) {
        this(string2, listener, n, n2, ImageView.ScaleType.CENTER_INSIDE, config, errorListener);
    }

    public ImageRequest(String string2, Response.Listener<Bitmap> listener, int n, int n2, ImageView.ScaleType scaleType, Bitmap.Config config, Response.ErrorListener errorListener) {
        super(0, string2, errorListener);
        this.setRetryPolicy(new DefaultRetryPolicy(1000, 2, 2.0f));
        this.mListener = listener;
        this.mDecodeConfig = config;
        this.mMaxWidth = n;
        this.mMaxHeight = n2;
        this.mScaleType = scaleType;
    }

    private Response<Bitmap> doParse(NetworkResponse networkResponse) {
        Object object;
        block5: {
            int n;
            int n2;
            BitmapFactory.Options options;
            block6: {
                block4: {
                    object = networkResponse.data;
                    options = new BitmapFactory.Options();
                    if (this.mMaxWidth != 0 || this.mMaxHeight != 0) break block4;
                    options.inPreferredConfig = this.mDecodeConfig;
                    object = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options);
                    break block5;
                }
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options);
                int n3 = options.outWidth;
                int n4 = options.outHeight;
                n2 = ImageRequest.getResizedDimension(this.mMaxWidth, this.mMaxHeight, n3, n4, this.mScaleType);
                n = ImageRequest.getResizedDimension(this.mMaxHeight, this.mMaxWidth, n4, n3, this.mScaleType);
                options.inJustDecodeBounds = false;
                options.inSampleSize = ImageRequest.findBestSampleSize(n3, n4, n2, n);
                options = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options);
                object = options;
                if (options == null) break block5;
                if (options.getWidth() > n2) break block6;
                object = options;
                if (options.getHeight() <= n) break block5;
            }
            object = Bitmap.createScaledBitmap((Bitmap)options, (int)n2, (int)n, (boolean)true);
            options.recycle();
        }
        if (object == null) {
            return Response.error(new ParseError(networkResponse));
        }
        return Response.success(object, HttpHeaderParser.parseCacheHeaders(networkResponse));
    }

    static int findBestSampleSize(int n, int n2, int n3, int n4) {
        float f;
        double d = Math.min((double)n / (double)n3, (double)n2 / (double)n4);
        float f2 = 1.0f;
        while ((double)(f = 2.0f * f2) <= d) {
            f2 = f;
        }
        return (int)f2;
    }

    private static int getResizedDimension(int n, int n2, int n3, int n4, ImageView.ScaleType scaleType) {
        if (n == 0 && n2 == 0) {
            return n3;
        }
        if (scaleType == ImageView.ScaleType.FIT_XY) {
            if (n == 0) {
                return n3;
            }
            return n;
        }
        if (n == 0) {
            double d = (double)n2 / (double)n4;
            return (int)((double)n3 * d);
        }
        if (n2 == 0) {
            return n;
        }
        double d = (double)n4 / (double)n3;
        if (scaleType == ImageView.ScaleType.CENTER_CROP) {
            double d2 = n;
            double d3 = n2;
            if (d2 * d < d3) {
                n = (int)(d3 / d);
            }
            return n;
        }
        double d4 = n;
        double d5 = n2;
        if (d4 * d > d5) {
            n = (int)(d5 / d);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cancel() {
        super.cancel();
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void deliverResponse(Bitmap bitmap) {
        Object object = this.mLock;
        // MONITORENTER : object
        Response.Listener<Bitmap> listener = this.mListener;
        // MONITOREXIT : object
        if (listener == null) return;
        listener.onResponse(bitmap);
    }

    @Override
    public Request.Priority getPriority() {
        return Request.Priority.LOW;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Response<Bitmap> parseNetworkResponse(NetworkResponse response) {
        Object object = sDecodeLock;
        synchronized (object) {
            try {
                try {
                    return this.doParse((NetworkResponse)((Object)response));
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    VolleyLog.e("Caught OOM for %d byte image, url=%s", ((NetworkResponse)((Object)response)).data.length, this.getUrl());
                    response = new Response<Bitmap>((Throwable)outOfMemoryError);
                    return Response.error((VolleyError)((Object)response));
                }
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }
}

