/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyLog;
import java.io.UnsupportedEncodingException;

public abstract class JsonRequest<T>
extends Request<T> {
    protected static final String PROTOCOL_CHARSET = "utf-8";
    private static final String PROTOCOL_CONTENT_TYPE = String.format("application/json; charset=%s", "utf-8");
    private Response.Listener<T> mListener;
    private final Object mLock = new Object();
    private final String mRequestBody;

    public JsonRequest(int n, String string2, String string3, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(n, string2, errorListener);
        this.mListener = listener;
        this.mRequestBody = string3;
    }

    @Deprecated
    public JsonRequest(String string2, String string3, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        this(-1, string2, string3, listener, errorListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cancel() {
        super.cancel();
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void deliverResponse(T t) {
        Object object = this.mLock;
        // MONITORENTER : object
        Response.Listener<T> listener = this.mListener;
        // MONITOREXIT : object
        if (listener == null) return;
        listener.onResponse(t);
    }

    @Override
    public byte[] getBody() {
        byte[] byArray;
        block3: {
            String string2;
            byArray = null;
            try {
                string2 = this.mRequestBody;
                if (string2 == null) break block3;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                VolleyLog.wtf("Unsupported Encoding while trying to get the bytes of %s using %s", this.mRequestBody, PROTOCOL_CHARSET);
                return null;
            }
            byArray = string2.getBytes(PROTOCOL_CHARSET);
        }
        return byArray;
    }

    @Override
    public String getBodyContentType() {
        return PROTOCOL_CONTENT_TYPE;
    }

    @Override
    @Deprecated
    public byte[] getPostBody() {
        return this.getBody();
    }

    @Override
    @Deprecated
    public String getPostBodyContentType() {
        return this.getBodyContentType();
    }

    @Override
    protected abstract Response<T> parseNetworkResponse(NetworkResponse var1);
}

