/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.Threads;

public class NetworkImageView
extends ImageView {
    private Bitmap mDefaultImageBitmap;
    private Drawable mDefaultImageDrawable;
    private int mDefaultImageId;
    private Bitmap mErrorImageBitmap;
    private Drawable mErrorImageDrawable;
    private int mErrorImageId;
    private ImageLoader.ImageContainer mImageContainer;
    private ImageLoader mImageLoader;
    private String mUrl;

    public NetworkImageView(Context context) {
        this(context, null);
    }

    public NetworkImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public NetworkImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    private void setDefaultImageOrNull() {
        int n = this.mDefaultImageId;
        if (n != 0) {
            this.setImageResource(n);
        } else {
            Drawable drawable2 = this.mDefaultImageDrawable;
            if (drawable2 != null) {
                this.setImageDrawable(drawable2);
            } else {
                drawable2 = this.mDefaultImageBitmap;
                if (drawable2 != null) {
                    this.setImageBitmap((Bitmap)drawable2);
                } else {
                    this.setImageBitmap(null);
                }
            }
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    void loadImageIfNecessary(final boolean bl) {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        int n4;
        int n5;
        block9: {
            block8: {
                block7: {
                    n5 = this.getWidth();
                    n4 = this.getHeight();
                    object2 = this.getScaleType();
                    object = this.getLayoutParams();
                    n3 = 1;
                    if (object == null) break block7;
                    n2 = this.getLayoutParams().width == -2 ? 1 : 0;
                    n = n2;
                    if (this.getLayoutParams().height != -2) break block8;
                    int n6 = 1;
                    n = n2;
                    n2 = n6;
                    break block9;
                }
                n = 0;
            }
            n2 = 0;
        }
        if (n == 0 || n2 == 0) {
            n3 = 0;
        }
        if (n5 == 0 && n4 == 0 && n3 == 0) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            object2 = this.mImageContainer;
            if (object2 != null) {
                ((ImageLoader.ImageContainer)object2).cancelRequest();
                this.mImageContainer = null;
            }
            this.setDefaultImageOrNull();
            return;
        }
        object = this.mImageContainer;
        if (object != null && ((ImageLoader.ImageContainer)object).getRequestUrl() != null) {
            if (this.mImageContainer.getRequestUrl().equals(this.mUrl)) {
                return;
            }
            this.mImageContainer.cancelRequest();
            this.setDefaultImageOrNull();
        }
        n3 = n5;
        if (n != 0) {
            n3 = 0;
        }
        n2 = n2 != 0 ? 0 : n4;
        this.mImageContainer = this.mImageLoader.get(this.mUrl, new ImageLoader.ImageListener(){

            @Override
            public void onErrorResponse(VolleyError object) {
                if (NetworkImageView.this.mErrorImageId != 0) {
                    object = NetworkImageView.this;
                    object.setImageResource(((NetworkImageView)((Object)object)).mErrorImageId);
                } else if (NetworkImageView.this.mErrorImageDrawable != null) {
                    object = NetworkImageView.this;
                    object.setImageDrawable(((NetworkImageView)((Object)object)).mErrorImageDrawable);
                } else if (NetworkImageView.this.mErrorImageBitmap != null) {
                    object = NetworkImageView.this;
                    object.setImageBitmap(((NetworkImageView)((Object)object)).mErrorImageBitmap);
                }
            }

            @Override
            public void onResponse(ImageLoader.ImageContainer object, boolean bl2) {
                if (bl2 && bl) {
                    NetworkImageView.this.post(new Runnable((ImageLoader.ImageContainer)object){
                        final /* synthetic */ ImageLoader.ImageContainer val$response;
                        {
                            this.val$response = imageContainer;
                        }

                        @Override
                        public void run() {
                            this.onResponse(this.val$response, false);
                        }
                    });
                    return;
                }
                if (object.getBitmap() != null) {
                    NetworkImageView.this.setImageBitmap(object.getBitmap());
                } else if (NetworkImageView.this.mDefaultImageId != 0) {
                    object = NetworkImageView.this;
                    object.setImageResource(((NetworkImageView)((Object)object)).mDefaultImageId);
                } else if (NetworkImageView.this.mDefaultImageDrawable != null) {
                    object = NetworkImageView.this;
                    object.setImageDrawable(((NetworkImageView)((Object)object)).mDefaultImageDrawable);
                } else if (NetworkImageView.this.mDefaultImageBitmap != null) {
                    object = NetworkImageView.this;
                    object.setImageBitmap(((NetworkImageView)((Object)object)).mDefaultImageBitmap);
                }
            }
        }, n3, n2, (ImageView.ScaleType)object2);
    }

    protected void onDetachedFromWindow() {
        ImageLoader.ImageContainer imageContainer = this.mImageContainer;
        if (imageContainer != null) {
            imageContainer.cancelRequest();
            this.setImageBitmap(null);
            this.mImageContainer = null;
        }
        super.onDetachedFromWindow();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.loadImageIfNecessary(true);
    }

    public void setDefaultImageBitmap(Bitmap bitmap) {
        this.mDefaultImageId = 0;
        this.mDefaultImageDrawable = null;
        this.mDefaultImageBitmap = bitmap;
    }

    public void setDefaultImageDrawable(Drawable drawable2) {
        this.mDefaultImageId = 0;
        this.mDefaultImageBitmap = null;
        this.mDefaultImageDrawable = drawable2;
    }

    public void setDefaultImageResId(int n) {
        this.mDefaultImageBitmap = null;
        this.mDefaultImageDrawable = null;
        this.mDefaultImageId = n;
    }

    public void setErrorImageBitmap(Bitmap bitmap) {
        this.mErrorImageId = 0;
        this.mErrorImageDrawable = null;
        this.mErrorImageBitmap = bitmap;
    }

    public void setErrorImageDrawable(Drawable drawable2) {
        this.mErrorImageId = 0;
        this.mErrorImageBitmap = null;
        this.mErrorImageDrawable = drawable2;
    }

    public void setErrorImageResId(int n) {
        this.mErrorImageBitmap = null;
        this.mErrorImageDrawable = null;
        this.mErrorImageId = n;
    }

    public void setImageUrl(String string2, ImageLoader imageLoader) {
        Threads.throwIfNotOnMainThread();
        this.mUrl = string2;
        this.mImageLoader = imageLoader;
        this.loadImageIfNecessary(false);
    }
}

