/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.os.SystemClock;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.ClientError;
import com.android.volley.Header;
import com.android.volley.NetworkError;
import com.android.volley.NetworkResponse;
import com.android.volley.NoConnectionError;
import com.android.volley.Request;
import com.android.volley.RetryPolicy;
import com.android.volley.ServerError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.ByteArrayPool;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.HttpResponse;
import com.android.volley.toolbox.PoolingByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.List;

final class NetworkUtility {
    private static final int SLOW_REQUEST_THRESHOLD_MS = 3000;

    private NetworkUtility() {
    }

    static void attemptRetryOnException(Request<?> request, RetryInfo retryInfo) throws VolleyError {
        RetryPolicy retryPolicy = request.getRetryPolicy();
        int n = request.getTimeoutMs();
        try {
            retryPolicy.retry(retryInfo.errorToRetry);
        }
        catch (VolleyError volleyError) {
            request.addMarker(String.format("%s-timeout-giveup [timeout=%s]", retryInfo.logPrefix, n));
            throw volleyError;
        }
        request.addMarker(String.format("%s-retry [timeout=%s]", retryInfo.logPrefix, n));
    }

    static NetworkResponse getNotModifiedNetworkResponse(Request<?> object, long l, List<Header> list) {
        if ((object = ((Request)object).getCacheEntry()) == null) {
            return new NetworkResponse(304, null, true, l, list);
        }
        list = HttpHeaderParser.combineHeaders(list, (Cache.Entry)object);
        return new NetworkResponse(304, ((Cache.Entry)object).data, true, l, list);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] inputStreamToBytes(InputStream inputStream, int n, ByteArrayPool byteArrayPool) throws IOException {
        void var5_10;
        byte[] byArray;
        PoolingByteArrayOutputStream poolingByteArrayOutputStream;
        block10: {
            byte[] byArray2;
            block11: {
                poolingByteArrayOutputStream = new PoolingByteArrayOutputStream(byteArrayPool, n);
                try {
                    byArray = byteArrayPool.getBuf(1024);
                }
                catch (Throwable throwable) {
                    byArray = null;
                    break block10;
                }
                try {
                    while ((n = inputStream.read(byArray)) != -1) {
                        poolingByteArrayOutputStream.write(byArray, 0, n);
                    }
                    byArray2 = poolingByteArrayOutputStream.toByteArray();
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    break block10;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    VolleyLog.v("Error occurred when closing InputStream", new Object[0]);
                }
            }
            byteArrayPool.returnBuf(byArray);
            poolingByteArrayOutputStream.close();
            return byArray2;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                VolleyLog.v("Error occurred when closing InputStream", new Object[0]);
            }
        }
        byteArrayPool.returnBuf(byArray);
        poolingByteArrayOutputStream.close();
        throw var5_10;
    }

    static void logSlowRequests(long l, Request<?> request, byte[] object, int n) {
        if (VolleyLog.DEBUG || l > 3000L) {
            object = object != null ? (Object)((byte[])object).length : (Object)"null";
            VolleyLog.d("HTTP response for request=<%s> [lifetime=%d], [size=%s], [rc=%d], [retryCount=%s]", request, l, object, n, request.getRetryPolicy().getCurrentRetryCount());
        }
    }

    static RetryInfo shouldRetryException(Request<?> request, IOException object, long l, HttpResponse object2, byte[] byArray) throws VolleyError {
        if (object instanceof SocketTimeoutException) {
            return new RetryInfo("socket", new TimeoutError());
        }
        if (!(object instanceof MalformedURLException)) {
            if (object2 != null) {
                int n = ((HttpResponse)object2).getStatusCode();
                VolleyLog.e("Unexpected response code %d for %s", n, request.getUrl());
                if (byArray != null) {
                    object = ((HttpResponse)object2).getHeaders();
                    object = new NetworkResponse(n, byArray, false, SystemClock.elapsedRealtime() - l, (List<Header>)object);
                    if (n != 401 && n != 403) {
                        if (n >= 400 && n <= 499) {
                            throw new ClientError((NetworkResponse)object);
                        }
                        if (n >= 500 && n <= 599 && request.shouldRetryServerErrors()) {
                            return new RetryInfo("server", new ServerError((NetworkResponse)object));
                        }
                        throw new ServerError((NetworkResponse)object);
                    }
                    return new RetryInfo("auth", new AuthFailureError((NetworkResponse)object));
                }
                return new RetryInfo("network", new NetworkError());
            }
            if (request.shouldRetryConnectionErrors()) {
                return new RetryInfo("connection", new NoConnectionError());
            }
            throw new NoConnectionError((Throwable)object);
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Bad URL ");
        ((StringBuilder)object2).append(request.getUrl());
        throw new RuntimeException(((StringBuilder)object2).toString(), (Throwable)object);
    }

    static class RetryInfo {
        private final VolleyError errorToRetry;
        private final String logPrefix;

        private RetryInfo(String string2, VolleyError volleyError) {
            this.logPrefix = string2;
            this.errorToRetry = volleyError;
        }
    }
}

