/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import com.android.volley.toolbox.ByteArrayPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PoolingByteArrayOutputStream
extends ByteArrayOutputStream {
    private static final int DEFAULT_SIZE = 256;
    private final ByteArrayPool mPool;

    public PoolingByteArrayOutputStream(ByteArrayPool byteArrayPool) {
        this(byteArrayPool, 256);
    }

    public PoolingByteArrayOutputStream(ByteArrayPool byteArrayPool, int n) {
        this.mPool = byteArrayPool;
        this.buf = byteArrayPool.getBuf(Math.max(n, 256));
    }

    private void expand(int n) {
        if (this.count + n <= this.buf.length) {
            return;
        }
        byte[] byArray = this.mPool.getBuf((this.count + n) * 2);
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        this.mPool.returnBuf(this.buf);
        this.buf = byArray;
    }

    @Override
    public void close() throws IOException {
        this.mPool.returnBuf(this.buf);
        this.buf = null;
        super.close();
    }

    public void finalize() {
        this.mPool.returnBuf(this.buf);
    }

    @Override
    public void write(int n) {
        synchronized (this) {
            this.expand(1);
            super.write(n);
            return;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        synchronized (this) {
            this.expand(n2);
            super.write(byArray, n, n2);
            return;
        }
    }
}

