/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.os.SystemClock;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestFuture<T>
implements Future<T>,
Response.Listener<T>,
Response.ErrorListener {
    private VolleyError mException;
    private Request<?> mRequest;
    private T mResult;
    private boolean mResultReceived = false;

    private RequestFuture() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T doGet(Long serializable) throws InterruptedException, ExecutionException, TimeoutException {
        synchronized (this) {
            if (this.mException != null) {
                ExecutionException executionException = new ExecutionException(this.mException);
                throw executionException;
            }
            if (this.mResultReceived) {
                T t = this.mResult;
                return t;
            }
            if (serializable == null) {
                while (!this.isDone()) {
                    this.wait(0L);
                }
            } else if ((Long)serializable > 0L) {
                long l = SystemClock.uptimeMillis();
                long l2 = (Long)serializable + l;
                while (!this.isDone() && l < l2) {
                    this.wait(l2 - l);
                    l = SystemClock.uptimeMillis();
                }
            }
            if (this.mException != null) {
                ExecutionException executionException = new ExecutionException(this.mException);
                throw executionException;
            }
            if (this.mResultReceived) {
                T t = this.mResult;
                return t;
            }
            TimeoutException timeoutException = new TimeoutException();
            throw timeoutException;
        }
    }

    public static <E> RequestFuture<E> newFuture() {
        return new RequestFuture();
    }

    @Override
    public boolean cancel(boolean bl) {
        synchronized (this) {
            block6: {
                Request<?> request = this.mRequest;
                if (request != null) break block6;
                return false;
            }
            if (!this.isDone()) {
                this.mRequest.cancel();
                return true;
            }
            return false;
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        T t;
        try {
            t = this.doGet(null);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError((Object)timeoutException);
        }
        return t;
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doGet(TimeUnit.MILLISECONDS.convert(l, timeUnit));
    }

    @Override
    public boolean isCancelled() {
        Request<?> request = this.mRequest;
        if (request == null) {
            return false;
        }
        return request.isCanceled();
    }

    @Override
    public boolean isDone() {
        synchronized (this) {
            boolean bl;
            block4: {
                if (!this.mResultReceived && this.mException == null && !(bl = this.isCancelled())) {
                    bl = false;
                    break block4;
                }
                bl = true;
            }
            return bl;
        }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        synchronized (this) {
            this.mException = volleyError;
            this.notifyAll();
            return;
        }
    }

    @Override
    public void onResponse(T t) {
        synchronized (this) {
            this.mResultReceived = true;
            this.mResult = t;
            this.notifyAll();
            return;
        }
    }

    public void setRequest(Request<?> request) {
        this.mRequest = request;
    }
}

