/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.api;

import androidx.lifecycle.LiveData;
import com.brytonsport.active.api.ApiResponse;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;

public class LiveDataCallAdapter<R>
implements CallAdapter<R, LiveData<ApiResponse<R>>> {
    private final Type responseType;

    public LiveDataCallAdapter(Type type) {
        this.responseType = type;
    }

    public LiveData<ApiResponse<R>> adapt(final Call<R> call) {
        return new LiveData<ApiResponse<R>>(){
            AtomicBoolean started = new AtomicBoolean(false);

            @Override
            protected void onActive() {
                super.onActive();
                if (this.started.compareAndSet(false, true)) {
                    call.enqueue(new Callback<R>(){

                        public void onFailure(Call<R> call, Throwable throwable) {
                            this.postValue(new ApiResponse(throwable));
                        }

                        public void onResponse(Call<R> call, Response<R> response) {
                            this.postValue(new ApiResponse(response));
                        }
                    });
                }
            }
        };
    }

    public Type responseType() {
        return this.responseType;
    }
}

