/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.api;

import android.os.AsyncTask;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;
import com.brytonsport.active.api.ApiResponse;
import com.brytonsport.active.api.Resource;

public abstract class NetworkBoundResource<ResultType, RequestType> {
    private final MediatorLiveData<Resource<ResultType>> result;

    public NetworkBoundResource() {
        MediatorLiveData<Resource<Object>> mediatorLiveData = new MediatorLiveData<Resource<Object>>();
        this.result = mediatorLiveData;
        mediatorLiveData.setValue(Resource.loading(null));
        final LiveData<ResultType> liveData = this.loadFromDb();
        mediatorLiveData.addSource(liveData, new Observer<ResultType>(){

            @Override
            public void onChanged(ResultType ResultType) {
                NetworkBoundResource.this.result.removeSource(liveData);
                if (NetworkBoundResource.this.shouldFetch(ResultType)) {
                    NetworkBoundResource.this.fetchFromNetwork(liveData);
                } else {
                    NetworkBoundResource.this.result.addSource(liveData, new Observer<ResultType>(){

                        @Override
                        public void onChanged(ResultType ResultType) {
                            NetworkBoundResource.this.result.setValue(Resource.success(ResultType));
                        }
                    });
                }
            }
        });
    }

    private void fetchFromNetwork(final LiveData<ResultType> liveData) {
        final LiveData<ApiResponse<RequestType>> liveData2 = this.createCall();
        this.result.addSource(liveData, new Observer<ResultType>(){

            @Override
            public void onChanged(ResultType ResultType) {
                NetworkBoundResource.this.result.setValue(Resource.loading(ResultType));
            }
        });
        this.result.addSource(liveData2, new Observer<ApiResponse<RequestType>>(){

            @Override
            public void onChanged(final ApiResponse<RequestType> apiResponse) {
                NetworkBoundResource.this.result.removeSource(liveData2);
                NetworkBoundResource.this.result.removeSource(liveData);
                if (apiResponse.isSuccessful()) {
                    NetworkBoundResource.this.saveResultAndReInit(apiResponse);
                } else {
                    NetworkBoundResource.this.onFetchFailed();
                    NetworkBoundResource.this.result.addSource(liveData, new Observer<ResultType>(){

                        @Override
                        public void onChanged(ResultType ResultType) {
                            NetworkBoundResource.this.result.setValue(Resource.error(ResultType, apiResponse.errorMessage));
                        }
                    });
                }
            }
        });
    }

    private void saveResultAndReInit(final ApiResponse<RequestType> apiResponse) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... voidArray) {
                NetworkBoundResource.this.saveCallResult(apiResponse.body);
                return null;
            }

            protected void onPostExecute(Void void_) {
                NetworkBoundResource.this.result.addSource(NetworkBoundResource.this.loadFromDb(), new Observer<ResultType>(){

                    @Override
                    public void onChanged(ResultType ResultType) {
                        NetworkBoundResource.this.result.setValue(Resource.success(ResultType));
                    }
                });
            }
        }.execute((Object[])new Void[0]);
    }

    public LiveData<Resource<ResultType>> asLiveData() {
        return this.result;
    }

    protected abstract LiveData<ApiResponse<RequestType>> createCall();

    protected abstract LiveData<ResultType> loadFromDb();

    protected void onFetchFailed() {
    }

    protected abstract void saveCallResult(RequestType var1);

    protected abstract boolean shouldFetch(ResultType var1);
}

