/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.base;

import androidx.lifecycle.ViewModel;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.BaseViewModel$$ExternalSyntheticLambda0;
import com.brytonsport.active.base.BaseViewModel$$ExternalSyntheticLambda1;
import com.brytonsport.active.db.notification.entity.NotificationEntity;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.repo.account.LoginRepository;
import com.brytonsport.active.repo.course.FileIdHistoryRepository;
import com.brytonsport.active.repo.course.SearchHistoryRepository;
import com.brytonsport.active.repo.notification.NotificationRepository;
import com.brytonsport.active.repo.result.ActivityRepository;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.utils.NotificationConstantsUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.i18N;
import javax.inject.Inject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BaseViewModel
extends ViewModel {
    @Inject
    ActivityRepository activityRepository;
    @Inject
    BleRepository bleRepository;
    @Inject
    DeviceRepository deviceRepository;
    @Inject
    FileIdHistoryRepository fileIdHistoryRepository;
    @Inject
    LoginRepository loginRepository;
    @Inject
    NotificationRepository notificationRepository;
    @Inject
    SearchHistoryRepository searchHistoryRepository;

    public void AfterLogoutClearData() {
        new Thread(new BaseViewModel$$ExternalSyntheticLambda0(this)).start();
    }

    public void checkHasDeviceConnect() {
        new Thread(new BaseViewModel$$ExternalSyntheticLambda1(this)).start();
    }

    public void clearUserAccountSharedPreferences() {
        ProfileUtil.getInstance().set("userId", "");
        ProfileUtil.getInstance().set("com.brytonsport.active.loginToken", "");
        ProfileUtil.getInstance().set("nickName", "");
        ProfileUtil.getInstance().set("avatar", "");
        ProfileUtil.getInstance().set("activityListTimestamp", 0);
        ProfileUtil.getInstance().set("app_first_in_need_show_tutorial", true);
        ProfileUtil.getInstance().set("connect_ready_to_send_get_user_name", false);
        App.isAppNeedGetAnnouncement = true;
    }

    public void disconnectCurrentDevice() {
        for (DeviceManagerEntity deviceManagerEntity : this.deviceRepository.loadDeviceManagerList()) {
            if (!deviceManagerEntity.isConnected()) continue;
            this.bleRepository.disConnectDevice(deviceManagerEntity.getMacAddress());
        }
    }

    public void getAnnouncement() {
        this.loginRepository.getAnnouncement();
    }

    public void insertAppVersionNotification(String object, String string2, long l, long l2) {
        object = new NotificationEntity(NotificationConstantsUtil.CATEGORY_NEW_APP_VERSION, (String)object, string2, l, l2);
        this.notificationRepository.insertNewAppVersion((NotificationEntity)object);
    }

    public void insertNotification(String string2, String object, long l, long l2) {
        object = new NotificationEntity(NotificationConstantsUtil.CATEGORY_ANNOUNCEMENT, i18N.get("T_ImportantAnnouncement"), (String)object, l, l2);
        this.notificationRepository.insertAnnouncement(string2, (NotificationEntity)object);
    }

    public /* synthetic */ void lambda$AfterLogoutClearData$1$com-brytonsport-active-base-BaseViewModel() {
        this.disconnectCurrentDevice();
        this.activityRepository.deleteActivityAllData();
        this.searchHistoryRepository.deleteAllData();
        this.fileIdHistoryRepository.deleteAllData();
        this.deviceRepository.deleteAllData();
        this.notificationRepository.deleteAllData();
        this.loginRepository.deleteUserInfoAllData();
        this.loginRepository.deleteUserProfileAllData();
        this.clearUserAccountSharedPreferences();
    }

    public /* synthetic */ void lambda$checkHasDeviceConnect$0$com-brytonsport-active-base-BaseViewModel() {
        DeviceManagerEntity deviceManagerEntity = this.deviceRepository.loadDeviceIsChoice();
        if (deviceManagerEntity != null) {
            this.bleRepository.checkHasDeviceConnect(deviceManagerEntity);
        }
    }

    public void logout() {
        this.loginRepository.logout();
    }
}

