/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.base;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;

public abstract class GroupingRecyclerViewAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    protected static final String EXTRA_DATA;
    protected static final String EXTRA_GROUPS;
    protected static final String EXTRA_NAMESPACE = "com.brytonsport.active.base.GroupingRecyclerViewAdapter";
    protected static final int VIEW_TYPE_GROUP = 0;
    protected List<T> data;
    protected final int groupLayoutRes;
    protected SparseArray<Group> groups;

    static {
        String string2 = GroupingRecyclerViewAdapter.class.getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("_groups");
        EXTRA_GROUPS = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("_data");
        EXTRA_DATA = stringBuilder.toString();
    }

    public GroupingRecyclerViewAdapter() {
        this(2131427477);
    }

    public GroupingRecyclerViewAdapter(int n) {
        this.groupLayoutRes = n;
        this.groups = new SparseArray();
        this.data = new ArrayList<T>();
    }

    public void addAll(List<T> list) {
        int n = this.getItemCount();
        this.data.addAll(new ArrayList<T>(list));
        for (int i = this.data.size(); i < this.data.size(); ++i) {
            if (!this.shouldCreateGroup(i)) continue;
            list = this.groups;
            list.put(list.size() + i, this.createGroup(this.data.get(i)));
        }
        this.notifyItemRangeInserted(n, this.getItemCount() - n);
    }

    protected abstract Group createGroup(T var1);

    protected T getData(int n) {
        T t = (n = this.getDataPosition(n)) >= -1 ? (T)this.data.get(n) : null;
        return t;
    }

    protected int getDataPosition(int n) {
        if (this.isGroupPosition(n)) {
            return -1;
        }
        int n2 = 0;
        for (int i = 0; i < this.groups.size() && this.groups.keyAt(i) <= n; ++i) {
            --n2;
        }
        return n + n2;
    }

    @Override
    public int getItemCount() {
        return this.groups.size() + this.data.size();
    }

    @Override
    public int getItemViewType(int n) {
        return this.isGroupPosition(n) ^ 1;
    }

    protected boolean isGroupPosition(int n) {
        boolean bl = this.groups.get(n) != null;
        return bl;
    }

    protected abstract void onBindGroupItemViewHolder(VH var1, T var2);

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n) {
        if (this.isGroupPosition(n)) {
            ((GroupViewHolder)viewHolder).bind((Group)this.groups.get(n));
        } else {
            T t = this.getData(n);
            if (t != null) {
                this.onBindGroupItemViewHolder(viewHolder, t);
            }
        }
    }

    protected abstract VH onCreateGroupItemViewHolder(ViewGroup var1);

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup object, int n) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)object.getContext());
        object = n == 0 ? new GroupViewHolder((TextView)layoutInflater.inflate(this.groupLayoutRes, object, false)) : this.onCreateGroupItemViewHolder((ViewGroup)object);
        return object;
    }

    protected boolean shouldCreateGroup(int n) {
        boolean bl = true;
        if (n == 0) {
            return true;
        }
        T t = this.data.get(n - 1);
        T t2 = this.data.get(n);
        boolean bl2 = bl;
        if (t != null) {
            bl2 = bl;
            if (t2 != null) {
                bl2 = this.shouldCreateGroup(t, t2) ? bl : false;
            }
        }
        return bl2;
    }

    protected abstract boolean shouldCreateGroup(T var1, T var2);

    public void updateList(List<T> list) {
        this.data.clear();
        this.data.addAll(new ArrayList<T>(list));
        for (int i = this.data.size(); i < this.data.size(); ++i) {
            if (!this.shouldCreateGroup(i)) continue;
            list = this.groups;
            list.put(list.size() + i, this.createGroup(this.data.get(i)));
        }
        this.notifyItemRangeChanged(0, this.getItemCount() - 0);
    }

    protected static class Group {
        private final String title;

        public Group(String string2) {
            this.title = string2;
        }

        public String getTitle() {
            return this.title;
        }
    }

    protected static class GroupViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView tvTitle;

        public GroupViewHolder(TextView textView) {
            super((View)textView);
            this.tvTitle = textView;
        }

        public void bind(Group group) {
            this.tvTitle.setText((CharSequence)group.getTitle());
        }
    }
}

