/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.base;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.ui.profile.ProfileAboutMeActivity;
import com.brytonsport.active.ui.profile.ProfileActivity;
import com.brytonsport.active.ui.setting.SettingActivity;
import com.brytonsport.active.ui.setting.SettingManageDeviceActivity;
import com.brytonsport.active.ui.setting.SettingPairNewDeviceActivity;
import com.brytonsport.active.utils.BackLightMenuUtil;
import com.brytonsport.active.utils.GpsMenuUtil;
import com.brytonsport.active.utils.JsonUtil;
import com.brytonsport.active.utils.SettingLanguageUtil;
import com.brytonsport.active.utils.i18N;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SyncBLEViewModel
extends BaseViewModel {
    public static final int CMD_EXTRA_DEVICE_UPDATE = -1;
    private static final Map<Integer, String[]> CMD_Map;
    private static final int GET_FUNC_IDX = 0;
    private static final int SET_FUNC_IDX = 1;
    public final ArrayList<String> AUTO_LAP_BY_OPTIONS;
    public final int AUTO_LAP_CMD_DISTANCE;
    public final int AUTO_LAP_CMD_LOCATION;
    public final int AUTO_LAP_CMD_OFF;
    public final int AUTO_LAP_CMD_UNKNOWN;
    private final String AUTO_LAP_DISTANCE_TEXT;
    private final String AUTO_LAP_OFF_TEXT;
    private final String AUTO_LAP_POSITION_TEXT;
    public final int BIKE_CMD_ACTIVE;
    public final int BIKE_CMD_CRANK_LENGTH;
    public final int BIKE_CMD_NAME;
    public final int BIKE_CMD_SPD_SRC;
    public final int BIKE_CMD_WEIGHT;
    public final int BIKE_CMD_WHEEL;
    public final int FTP_CMD_BASE_VALUE;
    public final int FTP_CMD_LIST;
    public String[] Genders;
    public final int LTHR_CMD_BASE_VALUE;
    public final int LTHR_CMD_LIST;
    public final int MAP_CMD_BASE_VALUE;
    public final int MAP_CMD_LIST;
    public final int MHR_CMD_BASE_VALUE;
    public final int MHR_CMD_LIST;
    private final int MSG_TIMER_SYNC;
    public final int RIDE_INFO_CMD_ALT_GAIN;
    public final int RIDE_INFO_CMD_ALT_LOSS;
    public final int RIDE_INFO_CMD_RIDE_TIME;
    public final int SYNC_CMD_TYPE_GET;
    public final int SYNC_CMD_TYPE_SET;
    private final String TAG = this.getClass().toString();
    public final int USER_CMD_BIRTHDAY;
    public final int USER_CMD_DEVICE_LANG_ID;
    public final int USER_CMD_GENDER;
    public final int USER_CMD_HEIGHT;
    public final int USER_CMD_OLD_DEVICE_LANG;
    public final int USER_CMD_STOP_WATCH_NAME;
    public final int USER_CMD_WEIGHT;
    public String[] UnitTypes;
    public final int WIFI_ADD;
    public final int WIFI_CONNECT;
    public final int WIFI_DELETE;
    public final int WIFI_HOTSPOT;
    public final int WIFI_HOTSPOT_LIST;
    public final int WIFI_LIST;
    @Inject
    public BleRepository bleRepository;
    private boolean isAskStopSync;
    public MutableLiveData<String> mAutoLapBy;
    public MutableLiveData<String> mAutoLapValue;
    private int mBacklightCmdVer;
    public MutableLiveData<String> mBacklightOff;
    public MutableLiveData<String> mBike1Name;
    public MutableLiveData<ArrayList<Integer>> mBike1SPDSrcs;
    public MutableLiveData<String> mBike2Name;
    public MutableLiveData<ArrayList<Integer>> mBike2SPDSrcs;
    public MutableLiveData<String> mBike3Name;
    public MutableLiveData<ArrayList<Integer>> mBike3SPDSrcs;
    public MutableLiveData<Integer> mBikeNum;
    public MutableLiveData<String> mBikeODO;
    public MutableLiveData<String> mBirthday;
    public MutableLiveData<String> mDeviceLang;
    public MutableLiveData<Integer> mExtraCmdRun;
    public MutableLiveData<ArrayList<Float>> mFTPs;
    public MutableLiveData<String> mGPS;
    private int mGPSCmdVer;
    private final BroadcastReceiver mGattUpdateReceiver;
    public MutableLiveData<String> mGender;
    private final Handler mHandler;
    public MutableLiveData<ArrayList<Float>> mHeartRates;
    public MutableLiveData<String> mHeight;
    public MutableLiveData<Boolean> mIsAutoLap;
    public MutableLiveData<Boolean> mIsAutoPause;
    public MutableLiveData<Boolean> mIsKeyTone;
    public MutableLiveData<Boolean> mIsLoading;
    public MutableLiveData<Boolean> mIsSound;
    public MutableLiveData<ArrayList<Float>> mLTHRs;
    public MutableLiveData<ArrayList<Float>> mMAPs;
    public MutableLiveData<String> mMaxFTP;
    public MutableLiveData<String> mMaxHeartRate;
    public MutableLiveData<String> mMaxLTHR;
    public MutableLiveData<String> mMaxMAP;
    public MutableLiveData<Integer> mReqDone;
    private final ArrayList<JSONArray> mReqs;
    public MutableLiveData<String> mRideAltGain;
    public MutableLiveData<String> mRideAltLoss;
    public MutableLiveData<String> mRideTime;
    public MutableLiveData<String> mRideTrip1;
    public MutableLiveData<String> mRideTrip2;
    public MutableLiveData<String> mSensorPairedList;
    public MutableLiveData<String> mSensorScanList;
    public MutableLiveData<String> mSensorTypes;
    public MutableLiveData<Integer> mSensorValid;
    public MutableLiveData<String> mSensorWheelSize;
    public MutableLiveData<String> mStopWatchName;
    private Thread mThrSync;
    public MutableLiveData<String> mUnit;
    private int mUnitCmdVer;
    private final ArrayList<Integer> mWaits;
    public MutableLiveData<String> mWeight;
    public MutableLiveData<Integer> mWifiAPConnected;
    public MutableLiveData<String> mWifiList;
    public MutableLiveData<String> mWifiSpotList;
    public MutableLiveData<String> mWifiSpots;

    static {
        HashMap<Integer, String[]> hashMap = new HashMap<Integer, String[]>();
        CMD_Map = hashMap;
        hashMap.put(20, new String[]{"get.backlight", "set.backlight"});
        hashMap.put(21, new String[]{"get.grid.page", "set.grid.page"});
        hashMap.put(22, new String[]{"get.grid.setting", "set.grid.setting"});
        hashMap.put(23, new String[]{null, null});
        hashMap.put(24, new String[]{"get.battery", null});
        hashMap.put(25, new String[]{"get.keytone", "set.keytone"});
        hashMap.put(26, new String[]{"get.sound", "set.sound"});
        hashMap.put(27, new String[]{"get.auto.pause", "set.auto.pause"});
        hashMap.put(28, new String[]{"get.auto.lap", "set.auto.lap"});
        hashMap.put(29, new String[]{"get.unit", "set.unit"});
        hashMap.put(30, new String[]{null, null});
        hashMap.put(31, new String[]{null, null});
        hashMap.put(32, new String[]{"get.zone.map", "set.zone.map"});
        hashMap.put(33, new String[]{"get.zone.ftp", "set.zone.ftp"});
        hashMap.put(34, new String[]{"get.zone.mhr", "set.zone.mhr"});
        hashMap.put(35, new String[]{"get.zone.lthr", "set.zone.lthr"});
        hashMap.put(40, new String[]{"get.gps", "set.gps"});
        hashMap.put(45, new String[]{"get.bike.odo", "set.bike.odo"});
        hashMap.put(42, new String[]{"get.bike.trip", "set.bike.trip"});
        hashMap.put(53, new String[]{null, "set.updatepackage_info"});
        hashMap.put(44, new String[]{"get.sensor.status", "set.sensor.status"});
        hashMap.put(43, new String[]{"get.sensor.list", null});
        hashMap.put(-1, new String[]{null, "set.device.update"});
    }

    public SyncBLEViewModel() {
        Boolean bl = true;
        this.MSG_TIMER_SYNC = 1;
        this.mHandler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message message) {
                int n = message.what;
                boolean bl = false;
                if (n == 1) {
                    SyncBLEViewModel.this.stopSyncTimer();
                    SyncBLEViewModel.this.mIsLoading.setValue(false);
                    bl = true;
                }
                return bl;
            }
        });
        this.mBacklightCmdVer = 1;
        this.mGPSCmdVer = 1;
        this.mUnitCmdVer = 1;
        String string2 = i18N.get("Metric");
        Boolean bl2 = false;
        this.UnitTypes = new String[]{string2, i18N.get("Imperial")};
        this.Genders = new String[]{i18N.get("Female"), i18N.get("Male")};
        this.mIsLoading = new MutableLiveData<Boolean>(bl2);
        this.mIsKeyTone = new MutableLiveData<Boolean>(bl);
        this.mIsSound = new MutableLiveData<Boolean>(bl);
        this.mIsAutoPause = new MutableLiveData<Boolean>(bl);
        this.mBacklightOff = new MutableLiveData<String>("");
        this.mGPS = new MutableLiveData<String>("");
        this.mStopWatchName = new MutableLiveData<String>("");
        this.mUnit = new MutableLiveData<String>(App.profile.timeUnit.unit);
        this.mGender = new MutableLiveData<String>("");
        this.mBirthday = new MutableLiveData<String>("");
        this.mHeight = new MutableLiveData<String>("");
        this.mWeight = new MutableLiveData<String>("");
        this.mDeviceLang = new MutableLiveData<String>("");
        this.mMaxHeartRate = new MutableLiveData<String>("190 bpm");
        this.mHeartRates = new MutableLiveData();
        this.mMaxLTHR = new MutableLiveData<String>("190 bpm");
        this.mLTHRs = new MutableLiveData();
        this.mMaxMAP = new MutableLiveData<String>("250 watt");
        this.mMAPs = new MutableLiveData();
        this.mMaxFTP = new MutableLiveData<String>("250 watt");
        this.mFTPs = new MutableLiveData();
        this.mBikeNum = new MutableLiveData<Integer>(-1);
        this.mIsAutoLap = new MutableLiveData<Boolean>(bl2);
        this.mAutoLapBy = new MutableLiveData<String>("");
        this.mAutoLapValue = new MutableLiveData<String>("");
        this.mBikeODO = new MutableLiveData<String>("");
        this.mBike1Name = new MutableLiveData<String>("");
        this.mBike2Name = new MutableLiveData<String>("");
        this.mBike3Name = new MutableLiveData<String>("");
        this.mBike1SPDSrcs = new MutableLiveData();
        this.mBike2SPDSrcs = new MutableLiveData();
        this.mBike3SPDSrcs = new MutableLiveData();
        this.mRideTime = new MutableLiveData<String>("0");
        this.mRideAltGain = new MutableLiveData<String>("0");
        this.mRideAltLoss = new MutableLiveData<String>("0");
        this.mRideTrip1 = new MutableLiveData<String>("0");
        this.mRideTrip2 = new MutableLiveData<String>("0");
        this.mWifiAPConnected = new MutableLiveData<Integer>(0);
        this.mWifiList = new MutableLiveData();
        this.mWifiSpots = new MutableLiveData();
        this.mWifiSpotList = new MutableLiveData();
        this.mSensorPairedList = new MutableLiveData();
        this.mSensorValid = new MutableLiveData();
        this.mSensorWheelSize = new MutableLiveData();
        this.mSensorTypes = new MutableLiveData();
        this.mSensorScanList = new MutableLiveData();
        this.mReqDone = new MutableLiveData();
        this.mGattUpdateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                SyncBLEViewModel.this.onBLEReceive(context, intent);
            }
        };
        this.mReqs = new ArrayList();
        this.mWaits = new ArrayList();
        this.SYNC_CMD_TYPE_GET = 0;
        this.SYNC_CMD_TYPE_SET = 1;
        this.mThrSync = null;
        this.isAskStopSync = false;
        this.mExtraCmdRun = new MutableLiveData();
        this.USER_CMD_HEIGHT = 0;
        this.USER_CMD_WEIGHT = 1;
        this.USER_CMD_BIRTHDAY = 2;
        this.USER_CMD_GENDER = 3;
        this.USER_CMD_OLD_DEVICE_LANG = 4;
        this.USER_CMD_STOP_WATCH_NAME = 5;
        this.USER_CMD_DEVICE_LANG_ID = 6;
        this.WIFI_CONNECT = 0;
        this.WIFI_ADD = 1;
        this.WIFI_DELETE = 2;
        this.WIFI_LIST = 3;
        this.WIFI_HOTSPOT = 4;
        this.WIFI_HOTSPOT_LIST = 6;
        this.MHR_CMD_BASE_VALUE = 0;
        this.MHR_CMD_LIST = 1;
        this.LTHR_CMD_BASE_VALUE = 0;
        this.LTHR_CMD_LIST = 1;
        this.MAP_CMD_BASE_VALUE = 0;
        this.MAP_CMD_LIST = 1;
        this.FTP_CMD_BASE_VALUE = 0;
        this.FTP_CMD_LIST = 1;
        this.AUTO_LAP_CMD_OFF = 0;
        this.AUTO_LAP_CMD_DISTANCE = 1;
        this.AUTO_LAP_CMD_LOCATION = 2;
        this.AUTO_LAP_CMD_UNKNOWN = 3;
        this.AUTO_LAP_OFF_TEXT = "Off";
        this.AUTO_LAP_DISTANCE_TEXT = "Distance";
        this.AUTO_LAP_POSITION_TEXT = "Position";
        this.AUTO_LAP_BY_OPTIONS = new ArrayList<String>(Arrays.asList(i18N.get("Distance"), i18N.get("Location")));
        this.BIKE_CMD_SPD_SRC = 0;
        this.BIKE_CMD_WEIGHT = 1;
        this.BIKE_CMD_WHEEL = 2;
        this.BIKE_CMD_ACTIVE = 3;
        this.BIKE_CMD_CRANK_LENGTH = 4;
        this.BIKE_CMD_NAME = 5;
        this.RIDE_INFO_CMD_RIDE_TIME = 0;
        this.RIDE_INFO_CMD_ALT_GAIN = 1;
        this.RIDE_INFO_CMD_ALT_LOSS = 2;
    }

    static /* synthetic */ Thread access$402(SyncBLEViewModel syncBLEViewModel, Thread thread) {
        syncBLEViewModel.mThrSync = thread;
        return thread;
    }

    private String[] getBikeCommands(Object object) {
        String[] stringArray = null;
        if (object == null) {
            return null;
        }
        String[] stringArray2 = stringArray;
        if (object instanceof Integer) {
            int n = (Integer)object;
            stringArray2 = n != 0 ? (n != 5 ? stringArray : new String[]{"get.bike.name", "set.bike.name"}) : new String[]{"get.bike.spdSource", "set.bike.spdSource"};
        }
        return stringArray2;
    }

    private ArrayList<String> getDeviceLangList(String string2) {
        Object object;
        String string3 = string2;
        if (!string2.isEmpty()) {
            string3 = string2.toLowerCase();
        }
        if (SettingLanguageUtil.deviceLangMap.getModelName().equals(string3)) {
            return SettingLanguageUtil.deviceLangMap.getOrderedKeys();
        }
        string2 = new JSONObject();
        try {
            object = new JSONObject(JsonUtil.readJsonFile(2131689474));
            string2 = object;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2.has(string3)) {
            object = new JSONArray();
            try {
                string2 = string2.getJSONArray(string3);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                string2 = object;
            }
            object = new HashMap();
            for (int i = 0; i < string2.length(); ++i) {
                try {
                    JSONObject jSONObject = string2.getJSONObject(i);
                    arrayList.add(jSONObject.getString("key"));
                    object.put(jSONObject.getString("key"), jSONObject.getString("devLang"));
                    continue;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            SettingLanguageUtil.deviceLangMap.setMap(string3, (Map<String, String>)object, arrayList);
        }
        return arrayList;
    }

    private ArrayList<String> getDeviceLangListFor320() {
        Object object;
        if (SettingLanguageUtil.deviceLangMap.getModelName().equals("rider320")) {
            return SettingLanguageUtil.deviceLangMap.getKeys();
        }
        JSONArray jSONArray = new JSONArray();
        try {
            object = new JSONArray(JsonUtil.readJsonFile(2131689475));
            jSONArray = object;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        object = new ArrayList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(i18N.get("Default"), "default");
        ((ArrayList)object).add(i18N.get("Default"));
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                ((ArrayList)object).add(jSONObject.getString("key"));
                hashMap.put(jSONObject.getString("key"), jSONObject.getString("serverStr"));
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        SettingLanguageUtil.deviceLangMap.setMap("rider320", hashMap, (ArrayList<String>)object);
        return object;
    }

    private String[] getRideInfoCommands(Object object) {
        String[] stringArray = null;
        if (object == null) {
            return null;
        }
        String[] stringArray2 = stringArray;
        if (object instanceof Integer) {
            int n = (Integer)object;
            stringArray2 = n != 0 ? (n != 1 ? (n != 2 ? stringArray : new String[]{"get.bike.altloss", "set.bike.altloss"}) : new String[]{"get.bike.altgain", "set.bike.altgain"}) : new String[]{"get.bike.ridetime", "set.bike.ridetime"};
        }
        return stringArray2;
    }

    private String[] getUserCommands(Object object) {
        String[] stringArray = null;
        if (object == null) {
            return null;
        }
        String[] stringArray2 = stringArray;
        if (object instanceof Integer) {
            switch ((Integer)object) {
                default: {
                    stringArray2 = stringArray;
                    break;
                }
                case 6: {
                    stringArray2 = new String[]{"get.user.langId", "set.user.langId"};
                    break;
                }
                case 5: {
                    stringArray2 = new String[]{"get.user.name", "set.user.name"};
                    break;
                }
                case 4: {
                    stringArray2 = new String[]{"get.user.lang", "set.user.langId"};
                    break;
                }
                case 3: {
                    stringArray2 = new String[]{"get.user.gender", "set.user.gender"};
                    break;
                }
                case 2: {
                    stringArray2 = new String[]{"get.user.bday", "set.user.bday"};
                    break;
                }
                case 1: {
                    stringArray2 = new String[]{"get.user.weight", "set.user.weight"};
                    break;
                }
                case 0: {
                    stringArray2 = new String[]{"get.user.height", "set.user.height"};
                }
            }
        }
        return stringArray2;
    }

    private String[] getWifiCommands(Object object) {
        String[] stringArray = null;
        if (object == null) {
            return null;
        }
        String[] stringArray2 = stringArray;
        if (object instanceof Integer) {
            int n = (Integer)object;
            stringArray2 = n != 0 ? (n != 1 ? (n != 2 ? (n != 3 ? (n != 4 ? (n != 6 ? stringArray : new String[]{"get.wifi.hotspot.list", null}) : new String[]{"get.wifi.hotspot", null}) : new String[]{"get.wifi.list", null}) : new String[]{null, "set.wifi.delete"}) : new String[]{null, "set.wifi.add"}) : new String[]{null, "set.wifi.connect"};
        }
        return stringArray2;
    }

    /*
     * Unable to fully structure code
     */
    private void onGetBikeCmdResult(JSONObject var1_1) {
        block17: {
            if (var1_1 == null) {
                return;
            }
            var2_3 = -1;
            try {
                var3_4 = (Integer)var1_1.get("item");
            }
            catch (JSONException var4_5) {
                var4_5.printStackTrace();
                var3_4 = var2_3;
            }
            if (var3_4 < 0) {
                return;
            }
            if (var3_4 == 0) ** GOTO lbl34
            if (var3_4 != 5) break block17;
            try {
                if (var1_1.has("bikeNum")) {
                    var3_4 = var1_1.getInt("bikeNum");
                    if (this.getBikeNameLiveData(var3_4) != null) {
                        if (var1_1.has("name")) {
                            this.getBikeNameLiveData(var3_4).setValue(var1_1.getString("name"));
                        } else {
                            this.getBikeNameLiveData(var3_4).setValue("");
                        }
                    } else {
                        var4_6 = this.TAG;
                        var1_1 = new StringBuilder();
                        var1_1.append("Get bike number bigger than 2(");
                        var1_1.append(var3_4);
                        var1_1.append(")");
                        Log.e((String)var4_6, (String)var1_1.toString());
                    }
                }
                break block17;
lbl34:
                // 1 sources

                var4_7 = new ArrayList();
                var4_7.add(0);
                var4_7.add(0);
                var4_7.add(0);
                if (var1_1.has("spdPriority1")) {
                    var4_7.set(0, var1_1.getInt("spdPriority1"));
                }
                if (var1_1.has("spdPriority2")) {
                    var4_7.set(1, var1_1.getInt("spdPriority2"));
                }
                if (var1_1.has("spdPriority3")) {
                    var4_7.set(2, var1_1.getInt("spdPriority3"));
                }
                if (var1_1.has("bikeNum")) {
                    var3_4 = var1_1.getInt("bikeNum");
                    if (this.getBikeSPDSrcLiveData(var3_4) != null) {
                        this.getBikeSPDSrcLiveData(var3_4).setValue((ArrayList<Integer>)var4_7);
                    } else {
                        var1_1 = this.TAG;
                        var4_7 = new StringBuilder();
                        var4_7.append("Get bike number bigger than 2(");
                        var4_7.append(var3_4);
                        var4_7.append(")");
                        Log.e((String)var1_1, (String)var4_7.toString());
                    }
                }
            }
            catch (JSONException var1_2) {
                var1_2.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void onGetFTPResult(JSONObject var1_1) {
        block11: {
            if (var1_1 == null) {
                return;
            }
            var2_3 = -1;
            try {
                var2_3 = var3_4 = ((Integer)var1_1.get("item")).intValue();
            }
            catch (JSONException var4_5) {
                var4_5.printStackTrace();
            }
            if (var2_3 < 0) {
                return;
            }
            if (var2_3 == 0) ** GOTO lbl31
            if (var2_3 != 1) break block11;
            var4_6 = var1_1.getJSONArray("list");
            var3_4 = this.getMaxFTP();
            var1_1 = new ArrayList();
            var2_3 = 0;
            while (true) {
                if (var2_3 >= var4_6.length()) break;
                var5_8 = (float)var4_6.getDouble(var2_3);
                if (var5_8 >= 0.0f) {
                    var1_1.add(Float.valueOf((float)var3_4 * var5_8 / 100.0f));
                }
                ++var2_3;
            }
            try {
                this.mFTPs.setValue((ArrayList<Float>)var1_1);
                break block11;
lbl31:
                // 1 sources

                var2_3 = var1_1.getInt("baseValue");
                var1_1 = this.mMaxFTP;
                var4_7 = new StringBuilder();
                var4_7.append(var2_3);
                var4_7.append(" ");
                var4_7.append(App.get("watt"));
                var1_1.setValue(var4_7.toString());
            }
            catch (JSONException var1_2) {
                var1_2.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void onGetLTHRResult(JSONObject var1_1) {
        block11: {
            if (var1_1 == null) {
                return;
            }
            var2_3 = -1;
            try {
                var3_4 = (Integer)var1_1.get("item");
            }
            catch (JSONException var4_5) {
                var4_5.printStackTrace();
                var3_4 = var2_3;
            }
            if (var3_4 < 0) {
                return;
            }
            if (var3_4 == 0) ** GOTO lbl32
            if (var3_4 != 1) break block11;
            var4_6 = var1_1.getJSONArray("list");
            var2_3 = this.getMaxLTHR();
            var1_1 = new ArrayList();
            var3_4 = 0;
            while (true) {
                if (var3_4 >= var4_6.length()) break;
                var5_8 = (float)var4_6.getDouble(var3_4);
                if (var5_8 >= 0.0f) {
                    var1_1.add(Float.valueOf((float)var2_3 * var5_8 / 100.0f));
                }
                ++var3_4;
            }
            try {
                this.mLTHRs.setValue((ArrayList<Float>)var1_1);
                break block11;
lbl32:
                // 1 sources

                var3_4 = var1_1.getInt("baseValue");
                var1_1 = this.mMaxLTHR;
                var4_7 = new StringBuilder();
                var4_7.append(var3_4);
                var4_7.append(" ");
                var4_7.append(App.get("bpm"));
                var1_1.setValue(var4_7.toString());
            }
            catch (JSONException var1_2) {
                var1_2.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void onGetMAPResult(JSONObject var1_1) {
        block11: {
            if (var1_1 == null) {
                return;
            }
            var2_3 = -1;
            try {
                var2_3 = var3_4 = ((Integer)var1_1.get("item")).intValue();
            }
            catch (JSONException var4_5) {
                var4_5.printStackTrace();
            }
            if (var2_3 < 0) {
                return;
            }
            if (var2_3 == 0) ** GOTO lbl31
            if (var2_3 != 1) break block11;
            var4_6 = var1_1.getJSONArray("list");
            var3_4 = this.getMaxMAP();
            var1_1 = new ArrayList();
            var2_3 = 0;
            while (true) {
                if (var2_3 >= var4_6.length()) break;
                var5_8 = (float)var4_6.getDouble(var2_3);
                if (var5_8 >= 0.0f) {
                    var1_1.add(Float.valueOf((float)var3_4 * var5_8 / 100.0f));
                }
                ++var2_3;
            }
            try {
                this.mMAPs.setValue((ArrayList<Float>)var1_1);
                break block11;
lbl31:
                // 1 sources

                var2_3 = var1_1.getInt("baseValue");
                var1_1 = this.mMaxMAP;
                var4_7 = new StringBuilder();
                var4_7.append(var2_3);
                var4_7.append(" ");
                var4_7.append(App.get("watt"));
                var1_1.setValue(var4_7.toString());
            }
            catch (JSONException var1_2) {
                var1_2.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void onGetMHRResult(JSONObject var1_1) {
        block11: {
            if (var1_1 == null) {
                return;
            }
            var2_3 = -1;
            try {
                var3_4 = (Integer)var1_1.get("item");
            }
            catch (JSONException var4_5) {
                var4_5.printStackTrace();
                var3_4 = var2_3;
            }
            if (var3_4 < 0) {
                return;
            }
            if (var3_4 == 0) ** GOTO lbl32
            if (var3_4 != 1) break block11;
            var4_6 = var1_1.getJSONArray("list");
            var2_3 = this.getMaxHeartRate();
            var1_1 = new ArrayList();
            var3_4 = 0;
            while (true) {
                if (var3_4 >= var4_6.length()) break;
                var5_8 = (float)var4_6.getDouble(var3_4);
                if (var5_8 >= 0.0f) {
                    var1_1.add(Float.valueOf((float)var2_3 * var5_8 / 100.0f));
                }
                ++var3_4;
            }
            try {
                this.mHeartRates.setValue((ArrayList<Float>)var1_1);
                break block11;
lbl32:
                // 1 sources

                var3_4 = var1_1.getInt("baseValue");
                var1_1 = this.mMaxHeartRate;
                var4_7 = new StringBuilder();
                var4_7.append(Math.abs(var3_4));
                var4_7.append(" ");
                var4_7.append(App.get("bpm"));
                var1_1.setValue(var4_7.toString());
            }
            catch (JSONException var1_2) {
                var1_2.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onGetRideInfoCmdResult(JSONObject object) {
        int n;
        if (object == null) {
            return;
        }
        int n2 = -1;
        try {
            n = (Integer)object.get("item");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            n = n2;
        }
        if (n < 0) {
            return;
        }
        try {
            if (object.has("bikeNum")) {
                object.getInt("bikeNum");
            }
            if (n != 0) {
                if (n != 1) {
                    if (n != 2) {
                        return;
                    }
                    float f = (float)object.getDouble("altMetric");
                    float f2 = (float)object.getDouble("altImperial");
                    new DecimalFormat("#####");
                    if (App.getInstance().isMetricUnit()) {
                        object = this.mRideAltLoss;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append((int)f);
                        stringBuilder.append("");
                        ((MutableLiveData)object).setValue(stringBuilder.toString());
                        return;
                    }
                    MutableLiveData<String> mutableLiveData = this.mRideAltLoss;
                    object = new StringBuilder();
                    ((StringBuilder)object).append((int)f2);
                    ((StringBuilder)object).append("");
                    mutableLiveData.setValue(((StringBuilder)object).toString());
                    return;
                }
                float f = (float)object.getDouble("altMetric");
                float f3 = (float)object.getDouble("altImperial");
                new DecimalFormat("#####");
                if (App.getInstance().isMetricUnit()) {
                    object = this.mRideAltGain;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((int)f);
                    stringBuilder.append("");
                    ((MutableLiveData)object).setValue(stringBuilder.toString());
                    return;
                }
                object = this.mRideAltGain;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((int)f3);
                stringBuilder.append("");
                ((MutableLiveData)object).setValue(stringBuilder.toString());
                return;
            }
            float f = object.has("rideTime") ? (float)object.getDouble("rideTime") : 0.0f;
            object = new DecimalFormat("#####");
            this.mRideTime.setValue(((NumberFormat)object).format(f));
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private void onGetSensorStatusResult(JSONObject object) {
        int n;
        if (object == null) {
            return;
        }
        int n2 = -1;
        try {
            n = object.getInt("subType");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            n = n2;
        }
        if (n != 6) {
            if (n != 7) {
                if (n != 8) {
                    if (n != 10) {
                        String string2 = this.TAG;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Strange sensor status command result : ");
                        ((StringBuilder)object).append(n);
                        Log.d((String)string2, (String)((StringBuilder)object).toString());
                    } else if (object.has("state")) {
                        try {
                            this.mSensorValid.setValue(object.getInt("state"));
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                            this.mSensorValid.setValue(0);
                        }
                    } else {
                        this.mSensorValid.setValue(0);
                    }
                } else if (object.has("wheelSize")) {
                    try {
                        this.mSensorWheelSize.setValue(object.getString("wheelSize"));
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        this.mSensorWheelSize.setValue(null);
                    }
                } else {
                    this.mSensorWheelSize.setValue(null);
                }
            } else if (object.has("list")) {
                try {
                    object = object.getJSONArray("list");
                    this.mSensorScanList.setValue(object.toString());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        } else if (object.has("list")) {
            try {
                object = object.getJSONArray("list");
                this.mSensorPairedList.setValue(object.toString());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void onGetUserCmdResult(JSONObject var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [15 : 340->615)] org.json.JSONException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private void onGetWifiCmdResult(JSONObject var1_1) {
        block13: {
            if (var1_1 == null) {
                return;
            }
            var2_3 = -1;
            try {
                var2_3 = var3_4 = ((Integer)var1_1.get("item")).intValue();
            }
            catch (JSONException var4_5) {
                var4_5.printStackTrace();
            }
            if (var2_3 < 0) {
                return;
            }
            var4_6 = "[]";
            if (var2_3 == 3) ** GOTO lbl32
            if (var2_3 == 4) ** GOTO lbl24
            if (var2_3 != 6) break block13;
            if (var1_1.has("totalAp")) {
                var1_1.getInt("totalAp");
            }
            var5_7 = this.mWifiSpotList;
            if (var1_1.has("list")) {
                var4_6 = var1_1.getJSONArray("list").toString();
            }
            var5_7.setValue(var4_6);
            break block13;
lbl24:
            // 1 sources

            if (var1_1.has("totalAp")) {
                var1_1.getInt("totalAp");
            }
            var5_8 = this.mWifiSpots;
            if (var1_1.has("list")) {
                var4_6 = var1_1.getJSONArray("list").toString();
            }
            var5_8.setValue(var4_6);
            break block13;
lbl32:
            // 1 sources

            if (var1_1.has("totalAp")) {
                var1_1.getInt("totalAp");
            }
            var5_9 = this.mWifiAPConnected;
            var2_3 = var1_1.has("selectId") != false ? var1_1.getInt("selectId") : 0;
            try {
                var5_9.setValue(var2_3);
                var5_9 = this.mWifiList;
                if (var1_1.has("list")) {
                    var4_6 = var1_1.getJSONArray("list").toString();
                }
                var5_9.setValue((Integer)var4_6);
            }
            catch (JSONException var1_2) {
                var1_2.printStackTrace();
            }
        }
    }

    private void startSyncTimer() {
        this.stopSyncTimer();
        this.mHandler.sendEmptyMessageDelayed(1, 10000L);
    }

    private void stopSyncTimer() {
        this.mHandler.removeMessages(1);
    }

    public String GPSIntToString(int n) {
        return GpsMenuUtil.itemId2Desc(n);
    }

    public int GPSOffCmdID() {
        return GpsMenuUtil.getGPSOffCmdID();
    }

    public int GPSStrToInt(String string2) {
        return GpsMenuUtil.itemDesc2Id(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addReq(JSONArray jSONArray) {
        ArrayList<JSONArray> arrayList = this.mReqs;
        synchronized (arrayList) {
            return this.mReqs.add(jSONArray);
        }
    }

    public int autoLapDeviceCmd2OptionSel(int n) {
        String string2;
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    return -1;
                }
                string2 = i18N.get("Location");
            } else {
                string2 = i18N.get("Distance");
            }
        } else {
            string2 = "Off";
        }
        for (n = 0; n < this.AUTO_LAP_BY_OPTIONS.size(); ++n) {
            if (!this.AUTO_LAP_BY_OPTIONS.get(n).equals(string2)) continue;
            return n;
        }
        return -1;
    }

    public int autoLapOptionSel2DeviceCmd(int n) {
        int n2 = 3;
        if (n < 0) {
            return 3;
        }
        int n3 = n;
        if (!this.AUTO_LAP_BY_OPTIONS.contains(0)) {
            n3 = n + 1;
        }
        n = n2;
        if (n3 >= 0) {
            n = n2;
            if (n3 < 3) {
                n = n3;
            }
        }
        return n;
    }

    public int autoLapSelText2DeviceCmd(String string2) {
        for (int i = 0; i < this.AUTO_LAP_BY_OPTIONS.size(); ++i) {
            if (!this.AUTO_LAP_BY_OPTIONS.get(i).equals(string2)) continue;
            return this.autoLapOptionSel2DeviceCmd(i);
        }
        return -1;
    }

    public String backlightIntToString(int n) {
        return BackLightMenuUtil.itemId2Desc(n);
    }

    public int backlightStrToInt(String string2) {
        return BackLightMenuUtil.itemDesc2Id(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearAllSyncReq() {
        ArrayList<JSONArray> arrayList = this.mReqs;
        synchronized (arrayList) {
            this.mWaits.clear();
            this.mReqs.clear();
            return;
        }
    }

    public int findIdxInStringArray(String string2, String[] stringArray) {
        if (string2 != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public byte genAutoLapType(byte by, byte by2) {
        return (byte)(by | by2 << 4);
    }

    public String[] getBacklightOptions() {
        return BackLightMenuUtil.loadBackLightMenuByVersion(this.mBacklightCmdVer).toArray(new String[0]);
    }

    /*
     * Unable to fully structure code
     */
    public JSONArray getBaseCmdJsonArray(int var1_1, int var2_2, Object var3_3) {
        block29: {
            block31: {
                block32: {
                    block33: {
                        block30: {
                            block28: {
                                block23: {
                                    block24: {
                                        block25: {
                                            block26: {
                                                block27: {
                                                    var2_2 = var2_2 != 0 ? (var2_2 != 1 ? -1 : 1) : 0;
                                                    var4_4 = null;
                                                    if (var2_2 < 0) {
                                                        return null;
                                                    }
                                                    if (var1_1 == 23) break block23;
                                                    if (var1_1 == 44) break block24;
                                                    if (var1_1 == 48) break block25;
                                                    if (var1_1 == 30) break block26;
                                                    if (var1_1 == 31) break block27;
                                                    var5_5 = SyncBLEViewModel.CMD_Map.get(var1_1);
                                                    break block28;
                                                }
                                                if (var3_3 == null) ** GOTO lbl-1000
                                                var5_5 = this.getBikeCommands(((BikeCmdExtra)var3_3).type);
                                                break block28;
                                            }
                                            var5_5 = this.getUserCommands(var3_3);
                                            break block28;
                                        }
                                        if (var3_3 != null) {
                                            var5_5 = this.getRideInfoCommands(((BikeCmdExtra)var3_3).type);
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            var5_5 = null;
                                        }
                                        break block28;
                                    }
                                    var5_5 = var3_3 != null && var3_3 instanceof Integer && (Integer)var3_3 == 5 ? new String[]{null, "set.sensor.name"} : SyncBLEViewModel.CMD_Map.get(var1_1);
                                    break block28;
                                }
                                var5_5 = this.getWifiCommands(var3_3);
                            }
                            var6_6 = var4_4;
                            if (var5_5 == null) break block29;
                            if (var5_5[var2_2] != null) break block30;
                            var6_6 = var4_4;
                            break block29;
                        }
                        var4_4 = new JSONArray();
                        var4_4.put(var1_1);
                        var4_4.put((Object)var5_5[var2_2]);
                        if (var1_1 == 27) break block31;
                        if (var1_1 == 28) break block32;
                        if (var1_1 == 40 || var1_1 == 42) break block31;
                        if (var1_1 == 45) break block33;
                        if (var1_1 == 48) ** GOTO lbl-1000
                        if (var1_1 == 53) ** GOTO lbl66
                        switch (var1_1) {
                            default: {
                                var6_6 = var4_4;
                                break;
                            }
                            case 32: 
                            case 33: 
                            case 34: 
                            case 35: {
                                if (var2_2 == 1) {
                                    var4_4.put(var1_1);
                                }
                                var6_6 = var4_4;
                                if (var3_3 != null) {
                                    var3_3 = (Integer)var3_3;
                                    var6_6 = var4_4;
                                    if (var3_3.intValue() >= 0) {
                                        var4_4.put(var3_3);
                                        var6_6 = var4_4;
                                        break;
                                    }
                                }
                                break block29;
                            }
lbl66:
                            // 1 sources

                            var6_6 = var4_4;
                            if (var3_3 != null) {
                                var6_6 = var4_4;
                                if (var3_3 instanceof JSONArray) {
                                    var4_4.put((Object)((JSONArray)var3_3));
                                    var6_6 = var4_4;
                                    break;
                                }
                            }
                            break block29;
                            case 31: lbl-1000:
                            // 2 sources

                            {
                                var6_6 = var4_4;
                                if (var3_3 != null) {
                                    var4_4.put(((BikeCmdExtra)var3_3).number);
                                    var6_6 = var4_4;
                                    break;
                                }
                                break block29;
                            }
                        }
                        break block29;
                    }
                    var6_6 = var4_4;
                    if (var2_2 == 0) {
                        var4_4.put(0);
                        var6_6 = var4_4;
                    }
                    break block29;
                }
                if (var2_2 == 0) {
                    var6_6 = var4_4;
                    if (var3_3 != null) {
                        var3_3 = (Integer)var3_3;
                        var6_6 = var4_4;
                        if (var3_3.intValue() >= 0) {
                            var4_4.put(var3_3);
                            var6_6 = var4_4;
                        }
                    }
                } else {
                    var6_6 = var4_4;
                    if (var2_2 == 1) {
                        var6_6 = var4_4;
                        if (var3_3 != null) {
                            var6_6 = var4_4;
                            if (var3_3 instanceof JSONObject) {
                                var4_4.put((Object)((JSONObject)var3_3));
                                var6_6 = var4_4;
                            }
                        }
                    }
                }
                break block29;
            }
            var6_6 = var4_4;
            if (var3_3 != null) {
                var3_3 = (Integer)var3_3;
                var6_6 = var4_4;
                if (var3_3.intValue() >= 0) {
                    var4_4.put(var3_3);
                    var6_6 = var4_4;
                }
            }
        }
        return var6_6;
    }

    public MutableLiveData<String> getBikeNameLiveData(int n) {
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    return null;
                }
                return this.mBike3Name;
            }
            return this.mBike2Name;
        }
        return this.mBike1Name;
    }

    public MutableLiveData<ArrayList<Integer>> getBikeSPDSrcLiveData(int n) {
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    return null;
                }
                return this.mBike3SPDSrcs;
            }
            return this.mBike2SPDSrcs;
        }
        return this.mBike1SPDSrcs;
    }

    protected String getCustomDeviceLangMapKeyByValue(String string2) {
        return null;
    }

    public ArrayList<String> getDeviceLangListByModelName(String string2) {
        if (string2.toLowerCase().equals("rider320")) {
            return this.getDeviceLangListFor320();
        }
        return this.getDeviceLangList(string2);
    }

    public ArrayList<Float> getFTPList() {
        return (ArrayList)this.mFTPs.getValue();
    }

    public String[] getGPSOptions(boolean bl) {
        return GpsMenuUtil.loadGpsMenuByVersion(this.mGPSCmdVer, bl).toArray(new String[0]);
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public ArrayList<Float> getHeartRateList() {
        return (ArrayList)this.mHeartRates.getValue();
    }

    public ArrayList<Float> getLTHRList() {
        return (ArrayList)this.mLTHRs.getValue();
    }

    public ArrayList<Float> getMAPList() {
        return (ArrayList)this.mMAPs.getValue();
    }

    public int getMaxFTP() {
        return this.trimInteger((String)this.mMaxFTP.getValue());
    }

    public String getMaxFTPText() {
        return (String)this.mMaxFTP.getValue();
    }

    public int getMaxHeartRate() {
        return this.trimInteger((String)this.mMaxHeartRate.getValue());
    }

    public String getMaxHeartRateText() {
        return (String)this.mMaxHeartRate.getValue();
    }

    public int getMaxLTHR() {
        return this.trimInteger((String)this.mMaxLTHR.getValue());
    }

    public String getMaxLTHRText() {
        return (String)this.mMaxLTHR.getValue();
    }

    public int getMaxMAP() {
        return this.trimInteger((String)this.mMaxMAP.getValue());
    }

    public String getMaxMAPText() {
        return (String)this.mMaxMAP.getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasRunningReqs() {
        ArrayList<JSONArray> arrayList = this.mReqs;
        synchronized (arrayList) {
            if (this.mReqs.size() > 0) return true;
            if (this.mWaits.size() <= 0) return false;
            return true;
        }
    }

    protected IntentFilter makeGattUpdateIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.brytonsport.active.SERVICE_SETTING_COMMAND_RETURN");
        intentFilter.addAction("com.brytonsport.active.ACTION_DISCONNECTED_PERIPHERAL");
        return intentFilter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onBLEReceive(Context context, Intent object) {
        int n;
        String string2 = object.getAction();
        boolean bl = true;
        if (string2 != null && string2.equals("com.brytonsport.active.SERVICE_SETTING_COMMAND_RETURN")) {
            object = object.getStringExtra("com.brytonsport.active.SERVICE_STRING_EXTRA_DATA");
            try {
                context = new JSONObject((String)object);
                n = context.getInt("cmd");
                object = this.mReqs;
                synchronized (object) {
                    if (this.mWaits.size() > 0) {
                    }
                    break block14;
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                return;
            }
        }
        if (string2 == null) return;
        if (!string2.equals("com.brytonsport.active.ACTION_DISCONNECTED_PERIPHERAL")) return;
        object = ((ActivityManager.RunningTaskInfo)((ActivityManager)context.getSystemService((String)"activity")).getRunningTasks((int)1).get((int)0)).topActivity;
        if (object.getClassName().equals(SettingPairNewDeviceActivity.class.getCanonicalName())) return;
        if (object.getClassName().equals(SettingManageDeviceActivity.class.getCanonicalName())) return;
        if (object.getClassName().equals(ProfileActivity.class.getCanonicalName())) return;
        if (object.getClassName().equals(ProfileAboutMeActivity.class.getCanonicalName())) {
            return;
        }
        object = new Intent(context, SettingActivity.class);
        object.setFlags(0x10008000);
        context.startActivity(object);
        return;
        {
            block14: {
                for (int i = 0; i < this.mWaits.size(); ++i) {
                    if (this.mWaits.get(i) != n) continue;
                    this.mWaits.remove(i);
                    this.mReqDone.postValue(n);
                    break;
                }
                if (this.mThrSync == null && this.mWaits.size() <= 0) {
                    this.stopSyncTimer();
                    this.mIsLoading.setValue(false);
                }
            }
            if (context.has("ack")) {
                if (context.getInt("ack") != 10) {
                    bl = false;
                }
                this.onSetSettingResult(n, bl);
            } else {
                this.onGetSettingResult(n, (JSONObject)context);
            }
            return;
        }
    }

    protected void onDeviceInfo(int n, int n2) {
    }

    /*
     * Exception decompiling
     */
    protected void onGetSettingResult(int var1_1, JSONObject var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 22[TRYBLOCK] [47 : 1283->1317)] org.json.JSONException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void onPackageInfoUpdated(boolean bl) {
    }

    protected void onSetSettingResult(int n, boolean bl) {
        block44: {
            block39: {
                block40: {
                    block41: {
                        block42: {
                            block43: {
                                if (n == 20) break block39;
                                if (n == 23) break block40;
                                if (n == 40) break block41;
                                if (n == 48) break block42;
                                if (n == 53) break block43;
                                switch (n) {
                                    default: {
                                        switch (n) {
                                            default: {
                                                break;
                                            }
                                            case 45: {
                                                if (!bl) {
                                                    Log.e((String)this.TAG, (String)"Failed to set bike ODO");
                                                    break;
                                                }
                                                break block44;
                                            }
                                            case 44: {
                                                if (!bl) {
                                                    Log.e((String)this.TAG, (String)"Failed on user set sensor status command");
                                                    break;
                                                }
                                                break block44;
                                            }
                                            case 43: {
                                                if (!bl) {
                                                    Log.e((String)this.TAG, (String)"Failed on user get sensor list");
                                                    break;
                                                }
                                                break block44;
                                            }
                                            case 42: {
                                                if (!bl) {
                                                    Log.e((String)this.TAG, (String)"Failed to set bike trip");
                                                    break;
                                                }
                                                break block44;
                                            }
                                        }
                                        break block44;
                                    }
                                    case 35: {
                                        if (!bl) {
                                            Log.e((String)this.TAG, (String)"Failed to set LTHR");
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 34: {
                                        if (!bl) {
                                            Log.e((String)this.TAG, (String)"Failed to set MHR");
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 33: {
                                        if (!bl) {
                                            Log.e((String)this.TAG, (String)"Failed to set FTP");
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 32: {
                                        if (!bl) {
                                            Log.e((String)this.TAG, (String)"Failed to set MAP");
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 31: {
                                        if (!bl) {
                                            Log.e((String)this.TAG, (String)"Failed to set bike cmd");
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 30: {
                                        if (!bl) {
                                            Log.e((String)this.TAG, (String)"Failed on user set command");
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 29: {
                                        if (!bl) {
                                            Log.e((String)this.TAG, (String)"Failed to set unit");
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 28: {
                                        if (!bl) {
                                            Log.e((String)this.TAG, (String)"Failed to set Auto-Lap");
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 27: {
                                        if (!bl) {
                                            this.mIsAutoPause.setValue(Boolean.FALSE.equals(this.mIsAutoPause.getValue()));
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 26: {
                                        if (!bl) {
                                            this.mIsSound.setValue(Boolean.FALSE.equals(this.mIsSound.getValue()));
                                            break;
                                        }
                                        break block44;
                                    }
                                    case 25: {
                                        if (!bl) {
                                            this.mIsKeyTone.setValue(Boolean.FALSE.equals(this.mIsKeyTone.getValue()));
                                            break;
                                        }
                                        break block44;
                                    }
                                }
                                break block44;
                            }
                            if (!bl) {
                                Log.e((String)this.TAG, (String)"Failed to set update package info");
                            }
                            this.onPackageInfoUpdated(bl);
                            break block44;
                        }
                        if (!bl) {
                            Log.e((String)this.TAG, (String)"Failed to set bike ride info");
                        }
                        break block44;
                    }
                    if (!bl) {
                        Log.e((String)this.TAG, (String)"Failed to set GPS");
                    }
                    break block44;
                }
                if (!bl) {
                    Log.e((String)this.TAG, (String)"Failed on user set wifi command");
                }
                break block44;
            }
            if (!bl) {
                Log.e((String)this.TAG, (String)"Failed to set backlight");
            }
        }
    }

    protected void registerBLESyncReceiver(Context context) {
        context.registerReceiver(this.mGattUpdateReceiver, this.makeGattUpdateIntentFilter());
    }

    public void startSyncSettings() {
        this.startSyncSettings(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startSyncSettings(boolean bl) {
        ArrayList<JSONArray> arrayList = this.mReqs;
        synchronized (arrayList) {
            if (this.mThrSync == null) {
                Thread thread;
                this.mWaits.clear();
                Runnable runnable = new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        ArrayList arrayList;
                        while (!SyncBLEViewModel.this.isAskStopSync) {
                            ArrayList arrayList2 = SyncBLEViewModel.this.mReqs;
                            synchronized (arrayList2) {
                                if (SyncBLEViewModel.this.mWaits.size() <= 0 && SyncBLEViewModel.this.mReqs.size() > 0 && (arrayList = (JSONArray)SyncBLEViewModel.this.mReqs.remove(0)) != null) {
                                    int n = (Integer)arrayList.remove(0);
                                    if (n >= 0) {
                                        SyncBLEViewModel.this.mWaits.add(n);
                                    }
                                    SyncBLEViewModel.this.bleRepository.passSettingCommand((JSONArray)arrayList);
                                    if (n < 0) {
                                        SyncBLEViewModel.this.mExtraCmdRun.postValue(n);
                                    }
                                }
                                if (SyncBLEViewModel.this.mReqs.size() <= 0) {
                                    SyncBLEViewModel.access$402(SyncBLEViewModel.this, null);
                                    break;
                                }
                            }
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        arrayList = SyncBLEViewModel.this.mReqs;
                        synchronized (arrayList) {
                            SyncBLEViewModel.access$402(SyncBLEViewModel.this, null);
                            return;
                        }
                    }
                };
                this.mThrSync = thread = new Thread(runnable);
                thread.start();
            }
            this.mIsLoading.setValue(bl);
            this.startSyncTimer();
            return;
        }
    }

    public void stopSyncTask() {
        this.isAskStopSync = true;
        while (this.mThrSync != null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.isAskStopSync = false;
    }

    public String toBirthday(int n, int n2, int n3) {
        CharSequence charSequence;
        CharSequence charSequence2;
        if (++n2 < 10) {
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append("0");
            ((StringBuilder)charSequence2).append(n2);
            charSequence2 = ((StringBuilder)charSequence2).toString();
        } else {
            charSequence2 = String.valueOf(n2);
        }
        if (n3 < 10) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("0");
            ((StringBuilder)charSequence).append(n3);
            charSequence = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = String.valueOf(n3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append("/");
        stringBuilder.append((String)charSequence2);
        stringBuilder.append("/");
        stringBuilder.append((String)charSequence);
        return stringBuilder.toString();
    }

    public int trimInteger(String string2) {
        int n;
        int n2 = -1;
        if (string2 == null) {
            return -1;
        }
        try {
            n = Integer.parseInt(string2.split(" ")[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = n2;
        }
        return n;
    }

    protected void unregisterBLESyncReceiver(Context context) {
        context.unregisterReceiver(this.mGattUpdateReceiver);
    }

    public static class BikeCmdExtra {
        int number;
        int type;

        public BikeCmdExtra(int n, int n2) {
            this.type = n;
            this.number = n2;
        }
    }
}

