/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.bleplugin;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.util.Log;
import com.brytonsport.active.bleplugin.BleCommandSetting;
import com.brytonsport.active.bleplugin.NewSettingUtil;
import com.brytonsport.active.bleplugin.ParserUtil;
import com.brytonsport.active.bleplugin.SampleGattAttributes;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.WriteType;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.PriorityBlockingQueue;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommandBbcpQueueUtil {
    private static long CMD_CHECK_DEVICE_BUSY_TIMEOUT = 500L;
    private static final String TAG = "CommandBbcpQueueUtil";
    public Map<String, Object> abortMap = new HashMap<String, Object>();
    private boolean bleProcessing = false;
    private PriorityBlockingQueue<BleCommandSetting> commandQueue;
    public boolean isRunOneCmdFinish = true;
    public boolean isRunningSettingLongCmd = false;
    BluetoothGatt mBluetoothGatt;
    Context mContext;
    BluetoothPeripheral mPeripheral;
    NewSettingUtil newSettingUtil;
    public String nowRunCmdAction = "";
    public int nowRunCmdId = 0;

    public CommandBbcpQueueUtil(Context context, BluetoothPeripheral bluetoothPeripheral) {
        this.mContext = context;
        this.mPeripheral = bluetoothPeripheral;
        this.commandQueue = new PriorityBlockingQueue();
    }

    private int calCmdPriorityByType(int n, int n2) {
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 4) {
                    if (n2 == 5) {
                        ++n;
                    }
                } else {
                    n += 0;
                }
            } else {
                n += 3;
            }
        } else {
            n += 2;
        }
        return n;
    }

    private int decideCmdPriority(int n, int n2) {
        n = n2 == 0 ? 0 : (n != 20 ? (n != 37 ? (n != 39 ? (n != 41 ? (n != 47 ? (n != 52 ? (n != 57 ? (n != 63 ? (n != 65 ? (n != 71 ? (n != 23 ? (n != 24 ? (n != 29 ? (n != 30 ? this.calCmdPriorityByType(300, n2) : this.calCmdPriorityByType(180, n2)) : this.calCmdPriorityByType(180, n2)) : this.calCmdPriorityByType(280, n2)) : this.calCmdPriorityByType(154, n2)) : this.calCmdPriorityByType(120, n2)) : this.calCmdPriorityByType(160, n2)) : this.calCmdPriorityByType(260, n2)) : this.calCmdPriorityByType(190, n2)) : this.calCmdPriorityByType(110, n2)) : this.calCmdPriorityByType(100, n2)) : this.calCmdPriorityByType(250, n2)) : this.calCmdPriorityByType(170, n2)) : this.calCmdPriorityByType(200, n2)) : this.calCmdPriorityByType(150, n2));
        return n;
    }

    private BluetoothGattCharacteristic findNotifyCharacteristic(BluetoothGattService bluetoothGattService, UUID uUID) {
        BluetoothGattCharacteristic bluetoothGattCharacteristic;
        BluetoothGattCharacteristic bluetoothGattCharacteristic2 = null;
        if (bluetoothGattService == null) {
            Log.d((String)TAG, (String)"BluetoothGattService is null");
            return null;
        }
        Object object = bluetoothGattService.getCharacteristics();
        Iterator iterator = object.iterator();
        do {
            bluetoothGattCharacteristic = bluetoothGattCharacteristic2;
        } while (iterator.hasNext() && (((bluetoothGattCharacteristic = (BluetoothGattCharacteristic)iterator.next()).getProperties() & 0x10) == 0 || !uUID.equals(bluetoothGattCharacteristic.getUuid())));
        if (bluetoothGattCharacteristic != null) {
            return bluetoothGattCharacteristic;
        }
        object = object.iterator();
        do {
            bluetoothGattCharacteristic2 = bluetoothGattCharacteristic;
        } while (object.hasNext() && (((bluetoothGattCharacteristic2 = (BluetoothGattCharacteristic)object.next()).getProperties() & 0x20) == 0 || !uUID.equals(bluetoothGattCharacteristic2.getUuid())));
        bluetoothGattCharacteristic = bluetoothGattCharacteristic2;
        if (bluetoothGattCharacteristic2 == null) {
            bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(uUID);
        }
        return bluetoothGattCharacteristic;
    }

    private BluetoothGattCharacteristic findWritableCharacteristic(BluetoothGattService bluetoothGattService, UUID uUID, int n) {
        BluetoothGattCharacteristic bluetoothGattCharacteristic2;
        block2: {
            n = n == 1 ? 4 : 8;
            for (BluetoothGattCharacteristic bluetoothGattCharacteristic2 : bluetoothGattService.getCharacteristics()) {
                if ((bluetoothGattCharacteristic2.getProperties() & n) == 0 || !uUID.equals(bluetoothGattCharacteristic2.getUuid())) continue;
                break block2;
            }
            bluetoothGattCharacteristic2 = null;
        }
        BluetoothGattCharacteristic bluetoothGattCharacteristic3 = bluetoothGattCharacteristic2;
        if (bluetoothGattCharacteristic2 == null) {
            bluetoothGattCharacteristic3 = bluetoothGattService.getCharacteristic(uUID);
        }
        return bluetoothGattCharacteristic3;
    }

    private boolean isCommandRepeat(BleCommandSetting bleCommandSetting) {
        boolean bl;
        if (bleCommandSetting.getCharacteristicUUID().equals(SampleGattAttributes.SETTING_CHANNEL_UUID)) {
            for (BleCommandSetting bleCommandSetting2 : this.commandQueue) {
                if (bleCommandSetting2.getPriority() != bleCommandSetting.getPriority() || bleCommandSetting2.getCmdId() != bleCommandSetting.getCmdId() || bleCommandSetting2.getCmdType() != bleCommandSetting.getCmdType()) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isDeviceBusy() {
        boolean bl;
        block3: {
            try {
                bl = (Boolean)this.readField(this.mBluetoothGatt, "mDeviceBusy");
                break block3;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            bl = false;
        }
        return bl;
    }

    private Object readField(Object object, String object2) throws IllegalAccessException, NoSuchFieldException {
        object2 = object.getClass().getDeclaredField((String)object2);
        ((Field)object2).setAccessible(true);
        return ((Field)object2).get(object);
    }

    private void registerNotifyCallback(UUID uUID, UUID uUID2) {
        boolean bl;
        block10: {
            block9: {
                Object object = this.mBluetoothGatt;
                if (object == null) {
                    return;
                }
                object = this.findNotifyCharacteristic(object.getService(uUID), uUID2);
                bl = true;
                if (object == null || !this.mBluetoothGatt.setCharacteristicNotification((BluetoothGattCharacteristic)object, true) || (uUID = object.getDescriptor(SampleGattAttributes.CLIENT_CHARACTERISTIC_CONFIGURATION_UUID)) == null) break block9;
                if ((object.getProperties() & 0x10) != 0) {
                    uUID.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                } else if ((object.getProperties() & 0x20) != 0) {
                    uUID.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
                } else {
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Characteristic ");
                    ((StringBuilder)object).append(uUID2);
                    ((StringBuilder)object).append(" does not have NOTIFY or INDICATE property set");
                    Log.w((String)string2, (String)((StringBuilder)object).toString());
                }
                if (this.mBluetoothGatt.writeDescriptor((BluetoothGattDescriptor)uUID)) break block10;
            }
            bl = false;
        }
        if (!bl) {
            this.commandCompleted();
        }
    }

    private void removeNotifyCallback(UUID uUID, UUID uUID2) {
        BluetoothGatt bluetoothGatt = this.mBluetoothGatt;
        if (bluetoothGatt == null) {
            return;
        }
        if ((uUID = this.findNotifyCharacteristic(bluetoothGatt.getService(uUID), uUID2)) != null && this.mBluetoothGatt.setCharacteristicNotification((BluetoothGattCharacteristic)uUID, false)) {
            uUID.getDescriptor(SampleGattAttributes.CLIENT_CHARACTERISTIC_CONFIGURATION_UUID);
        }
        this.commandCompleted();
    }

    private void writeCharacteristic(UUID uUID, UUID uUID2, byte[] byArray, int n) {
        boolean bl = n == 2 ? this.mPeripheral.writeCharacteristic(uUID, uUID2, byArray, WriteType.WITH_RESPONSE) : this.mPeripheral.writeCharacteristic(uUID, uUID2, byArray, WriteType.WITHOUT_RESPONSE);
        if (!bl) {
            this.commandCompleted();
        }
    }

    public void commandCompleted() {
        this.nowRunCmdId = 0;
        this.bleProcessing = false;
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.processCommands();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processCommands() {
        int n;
        CharSequence charSequence;
        CharSequence charSequence2;
        if (this.bleProcessing) {
            return;
        }
        BleCommandSetting bleCommandSetting = this.commandQueue.peek();
        boolean bl = SampleGattAttributes.commandQueueUtilLog;
        int n2 = 0;
        CharSequence charSequence3 = "";
        if (bl && bleCommandSetting != null) {
            byte[] byArray = bleCommandSetting.getData();
            charSequence = charSequence2 = "";
            if (byArray != null) {
                n = 0;
                while (true) {
                    charSequence = charSequence2;
                    if (n >= bleCommandSetting.getData().length) break;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append((String)charSequence2);
                    ((StringBuilder)charSequence).append(ParserUtil.getUnsignedByte(bleCommandSetting.getData()[n]));
                    ((StringBuilder)charSequence).append(", ");
                    charSequence2 = ((StringBuilder)charSequence).toString();
                    ++n;
                }
            }
            try {
                String string2 = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("processCommands: \u73fe\u5728\u5f9equeue \u53d6\u51fa cmdId = ");
                stringBuilder.append(bleCommandSetting.getCmdId());
                if (bleCommandSetting.getCmdAction() != null) {
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append(", CmdAction = ");
                    ((StringBuilder)charSequence2).append(bleCommandSetting.getCmdAction());
                    charSequence2 = ((StringBuilder)charSequence2).toString();
                } else {
                    charSequence2 = "";
                }
                stringBuilder.append((String)charSequence2);
                if (bleCommandSetting.getParamArray() != null) {
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append(", ParamArray = ");
                    ((StringBuilder)charSequence2).append(bleCommandSetting.getParamArray().toString());
                    charSequence2 = ((StringBuilder)charSequence2).toString();
                } else {
                    charSequence2 = "";
                }
                stringBuilder.append((String)charSequence2);
                if (bleCommandSetting.getData() != null) {
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append(", raw = ");
                    ((StringBuilder)charSequence2).append((String)charSequence);
                    charSequence2 = ((StringBuilder)charSequence2).toString();
                } else {
                    charSequence2 = "";
                }
                stringBuilder.append((String)charSequence2);
                Log.d((String)string2, (String)stringBuilder.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bleCommandSetting == null) {
            this.abortMap.clear();
            return;
        }
        if (bleCommandSetting.getType() == 2) {
            this.bleProcessing = true;
            if (!bleCommandSetting.getCharacteristicUUID().equals(SampleGattAttributes.SETTING_CHANNEL_UUID)) {
                this.commandQueue.remove();
                this.writeCharacteristic(bleCommandSetting.getServiceUUID(), bleCommandSetting.getCharacteristicUUID(), bleCommandSetting.getData(), bleCommandSetting.getType());
                return;
            }
            if (this.isRunningSettingLongCmd) {
                if (bleCommandSetting.getCmdType() == 0) {
                    this.commandQueue.remove();
                    this.writeCharacteristic(bleCommandSetting.getServiceUUID(), bleCommandSetting.getCharacteristicUUID(), bleCommandSetting.getData(), bleCommandSetting.getType());
                    return;
                }
                this.bleProcessing = false;
                return;
            }
            if (bleCommandSetting.isFromDevice()) {
                charSequence = TAG;
                Log.d((String)charSequence, (String)"queue) \u8655\u7406 command \u662f device \u4f86\u7684");
                if (this.isRunOneCmdFinish) {
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append("command \u662f device \u4f86\u7684 \u73fe\u5728\u7684 nowRunCmdAction -> ");
                    ((StringBuilder)charSequence2).append(this.nowRunCmdAction);
                    Log.d((String)charSequence, (String)((StringBuilder)charSequence2).toString());
                    try {
                        bl = this.nowRunCmdAction.split("-")[1].equals("4");
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (!this.nowRunCmdAction.equals("") && bl) {
                        charSequence = TAG;
                        charSequence2 = new StringBuilder();
                        ((StringBuilder)charSequence2).append("queue) \u6aa2\u67e5  \u6709\u6b63\u5728\u57f7\u884c\u7684 command -> ");
                        ((StringBuilder)charSequence2).append(this.nowRunCmdAction);
                        ((StringBuilder)charSequence2).append(", \u6b32\u57f7\u884c command \u662f device \u4f86\u7684-> ");
                        ((StringBuilder)charSequence2).append(bleCommandSetting.getCmdAction());
                        Log.d((String)charSequence, (String)((StringBuilder)charSequence2).toString());
                        this.bleProcessing = false;
                        return;
                    }
                }
                this.commandQueue.remove();
                if (bleCommandSetting.getCmdId() == 24) {
                    if (SampleGattAttributes.settingLogFromDevice) {
                        Log.d((String)TAG, (String)"queue) \u986f\u793a -> showDeviceBattery");
                    }
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> CMD-24 checkDeviceCapability");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), "set.battery", bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 39) {
                    if (SampleGattAttributes.settingLogFromDevice) {
                        Log.d((String)TAG, (String)"queue) \u986f\u793a -> show DEV_NOTIFY");
                    }
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), "set.dev.notify", bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 52) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> show BT_HANDSHAKE_PAYLOAD");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), "set.handshake_payload", bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 23) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> show CMD_WIFI");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 32) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> show CMD_MAP");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 63) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> show CMD_DEV_INFORM");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 31) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> show CMD_BIKE");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 37) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> show CMD_SERVEREE");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 59) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> show CMD_SPEECH_TO_TEXT");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 60) {
                    charSequence = TAG;
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append("queue) \u8655\u7406 command \u662f device \u4f86\u7684 ->  CMD_PLAN_TRIP action = ");
                    ((StringBuilder)charSequence2).append(bleCommandSetting.getCmdAction());
                    Log.d((String)charSequence, (String)((StringBuilder)charSequence2).toString());
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 68) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> CMD_SURPRISE_ME_DISTANCE");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 69) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> CMD_SURPRISE_ME_SELECT_ID");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 73) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> CMD_LIVE_TRACKING_INFO");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 75) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> CMD_GROUP_RIDE_INFO");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 76) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> CMD_GROUP_RIDE_MSG_ID");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else if (bleCommandSetting.getCmdId() == 41) {
                    Log.d((String)TAG, (String)"queue) \u986f\u793a -> CMD_LOG_STATE");
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                } else {
                    charSequence = TAG;
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append("processCommands: \u6709\u5176\u4ed6\u662f\u6a5f\u5668\u4e3b\u52d5\u6253\u4f86\u7684CMD = ");
                    ((StringBuilder)charSequence2).append(bleCommandSetting.getCmdId());
                    ((StringBuilder)charSequence2).append(", action = ");
                    ((StringBuilder)charSequence2).append(bleCommandSetting.getCmdAction());
                    Log.e((String)charSequence, (String)((StringBuilder)charSequence2).toString());
                }
                this.commandCompleted();
                return;
            }
            if (bleCommandSetting.getData() != null) {
                if (this.isRunOneCmdFinish && bleCommandSetting.getCmdType() == 4) {
                    charSequence2 = TAG;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("action \u73fe\u5728\u7684 nowRunCmdAction -> ");
                    ((StringBuilder)charSequence).append(this.nowRunCmdAction);
                    Log.d((String)charSequence2, (String)((StringBuilder)charSequence).toString());
                    if (!this.nowRunCmdAction.equals("")) {
                        charSequence = this.nowRunCmdAction;
                        charSequence3 = new StringBuilder();
                        ((StringBuilder)charSequence3).append(String.valueOf(bleCommandSetting.getCmdId()));
                        ((StringBuilder)charSequence3).append("-");
                        ((StringBuilder)charSequence3).append(4);
                        if (!((String)charSequence).equals(((StringBuilder)charSequence3).toString())) {
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append("queue) \u6aa2\u67e5  \u6709\u6b63\u5728\u57f7\u884c\u7684 command -> ");
                            ((StringBuilder)charSequence).append(this.nowRunCmdAction);
                            ((StringBuilder)charSequence).append(", \u6b32\u57f7\u884c -> ");
                            ((StringBuilder)charSequence).append(bleCommandSetting.getCmdAction());
                            Log.d((String)charSequence2, (String)((StringBuilder)charSequence).toString());
                            this.bleProcessing = false;
                            return;
                        }
                    }
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append(String.valueOf(bleCommandSetting.getCmdId()));
                    ((StringBuilder)charSequence).append("-");
                    ((StringBuilder)charSequence).append(4);
                    this.nowRunCmdAction = ((StringBuilder)charSequence).toString();
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("queue) \u73fe\u5728\u57f7\u884c (\u6709data) command -> ");
                    ((StringBuilder)charSequence).append(this.nowRunCmdAction);
                    ((StringBuilder)charSequence).append(", isFromDevice = ");
                    ((StringBuilder)charSequence).append(bleCommandSetting.isFromDevice());
                    Log.d((String)charSequence2, (String)((StringBuilder)charSequence).toString());
                }
                this.commandQueue.remove();
                this.writeCharacteristic(bleCommandSetting.getServiceUUID(), bleCommandSetting.getCharacteristicUUID(), bleCommandSetting.getData(), bleCommandSetting.getType());
                return;
            }
            if (bleCommandSetting.getCmdType() != 0 && bleCommandSetting.getCmdType() != 4) {
                if (this.isRunOneCmdFinish) {
                    charSequence = TAG;
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append("action \u73fe\u5728\u7684 nowRunCmdAction -> ");
                    ((StringBuilder)charSequence2).append(this.nowRunCmdAction);
                    Log.d((String)charSequence, (String)((StringBuilder)charSequence2).toString());
                    try {
                        bl = this.nowRunCmdAction.split("-")[1].equals("4");
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (!this.nowRunCmdAction.equals("") && bl) {
                        charSequence = TAG;
                        charSequence2 = new StringBuilder();
                        ((StringBuilder)charSequence2).append("queue) \u6aa2\u67e5  \u6709\u6b63\u5728\u57f7\u884c\u7684 command -> ");
                        ((StringBuilder)charSequence2).append(this.nowRunCmdAction);
                        ((StringBuilder)charSequence2).append(", \u6b32\u57f7\u884c -> ");
                        ((StringBuilder)charSequence2).append(bleCommandSetting.getCmdAction());
                        Log.d((String)charSequence, (String)((StringBuilder)charSequence2).toString());
                        this.bleProcessing = false;
                        return;
                    }
                }
                try {
                    this.commandQueue.remove();
                    this.newSettingUtil.checkDeviceCapability(bleCommandSetting.getCmdId(), bleCommandSetting.getCmdAction(), bleCommandSetting.getParamArray(), bleCommandSetting.isFromDevice(), bleCommandSetting.getData());
                }
                catch (NoSuchElementException noSuchElementException) {
                    noSuchElementException.printStackTrace();
                }
                this.commandCompleted();
                return;
            }
            if (SampleGattAttributes.commandQueueUtilLog) {
                charSequence2 = charSequence3;
                for (n = n2; n < bleCommandSetting.getData().length; ++n) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append((String)charSequence2);
                    ((StringBuilder)charSequence).append(ParserUtil.getUnsignedByte(bleCommandSetting.getData()[n]));
                    ((StringBuilder)charSequence).append(", ");
                    charSequence2 = ((StringBuilder)charSequence).toString();
                }
                charSequence3 = TAG;
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("queue) \u5176\u9918\u72c0\u6cc1\u57f7\u884c command -> ");
                ((StringBuilder)charSequence).append((String)charSequence2);
                ((StringBuilder)charSequence).append("isFromDevice = ");
                ((StringBuilder)charSequence).append(bleCommandSetting.isFromDevice());
                Log.d((String)charSequence3, (String)((StringBuilder)charSequence).toString());
            }
            this.commandQueue.remove();
            this.writeCharacteristic(bleCommandSetting.getServiceUUID(), bleCommandSetting.getCharacteristicUUID(), bleCommandSetting.getData(), bleCommandSetting.getType());
            return;
        }
        if (bleCommandSetting.getType() == 1) {
            this.bleProcessing = true;
            this.commandQueue.remove();
            this.writeCharacteristic(bleCommandSetting.getServiceUUID(), bleCommandSetting.getCharacteristicUUID(), bleCommandSetting.getData(), bleCommandSetting.getType());
            return;
        }
        if (bleCommandSetting.getType() == BleCommandSetting.REGISTER_NOTIFY) {
            charSequence = TAG;
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append("Register Notify ");
            ((StringBuilder)charSequence2).append(bleCommandSetting.getCharacteristicUUID());
            Log.d((String)charSequence, (String)((StringBuilder)charSequence2).toString());
            this.bleProcessing = true;
            this.commandQueue.remove();
            this.registerNotifyCallback(bleCommandSetting.getServiceUUID(), bleCommandSetting.getCharacteristicUUID());
            return;
        }
        if (bleCommandSetting.getType() == BleCommandSetting.REMOVE_NOTIFY) {
            charSequence2 = TAG;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Remove Notify ");
            ((StringBuilder)charSequence).append(bleCommandSetting.getCharacteristicUUID());
            Log.d((String)charSequence2, (String)((StringBuilder)charSequence).toString());
            this.bleProcessing = true;
            this.commandQueue.remove();
            this.removeNotifyCallback(bleCommandSetting.getServiceUUID(), bleCommandSetting.getCharacteristicUUID());
            return;
        }
        charSequence2 = new StringBuilder();
        ((StringBuilder)charSequence2).append("Unexpected BLE Command type ");
        ((StringBuilder)charSequence2).append(bleCommandSetting.getType());
        throw new RuntimeException(((StringBuilder)charSequence2).toString());
    }

    public void putInAbortMap(String string2, JSONObject object) {
        PriorityBlockingQueue<BleCommandSetting> priorityBlockingQueue = this.commandQueue;
        if (priorityBlockingQueue != null && !priorityBlockingQueue.isEmpty()) {
            this.abortMap.put(string2, object);
            priorityBlockingQueue = TAG;
            object = new StringBuilder();
            ((StringBuilder)object).append("putInAbortMap: \u52a0\u5165\u9019\u500b abort -> ");
            ((StringBuilder)object).append(string2);
            Log.d((String)((Object)priorityBlockingQueue), (String)((StringBuilder)object).toString());
        } else {
            object = TAG;
            priorityBlockingQueue = new StringBuilder();
            ((StringBuilder)((Object)priorityBlockingQueue)).append("putInAbortMap: commandQueue \u7a7a\u7684\uff0c\u4e0d\u9700\u8981\u52a0\u5165\u9019\u500b abort -> ");
            ((StringBuilder)((Object)priorityBlockingQueue)).append(string2);
            Log.d((String)object, (String)((StringBuilder)((Object)priorityBlockingQueue)).toString());
        }
    }

    public void queueCleanup() {
        this.bleProcessing = false;
        while (this.commandQueue.poll() != null) {
        }
    }

    public void queueCommand(BleCommandSetting object) {
        int n;
        Object object2;
        Object object3;
        boolean bl = this.isCommandRepeat((BleCommandSetting)object);
        if (((BleCommandSetting)object).getType() == BleCommandSetting.REGISTER_NOTIFY) {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("REGISTER_NOTIFY: ");
            ((StringBuilder)object3).append(((BleCommandSetting)object).getCharacteristicUUID());
            object3 = ((StringBuilder)object3).toString();
        } else if (((BleCommandSetting)object).getType() == BleCommandSetting.REMOVE_NOTIFY) {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("REMOVE_NOTIFY: ");
            ((StringBuilder)object3).append(((BleCommandSetting)object).getCharacteristicUUID());
            object3 = ((StringBuilder)object3).toString();
        } else if (((BleCommandSetting)object).getData() != null) {
            object2 = ((BleCommandSetting)object).isFromDevice() ? "\u5f9edevice \u4f86\u7684 -> " : "";
            n = 0;
            while (true) {
                object3 = object2;
                if (n < ((BleCommandSetting)object).getData().length) {
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append((String)object2);
                    ((StringBuilder)object3).append(ParserUtil.getUnsignedByte(((BleCommandSetting)object).getData()[n]));
                    ((StringBuilder)object3).append(", ");
                    object2 = ((StringBuilder)object3).toString();
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("");
            ((StringBuilder)object3).append("\u6c92\u6709 data \u7684 command: ");
            ((StringBuilder)object3).append(((BleCommandSetting)object).getCmdId());
            ((StringBuilder)object3).append(", ");
            object2 = ((StringBuilder)object3).toString();
            object3 = new StringBuilder();
            ((StringBuilder)object3).append((String)object2);
            ((StringBuilder)object3).append("CmdAction: ");
            ((StringBuilder)object3).append(((BleCommandSetting)object).getCmdAction());
            object3 = ((StringBuilder)object3).toString();
        }
        if (!bl) {
            CharSequence charSequence;
            if (SampleGattAttributes.commandQueueUtilLog) {
                if (((BleCommandSetting)object).getCmdId() != 24 && ((BleCommandSetting)object).getCmdId() != 39) {
                    object2 = TAG;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("queue) add command -> ");
                    ((StringBuilder)charSequence).append((String)object3);
                    Log.d((String)object2, (String)((StringBuilder)charSequence).toString());
                } else if (SampleGattAttributes.settingLogFromDevice) {
                    object2 = TAG;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("queue) add command -> ");
                    ((StringBuilder)charSequence).append((String)object3);
                    Log.d((String)object2, (String)((StringBuilder)charSequence).toString());
                }
            }
            this.commandQueue.add((BleCommandSetting)object);
            if (SampleGattAttributes.commandQueueUtilLog) {
                object3 = this.commandQueue.iterator();
                object = "";
                while (object3.hasNext()) {
                    object2 = (BleCommandSetting)object3.next();
                    if (((BleCommandSetting)object2).getCmdAction() != null) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("cmdId [");
                        ((StringBuilder)object).append(((BleCommandSetting)object2).getCmdId());
                        ((StringBuilder)object).append("] cmdAction [");
                        ((StringBuilder)object).append(((BleCommandSetting)object2).getCmdAction());
                        ((StringBuilder)object).append("] priority [");
                        ((StringBuilder)object).append(((BleCommandSetting)object2).getPriority());
                        ((StringBuilder)object).append("] ,");
                        object = ((StringBuilder)object).toString();
                    } else if (((BleCommandSetting)object2).getData() != null) {
                        object = "";
                        for (n = 0; n < ((BleCommandSetting)object2).getData().length; ++n) {
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append((String)object);
                            ((StringBuilder)charSequence).append(ParserUtil.getUnsignedByte(((BleCommandSetting)object2).getData()[n]));
                            ((StringBuilder)charSequence).append(", ");
                            object = ((StringBuilder)charSequence).toString();
                        }
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append(" data [");
                        ((StringBuilder)charSequence).append((String)object);
                        ((StringBuilder)charSequence).append("] priority [");
                        ((StringBuilder)charSequence).append(((BleCommandSetting)object2).getPriority());
                        ((StringBuilder)charSequence).append("] ,");
                        object = ((StringBuilder)charSequence).toString();
                    }
                    charSequence = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("queueCommand: \u76ee\u524dqueue \u6709 -> ");
                    ((StringBuilder)object2).append((String)object);
                    Log.d((String)charSequence, (String)((StringBuilder)object2).toString());
                }
            }
        } else {
            object2 = TAG;
            object = new StringBuilder();
            ((StringBuilder)object).append("queue) queue \u4e2d\u5df2\u6709\u91cd\u8907 not add command -> ");
            ((StringBuilder)object).append((String)object3);
            Log.d((String)object2, (String)((StringBuilder)object).toString());
        }
        if (!this.bleProcessing) {
            this.processCommands();
        }
    }

    public void queueWrite(int n, int n2, String string2, JSONArray jSONArray, UUID uUID, UUID uUID2, byte[] byArray, int n3) {
        this.queueCommand(new BleCommandSetting(this.decideCmdPriority(n, n2), n, n2, false, string2, jSONArray, uUID, uUID2, byArray, n3));
    }

    public void queueWrite(int n, int n2, UUID uUID, UUID uUID2, byte[] byArray, int n3) {
        this.queueCommand(new BleCommandSetting(this.decideCmdPriority(n, n2), n, n2, false, null, null, uUID, uUID2, byArray, n3));
    }

    public void queueWriteForBbcp(UUID uUID, UUID uUID2, byte[] byArray, int n) {
        int n2 = uUID2.equals(SampleGattAttributes.COMMAND_CHANNEL_UUID) && byArray != null && byArray.length > 0 ? ParserUtil.getUnsignedByte(byArray[0]) : -1;
        this.queueCommand(new BleCommandSetting(80, n2, -1, false, uUID, uUID2, byArray, n));
    }

    public void queueWriteFromDevice(int n, int n2, String string2, UUID uUID, UUID uUID2, byte[] byArray, int n3) {
        if (SampleGattAttributes.commandQueueUtilLog) {
            String string3 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("queueWriteFromDevice:  cmdId = ");
            stringBuilder.append(n);
            stringBuilder.append(", cmdAction = ");
            stringBuilder.append(string2);
            Log.d((String)string3, (String)stringBuilder.toString());
        }
        this.queueCommand(new BleCommandSetting(this.decideCmdPriority(n, n2), n, n2, true, string2, null, uUID, uUID2, byArray, n3));
    }

    public void setNewSettingUtil(NewSettingUtil newSettingUtil) {
        this.newSettingUtil = newSettingUtil;
    }
}

