/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.bleplugin;

import android.util.Base64;
import android.util.Log;
import com.brytonsport.active.bleplugin.ParserUtil;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataUtil {
    private static final String TAG = "DataUtil";
    private static DataUtil instance;
    static int sendFileType;

    protected DataUtil() {
    }

    private static byte[] convertToPrimitiveArray(List<Byte> list) {
        byte[] byArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            byArray[i] = list.get(i);
        }
        return byArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileListResult(byte[] byArray) {
        int n = byArray.length / 36;
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("extra", n);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        JSONArray jSONArray = new JSONArray();
        int n2 = 0;
        while (true) {
            if (n2 < n) {
                int n3;
                int n4 = n2 * 36;
                int n5 = ParserUtil.byte2Int(byArray[n4 + 0]);
                byte[] byArray2 = new byte[4];
                for (n3 = 0; n3 < 4; ++n3) {
                    byArray2[n3] = byArray[n4 + n3 + 1];
                }
                int n6 = new BigInteger(byArray2).intValue();
                Object object = new StringBuilder();
                ((StringBuilder)object).append(ParserUtil.toBin(byArray2[0]));
                ((StringBuilder)object).append(ParserUtil.toBin(byArray2[1]));
                ((StringBuilder)object).append(ParserUtil.toBin(byArray2[2]));
                ((StringBuilder)object).append(ParserUtil.toBin(byArray2[3]));
                object = new Date(ParserUtil.stringToInt(((StringBuilder)object).toString()) * 1000L);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                object = simpleDateFormat.format((Date)object);
                byte[] byArray3 = new byte[4];
                for (n3 = 0; n3 < 4; ++n3) {
                    byArray3[n3] = byArray[n4 + n3 + 5];
                }
                int n7 = new BigInteger(byArray3).intValue();
                byte[] byArray4 = new byte[4];
                for (n3 = 0; n3 < 4; ++n3) {
                    byArray4[n3] = byArray[n4 + n3 + 9];
                }
                int n8 = new BigInteger(byArray4).intValue();
                int n9 = ParserUtil.byte2Int(byArray[13]);
                byte[] byArray5 = new byte[4];
                for (n3 = 0; n3 < 4; ++n3) {
                    byArray5[n3] = byArray[n4 + n3 + 14];
                }
                int n10 = new BigInteger(byArray5).intValue();
                int n11 = ParserUtil.byte2Int(byArray[n4 + 18]);
                byte[] byArray6 = new byte[17];
                for (n3 = 0; n3 < 17; ++n3) {
                    byArray6[n3] = byArray[n4 + n3 + 19];
                }
                new BigInteger(byArray6).intValue();
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("activityDist", n8);
                jSONObject2.put("activityTime", n7);
                jSONObject2.put("fileId", n6);
                jSONObject2.put("isWorkout", n9);
                jSONObject2.put("sportType", n11);
                jSONObject2.put("workoutId", n10);
                jSONObject2.put("fileIdToTimeStamp", object);
                jSONObject2.put("payloadSize", n5);
                jSONArray.put((Object)jSONObject2);
            } else {
                try {
                    jSONObject.put("result", (Object)jSONArray);
                    return jSONObject.toString();
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                return jSONObject.toString();
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    public static DataUtil getInstance() {
        if (instance == null) {
            instance = new DataUtil();
        }
        return instance;
    }

    public static JSONObject readDeviceInfoFormat(byte[] object) {
        Object object2 = DataUtil.split(object, (byte)0);
        object = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            byte[] byArray = (byte[])object2.next();
            String string2 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("readDeviceInfoArray dataArray split = ");
            stringBuilder.append(Arrays.toString(byArray));
            Log.d((String)string2, (String)stringBuilder.toString());
            string2 = new String(byArray, StandardCharsets.UTF_8);
            stringBuilder = new JSONArray();
            if ("UD".equals(string2.substring(0, 2))) {
                stringBuilder.put("UD");
                stringBuilder.put(string2.substring(2));
                string2.substring(2);
            } else if ("IV".equals(string2.substring(0, 2))) {
                stringBuilder.put("IV");
                stringBuilder.put(string2.substring(2));
                string2.substring(2);
            } else if ("MN".equals(string2.substring(0, 2))) {
                stringBuilder.put("MN");
                stringBuilder.put(string2.substring(2));
                string2.substring(2);
            } else if ("CP".equals(string2.substring(0, 2))) {
                stringBuilder.put("CP");
                stringBuilder.put(string2.substring(2));
                string2.substring(2);
            }
            jSONArray.put((Object)stringBuilder);
            try {
                object.put("result", (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return object;
    }

    public static JSONObject requestDataResult(byte[] object) {
        JSONObject jSONObject = new JSONObject();
        object = Base64.encodeToString((byte[])object, (int)10);
        try {
            jSONObject.put("result", object);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    private static List<byte[]> split(byte[] byArray, byte by) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
        for (byte by2 : byArray) {
            ArrayList<Byte> arrayList3;
            if (by2 == by && !arrayList2.isEmpty()) {
                arrayList.add(DataUtil.convertToPrimitiveArray(arrayList2));
                arrayList3 = new ArrayList();
            } else {
                arrayList3 = arrayList2;
                if (by2 != by) {
                    arrayList2.add(by2);
                    arrayList3 = arrayList2;
                }
            }
            arrayList2 = arrayList3;
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(DataUtil.convertToPrimitiveArray(arrayList2));
        }
        return arrayList;
    }

    public byte[] requestDataCmd(int n, int n2) {
        return this.requestDataCmd(n, n2, 0, 0, "");
    }

    public byte[] requestDataCmd(int n, int n2, int n3) {
        return this.requestDataCmd(n, n2, n3, 0, "");
    }

    public byte[] requestDataCmd(int n, int n2, int n3, int n4, int n5, int n6, String object) {
        byte[] byArray;
        int n7 = 2;
        if (n != 8) {
            if (n != 12) {
                switch (n) {
                    default: {
                        byArray = new byte[2];
                        break;
                    }
                    case 17: {
                        byArray = new byte[15];
                        break;
                    }
                    case 15: 
                    case 16: {
                        byArray = new byte[3];
                        break;
                    }
                }
            } else {
                byArray = new byte[7];
            }
        } else {
            byArray = new byte[10];
        }
        byArray[0] = (byte)n;
        String string2 = ParserUtil.intToBinaryString(n2, 3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("000");
        stringBuilder.append(string2);
        stringBuilder.append("00");
        byArray[1] = Byte.parseByte(stringBuilder.toString(), 2);
        if (n != 8) {
            if (n != 12) {
                switch (n) {
                    default: {
                        break;
                    }
                    case 17: {
                        object = ParserUtil.fitFileNameToByteArray(n4);
                        byArray[2] = (byte)object[0];
                        byArray[3] = (byte)object[1];
                        byArray[4] = (byte)object[2];
                        byArray[5] = (byte)object[3];
                        byArray[6] = (byte)n3;
                        object = ByteBuffer.allocate(4).putInt(n5).array();
                        byArray[7] = (byte)object[0];
                        byArray[8] = (byte)object[1];
                        byArray[9] = (byte)object[2];
                        byArray[10] = (byte)object[3];
                        object = ByteBuffer.allocate(4).putInt(n6).array();
                        byArray[11] = (byte)object[0];
                        byArray[12] = (byte)object[1];
                        byArray[13] = (byte)object[2];
                        byArray[14] = (byte)object[3];
                        break;
                    }
                    case 16: {
                        sendFileType = n3;
                        byArray[2] = (byte)n3;
                        break;
                    }
                    case 15: {
                        byArray[2] = (byte)n3;
                        break;
                    }
                }
            } else {
                object = ParserUtil.fitFileNameToByteArray(n4);
                byArray[2] = (byte)object[0];
                byArray[3] = (byte)object[1];
                byArray[4] = (byte)object[2];
                byArray[5] = (byte)object[3];
                byArray[6] = (byte)n3;
            }
        } else {
            object = ((String)object).getBytes();
            for (n = n7; n < byArray.length; ++n) {
                byArray[n] = (byte)object[n - 2];
            }
        }
        return byArray;
    }

    public byte[] requestDataCmd(int n, int n2, int n3, int n4, String string2) {
        return this.requestDataCmd(n, n2, n3, n4, 0, 0, string2);
    }

    public byte[] requestDataCmd(int n, int n2, String string2) {
        return this.requestDataCmd(n, n2, 0, 0, string2);
    }

    public byte[] smartNotifyApp(int n, int n2, String object) {
        int n3 = 0;
        byte[] byArray = new byte[3];
        byArray[0] = (byte)n;
        byArray[1] = (byte)65;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2) {
                    byArray[2] = (byte)50;
                }
            } else {
                byArray[2] = (byte)49;
            }
        } else {
            byArray[2] = (byte)48;
        }
        object = ((String)object).getBytes();
        n2 = ((Object)object).length;
        n = 16;
        if (n2 < 16) {
            n = ((Object)object).length;
        }
        byte[] byArray2 = new byte[n];
        for (n2 = n3; n2 < n; ++n2) {
            byArray2[n2] = (byte)object[n2];
        }
        return ParserUtil.joinByteArray(byArray, ParserUtil.joinByteArray(byArray2, new byte[]{0}));
    }

    public byte[] smartNotifyMail(int n) {
        return ParserUtil.joinByteArray(new byte[]{(byte)n, 70, 48}, new byte[]{0});
    }

    public byte[] smartNotifyPhone(int n, int n2, String object) {
        int n3 = 0;
        byte[] byArray = new byte[3];
        byArray[0] = (byte)n;
        byArray[1] = (byte)69;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2) {
                    byArray[2] = (byte)50;
                }
            } else {
                byArray[2] = (byte)49;
            }
        } else {
            byArray[2] = (byte)48;
        }
        byte[] byArray2 = ((String)object).getBytes();
        n2 = byArray2.length;
        n = 16;
        if (n2 < 16) {
            n = byArray2.length;
        }
        object = new byte[n];
        for (n2 = n3; n2 < n; ++n2) {
            object[n2] = byArray2[n2];
        }
        return ParserUtil.joinByteArray(byArray, ParserUtil.joinByteArray((byte[])object, new byte[]{0}));
    }

    public byte[] smartNotifyText(int n) {
        return ParserUtil.joinByteArray(new byte[]{(byte)n, 71, 48}, new byte[]{0});
    }
}

