/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.bleplugin;

import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;

public class ParserUtil {
    public static byte[] InputStreamToByte(InputStream object) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = ((InputStream)object).read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return object;
    }

    public static byte[] bufToDataPkg(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 + 8];
        return ParserUtil.joinByteArray(ParserUtil.joinByteArray(ByteBuffer.allocate(4).putInt(n).array(), ByteBuffer.allocate(4).putInt(byArray.length).array()), Arrays.copyOfRange(byArray, n, n2 + n));
    }

    public static int byte2Int(byte by) {
        return by;
    }

    public static String byteToBin(byte by) {
        String string2 = Integer.toBinaryString(by & 0xFF);
        CharSequence charSequence = string2;
        if (string2.length() < 8) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("00000000".substring(0, 8 - string2.length()));
            ((StringBuilder)charSequence).append(string2);
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public static int calChecksum(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length - 1; ++i) {
            n += ParserUtil.getUnsignedByte(byArray[i]);
        }
        return n % 256;
    }

    public static byte[] encodeCmd(byte[] byArray) {
        byArray[byArray.length - 1] = (byte)ParserUtil.calChecksum(byArray);
        return byArray;
    }

    public static String fileIdToFormatString(int n) {
        Object object = ByteBuffer.allocate(4).putInt(n).array();
        Comparable<StringBuilder> comparable = new StringBuilder();
        comparable.append(ParserUtil.toBin(object[0]));
        comparable.append(ParserUtil.toBin(object[1]));
        comparable.append(ParserUtil.toBin(object[2]));
        comparable.append(ParserUtil.toBin(object[3]));
        comparable = new Date(ParserUtil.stringToInt(comparable.toString()) * 1000L);
        object = new SimpleDateFormat("yyMMddHHmmss");
        ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
        return ((DateFormat)object).format((Date)comparable);
    }

    public static String fileIdToFormatString(long l) {
        Object object = new Date(new Timestamp(1000L * l).getTime());
        Serializable serializable = new SimpleDateFormat("yyMMddHHmmss");
        ((DateFormat)serializable).setTimeZone(TimeZone.getTimeZone("UTC"));
        object = ((DateFormat)serializable).format((Date)object);
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("fileIdToFormatString: fileId: ");
        ((StringBuilder)serializable).append(l);
        ((StringBuilder)serializable).append(", result: ");
        ((StringBuilder)serializable).append((String)object);
        Log.d((String)"\u8f49\u6642\u9593", (String)((StringBuilder)serializable).toString());
        return object;
    }

    public static byte[] fitFileNameToByteArray(int n) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append("fitFileNameToByteArray() -> fileId = ");
        ((StringBuilder)object).append(n);
        Log.d((String)"ParserUtil", (String)((StringBuilder)object).toString());
        object = ParserUtil.fileIdToFormatString(n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            object = simpleDateFormat.parse((String)object);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            object = null;
        }
        if (object != null) {
            n = (int)(((Date)object).getTime() / 1000L);
            return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        }
        return null;
    }

    public static String fitNameToFormatName(byte[] object) {
        Comparable<StringBuilder> comparable = new StringBuilder();
        comparable.append(ParserUtil.toBin(object[2]));
        comparable.append(ParserUtil.toBin(object[3]));
        comparable.append(ParserUtil.toBin(object[4]));
        comparable.append(ParserUtil.toBin(object[5]));
        comparable = new Date(ParserUtil.stringToInt(comparable.toString()) * 1000L);
        object = new SimpleDateFormat("yyMMddHHmmss");
        ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
        return ((DateFormat)object).format((Date)comparable);
    }

    public static Integer getBitByByte(byte by, int n, int n2) {
        if (n < 8 && n2 < 8 && n < n2) {
            return Integer.parseInt(ParserUtil.byteToBin(by).substring(n, n2 + 1), 2);
        }
        return null;
    }

    public static int getUnsignedByte(byte by) {
        return by & 0xFF;
    }

    public static String intToBinaryString(int n, int n2) {
        if (n2 > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("%");
            stringBuilder.append(n2);
            stringBuilder.append("s");
            return String.format(stringBuilder.toString(), Integer.toBinaryString(n)).replaceAll(" ", "0");
        }
        return null;
    }

    public static boolean isValidData(byte[] byArray) {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < byArray.length - 1; ++i) {
            n += byArray[i];
        }
        if (n % 256 == byArray[byArray.length - 1]) {
            bl = true;
        }
        return bl;
    }

    public static byte[] joinByteArray(byte[] byArray, byte[] byArray2) {
        return ByteBuffer.allocate(byArray.length + byArray2.length).put(byArray).put(byArray2).array();
    }

    public static long stringToInt(String string2) {
        string2 = string2.trim();
        long l = 0L;
        for (int i = string2.length() - 1; i >= 0; --i) {
            char c = string2.charAt(i);
            l = (long)((double)l + (double)Integer.parseInt(String.valueOf(c)) * Math.pow(2.0, string2.length() - 1 - i));
        }
        return l;
    }

    public static String toBin(byte by) {
        int n = ParserUtil.getUnsignedByte(by);
        if (n == 0) {
            return "00000000";
        }
        String string2 = Integer.toBinaryString(n);
        int n2 = 8 - string2.length() % 8;
        CharSequence charSequence = string2;
        if (n2 != 8) {
            n = 0;
            while (true) {
                charSequence = string2;
                if (n >= n2) break;
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("0");
                ((StringBuilder)charSequence).append(string2);
                string2 = ((StringBuilder)charSequence).toString();
                ++n;
            }
        }
        return charSequence;
    }

    public static long toUInt(byte[] byArray) {
        if (byArray != null && byArray.length == 4) {
            return ((long)byArray[3] & 0xFFL) << 24 | ((long)byArray[2] & 0xFFL) << 16 | ((long)byArray[1] & 0xFFL) << 8 | 0xFFL & (long)byArray[0];
        }
        throw new IllegalArgumentException("!= 4 bytes");
    }

    public static int toUShort(byte[] byArray) {
        if (byArray != null && byArray.length == 2) {
            byte by = byArray[1];
            return byArray[0] & 0xFF | (by & 0xFF) << 8;
        }
        throw new IllegalArgumentException("!= 2 bytes");
    }
}

