/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.db;

import android.content.Context;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import com.brytonsport.active.db.account.dao.UserInfoDao;
import com.brytonsport.active.db.account.dao.UserProfileDao;
import com.brytonsport.active.db.course.dao.CourseSearchHistoryDao;
import com.brytonsport.active.db.course.dao.FileIdHistoryDao;
import com.brytonsport.active.db.notification.dao.NotificationDao;
import com.brytonsport.active.db.result.dao.BrytonActivityDao;
import com.brytonsport.active.db.setting.dao.DeviceManagerDao;

public abstract class AppDatabase
extends RoomDatabase {
    public static final String DB_NAME = "BrytonData.db";
    static final Migration MIGRATION_1_2 = new Migration(1, 2){

        @Override
        public void migrate(SupportSQLiteDatabase supportSQLiteDatabase) {
            supportSQLiteDatabase.execSQL("ALTER TABLE device_manager  ADD COLUMN sptLiveTrack INTEGER NOT NULL DEFAULT 0");
            supportSQLiteDatabase.execSQL("ALTER TABLE device_manager  ADD COLUMN sptGroupRide INTEGER NOT NULL DEFAULT 0");
        }
    };
    static final Migration MIGRATION_2_3 = new Migration(2, 3){

        @Override
        public void migrate(SupportSQLiteDatabase supportSQLiteDatabase) {
            supportSQLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS `activity_list_new` (`_id` TEXT NOT NULL, `name` TEXT, `owner` TEXT, `hash` TEXT, `sport` TEXT, `start_time` INTEGER, `local_start_time` INTEGER, `uploaded_at` INTEGER, `map_image` TEXT, `totalElapsedTime` REAL, `totalMovingTime` REAL, `totalDistance` REAL, `avgSpeed` REAL, `maxSpeed` REAL, `avgHeartRate` REAL, `maxHeartRate` INTEGER, `avgCadence` REAL, `avgRunningCadence` REAL, `maxCadence` REAL, `maxRunningCadence` REAL, `avgPower` REAL, `maxPower` INTEGER, `totalAscent` REAL, `totalDescent` REAL, `maxAltitude` REAL, `minAltitude` REAL, `maxTemperature` REAL, `minTemperature` REAL, `avgTemperature` REAL, `totalCalories` REAL, `carbohydrate` REAL, `fat` REAL, `uphillTime` INTEGER, `uphillDist` INTEGER, `uphillAvgSpeed` REAL, `uphillGrade` REAL, `uphillAvgBpm` REAL, `uphillAvgRpm` REAL, `downhillTime` INTEGER, `downhillDist` INTEGER, `downhillAvgSpeed` REAL, `downhillGrade` REAL, `downhillAvgBpm` REAL, `downhillAvgRpm` REAL, PRIMARY KEY(`_id`))");
            supportSQLiteDatabase.execSQL("INSERT INTO activity_list_new  SELECT * FROM activity_list");
            supportSQLiteDatabase.execSQL("DROP TABLE activity_list");
            supportSQLiteDatabase.execSQL("ALTER TABLE activity_list_new RENAME TO activity_list");
        }
    };
    static final Migration MIGRATION_3_4 = new Migration(3, 4){

        @Override
        public void migrate(SupportSQLiteDatabase supportSQLiteDatabase) {
            supportSQLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS `activity_list_new` (`_id` TEXT NOT NULL, `name` TEXT, `owner` TEXT, `hash` TEXT, `sport` TEXT, `start_time` INTEGER, `local_start_time` INTEGER, `uploaded_at` INTEGER, `map_image` TEXT, `totalElapsedTime` REAL, `totalMovingTime` REAL, `totalDistance` REAL, `avgSpeed` REAL, `maxSpeed` REAL, `avgHeartRate` REAL, `maxHeartRate` INTEGER, `avgCadence` REAL, `avgRunningCadence` REAL, `maxCadence` REAL, `maxRunningCadence` REAL, `avgPower` REAL, `maxPower` INTEGER, `totalAscent` REAL, `totalDescent` REAL, `maxAltitude` REAL, `minAltitude` REAL, `maxTemperature` REAL, `minTemperature` REAL, `avgTemperature` REAL, `totalCalories` REAL, `carbohydrate` REAL, `fat` REAL, `uphillTime` INTEGER, `uphillDist` INTEGER, `uphillAvgSpeed` REAL, `uphillGrade` REAL, `uphillAvgBpm` REAL, `uphillAvgRpm` REAL, `downhillTime` INTEGER, `downhillDist` INTEGER, `downhillAvgSpeed` REAL, `downhillGrade` REAL, `downhillAvgBpm` REAL, `downhillAvgRpm` REAL, PRIMARY KEY(`_id`))");
            supportSQLiteDatabase.execSQL("INSERT INTO activity_list_new  SELECT * FROM activity_list");
            supportSQLiteDatabase.execSQL("DROP TABLE activity_list");
            supportSQLiteDatabase.execSQL("ALTER TABLE activity_list_new RENAME TO activity_list");
        }
    };
    private static volatile AppDatabase instance;

    private static AppDatabase create(Context context) {
        return Room.databaseBuilder(context, AppDatabase.class, DB_NAME).addMigrations(MIGRATION_3_4).build();
    }

    public static AppDatabase getInstance(Context object) {
        synchronized (AppDatabase.class) {
            if (instance == null) {
                instance = AppDatabase.create(object);
            }
            object = instance;
            return object;
        }
    }

    public abstract BrytonActivityDao brytonActivityDao();

    public abstract CourseSearchHistoryDao courseSearchHistoryDao();

    public abstract DeviceManagerDao deviceManagerDao();

    public abstract FileIdHistoryDao fileIdHistoryDao();

    public abstract NotificationDao notificationDao();

    public abstract UserInfoDao userInfoDao();

    public abstract UserProfileDao userProfileDao();
}

