/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.db.course.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.brytonsport.active.db.course.dao.CourseSearchHistoryDao;
import com.brytonsport.active.db.course.entity.CourseSearchHistoryEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class CourseSearchHistoryDao_Impl
extends CourseSearchHistoryDao {
    private final RoomDatabase __db;
    private final EntityDeletionOrUpdateAdapter<CourseSearchHistoryEntity> __deletionAdapterOfCourseSearchHistoryEntity;
    private final EntityInsertionAdapter<CourseSearchHistoryEntity> __insertionAdapterOfCourseSearchHistoryEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final EntityDeletionOrUpdateAdapter<CourseSearchHistoryEntity> __updateAdapterOfCourseSearchHistoryEntity;

    public CourseSearchHistoryDao_Impl(RoomDatabase roomDatabase) {
        this.__db = roomDatabase;
        this.__insertionAdapterOfCourseSearchHistoryEntity = new EntityInsertionAdapter<CourseSearchHistoryEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, CourseSearchHistoryEntity courseSearchHistoryEntity) {
                supportSQLiteStatement.bindLong(1, courseSearchHistoryEntity.getSn());
                if (courseSearchHistoryEntity.getContent() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, courseSearchHistoryEntity.getContent());
                }
                supportSQLiteStatement.bindLong(3, courseSearchHistoryEntity.getUpdateDate());
            }

            @Override
            public String createQuery() {
                return "INSERT OR REPLACE INTO `course_search_history` (`sn`,`content`,`updateDate`) VALUES (nullif(?, 0),?,?)";
            }
        };
        this.__deletionAdapterOfCourseSearchHistoryEntity = new EntityDeletionOrUpdateAdapter<CourseSearchHistoryEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, CourseSearchHistoryEntity courseSearchHistoryEntity) {
                supportSQLiteStatement.bindLong(1, courseSearchHistoryEntity.getSn());
            }

            @Override
            public String createQuery() {
                return "DELETE FROM `course_search_history` WHERE `sn` = ?";
            }
        };
        this.__updateAdapterOfCourseSearchHistoryEntity = new EntityDeletionOrUpdateAdapter<CourseSearchHistoryEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, CourseSearchHistoryEntity courseSearchHistoryEntity) {
                supportSQLiteStatement.bindLong(1, courseSearchHistoryEntity.getSn());
                if (courseSearchHistoryEntity.getContent() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, courseSearchHistoryEntity.getContent());
                }
                supportSQLiteStatement.bindLong(3, courseSearchHistoryEntity.getUpdateDate());
                supportSQLiteStatement.bindLong(4, courseSearchHistoryEntity.getSn());
            }

            @Override
            public String createQuery() {
                return "UPDATE OR ABORT `course_search_history` SET `sn` = ?,`content` = ?,`updateDate` = ? WHERE `sn` = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(roomDatabase){

            @Override
            public String createQuery() {
                return "DELETE FROM course_search_history";
            }
        };
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    @Override
    public void delete(CourseSearchHistoryEntity courseSearchHistoryEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCourseSearchHistoryEntity.handle(courseSearchHistoryEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(supportSQLiteStatement);
        }
    }

    @Override
    public void insert(CourseSearchHistoryEntity courseSearchHistoryEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCourseSearchHistoryEntity.insert(courseSearchHistoryEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<CourseSearchHistoryEntity> list) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCourseSearchHistoryEntity.insert((CourseSearchHistoryEntity)((Object)list));
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<CourseSearchHistoryEntity> loadSearchHistoryList() {
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire("SELECT * FROM course_search_history order by updateDate desc", 0);
        this.__db.assertNotSuspendingTransaction();
        Cursor cursor = DBUtil.query(this.__db, roomSQLiteQuery, false, null);
        try {
            int n = CursorUtil.getColumnIndexOrThrow(cursor, "sn");
            int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "content");
            int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "updateDate");
            ArrayList<CourseSearchHistoryEntity> arrayList = new ArrayList<CourseSearchHistoryEntity>(cursor.getCount());
            while (cursor.moveToNext()) {
                String string2 = cursor.isNull(n2) ? null : cursor.getString(n2);
                long l = cursor.getLong(n3);
                CourseSearchHistoryEntity courseSearchHistoryEntity = new CourseSearchHistoryEntity(string2, l);
                courseSearchHistoryEntity.setSn(cursor.getInt(n));
                arrayList.add(courseSearchHistoryEntity);
            }
            return arrayList;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    @Override
    public LiveData<List<CourseSearchHistoryEntity>> loadSearchHistoryListLive() {
        Object object = RoomSQLiteQuery.acquire("SELECT * FROM course_search_history order by updateDate desc", 0);
        InvalidationTracker invalidationTracker = this.__db.getInvalidationTracker();
        object = new Callable<List<CourseSearchHistoryEntity>>((RoomSQLiteQuery)object){
            final /* synthetic */ RoomSQLiteQuery val$_statement;
            {
                this.val$_statement = roomSQLiteQuery;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<CourseSearchHistoryEntity> call() throws Exception {
                Cursor cursor = DBUtil.query(CourseSearchHistoryDao_Impl.this.__db, this.val$_statement, false, null);
                try {
                    int n = CursorUtil.getColumnIndexOrThrow(cursor, "sn");
                    int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "content");
                    int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "updateDate");
                    ArrayList<CourseSearchHistoryEntity> arrayList = new ArrayList<CourseSearchHistoryEntity>(cursor.getCount());
                    while (cursor.moveToNext()) {
                        String string2 = cursor.isNull(n2) ? null : cursor.getString(n2);
                        long l = cursor.getLong(n3);
                        CourseSearchHistoryEntity courseSearchHistoryEntity = new CourseSearchHistoryEntity(string2, l);
                        courseSearchHistoryEntity.setSn(cursor.getInt(n));
                        arrayList.add(courseSearchHistoryEntity);
                    }
                    return arrayList;
                }
                finally {
                    cursor.close();
                }
            }

            protected void finalize() {
                this.val$_statement.release();
            }
        };
        return invalidationTracker.createLiveData(new String[]{"course_search_history"}, false, object);
    }

    @Override
    public void update(CourseSearchHistoryEntity courseSearchHistoryEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCourseSearchHistoryEntity.handle(courseSearchHistoryEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

