/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.db.course.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.brytonsport.active.db.course.dao.FileIdHistoryDao;
import com.brytonsport.active.db.course.entity.FileIdHistoryEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class FileIdHistoryDao_Impl
extends FileIdHistoryDao {
    private final RoomDatabase __db;
    private final EntityDeletionOrUpdateAdapter<FileIdHistoryEntity> __deletionAdapterOfFileIdHistoryEntity;
    private final EntityInsertionAdapter<FileIdHistoryEntity> __insertionAdapterOfFileIdHistoryEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final EntityDeletionOrUpdateAdapter<FileIdHistoryEntity> __updateAdapterOfFileIdHistoryEntity;

    public FileIdHistoryDao_Impl(RoomDatabase roomDatabase) {
        this.__db = roomDatabase;
        this.__insertionAdapterOfFileIdHistoryEntity = new EntityInsertionAdapter<FileIdHistoryEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, FileIdHistoryEntity fileIdHistoryEntity) {
                supportSQLiteStatement.bindLong(1, fileIdHistoryEntity.getSn());
                supportSQLiteStatement.bindLong(2, fileIdHistoryEntity.getType());
                if (fileIdHistoryEntity.getFileId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, fileIdHistoryEntity.getFileId());
                }
                supportSQLiteStatement.bindLong(4, fileIdHistoryEntity.getUpdateDate());
            }

            @Override
            public String createQuery() {
                return "INSERT OR REPLACE INTO `file_id_history` (`sn`,`type`,`fileId`,`updateDate`) VALUES (nullif(?, 0),?,?,?)";
            }
        };
        this.__deletionAdapterOfFileIdHistoryEntity = new EntityDeletionOrUpdateAdapter<FileIdHistoryEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, FileIdHistoryEntity fileIdHistoryEntity) {
                supportSQLiteStatement.bindLong(1, fileIdHistoryEntity.getSn());
            }

            @Override
            public String createQuery() {
                return "DELETE FROM `file_id_history` WHERE `sn` = ?";
            }
        };
        this.__updateAdapterOfFileIdHistoryEntity = new EntityDeletionOrUpdateAdapter<FileIdHistoryEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, FileIdHistoryEntity fileIdHistoryEntity) {
                supportSQLiteStatement.bindLong(1, fileIdHistoryEntity.getSn());
                supportSQLiteStatement.bindLong(2, fileIdHistoryEntity.getType());
                if (fileIdHistoryEntity.getFileId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, fileIdHistoryEntity.getFileId());
                }
                supportSQLiteStatement.bindLong(4, fileIdHistoryEntity.getUpdateDate());
                supportSQLiteStatement.bindLong(5, fileIdHistoryEntity.getSn());
            }

            @Override
            public String createQuery() {
                return "UPDATE OR ABORT `file_id_history` SET `sn` = ?,`type` = ?,`fileId` = ?,`updateDate` = ? WHERE `sn` = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(roomDatabase){

            @Override
            public String createQuery() {
                return "DELETE FROM file_id_history";
            }
        };
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    @Override
    public void delete(FileIdHistoryEntity fileIdHistoryEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfFileIdHistoryEntity.handle(fileIdHistoryEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(supportSQLiteStatement);
        }
    }

    @Override
    public void insert(FileIdHistoryEntity fileIdHistoryEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfFileIdHistoryEntity.insert(fileIdHistoryEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<FileIdHistoryEntity> list) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfFileIdHistoryEntity.insert((FileIdHistoryEntity)((Object)list));
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<FileIdHistoryEntity> loadFileIdHistoryListByType(int n) {
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire("SELECT * FROM file_id_history WHERE type = ?", 1);
        roomSQLiteQuery.bindLong(1, n);
        this.__db.assertNotSuspendingTransaction();
        Cursor cursor = DBUtil.query(this.__db, roomSQLiteQuery, false, null);
        try {
            int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "sn");
            n = CursorUtil.getColumnIndexOrThrow(cursor, "type");
            int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "fileId");
            int n4 = CursorUtil.getColumnIndexOrThrow(cursor, "updateDate");
            ArrayList<FileIdHistoryEntity> arrayList = new ArrayList<FileIdHistoryEntity>(cursor.getCount());
            while (cursor.moveToNext()) {
                int n5 = cursor.getInt(n);
                String string2 = cursor.isNull(n3) ? null : cursor.getString(n3);
                long l = cursor.getLong(n4);
                FileIdHistoryEntity fileIdHistoryEntity = new FileIdHistoryEntity(n5, string2, l);
                fileIdHistoryEntity.setSn(cursor.getInt(n2));
                arrayList.add(fileIdHistoryEntity);
            }
            return arrayList;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    @Override
    public LiveData<List<FileIdHistoryEntity>> loadFileIdHistoryListByTypeLive(int n) {
        Object object = RoomSQLiteQuery.acquire("SELECT * FROM file_id_history WHERE type = ?", 1);
        ((RoomSQLiteQuery)object).bindLong(1, n);
        InvalidationTracker invalidationTracker = this.__db.getInvalidationTracker();
        object = new Callable<List<FileIdHistoryEntity>>((RoomSQLiteQuery)object){
            final /* synthetic */ RoomSQLiteQuery val$_statement;
            {
                this.val$_statement = roomSQLiteQuery;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<FileIdHistoryEntity> call() throws Exception {
                Cursor cursor = DBUtil.query(FileIdHistoryDao_Impl.this.__db, this.val$_statement, false, null);
                try {
                    int n = CursorUtil.getColumnIndexOrThrow(cursor, "sn");
                    int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "type");
                    int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "fileId");
                    int n4 = CursorUtil.getColumnIndexOrThrow(cursor, "updateDate");
                    ArrayList<FileIdHistoryEntity> arrayList = new ArrayList<FileIdHistoryEntity>(cursor.getCount());
                    while (cursor.moveToNext()) {
                        int n5 = cursor.getInt(n2);
                        String string2 = cursor.isNull(n3) ? null : cursor.getString(n3);
                        long l = cursor.getLong(n4);
                        FileIdHistoryEntity fileIdHistoryEntity = new FileIdHistoryEntity(n5, string2, l);
                        fileIdHistoryEntity.setSn(cursor.getInt(n));
                        arrayList.add(fileIdHistoryEntity);
                    }
                    return arrayList;
                }
                finally {
                    cursor.close();
                }
            }

            protected void finalize() {
                this.val$_statement.release();
            }
        };
        return invalidationTracker.createLiveData(new String[]{"file_id_history"}, false, object);
    }

    @Override
    public void update(FileIdHistoryEntity fileIdHistoryEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfFileIdHistoryEntity.handle(fileIdHistoryEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

