/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.db.notification.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.brytonsport.active.db.notification.dao.NotificationDao;
import com.brytonsport.active.db.notification.entity.NotificationEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class NotificationDao_Impl
extends NotificationDao {
    private final RoomDatabase __db;
    private final EntityDeletionOrUpdateAdapter<NotificationEntity> __deletionAdapterOfNotificationEntity;
    private final EntityInsertionAdapter<NotificationEntity> __insertionAdapterOfNotificationEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStatusAndTitleByFileId;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStatusByFileId;
    private final EntityDeletionOrUpdateAdapter<NotificationEntity> __updateAdapterOfNotificationEntity;

    public NotificationDao_Impl(RoomDatabase roomDatabase) {
        this.__db = roomDatabase;
        this.__insertionAdapterOfNotificationEntity = new EntityInsertionAdapter<NotificationEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, NotificationEntity notificationEntity) {
                supportSQLiteStatement.bindLong(1, notificationEntity.getSn());
                supportSQLiteStatement.bindLong(2, notificationEntity.getStatus());
                if (notificationEntity.getTitle() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, notificationEntity.getTitle());
                }
                if (notificationEntity.getContent() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, notificationEntity.getContent());
                }
                supportSQLiteStatement.bindLong(5, notificationEntity.getPushDate());
                supportSQLiteStatement.bindLong(6, notificationEntity.getExpire());
                supportSQLiteStatement.bindLong(7, (long)notificationEntity.isRead());
                supportSQLiteStatement.bindLong(8, notificationEntity.getFileId());
            }

            @Override
            public String createQuery() {
                return "INSERT OR REPLACE INTO `result_notification` (`sn`,`status`,`title`,`content`,`push_date`,`expire`,`is_read`,`fileId`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }
        };
        this.__deletionAdapterOfNotificationEntity = new EntityDeletionOrUpdateAdapter<NotificationEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, NotificationEntity notificationEntity) {
                supportSQLiteStatement.bindLong(1, notificationEntity.getSn());
            }

            @Override
            public String createQuery() {
                return "DELETE FROM `result_notification` WHERE `sn` = ?";
            }
        };
        this.__updateAdapterOfNotificationEntity = new EntityDeletionOrUpdateAdapter<NotificationEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, NotificationEntity notificationEntity) {
                supportSQLiteStatement.bindLong(1, notificationEntity.getSn());
                supportSQLiteStatement.bindLong(2, notificationEntity.getStatus());
                if (notificationEntity.getTitle() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, notificationEntity.getTitle());
                }
                if (notificationEntity.getContent() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, notificationEntity.getContent());
                }
                supportSQLiteStatement.bindLong(5, notificationEntity.getPushDate());
                supportSQLiteStatement.bindLong(6, notificationEntity.getExpire());
                supportSQLiteStatement.bindLong(7, (long)notificationEntity.isRead());
                supportSQLiteStatement.bindLong(8, notificationEntity.getFileId());
                supportSQLiteStatement.bindLong(9, notificationEntity.getSn());
            }

            @Override
            public String createQuery() {
                return "UPDATE OR ABORT `result_notification` SET `sn` = ?,`status` = ?,`title` = ?,`content` = ?,`push_date` = ?,`expire` = ?,`is_read` = ?,`fileId` = ? WHERE `sn` = ?";
            }
        };
        this.__preparedStmtOfUpdateStatusByFileId = new SharedSQLiteStatement(roomDatabase){

            @Override
            public String createQuery() {
                return "UPDATE result_notification SET status = ?, push_date = ? WHERE fileId = ?";
            }
        };
        this.__preparedStmtOfUpdateStatusAndTitleByFileId = new SharedSQLiteStatement(roomDatabase){

            @Override
            public String createQuery() {
                return "UPDATE result_notification SET status = ?, content = ?, push_date = ? WHERE fileId = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(roomDatabase){

            @Override
            public String createQuery() {
                return "DELETE FROM result_notification";
            }
        };
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    @Override
    public void delete(NotificationEntity notificationEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfNotificationEntity.handle(notificationEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(supportSQLiteStatement);
        }
    }

    @Override
    public LiveData<Integer> getUnReadCount() {
        Object object = RoomSQLiteQuery.acquire("SELECT COUNT(*) FROM result_notification WHERE is_read = 0", 0);
        InvalidationTracker invalidationTracker = this.__db.getInvalidationTracker();
        object = new Callable<Integer>((RoomSQLiteQuery)object){
            final /* synthetic */ RoomSQLiteQuery val$_statement;
            {
                this.val$_statement = roomSQLiteQuery;
            }

            @Override
            public Integer call() throws Exception {
                Object object;
                RoomDatabase roomDatabase;
                block3: {
                    block4: {
                        roomDatabase = NotificationDao_Impl.this.__db;
                        object = this.val$_statement;
                        Object var3_4 = null;
                        roomDatabase = DBUtil.query(roomDatabase, (SupportSQLiteQuery)object, false, null);
                        object = var3_4;
                        try {
                            if (!roomDatabase.moveToFirst()) break block3;
                            if (!roomDatabase.isNull(0)) break block4;
                            object = var3_4;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            roomDatabase.close();
                            throw throwable;
                        }
                    }
                    int n = roomDatabase.getInt(0);
                    object = n;
                }
                roomDatabase.close();
                return object;
            }

            protected void finalize() {
                this.val$_statement.release();
            }
        };
        return invalidationTracker.createLiveData(new String[]{"result_notification"}, false, object);
    }

    @Override
    public void insert(NotificationEntity notificationEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfNotificationEntity.insert(notificationEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<NotificationEntity> list) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfNotificationEntity.insert((NotificationEntity)((Object)list));
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NotificationEntity loadNotificationById(int n) {
        boolean bl = true;
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire("SELECT * FROM result_notification WHERE fileId = ?", 1);
        roomSQLiteQuery.bindLong(1, n);
        this.__db.assertNotSuspendingTransaction();
        Object object = this.__db;
        Object object2 = null;
        String string2 = null;
        Cursor cursor = DBUtil.query((RoomDatabase)object, roomSQLiteQuery, false, null);
        try {
            int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "sn");
            int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "status");
            int n4 = CursorUtil.getColumnIndexOrThrow(cursor, "title");
            int n5 = CursorUtil.getColumnIndexOrThrow(cursor, "content");
            int n6 = CursorUtil.getColumnIndexOrThrow(cursor, "push_date");
            int n7 = CursorUtil.getColumnIndexOrThrow(cursor, "expire");
            int n8 = CursorUtil.getColumnIndexOrThrow(cursor, "is_read");
            n = CursorUtil.getColumnIndexOrThrow(cursor, "fileId");
            if (!cursor.moveToFirst()) return object2;
            n3 = cursor.getInt(n3);
            object2 = cursor.isNull(n4) ? null : cursor.getString(n4);
            if (!cursor.isNull(n5)) {
                string2 = cursor.getString(n5);
            }
            long l = cursor.getLong(n6);
            long l2 = cursor.getLong(n7);
            object = new NotificationEntity(n3, (String)object2, string2, l, l2);
            ((NotificationEntity)object).setSn(cursor.getInt(n2));
            if (cursor.getInt(n8) == 0) {
                bl = false;
            }
            ((NotificationEntity)object).setRead(bl);
            ((NotificationEntity)object).setFileId(cursor.getInt(n));
            object2 = object;
            return object2;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<NotificationEntity> loadNotificationList() {
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire("SELECT * FROM result_notification", 0);
        this.__db.assertNotSuspendingTransaction();
        Cursor cursor = DBUtil.query(this.__db, roomSQLiteQuery, false, null);
        try {
            int n = CursorUtil.getColumnIndexOrThrow(cursor, "sn");
            int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "status");
            int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "title");
            int n4 = CursorUtil.getColumnIndexOrThrow(cursor, "content");
            int n5 = CursorUtil.getColumnIndexOrThrow(cursor, "push_date");
            int n6 = CursorUtil.getColumnIndexOrThrow(cursor, "expire");
            int n7 = CursorUtil.getColumnIndexOrThrow(cursor, "is_read");
            int n8 = CursorUtil.getColumnIndexOrThrow(cursor, "fileId");
            ArrayList<NotificationEntity> arrayList = new ArrayList<NotificationEntity>(cursor.getCount());
            while (cursor.moveToNext()) {
                int n9 = cursor.getInt(n2);
                String string2 = cursor.isNull(n3) ? null : cursor.getString(n3);
                String string3 = cursor.isNull(n4) ? null : cursor.getString(n4);
                long l = cursor.getLong(n5);
                long l2 = cursor.getLong(n6);
                NotificationEntity notificationEntity = new NotificationEntity(n9, string2, string3, l, l2);
                notificationEntity.setSn(cursor.getInt(n));
                boolean bl = cursor.getInt(n7) != 0;
                notificationEntity.setRead(bl);
                notificationEntity.setFileId(cursor.getInt(n8));
                arrayList.add(notificationEntity);
            }
            return arrayList;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<NotificationEntity> loadNotificationListByStatus(int n) {
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire("SELECT * FROM result_notification WHERE status = ?", 1);
        roomSQLiteQuery.bindLong(1, n);
        this.__db.assertNotSuspendingTransaction();
        Cursor cursor = DBUtil.query(this.__db, roomSQLiteQuery, false, null);
        try {
            int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "sn");
            int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "status");
            int n4 = CursorUtil.getColumnIndexOrThrow(cursor, "title");
            n = CursorUtil.getColumnIndexOrThrow(cursor, "content");
            int n5 = CursorUtil.getColumnIndexOrThrow(cursor, "push_date");
            int n6 = CursorUtil.getColumnIndexOrThrow(cursor, "expire");
            int n7 = CursorUtil.getColumnIndexOrThrow(cursor, "is_read");
            int n8 = CursorUtil.getColumnIndexOrThrow(cursor, "fileId");
            ArrayList<NotificationEntity> arrayList = new ArrayList<NotificationEntity>(cursor.getCount());
            while (cursor.moveToNext()) {
                int n9 = cursor.getInt(n3);
                String string2 = cursor.isNull(n4) ? null : cursor.getString(n4);
                String string3 = cursor.isNull(n) ? null : cursor.getString(n);
                long l = cursor.getLong(n5);
                long l2 = cursor.getLong(n6);
                NotificationEntity notificationEntity = new NotificationEntity(n9, string2, string3, l, l2);
                notificationEntity.setSn(cursor.getInt(n2));
                boolean bl = cursor.getInt(n7) != 0;
                notificationEntity.setRead(bl);
                notificationEntity.setFileId(cursor.getInt(n8));
                arrayList.add(notificationEntity);
            }
            return arrayList;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    @Override
    public LiveData<List<NotificationEntity>> loadNotificationListLive() {
        Object object = RoomSQLiteQuery.acquire("SELECT * FROM result_notification order by push_date desc", 0);
        InvalidationTracker invalidationTracker = this.__db.getInvalidationTracker();
        object = new Callable<List<NotificationEntity>>((RoomSQLiteQuery)object){
            final /* synthetic */ RoomSQLiteQuery val$_statement;
            {
                this.val$_statement = roomSQLiteQuery;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<NotificationEntity> call() throws Exception {
                Cursor cursor = DBUtil.query(NotificationDao_Impl.this.__db, this.val$_statement, false, null);
                try {
                    int n = CursorUtil.getColumnIndexOrThrow(cursor, "sn");
                    int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "status");
                    int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "title");
                    int n4 = CursorUtil.getColumnIndexOrThrow(cursor, "content");
                    int n5 = CursorUtil.getColumnIndexOrThrow(cursor, "push_date");
                    int n6 = CursorUtil.getColumnIndexOrThrow(cursor, "expire");
                    int n7 = CursorUtil.getColumnIndexOrThrow(cursor, "is_read");
                    int n8 = CursorUtil.getColumnIndexOrThrow(cursor, "fileId");
                    ArrayList<NotificationEntity> arrayList = new ArrayList<NotificationEntity>(cursor.getCount());
                    while (cursor.moveToNext()) {
                        int n9 = cursor.getInt(n2);
                        String string2 = cursor.isNull(n3) ? null : cursor.getString(n3);
                        String string3 = cursor.isNull(n4) ? null : cursor.getString(n4);
                        long l = cursor.getLong(n5);
                        long l2 = cursor.getLong(n6);
                        NotificationEntity notificationEntity = new NotificationEntity(n9, string2, string3, l, l2);
                        notificationEntity.setSn(cursor.getInt(n));
                        boolean bl = cursor.getInt(n7) != 0;
                        notificationEntity.setRead(bl);
                        notificationEntity.setFileId(cursor.getInt(n8));
                        arrayList.add(notificationEntity);
                    }
                    return arrayList;
                }
                finally {
                    cursor.close();
                }
            }

            protected void finalize() {
                this.val$_statement.release();
            }
        };
        return invalidationTracker.createLiveData(new String[]{"result_notification"}, false, object);
    }

    @Override
    public void update(NotificationEntity notificationEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfNotificationEntity.handle(notificationEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateStatusAndTitleByFileId(int n, int n2, String string2, long l) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = this.__preparedStmtOfUpdateStatusAndTitleByFileId.acquire();
        supportSQLiteStatement.bindLong(1, n2);
        if (string2 == null) {
            supportSQLiteStatement.bindNull(2);
        } else {
            supportSQLiteStatement.bindString(2, string2);
        }
        supportSQLiteStatement.bindLong(3, l);
        supportSQLiteStatement.bindLong(4, n);
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateStatusAndTitleByFileId.release(supportSQLiteStatement);
        }
    }

    @Override
    public void updateStatusByFileId(int n, int n2, long l) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = this.__preparedStmtOfUpdateStatusByFileId.acquire();
        supportSQLiteStatement.bindLong(1, n2);
        supportSQLiteStatement.bindLong(2, l);
        supportSQLiteStatement.bindLong(3, n);
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateStatusByFileId.release(supportSQLiteStatement);
        }
    }
}

