/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.db.setting.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.brytonsport.active.db.setting.dao.DeviceManagerDao;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class DeviceManagerDao_Impl
extends DeviceManagerDao {
    private final RoomDatabase __db;
    private final EntityDeletionOrUpdateAdapter<DeviceManagerEntity> __deletionAdapterOfDeviceManagerEntity;
    private final EntityInsertionAdapter<DeviceManagerEntity> __insertionAdapterOfDeviceManagerEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final EntityDeletionOrUpdateAdapter<DeviceManagerEntity> __updateAdapterOfDeviceManagerEntity;

    public DeviceManagerDao_Impl(RoomDatabase roomDatabase) {
        this.__db = roomDatabase;
        this.__insertionAdapterOfDeviceManagerEntity = new EntityInsertionAdapter<DeviceManagerEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, DeviceManagerEntity deviceManagerEntity) {
                if (deviceManagerEntity.getMacAddress() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, deviceManagerEntity.getMacAddress());
                }
                if (deviceManagerEntity.getDevName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, deviceManagerEntity.getDevName());
                }
                if (deviceManagerEntity.getDevUuid() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, deviceManagerEntity.getDevUuid());
                }
                if (deviceManagerEntity.getDevVersion() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, deviceManagerEntity.getDevVersion());
                }
                if (deviceManagerEntity.getCapability() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, deviceManagerEntity.getCapability());
                }
                supportSQLiteStatement.bindLong(6, (long)deviceManagerEntity.isChoices());
                supportSQLiteStatement.bindLong(7, (long)deviceManagerEntity.isConnected());
                supportSQLiteStatement.bindLong(8, (long)deviceManagerEntity.isSptLiveTrack());
                supportSQLiteStatement.bindLong(9, (long)deviceManagerEntity.isSptGroupRide());
            }

            @Override
            public String createQuery() {
                return "INSERT OR REPLACE INTO `device_manager` (`macAddress`,`devName`,`devUuid`,`devVersion`,`capability`,`isChoices`,`isConnected`,`sptLiveTrack`,`sptGroupRide`) VALUES (?,?,?,?,?,?,?,?,?)";
            }
        };
        this.__deletionAdapterOfDeviceManagerEntity = new EntityDeletionOrUpdateAdapter<DeviceManagerEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, DeviceManagerEntity deviceManagerEntity) {
                if (deviceManagerEntity.getMacAddress() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, deviceManagerEntity.getMacAddress());
                }
            }

            @Override
            public String createQuery() {
                return "DELETE FROM `device_manager` WHERE `macAddress` = ?";
            }
        };
        this.__updateAdapterOfDeviceManagerEntity = new EntityDeletionOrUpdateAdapter<DeviceManagerEntity>(roomDatabase){

            @Override
            public void bind(SupportSQLiteStatement supportSQLiteStatement, DeviceManagerEntity deviceManagerEntity) {
                if (deviceManagerEntity.getMacAddress() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, deviceManagerEntity.getMacAddress());
                }
                if (deviceManagerEntity.getDevName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, deviceManagerEntity.getDevName());
                }
                if (deviceManagerEntity.getDevUuid() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, deviceManagerEntity.getDevUuid());
                }
                if (deviceManagerEntity.getDevVersion() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, deviceManagerEntity.getDevVersion());
                }
                if (deviceManagerEntity.getCapability() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, deviceManagerEntity.getCapability());
                }
                supportSQLiteStatement.bindLong(6, (long)deviceManagerEntity.isChoices());
                supportSQLiteStatement.bindLong(7, (long)deviceManagerEntity.isConnected());
                supportSQLiteStatement.bindLong(8, (long)deviceManagerEntity.isSptLiveTrack());
                supportSQLiteStatement.bindLong(9, (long)deviceManagerEntity.isSptGroupRide());
                if (deviceManagerEntity.getMacAddress() == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, deviceManagerEntity.getMacAddress());
                }
            }

            @Override
            public String createQuery() {
                return "UPDATE OR ABORT `device_manager` SET `macAddress` = ?,`devName` = ?,`devUuid` = ?,`devVersion` = ?,`capability` = ?,`isChoices` = ?,`isConnected` = ?,`sptLiveTrack` = ?,`sptGroupRide` = ? WHERE `macAddress` = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(roomDatabase){

            @Override
            public String createQuery() {
                return "DELETE FROM device_manager";
            }
        };
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    @Override
    public void delete(DeviceManagerEntity deviceManagerEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfDeviceManagerEntity.handle(deviceManagerEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(supportSQLiteStatement);
        }
    }

    @Override
    public void insert(DeviceManagerEntity deviceManagerEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfDeviceManagerEntity.insert(deviceManagerEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DeviceManagerEntity loadDeviceEntityByAddress(String object) {
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire("SELECT * FROM device_manager where macAddress = ?", 1);
        if (object == null) {
            roomSQLiteQuery.bindNull(1);
        } else {
            roomSQLiteQuery.bindString(1, (String)object);
        }
        this.__db.assertNotSuspendingTransaction();
        Object object2 = this.__db;
        object = null;
        String string2 = null;
        Cursor cursor = DBUtil.query((RoomDatabase)object2, roomSQLiteQuery, false, null);
        try {
            int n = CursorUtil.getColumnIndexOrThrow(cursor, "macAddress");
            int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "devName");
            int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "devUuid");
            int n4 = CursorUtil.getColumnIndexOrThrow(cursor, "devVersion");
            int n5 = CursorUtil.getColumnIndexOrThrow(cursor, "capability");
            int n6 = CursorUtil.getColumnIndexOrThrow(cursor, "isChoices");
            int n7 = CursorUtil.getColumnIndexOrThrow(cursor, "isConnected");
            int n8 = CursorUtil.getColumnIndexOrThrow(cursor, "sptLiveTrack");
            int n9 = CursorUtil.getColumnIndexOrThrow(cursor, "sptGroupRide");
            if (!cursor.moveToFirst()) return object;
            object = cursor.isNull(n) ? null : cursor.getString(n);
            object2 = cursor.isNull(n2) ? null : cursor.getString(n2);
            String string3 = cursor.isNull(n3) ? null : cursor.getString(n3);
            String string4 = cursor.isNull(n4) ? null : cursor.getString(n4);
            if (!cursor.isNull(n5)) {
                string2 = cursor.getString(n5);
            }
            boolean bl = cursor.getInt(n6) != 0;
            boolean bl2 = cursor.getInt(n7) != 0;
            boolean bl3 = cursor.getInt(n8) != 0;
            boolean bl4 = cursor.getInt(n9) != 0;
            object = new DeviceManagerEntity((String)object, (String)object2, string3, string4, string2, bl, bl2, bl3, bl4);
            return object;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DeviceManagerEntity loadDeviceEntityIsChoice() {
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire("SELECT * FROM device_manager where isChoices = 1 LIMIT 1", 0);
        this.__db.assertNotSuspendingTransaction();
        Object object = this.__db;
        Object object2 = null;
        String string2 = null;
        Cursor cursor = DBUtil.query((RoomDatabase)object, roomSQLiteQuery, false, null);
        try {
            int n = CursorUtil.getColumnIndexOrThrow(cursor, "macAddress");
            int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "devName");
            int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "devUuid");
            int n4 = CursorUtil.getColumnIndexOrThrow(cursor, "devVersion");
            int n5 = CursorUtil.getColumnIndexOrThrow(cursor, "capability");
            int n6 = CursorUtil.getColumnIndexOrThrow(cursor, "isChoices");
            int n7 = CursorUtil.getColumnIndexOrThrow(cursor, "isConnected");
            int n8 = CursorUtil.getColumnIndexOrThrow(cursor, "sptLiveTrack");
            int n9 = CursorUtil.getColumnIndexOrThrow(cursor, "sptGroupRide");
            if (!cursor.moveToFirst()) return object2;
            object2 = cursor.isNull(n) ? null : cursor.getString(n);
            object = cursor.isNull(n2) ? null : cursor.getString(n2);
            String string3 = cursor.isNull(n3) ? null : cursor.getString(n3);
            String string4 = cursor.isNull(n4) ? null : cursor.getString(n4);
            if (!cursor.isNull(n5)) {
                string2 = cursor.getString(n5);
            }
            boolean bl = cursor.getInt(n6) != 0;
            boolean bl2 = cursor.getInt(n7) != 0;
            boolean bl3 = cursor.getInt(n8) != 0;
            boolean bl4 = cursor.getInt(n9) != 0;
            object2 = new DeviceManagerEntity((String)object2, (String)object, string3, string4, string2, bl, bl2, bl3, bl4);
            return object2;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    @Override
    public LiveData<DeviceManagerEntity> loadDeviceEntityIsChoiceAndConnected() {
        Object object = RoomSQLiteQuery.acquire("SELECT * FROM device_manager where isChoices = 1 and isConnected = 1 LIMIT 1", 0);
        InvalidationTracker invalidationTracker = this.__db.getInvalidationTracker();
        object = new Callable<DeviceManagerEntity>((RoomSQLiteQuery)object){
            final /* synthetic */ RoomSQLiteQuery val$_statement;
            {
                this.val$_statement = roomSQLiteQuery;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public DeviceManagerEntity call() throws Exception {
                Object object = DeviceManagerDao_Impl.this.__db;
                Object object2 = this.val$_statement;
                Object object3 = null;
                String string2 = null;
                Cursor cursor = DBUtil.query((RoomDatabase)object, (SupportSQLiteQuery)object2, false, null);
                try {
                    int n = CursorUtil.getColumnIndexOrThrow(cursor, "macAddress");
                    int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "devName");
                    int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "devUuid");
                    int n4 = CursorUtil.getColumnIndexOrThrow(cursor, "devVersion");
                    int n5 = CursorUtil.getColumnIndexOrThrow(cursor, "capability");
                    int n6 = CursorUtil.getColumnIndexOrThrow(cursor, "isChoices");
                    int n7 = CursorUtil.getColumnIndexOrThrow(cursor, "isConnected");
                    int n8 = CursorUtil.getColumnIndexOrThrow(cursor, "sptLiveTrack");
                    int n9 = CursorUtil.getColumnIndexOrThrow(cursor, "sptGroupRide");
                    if (!cursor.moveToFirst()) return object3;
                    object3 = cursor.isNull(n) ? null : cursor.getString(n);
                    object = cursor.isNull(n2) ? null : cursor.getString(n2);
                    object2 = cursor.isNull(n3) ? null : cursor.getString(n3);
                    String string3 = cursor.isNull(n4) ? null : cursor.getString(n4);
                    if (!cursor.isNull(n5)) {
                        string2 = cursor.getString(n5);
                    }
                    boolean bl = cursor.getInt(n6) != 0;
                    boolean bl2 = cursor.getInt(n7) != 0;
                    boolean bl3 = cursor.getInt(n8) != 0;
                    boolean bl4 = cursor.getInt(n9) != 0;
                    object3 = new DeviceManagerEntity((String)object3, (String)object, (String)object2, string3, string2, bl, bl2, bl3, bl4);
                    return object3;
                }
                finally {
                    cursor.close();
                }
            }

            protected void finalize() {
                this.val$_statement.release();
            }
        };
        return invalidationTracker.createLiveData(new String[]{"device_manager"}, false, object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DeviceManagerEntity> loadDeviceManagerList() {
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire("SELECT * FROM device_manager", 0);
        this.__db.assertNotSuspendingTransaction();
        Cursor cursor = DBUtil.query(this.__db, roomSQLiteQuery, false, null);
        try {
            int n = CursorUtil.getColumnIndexOrThrow(cursor, "macAddress");
            int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "devName");
            int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "devUuid");
            int n4 = CursorUtil.getColumnIndexOrThrow(cursor, "devVersion");
            int n5 = CursorUtil.getColumnIndexOrThrow(cursor, "capability");
            int n6 = CursorUtil.getColumnIndexOrThrow(cursor, "isChoices");
            int n7 = CursorUtil.getColumnIndexOrThrow(cursor, "isConnected");
            int n8 = CursorUtil.getColumnIndexOrThrow(cursor, "sptLiveTrack");
            int n9 = CursorUtil.getColumnIndexOrThrow(cursor, "sptGroupRide");
            ArrayList<DeviceManagerEntity> arrayList = new ArrayList<DeviceManagerEntity>(cursor.getCount());
            while (cursor.moveToNext()) {
                String string2 = cursor.isNull(n) ? null : cursor.getString(n);
                String string3 = cursor.isNull(n2) ? null : cursor.getString(n2);
                String string4 = cursor.isNull(n3) ? null : cursor.getString(n3);
                String string5 = cursor.isNull(n4) ? null : cursor.getString(n4);
                String string6 = cursor.isNull(n5) ? null : cursor.getString(n5);
                boolean bl = cursor.getInt(n6) != 0;
                boolean bl2 = cursor.getInt(n7) != 0;
                boolean bl3 = cursor.getInt(n8) != 0;
                boolean bl4 = cursor.getInt(n9) != 0;
                DeviceManagerEntity deviceManagerEntity = new DeviceManagerEntity(string2, string3, string4, string5, string6, bl, bl2, bl3, bl4);
                arrayList.add(deviceManagerEntity);
            }
            return arrayList;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    @Override
    public LiveData<List<DeviceManagerEntity>> loadDeviceManagerListLive() {
        Object object = RoomSQLiteQuery.acquire("SELECT * FROM device_manager order by isChoices desc", 0);
        InvalidationTracker invalidationTracker = this.__db.getInvalidationTracker();
        object = new Callable<List<DeviceManagerEntity>>((RoomSQLiteQuery)object){
            final /* synthetic */ RoomSQLiteQuery val$_statement;
            {
                this.val$_statement = roomSQLiteQuery;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<DeviceManagerEntity> call() throws Exception {
                Cursor cursor = DBUtil.query(DeviceManagerDao_Impl.this.__db, this.val$_statement, false, null);
                try {
                    int n = CursorUtil.getColumnIndexOrThrow(cursor, "macAddress");
                    int n2 = CursorUtil.getColumnIndexOrThrow(cursor, "devName");
                    int n3 = CursorUtil.getColumnIndexOrThrow(cursor, "devUuid");
                    int n4 = CursorUtil.getColumnIndexOrThrow(cursor, "devVersion");
                    int n5 = CursorUtil.getColumnIndexOrThrow(cursor, "capability");
                    int n6 = CursorUtil.getColumnIndexOrThrow(cursor, "isChoices");
                    int n7 = CursorUtil.getColumnIndexOrThrow(cursor, "isConnected");
                    int n8 = CursorUtil.getColumnIndexOrThrow(cursor, "sptLiveTrack");
                    int n9 = CursorUtil.getColumnIndexOrThrow(cursor, "sptGroupRide");
                    ArrayList<DeviceManagerEntity> arrayList = new ArrayList<DeviceManagerEntity>(cursor.getCount());
                    while (cursor.moveToNext()) {
                        String string2 = cursor.isNull(n) ? null : cursor.getString(n);
                        String string3 = cursor.isNull(n2) ? null : cursor.getString(n2);
                        String string4 = cursor.isNull(n3) ? null : cursor.getString(n3);
                        String string5 = cursor.isNull(n4) ? null : cursor.getString(n4);
                        String string6 = cursor.isNull(n5) ? null : cursor.getString(n5);
                        boolean bl = cursor.getInt(n6) != 0;
                        boolean bl2 = cursor.getInt(n7) != 0;
                        boolean bl3 = cursor.getInt(n8) != 0;
                        boolean bl4 = cursor.getInt(n9) != 0;
                        DeviceManagerEntity deviceManagerEntity = new DeviceManagerEntity(string2, string3, string4, string5, string6, bl, bl2, bl3, bl4);
                        arrayList.add(deviceManagerEntity);
                    }
                    return arrayList;
                }
                finally {
                    cursor.close();
                }
            }

            protected void finalize() {
                this.val$_statement.release();
            }
        };
        return invalidationTracker.createLiveData(new String[]{"device_manager"}, false, object);
    }

    @Override
    public void update(DeviceManagerEntity deviceManagerEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfDeviceManagerEntity.handle(deviceManagerEntity);
            this.__db.setTransactionSuccessful();
            return;
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

