/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.fit;

import android.util.Log;
import com.garmin.fit.BrytonFitVersionMesg;
import com.garmin.fit.BrytonFitVersionMesgListener;
import com.garmin.fit.BrytonOverviewMesg;
import com.garmin.fit.BrytonOverviewMesgListener;
import com.garmin.fit.BrytonOverviewRecordMesg;
import com.garmin.fit.BrytonOverviewRecordMesgListener;
import com.garmin.fit.BrytonTrackMesg;
import com.garmin.fit.BrytonTrackMesgListener;
import com.garmin.fit.BrytonTrackRecordMesg;
import com.garmin.fit.BrytonTrackRecordMesgListener;
import com.garmin.fit.BrytonTurnMesg;
import com.garmin.fit.BrytonTurnMesgListener;
import com.garmin.fit.BrytonTurnRecordMesg;
import com.garmin.fit.BrytonTurnRecordMesgListener;
import com.garmin.fit.Decode;
import com.garmin.fit.FileEncoder;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgBroadcaster;
import com.garmin.fit.MesgDefinition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BrytonPlanTrip {
    private static final String TAG = "BrytonPlanTrip";
    List<BrytonTrackRecordMesg> brytonTrackRecordMesgList;
    List<BrytonTurnRecordMesg> brytonTurnRecordMesgList = new ArrayList<BrytonTurnRecordMesg>();
    Decode decode;
    FileEncoder encode;
    String fitFileName = "";
    BrytonFitVersionMesg fitVersionMesg;
    private int mIndex = 0;
    Integer maxAlt = -500;
    double maxLat = -90.0;
    double maxLon = -180.0;
    Integer minAlt = 10000;
    double minLat = 90.0;
    double minLon = 180.0;
    BrytonOverviewMesg overviewMesg;
    BrytonOverviewRecordMesg overviewRecordMesg;
    BrytonTrackMesg trackMesg;
    BrytonTrackRecordMesg trackRecordMesg;
    BrytonTurnMesg turnMesg;
    BrytonTurnRecordMesg turnRecordMesg;

    public BrytonPlanTrip() {
        BrytonFitVersionMesg brytonFitVersionMesg;
        this.brytonTrackRecordMesgList = new ArrayList<BrytonTrackRecordMesg>();
        this.fitVersionMesg = brytonFitVersionMesg = new BrytonFitVersionMesg();
        brytonFitVersionMesg.setLocalNum(7);
        brytonFitVersionMesg = new BrytonOverviewMesg();
        this.overviewMesg = brytonFitVersionMesg;
        brytonFitVersionMesg.setLocalNum(1);
        brytonFitVersionMesg = new BrytonOverviewRecordMesg();
        this.overviewRecordMesg = brytonFitVersionMesg;
        brytonFitVersionMesg.setLocalNum(2);
        brytonFitVersionMesg = new BrytonTurnMesg();
        this.turnMesg = brytonFitVersionMesg;
        brytonFitVersionMesg.setLocalNum(3);
        brytonFitVersionMesg = new BrytonTurnRecordMesg();
        this.turnRecordMesg = brytonFitVersionMesg;
        brytonFitVersionMesg.setLocalNum(4);
        brytonFitVersionMesg = new BrytonTrackMesg();
        this.trackMesg = brytonFitVersionMesg;
        brytonFitVersionMesg.setLocalNum(5);
        brytonFitVersionMesg = new BrytonTrackRecordMesg();
        this.trackRecordMesg = brytonFitVersionMesg;
        brytonFitVersionMesg.setLocalNum(6);
    }

    private void get_overviewRecord(JSONObject jSONObject) {
    }

    private void get_overview_after(JSONObject jSONObject) {
        try {
            if (this.overviewMesg.getGain() != null) {
                jSONObject.put("gain", Math.ceil(this.overviewMesg.getGain().intValue()));
            }
            if (this.overviewMesg.getLoss() != null) {
                jSONObject.put("loss", Math.ceil(this.overviewMesg.getLoss().intValue()));
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private void get_overview_before(JSONObject jSONObject) {
        if (this.overviewMesg.getTotalDistance() != null) {
            double d = this.overviewMesg.getTotalDistance();
            try {
                jSONObject.put("distance", Math.ceil(d));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    private void get_trackRecord(JSONObject jSONObject) {
        JSONArray jSONArray = new JSONArray();
        int n = this.brytonTrackRecordMesgList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = new JSONObject();
                BrytonTrackRecordMesg brytonTrackRecordMesg = this.brytonTrackRecordMesgList.get(i);
                jSONObject2.put("position_lat", (Object)String.valueOf(brytonTrackRecordMesg.getLatitude()));
                jSONObject2.put("position_long", (Object)String.valueOf(brytonTrackRecordMesg.getLongitude()));
                jSONObject2.put("altitude", (Object)String.valueOf(brytonTrackRecordMesg.getAltitude()));
                if (this.brytonTrackRecordMesgList.get(i).getGrade().floatValue() != Fit.SINT16_INVALID.floatValue()) {
                    jSONObject2.put("grade", Math.ceil(brytonTrackRecordMesg.getGrade().floatValue()));
                }
                jSONArray.put((Object)jSONObject2);
                continue;
            }
            try {
                jSONObject.put("points", (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    private void get_turn(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("steps_counter", (Object)this.turnMesg.getRecordCount());
            jSONObject.put("steps", (Object)jSONObject2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private void get_turnRecord(JSONObject jSONObject) {
        JSONArray jSONArray = new JSONArray();
        int n = this.brytonTurnRecordMesgList.size();
        if (n > 0) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                boolean bl3;
                block11: {
                    block10: {
                        JSONArray jSONArray2 = new JSONArray();
                        jSONArray2.put((Object)this.brytonTurnRecordMesgList.get(i).getTrackIndex());
                        jSONArray2.put((Object)this.brytonTurnRecordMesgList.get(i).getManeuver());
                        jSONArray2.put(Math.ceil(this.brytonTurnRecordMesgList.get(i).getDistance()));
                        jSONArray2.put((Object)this.brytonTurnRecordMesgList.get(i).getDuration());
                        jSONArray2.put((Object)this.brytonTurnRecordMesgList.get(i).getInstruction());
                        if (this.brytonTurnRecordMesgList.get(i).getManeuver() != 190 && this.brytonTurnRecordMesgList.get(i).getManeuver() != 191) {
                            jSONArray.put((Object)jSONArray2);
                        }
                        if (this.brytonTurnRecordMesgList.get(i).getManeuver() < 100) break block10;
                        bl3 = bl;
                        if (this.brytonTurnRecordMesgList.get(i).getManeuver() < 200) break block11;
                        bl3 = bl;
                        if (this.brytonTurnRecordMesgList.get(i).getManeuver() > 240) break block11;
                    }
                    bl3 = true;
                }
                if (this.brytonTurnRecordMesgList.get(i).getManeuver() == 190 || this.brytonTurnRecordMesgList.get(i).getManeuver() == 191) {
                    bl2 = true;
                }
                bl = bl3;
                continue;
            }
            try {
                jSONObject.put("steps", (Object)jSONArray);
                jSONObject.put("stepHasTurnInfoManeuver", bl);
                jSONObject.put("stepHasClimbProManeuver", bl2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    private void get_version(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("major", (Object)this.fitVersionMesg.getMajor());
            jSONObject2.put("minor", (Object)this.fitVersionMesg.getMinor());
            jSONObject.put("version", (Object)jSONObject2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private void overview(JSONObject jSONObject) {
        this.overviewMesg.addField();
        JSONArray jSONArray = jSONObject.getJSONArray("points");
        int n = 0;
        while (true) {
            block12: {
                int n2 = jSONArray.length();
                Integer n3 = null;
                if (n >= n2) break;
                double d = jSONArray.getJSONObject(n).getDouble("position_lat");
                double d2 = jSONArray.getJSONObject(n).getDouble("position_long");
                if (jSONArray.getJSONObject(n).has("altitude")) {
                    n3 = jSONArray.getJSONObject(n).getInt("altitude");
                }
                this.maxLat = Math.max(d, this.maxLat);
                this.minLat = Math.min(d, this.minLat);
                this.maxLon = Math.max(d2, this.maxLon);
                this.minLon = Math.min(d2, this.minLon);
                if (n3 == null) break block12;
                this.maxAlt = Math.max(n3, this.maxAlt);
                this.minAlt = Math.min(n3, this.minAlt);
            }
            ++n;
        }
        try {
            if (this.maxAlt == -500) {
                this.maxAlt = null;
            }
            if (this.minAlt == 1000) {
                this.minAlt = null;
            }
            this.overviewMesg.setRecordCount(Integer.valueOf(jSONArray.length()));
            this.overviewMesg.setMaxLat(Double.valueOf(this.maxLat));
            this.overviewMesg.setMinLat(Double.valueOf(this.minLat));
            this.overviewMesg.setMaxLon(Double.valueOf(this.maxLon));
            this.overviewMesg.setMinLon(Double.valueOf(this.minLon));
            n = (int)jSONObject.getDouble("distance");
            this.overviewMesg.setTotalDistance(Double.valueOf(n));
            this.overviewMesg.setMaxAlt(this.maxAlt);
            this.overviewMesg.setMinAlt(this.minAlt);
            if (jSONObject.has("gain")) {
                this.overviewMesg.addField("gain");
                this.overviewMesg.setGain(Integer.valueOf((int)jSONObject.getDouble("gain")));
            }
            if (jSONObject.has("loss")) {
                this.overviewMesg.addField("loss");
                this.overviewMesg.setLoss(Integer.valueOf((int)jSONObject.getDouble("loss")));
            }
            this.encode.write((Mesg)this.overviewMesg);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private void overviewRecord(JSONObject jSONObject) {
        int n;
        this.overviewRecordMesg.addField();
        try {
            jSONObject = jSONObject.getJSONArray("points");
            n = 0;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        while (true) {
            if (n < jSONObject.length()) {
                this.overviewRecordMesg.setTrackIndex(Integer.valueOf(n));
                this.encode.write((Mesg)this.overviewRecordMesg);
                ++n;
                continue;
            }
            break;
        }
    }

    private void release() {
        this.brytonTrackRecordMesgList.clear();
        this.brytonTurnRecordMesgList.clear();
    }

    private void track(JSONObject jSONObject) {
        this.trackMesg.addField();
        try {
            jSONObject = jSONObject.getJSONArray("points");
            this.trackMesg.setRecordCount(Integer.valueOf(jSONObject.length()));
            this.encode.write((Mesg)this.trackMesg);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void trackRecord(JSONObject jSONObject) {
        this.trackRecordMesg.addField();
        try {
            int n;
            int n2;
            JSONArray jSONArray;
            block10: {
                int n3;
                jSONArray = jSONObject.getJSONArray("points");
                n2 = 0;
                for (n = 0; n < (n3 = jSONArray.length()); ++n) {
                    if (!jSONArray.getJSONObject(n).has("grade")) continue;
                    this.trackRecordMesg.addField("grade");
                    n = 1;
                    break block10;
                }
                n = 0;
            }
            while (n2 < jSONArray.length()) {
                jSONObject = jSONArray.getJSONObject(n2);
                double d = jSONObject.getDouble("position_lat");
                double d2 = jSONObject.getDouble("position_long");
                jSONObject.getDouble("position_lat");
                jSONObject.getDouble("position_long");
                this.trackRecordMesg.setLatitude(Double.valueOf(d));
                this.trackRecordMesg.setLongitude(Double.valueOf(d2));
                if (jSONObject.has("altitude")) {
                    this.trackRecordMesg.setAltitude(Integer.valueOf(jSONObject.getInt("altitude")));
                } else {
                    this.trackRecordMesg.setAltitude(null);
                }
                if (n != 0) {
                    if (jSONObject.has("grade")) {
                        this.trackRecordMesg.setGrade(Float.valueOf((float)jSONObject.getDouble("grade")));
                    } else {
                        this.trackRecordMesg.setGrade(null);
                    }
                }
                this.encode.write((Mesg)this.trackRecordMesg);
                ++n2;
            }
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private void turn(JSONObject jSONObject) {
        this.turnMesg.addField();
        try {
            jSONObject = jSONObject.getJSONArray("steps");
            this.turnMesg.setRecordCount(Integer.valueOf(jSONObject.length()));
            this.encode.write((Mesg)this.turnMesg);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void turnRecord(JSONObject jSONObject) {
        this.turnRecordMesg.addField();
        Object object = new MesgDefinition((Mesg)this.turnRecordMesg);
        object.getField(1).setSize(2);
        object.getField(2).setSize(1);
        object.getField(3).setSize(4);
        object.getField(4).setSize(4);
        object.getField(5).setSize(32);
        this.encode.write(object);
        try {
            jSONObject = jSONObject.getJSONArray("steps");
            for (int n = 0; n < jSONObject.length(); object = object.getString(4), ++n) {
                object = jSONObject.getJSONArray(n);
                this.turnRecordMesg.setTrackIndex(Integer.valueOf(object.getInt(0)));
                this.turnRecordMesg.setManeuver(Integer.valueOf(object.getInt(1)));
                int n2 = (int)object.getDouble(2);
                this.turnRecordMesg.setDistance(Double.valueOf(n2));
                try {
                    this.turnRecordMesg.setDuration(Long.valueOf(object.getLong(3)));
                }
                catch (Exception exception) {
                    this.turnRecordMesg.setDuration(null);
                }
                this.turnRecordMesg.setInstruction((String)object);
                this.encode.write((Mesg)this.turnRecordMesg);
            }
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private void version(JSONObject jSONObject) {
        this.fitVersionMesg.addField();
        try {
            jSONObject = jSONObject.getJSONObject("version");
            this.fitVersionMesg.setMajor(Integer.valueOf(jSONObject.getInt("major")));
            this.fitVersionMesg.setMinor(Integer.valueOf(jSONObject.getInt("minor")));
            this.encode.write((Mesg)this.fitVersionMesg);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public boolean decode(JSONObject jSONObject) {
        MyListener myListener;
        FileInputStream fileInputStream;
        if (!new File(this.fitFileName).exists()) {
            Log.d((String)"Grad Debug", (String)"decode() fit file no exist.");
            return false;
        }
        try {
            fileInputStream = new FileInputStream(this.fitFileName);
            myListener = new MyListener();
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error opening file ");
            stringBuilder.append(this.fitFileName);
            stringBuilder.append(" [2]");
            throw new RuntimeException(stringBuilder.toString());
        }
        this.decode = new Decode();
        MesgBroadcaster mesgBroadcaster = new MesgBroadcaster(this.decode);
        mesgBroadcaster.addListener((BrytonFitVersionMesgListener)myListener);
        mesgBroadcaster.addListener((BrytonOverviewMesgListener)myListener);
        mesgBroadcaster.addListener((BrytonOverviewRecordMesgListener)myListener);
        mesgBroadcaster.addListener((BrytonTurnMesgListener)myListener);
        mesgBroadcaster.addListener((BrytonTurnRecordMesgListener)myListener);
        mesgBroadcaster.addListener((BrytonTrackMesgListener)myListener);
        mesgBroadcaster.addListener((BrytonTrackRecordMesgListener)myListener);
        try {
            mesgBroadcaster.run((InputStream)fileInputStream);
        }
        catch (FitRuntimeException fitRuntimeException) {
            System.err.print("Exception decoding file: ");
            System.err.println(fitRuntimeException.getMessage());
            try {
                fileInputStream.close();
                return false;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        try {
            fileInputStream.close();
            this.get_version(jSONObject);
            this.get_trackRecord(jSONObject);
            this.get_overview_before(jSONObject);
            this.get_turnRecord(jSONObject);
            this.get_overview_after(jSONObject);
            this.release();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        mesgBroadcaster.clear();
        Runtime.getRuntime().gc();
        return true;
    }

    public void encode(JSONObject jSONObject) {
        try {
            FileEncoder fileEncoder;
            File file = new File(this.fitFileName);
            this.encode = fileEncoder = new FileEncoder(file, Fit.ProtocolVersion.V1_0);
            this.version(jSONObject);
            this.overview(jSONObject);
            this.overviewRecord(jSONObject);
        }
        catch (FitRuntimeException fitRuntimeException) {
            System.err.println("Error opening file BrytonActivity.fit");
            return;
        }
        if (jSONObject.has("steps")) {
            this.turn(jSONObject);
            this.turnRecord(jSONObject);
        }
        this.track(jSONObject);
        this.trackRecord(jSONObject);
        try {
            this.encode.close();
        }
        catch (FitRuntimeException fitRuntimeException) {
            System.err.println("Error closing encode.");
            return;
        }
        Log.d((String)"Grad Debug", (String)"Bryton PlanTrip encode() is complete.");
    }

    public void encodeFileSet(String string2) {
        this.fitFileName = string2;
    }

    private class MyListener
    implements BrytonFitVersionMesgListener,
    BrytonOverviewMesgListener,
    BrytonOverviewRecordMesgListener,
    BrytonTurnMesgListener,
    BrytonTurnRecordMesgListener,
    BrytonTrackMesgListener,
    BrytonTrackRecordMesgListener {
        private MyListener() {
        }

        public void onMesg(BrytonFitVersionMesg brytonFitVersionMesg) {
            BrytonPlanTrip.this.fitVersionMesg = brytonFitVersionMesg;
        }

        public void onMesg(BrytonOverviewMesg brytonOverviewMesg) {
            BrytonPlanTrip.this.overviewMesg = brytonOverviewMesg;
        }

        public void onMesg(BrytonOverviewRecordMesg brytonOverviewRecordMesg) {
            BrytonPlanTrip.this.overviewRecordMesg = brytonOverviewRecordMesg;
        }

        public void onMesg(BrytonTrackMesg brytonTrackMesg) {
            BrytonPlanTrip.this.trackMesg = brytonTrackMesg;
        }

        public void onMesg(BrytonTrackRecordMesg brytonTrackRecordMesg) {
            BrytonPlanTrip.this.brytonTrackRecordMesgList.add(brytonTrackRecordMesg);
        }

        public void onMesg(BrytonTurnMesg brytonTurnMesg) {
            BrytonPlanTrip.this.turnMesg = brytonTurnMesg;
        }

        public void onMesg(BrytonTurnRecordMesg brytonTurnRecordMesg) {
            BrytonPlanTrip.this.brytonTurnRecordMesgList.add(brytonTurnRecordMesg);
        }
    }
}

