/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.fit;

import android.content.Context;
import android.util.Log;
import android.util.Pair;
import com.brytonsport.active.base.App;
import com.brytonsport.active.utils.ActivityFileUtil;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.vm.base.DoublePlanDetail;
import com.brytonsport.active.vm.base.PlanDetail;
import com.brytonsport.active.vm.base.TrainingPlan;
import com.garmin.fit.DateTime;
import com.garmin.fit.Decode;
import com.garmin.fit.File;
import com.garmin.fit.FileEncoder;
import com.garmin.fit.FileIdMesg;
import com.garmin.fit.FileIdMesgListener;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Intensity;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgBroadcaster;
import com.garmin.fit.Sport;
import com.garmin.fit.WktStepDuration;
import com.garmin.fit.WktStepTarget;
import com.garmin.fit.WorkoutMesg;
import com.garmin.fit.WorkoutMesgListener;
import com.garmin.fit.WorkoutStepMesg;
import com.garmin.fit.WorkoutStepMesgListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BrytonWorkout {
    private static final double CUSTOM_TARGET_SPEED_FACTOR = 1000.0;
    private static final long DATETIME_FACTOR = 1000L;
    private static final double DURATION_DISTANCE_FACTOR = 100.0;
    private static final double DURATION_TIME_DISTANCE_FACTOR = 1000.0;
    private static final double DURATION_TIME_TIME_FACTOR = 1.0;
    private static final int FILE_ID_MESG_LOCAL_NUM = 0;
    private static final String TAG = "BrytonWorkout";
    private static final int WORKOUTSTEP_MESG_LOCAL_NUM = 2;
    private static final int WORKOUT_MESG_LOCAL_NUM = 0;
    Decode decode;
    FileEncoder encode;
    String fitFileName = "";
    private double mDurationTimeFactor = 1.0;
    FileIdMesg mFileIdMesg;
    WorkoutMesg mWorkoutMesg;
    WorkoutStepMesg mWorkoutStepMesg;
    List<WorkoutStepMesg> mWorkoutStepMesgEncodeList;
    List<WorkoutStepMesg> mWorkoutStepMesgList = new ArrayList<WorkoutStepMesg>();

    public BrytonWorkout() {
        FileIdMesg fileIdMesg;
        this.mWorkoutStepMesgEncodeList = new ArrayList<WorkoutStepMesg>();
        this.mFileIdMesg = fileIdMesg = new FileIdMesg();
        fileIdMesg.setLocalNum(0);
        fileIdMesg = new WorkoutMesg();
        this.mWorkoutMesg = fileIdMesg;
        fileIdMesg.setLocalNum(0);
        fileIdMesg = new WorkoutStepMesg();
        this.mWorkoutStepMesg = fileIdMesg;
        fileIdMesg.setLocalNum(2);
    }

    public BrytonWorkout(TrainingPlan trainingPlan) {
        this.mWorkoutStepMesgEncodeList = new ArrayList<WorkoutStepMesg>();
        Object object = new FileIdMesg();
        this.mFileIdMesg = object;
        object.setType(File.WORKOUT);
        int n = trainingPlan.provider.equals(1) ? 255 : 267;
        this.mFileIdMesg.setManufacturer(Integer.valueOf(n));
        this.mFileIdMesg.setLocalNum(0);
        this.mFileIdMesg.setTimeCreated(new DateTime(trainingPlan.time / 1000L));
        object = new WorkoutMesg();
        this.mWorkoutMesg = object;
        object.setWktName(trainingPlan.name);
        object = trainingPlan.getComposedDetails(false);
        n = 0;
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            Object object2 = ((ArrayList)object).get(i);
            if (object2 instanceof PlanDetail) {
                object2 = (PlanDetail)object2;
                this.mDurationTimeFactor = 1.0;
                object2 = this.createWorkoutStepMesg((PlanDetail)object2, n, trainingPlan.isTargetBaseOnRange());
                this.mWorkoutStepMesgEncodeList.add((WorkoutStepMesg)object2);
            } else {
                int n2;
                object2 = (DoublePlanDetail)object2;
                WorkoutStepMesg workoutStepMesg = this.createWorkoutStepMesg(((DoublePlanDetail)object2).planDetail1, n, trainingPlan.isTargetBaseOnRange());
                this.mWorkoutStepMesgEncodeList.add(workoutStepMesg);
                long l = n;
                n = n2 = n + 1;
                if (((DoublePlanDetail)object2).planDetail2.intensityType != -1) {
                    workoutStepMesg = this.createWorkoutStepMesg(((DoublePlanDetail)object2).planDetail2, n2, trainingPlan.isTargetBaseOnRange());
                    this.mWorkoutStepMesgEncodeList.add(workoutStepMesg);
                    n = n2 + 1;
                }
                object2 = this.createWorkoutStepMesg((DoublePlanDetail)object2, n, l);
                this.mWorkoutStepMesgEncodeList.add((WorkoutStepMesg)object2);
            }
            ++n;
        }
        this.mWorkoutMesg.setNumValidSteps(Integer.valueOf(n));
        this.mWorkoutMesg.setSport(Sport.CYCLING);
        this.mWorkoutMesg.setLocalNum(0);
        trainingPlan = new WorkoutStepMesg();
        this.mWorkoutStepMesg = trainingPlan;
        trainingPlan.setLocalNum(2);
    }

    private WorkoutStepMesg createWorkoutStepMesg(DoublePlanDetail doublePlanDetail, int n, long l) {
        WorkoutStepMesg workoutStepMesg = new WorkoutStepMesg();
        workoutStepMesg.setLocalNum(2);
        workoutStepMesg.setMessageIndex(Integer.valueOf(n));
        workoutStepMesg.setDurationStep(Long.valueOf(l));
        workoutStepMesg.setRepeatSteps(Long.valueOf(doublePlanDetail.repeat));
        workoutStepMesg.setDurationType(WktStepDuration.REPEAT_UNTIL_STEPS_CMPLT);
        return workoutStepMesg;
    }

    private WorkoutStepMesg createWorkoutStepMesg(PlanDetail planDetail, int n, boolean bl) {
        WktStepTarget wktStepTarget;
        WorkoutStepMesg workoutStepMesg = new WorkoutStepMesg();
        workoutStepMesg.setLocalNum(2);
        workoutStepMesg.setWktStepName(planDetail.getTypeName());
        WktStepDuration wktStepDuration = planDetail.durationType;
        if (planDetail.intensityType() != Intensity.INVALID) {
            if (wktStepDuration == WktStepDuration.Distance) {
                this.mDurationTimeFactor = 1000.0;
                workoutStepMesg.setDurationDistance(Float.valueOf((float)((double)planDetail.durationDistance() * 1000.0)));
            } else if (wktStepDuration == WktStepDuration.Time) {
                wktStepTarget = planDetail.targetType;
                if (wktStepTarget == WktStepTarget.Cadence || wktStepTarget == WktStepTarget.MAP || wktStepTarget == WktStepTarget.FTP || wktStepTarget == WktStepTarget.LTHR || wktStepTarget == WktStepTarget.MHR || wktStepTarget == WktStepTarget.Power || wktStepTarget == WktStepTarget.Speed || wktStepTarget == WktStepTarget.HEART_RATE) {
                    this.mDurationTimeFactor = 1000.0;
                    workoutStepMesg.setDurationTime(Float.valueOf((float)((double)planDetail.durationTime() * this.mDurationTimeFactor)));
                }
            } else {
                wktStepTarget = WktStepDuration.OPEN;
            }
        }
        if ((wktStepTarget = planDetail.targetType) != WktStepTarget.OPEN) {
            workoutStepMesg.setTargetValue(Long.valueOf(0L));
        }
        if (bl) {
            Pair<Float, Float> pair = planDetail.intensityValue;
            if (wktStepTarget != WktStepTarget.FTP && wktStepTarget != WktStepTarget.MAP && wktStepTarget != WktStepTarget.LTHR && wktStepTarget != WktStepTarget.MHR) {
                if (wktStepTarget == WktStepTarget.Power) {
                    workoutStepMesg.setCustomTargetPowerLow(Long.valueOf((long)(((Float)pair.first).floatValue() + 1000.0f)));
                    workoutStepMesg.setCustomTargetPowerHigh(Long.valueOf((long)(((Float)pair.second).floatValue() + 1000.0f)));
                } else if (wktStepTarget == WktStepTarget.Cadence) {
                    workoutStepMesg.setCustomTargetCadenceLow(Long.valueOf((long)((Float)pair.first).floatValue()));
                    workoutStepMesg.setCustomTargetCadenceHigh(Long.valueOf((long)((Float)pair.second).floatValue()));
                } else if (wktStepTarget == WktStepTarget.HEART_RATE) {
                    workoutStepMesg.setCustomTargetHeartRateLow(Long.valueOf((long)((Float)pair.first).floatValue() + 100L));
                    workoutStepMesg.setCustomTargetHeartRateHigh(Long.valueOf((long)((Float)pair.second).floatValue() + 100L));
                } else if (wktStepTarget == WktStepTarget.Speed) {
                    workoutStepMesg.setCustomTargetSpeedLow(Float.valueOf(((Float)pair.first).floatValue() / 3.6f));
                    workoutStepMesg.setCustomTargetSpeedHigh(Float.valueOf(((Float)pair.second).floatValue() / 3.6f));
                }
            } else {
                workoutStepMesg.setCustomTargetValueLow(Long.valueOf((long)(((Float)pair.first).floatValue() + 100000.0f)));
                workoutStepMesg.setCustomTargetValueHigh(Long.valueOf((long)(((Float)pair.second).floatValue() + 100000.0f)));
            }
        } else {
            Float f = (Float)planDetail.intensityValue.first;
            if (wktStepTarget != WktStepTarget.FTP && wktStepTarget != WktStepTarget.MAP && wktStepTarget != WktStepTarget.LTHR && wktStepTarget != WktStepTarget.MHR) {
                if (wktStepTarget == WktStepTarget.Power) {
                    workoutStepMesg.setTargetValue(Long.valueOf(f.longValue() + 1000L));
                    workoutStepMesg.setCustomTargetPowerLow(Long.valueOf(f.longValue() + 1000L));
                    workoutStepMesg.setCustomTargetPowerHigh(Long.valueOf(f.longValue() + 1000L));
                } else if (wktStepTarget == WktStepTarget.Cadence) {
                    workoutStepMesg.setCustomTargetCadenceLow(Long.valueOf(f.longValue()));
                    workoutStepMesg.setCustomTargetCadenceHigh(Long.valueOf(f.longValue()));
                } else if (wktStepTarget == WktStepTarget.HEART_RATE) {
                    workoutStepMesg.setCustomTargetHeartRateLow(Long.valueOf(f.longValue() + 100L));
                    workoutStepMesg.setCustomTargetHeartRateHigh(Long.valueOf(f.longValue() + 100L));
                } else if (wktStepTarget == WktStepTarget.Speed) {
                    workoutStepMesg.setCustomTargetSpeedLow(Float.valueOf(f.floatValue() / 3.6f));
                    workoutStepMesg.setCustomTargetSpeedHigh(Float.valueOf(f.floatValue() / 3.6f));
                }
            } else {
                workoutStepMesg.setTargetValue(Long.valueOf(f.longValue() + 100000L));
                workoutStepMesg.setCustomTargetValueLow(Long.valueOf(f.longValue() + 100000L));
                workoutStepMesg.setCustomTargetValueHigh(Long.valueOf(f.longValue() + 100000L));
            }
        }
        workoutStepMesg.setMessageIndex(Integer.valueOf(n));
        workoutStepMesg.setDurationType(wktStepDuration);
        if (wktStepTarget != WktStepTarget.OPEN) {
            workoutStepMesg.setTargetType(wktStepTarget);
        }
        workoutStepMesg.setIntensity(planDetail.intensityType());
        return workoutStepMesg;
    }

    public static BrytonWorkout decodeFitToJson(String object, String string2) {
        block3: {
            Object object2 = App.getInstance().getFilesDir();
            CharSequence charSequence = new StringBuilder();
            charSequence.append(object2);
            charSequence.append(java.io.File.separator);
            charSequence.append((String)object);
            charSequence.append(java.io.File.separator);
            charSequence.append(string2);
            charSequence.append(".fit");
            charSequence = charSequence.toString();
            object = new BrytonWorkout();
            ((BrytonWorkout)object).encodeFileSet((String)charSequence);
            charSequence = new JSONObject();
            try {
                if (!((BrytonWorkout)object).decode((JSONObject)charSequence)) break block3;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("");
                ((StringBuilder)object2).append(string2);
                ((StringBuilder)object2).append(" decode ok");
                Log.d((String)TAG, (String)((StringBuilder)object2).toString());
                object2 = App.getInstance();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(java.io.File.separator);
                stringBuilder.append("workoutjson");
                String string3 = stringBuilder.toString();
                stringBuilder = new StringBuilder();
                stringBuilder.append(string2);
                stringBuilder.append(".json");
                ActivityFileUtil.writeJsonFile((Context)object2, string3, (JSONObject)charSequence, stringBuilder.toString());
                return object;
            }
            catch (Exception exception) {
                object = new StringBuilder();
                ((StringBuilder)object).append("");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" decode Exception: ");
                ((StringBuilder)object).append(exception.getMessage());
                Log.d((String)TAG, (String)((StringBuilder)object).toString());
                return null;
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" decode error");
        Log.d((String)TAG, (String)((StringBuilder)object).toString());
        return null;
    }

    private void fileIdMesgFind(JSONObject jSONObject) {
        this.mFileIdMesg.setType(File.WORKOUT);
        this.mFileIdMesg.setManufacturer(Integer.valueOf(267));
        try {
            long l = jSONObject.getLong("time_create");
            jSONObject = new DateTime(l * 1000L);
            this.mFileIdMesg.setTimeCreated((DateTime)jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public static Intensity getIntensityFromString(String string2) {
        for (Intensity intensity : Intensity.values()) {
            if (!string2.equals(BrytonWorkout.getIntensityStringValue(intensity))) continue;
            return intensity;
        }
        return Intensity.INVALID;
    }

    public static String getIntensityStringValue(Intensity intensity) {
        int n = 1.$SwitchMap$com$garmin$fit$Intensity[intensity.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) {
                        return "";
                    }
                    return "cooldown";
                }
                return "warmup";
            }
            return "rest";
        }
        return "active";
    }

    public static String getTargetTypeByI18N(String string2) {
        string2 = string2.equals(i18N.get("Speed")) ? "speed" : (string2.equals(i18N.get("Cadence")) ? "cadence" : string2.toLowerCase());
        return string2;
    }

    public static WktStepDuration getWktStepDurationFromString(String string2) {
        for (WktStepDuration wktStepDuration : WktStepDuration.values()) {
            if (!string2.equals(BrytonWorkout.getWktStepDurationStringValue(wktStepDuration))) continue;
            return wktStepDuration;
        }
        return WktStepDuration.INVALID;
    }

    public static String getWktStepDurationStringValue(WktStepDuration wktStepDuration) {
        int n = 1.$SwitchMap$com$garmin$fit$WktStepDuration[wktStepDuration.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) {
                        return "";
                    }
                    return "open";
                }
                return "distance";
            }
            return "repeat_until_steps_cmplt";
        }
        return "time";
    }

    public static WktStepTarget getWktStepTargetFromString(String string2) {
        for (WktStepTarget wktStepTarget : WktStepTarget.values()) {
            String string3 = BrytonWorkout.getWktStepTargetStringValue(wktStepTarget);
            String string4 = BrytonWorkout.getTargetTypeByI18N(string2);
            if (!string3.toLowerCase().equals(string4)) continue;
            return wktStepTarget;
        }
        return WktStepTarget.INVALID;
    }

    public static String getWktStepTargetStringValue(WktStepTarget wktStepTarget) {
        switch (1.$SwitchMap$com$garmin$fit$WktStepTarget[wktStepTarget.ordinal()]) {
            default: {
                return "";
            }
            case 8: {
                return "cadence";
            }
            case 7: {
                return "heart_rate";
            }
            case 6: {
                return "map";
            }
            case 5: {
                return "speed";
            }
            case 4: {
                return "power";
            }
            case 3: {
                return "mhr";
            }
            case 2: {
                return "lthr";
            }
            case 1: 
        }
        return "ftp";
    }

    private Intensity intensityStringToIntensity(String string2) {
        Intensity intensity = Intensity.INVALID;
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 3496916: {
                if (!string2.equals("rest")) break;
                n2 = 3;
                break;
            }
            case -546109589: {
                if (!string2.equals("cooldown")) break;
                n2 = 2;
                break;
            }
            case -795012128: {
                if (!string2.equals("warmup")) break;
                n2 = 1;
                break;
            }
            case -1422950650: {
                if (!string2.equals("active")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                string2 = intensity;
                break;
            }
            case 3: {
                string2 = Intensity.REST;
                break;
            }
            case 2: {
                string2 = Intensity.COOLDOWN;
                break;
            }
            case 1: {
                string2 = Intensity.WARMUP;
                break;
            }
            case 0: {
                string2 = Intensity.ACTIVE;
            }
        }
        return string2;
    }

    private String intensityToString(Intensity intensity) {
        String string2 = intensity == Intensity.WARMUP ? "warmup" : "";
        if (intensity == Intensity.COOLDOWN) {
            string2 = "cooldown";
        }
        if (intensity == Intensity.REST) {
            string2 = "rest";
        }
        if (intensity == Intensity.ACTIVE) {
            string2 = "active";
        }
        return string2;
    }

    private void manufacturer_id_get(JSONObject jSONObject) {
        try {
            if (this.mFileIdMesg.getManufacturer() != null) {
                jSONObject.put("manufacturer_id", (Object)String.valueOf(this.mFileIdMesg.getManufacturer()));
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private void release() {
        this.mWorkoutStepMesgList.clear();
        this.mWorkoutStepMesgEncodeList.clear();
    }

    private Sport sportStringToSport(String string2) {
        Sport sport = Sport.INVALID;
        string2.hashCode();
        string2 = !string2.equals("cycling") ? sport : Sport.CYCLING;
        return string2;
    }

    private String sportToString(Sport object) {
        object = object == Sport.CYCLING ? "cycling" : "";
        return object;
    }

    private void time_create_get(JSONObject jSONObject) {
        try {
            if (this.mFileIdMesg.getTimeCreated() != null) {
                jSONObject.put("time_create", this.mFileIdMesg.getTimeCreated().getDate().getTime() / 1000L);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private void type_get(JSONObject jSONObject) {
        try {
            if (this.mFileIdMesg.getType() != null && this.mFileIdMesg.getType() == File.WORKOUT) {
                jSONObject.put("type", 5);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private WktStepDuration wktStepDurationStringToWktStepDuration(String string2) {
        WktStepDuration wktStepDuration = WktStepDuration.INVALID;
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 288459765: {
                if (!string2.equals("distance")) break;
                n2 = 3;
                break;
            }
            case 3560141: {
                if (!string2.equals("time")) break;
                n2 = 2;
                break;
            }
            case 3417674: {
                if (!string2.equals("open")) break;
                n2 = 1;
                break;
            }
            case -916186831: {
                if (!string2.equals("repeat_until_steps_cmplt")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                string2 = wktStepDuration;
                break;
            }
            case 3: {
                string2 = WktStepDuration.Distance;
                break;
            }
            case 2: {
                string2 = WktStepDuration.Time;
                break;
            }
            case 1: {
                string2 = WktStepDuration.OPEN;
                break;
            }
            case 0: {
                string2 = WktStepDuration.REPEAT_UNTIL_STEPS_CMPLT;
            }
        }
        return string2;
    }

    private WktStepTarget wktStepTargetStringToWktStepTarget(String string2) {
        WktStepTarget wktStepTarget = WktStepTarget.INVALID;
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1930449209: {
                if (!string2.equals("heart_rate")) break;
                n2 = 17;
                break;
            }
            case 1863800889: {
                if (!string2.equals("resistance")) break;
                n2 = 16;
                break;
            }
            case 858556442: {
                if (!string2.equals("power_3s")) break;
                n2 = 15;
                break;
            }
            case 845500257: {
                if (!string2.equals("power_lap")) break;
                n2 = 14;
                break;
            }
            case 845443964: {
                if (!string2.equals("power_30s")) break;
                n2 = 13;
                break;
            }
            case 845442042: {
                if (!string2.equals("power_10s")) break;
                n2 = 12;
                break;
            }
            case 541048721: {
                if (!string2.equals("cadence")) break;
                n2 = 11;
                break;
            }
            case 109641799: {
                if (!string2.equals("speed")) break;
                n2 = 10;
                break;
            }
            case 106858757: {
                if (!string2.equals("power")) break;
                n2 = 9;
                break;
            }
            case 98615255: {
                if (!string2.equals("grade")) break;
                n2 = 8;
                break;
            }
            case 3417674: {
                if (!string2.equals("open")) break;
                n2 = 7;
                break;
            }
            case 3332242: {
                if (!string2.equals("lthr")) break;
                n2 = 6;
                break;
            }
            case 108087: {
                if (!string2.equals("mhr")) break;
                n2 = 5;
                break;
            }
            case 107868: {
                if (!string2.equals("map")) break;
                n2 = 4;
                break;
            }
            case 101730: {
                if (!string2.equals("ftp")) break;
                n2 = 3;
                break;
            }
            case -401147953: {
                if (!string2.equals("swim_stroke")) break;
                n2 = 2;
                break;
            }
            case -472916587: {
                if (!string2.equals("heart_rate_lap")) break;
                n2 = 1;
                break;
            }
            case -1642179165: {
                if (!string2.equals("speed_lap")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                string2 = wktStepTarget;
                break;
            }
            case 17: {
                string2 = WktStepTarget.HEART_RATE;
                break;
            }
            case 16: {
                string2 = WktStepTarget.RESISTANCE;
                break;
            }
            case 15: {
                string2 = WktStepTarget.POWER_3S;
                break;
            }
            case 14: {
                string2 = WktStepTarget.POWER_LAP;
                break;
            }
            case 13: {
                string2 = WktStepTarget.POWER_30S;
                break;
            }
            case 12: {
                string2 = WktStepTarget.POWER_10S;
                break;
            }
            case 11: {
                string2 = WktStepTarget.Cadence;
                break;
            }
            case 10: {
                string2 = WktStepTarget.Speed;
                break;
            }
            case 9: {
                string2 = WktStepTarget.Power;
                break;
            }
            case 8: {
                string2 = WktStepTarget.GRADE;
                break;
            }
            case 7: {
                string2 = WktStepTarget.OPEN;
                break;
            }
            case 6: {
                string2 = WktStepTarget.LTHR;
                break;
            }
            case 5: {
                string2 = WktStepTarget.MHR;
                break;
            }
            case 4: {
                string2 = WktStepTarget.MAP;
                break;
            }
            case 3: {
                string2 = WktStepTarget.FTP;
                break;
            }
            case 2: {
                string2 = WktStepTarget.SWIM_STROKE;
                break;
            }
            case 1: {
                string2 = WktStepTarget.HEART_RATE_LAP;
                break;
            }
            case 0: {
                string2 = WktStepTarget.SPEED_LAP;
            }
        }
        return string2;
    }

    private void workoutMesgFind(JSONObject jSONObject) {
        try {
            if (jSONObject.has("workout")) {
                if ((jSONObject = jSONObject.getJSONObject("workout")).has("wkt_name")) {
                    this.mWorkoutMesg.setWktName(jSONObject.getString("wkt_name"));
                }
                if (jSONObject.has("num_valid_steps")) {
                    this.mWorkoutMesg.setNumValidSteps(Integer.valueOf(jSONObject.getInt("num_valid_steps")));
                }
                if (jSONObject.has("sport")) {
                    jSONObject = this.sportStringToSport(jSONObject.getString("sport"));
                    this.mWorkoutMesg.setSport((Sport)jSONObject);
                }
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void workoutStepMesgFind(JSONObject object) {
        String string2 = "custom_target_power_high";
        String string3 = "custom_target_power_low";
        String string4 = "target_power_zone";
        String string5 = "custom_target_cadence_low";
        String string6 = "duration_distance";
        String string7 = "custom_target_speed_high";
        String string8 = "wkt_step_name";
        String string9 = "custom_target_speed_low";
        String string10 = "custom_target_heart_rate_high";
        String string11 = "target_value";
        String string12 = "custom_target_heart_rate_low";
        try {
            if (!object.has("workout_steps")) return;
            JSONArray jSONArray = object.getJSONArray("workout_steps");
            String string13 = "target_hr_zone";
            String string14 = string12;
            for (int i = 0; i < jSONArray.length(); ++i) {
                boolean bl;
                this.mDurationTimeFactor = 1.0;
                WorkoutStepMesg workoutStepMesg = new WorkoutStepMesg();
                workoutStepMesg.setLocalNum(2);
                workoutStepMesg.setMessageIndex(Integer.valueOf(i));
                string12 = jSONArray.getJSONObject(i);
                if (string12.has(string8)) {
                    workoutStepMesg.setWktStepName(string12.getString(string8));
                }
                if (string12.has(string6)) {
                    workoutStepMesg.setDurationDistance(Float.valueOf((float)string12.getDouble(string6)));
                }
                if (bl = string12.has("duration_type")) {
                    WktStepDuration wktStepDuration = this.wktStepDurationStringToWktStepDuration(string12.getString("duration_type"));
                    if (wktStepDuration == WktStepDuration.Distance) {
                        this.mDurationTimeFactor = 1000.0;
                    }
                    if (wktStepDuration == WktStepDuration.Time && string12.has("target_type") && ((wktStepDuration = this.wktStepTargetStringToWktStepTarget(string12.getString("target_type"))) == WktStepTarget.Cadence || wktStepDuration == WktStepTarget.MAP || wktStepDuration == WktStepTarget.FTP || wktStepDuration == WktStepTarget.LTHR || wktStepDuration == WktStepTarget.MHR || wktStepDuration == WktStepTarget.Power || wktStepDuration == WktStepTarget.Speed || wktStepDuration == WktStepTarget.HEART_RATE)) {
                        this.mDurationTimeFactor = 1000.0;
                    }
                }
                if (string12.has("duration_time")) {
                    workoutStepMesg.setDurationTime(Float.valueOf((float)(string12.getDouble("duration_time") * this.mDurationTimeFactor)));
                }
                if (string12.has(string11) && !string12.getString(string11).equals("null")) {
                    workoutStepMesg.setTargetValue(Long.valueOf(string12.getInt(string11)));
                }
                if (string12.has("duration_step")) {
                    workoutStepMesg.setDurationStep(Long.valueOf(string12.getInt("duration_step")));
                }
                if (string12.has("repeat_steps")) {
                    workoutStepMesg.setRepeatSteps(Long.valueOf(string12.getInt("repeat_steps")));
                }
                if (!string12.isNull("custom_target_value_low")) {
                    workoutStepMesg.setCustomTargetValueLow(Long.valueOf(string12.getInt("custom_target_value_low")));
                }
                if (!string12.isNull("custom_target_value_high")) {
                    workoutStepMesg.setCustomTargetValueHigh(Long.valueOf(string12.getInt("custom_target_value_high")));
                }
                if (!string12.isNull(string4)) {
                    workoutStepMesg.setTargetPowerZone(Long.valueOf(string12.getInt(string4)));
                }
                if (!string12.isNull(string3)) {
                    workoutStepMesg.setCustomTargetPowerLow(Long.valueOf(string12.getInt(string3)));
                }
                if (!string12.isNull(string2)) {
                    workoutStepMesg.setCustomTargetPowerHigh(Long.valueOf(string12.getInt(string2)));
                }
                if (!string12.isNull(string13)) {
                    workoutStepMesg.setTargetHrZone(Long.valueOf(string12.getInt(string13)));
                }
                if (!string12.isNull(string14)) {
                    workoutStepMesg.setCustomTargetHeartRateLow(Long.valueOf(string12.getInt(string14)));
                }
                if (!string12.isNull(string10)) {
                    workoutStepMesg.setCustomTargetHeartRateHigh(Long.valueOf(string12.getInt(string10)));
                }
                if (!(bl = string12.isNull(string9))) {
                    workoutStepMesg.setCustomTargetSpeedLow(Float.valueOf((float)string12.getDouble(string9)));
                }
                if (!string12.isNull(string7)) {
                    workoutStepMesg.setCustomTargetSpeedHigh(Float.valueOf((float)string12.getDouble(string7)));
                }
                if (!string12.isNull(string5)) {
                    workoutStepMesg.setCustomTargetCadenceLow(Long.valueOf(string12.getInt(string5)));
                }
                if (!string12.isNull("custom_target_cadence_high")) {
                    workoutStepMesg.setCustomTargetCadenceHigh(Long.valueOf(string12.getInt("custom_target_cadence_high")));
                }
                if (string12.has("message_index")) {
                    workoutStepMesg.setMessageIndex(Integer.valueOf(string12.getInt("message_index")));
                }
                if (string12.has("duration_type")) {
                    workoutStepMesg.setDurationType(this.wktStepDurationStringToWktStepDuration(string12.getString("duration_type")));
                }
                if (string12.has("target_type")) {
                    workoutStepMesg.setTargetType(this.wktStepTargetStringToWktStepTarget(string12.getString("target_type")));
                }
                if (string12.has("intensity")) {
                    workoutStepMesg.setIntensity(this.intensityStringToIntensity(string12.getString("intensity")));
                }
                this.mWorkoutStepMesgEncodeList.add(workoutStepMesg);
            }
            return;
        }
        catch (JSONException jSONException) {
            Log.d((String)"Grad Debug", (String)"workoutStepMesgFind() error.");
            jSONException.printStackTrace();
        }
    }

    private void workout_get(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            if (this.mWorkoutMesg.getWktName() != null) {
                jSONObject2.put("wkt_name", (Object)this.mWorkoutMesg.getWktName());
            }
            if (this.mWorkoutMesg.getNumValidSteps() != null) {
                jSONObject2.put("num_valid_steps", (Object)this.mWorkoutMesg.getNumValidSteps());
            }
            if (this.mWorkoutMesg.getSport() != null) {
                jSONObject2.put("sport", (Object)this.sportToString(this.mWorkoutMesg.getSport()));
            }
            jSONObject.put("workout", (Object)jSONObject2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void workout_steps_get(JSONObject var1_1) {
        block54: {
            var2_3 = new JSONArray();
            var3_4 = this.mWorkoutStepMesgList.size();
            if (var3_4 <= 0) break block54;
            for (var4_5 = 0; var4_5 < var3_4; ++var4_5) {
                block55: {
                    block53: {
                        block52: {
                            var5_6 = new JSONObject();
                            var6_7 = WktStepDuration.INVALID;
                            var7_8 = WktStepTarget.INVALID;
                            this.mDurationTimeFactor = 1.0;
                            if (this.mWorkoutStepMesgList.get(var4_5).getDurationType() == null) break block52;
                            var8_9 = this.mWorkoutStepMesgList.get(var4_5).getDurationType();
                            var6_7 = var8_9;
                            if (var8_9 != WktStepDuration.Distance) break block52;
                            this.mDurationTimeFactor = 1000.0;
                            var6_7 = var8_9;
                        }
                        var8_9 = var7_8;
                        if (var6_7 == WktStepDuration.OPEN) break block53;
                        var8_9 = var7_8;
                        if (var6_7 == WktStepDuration.REPEAT_UNTIL_STEPS_CMPLT) break block53;
                        if (this.mWorkoutStepMesgList.get(var4_5).getTargetType() != null) {
                            var7_8 = this.mWorkoutStepMesgList.get(var4_5).getTargetType();
                        }
                        if (var6_7 == WktStepDuration.Time && var7_8 == WktStepTarget.Cadence || var6_7 == WktStepDuration.Time && var7_8 == WktStepTarget.MAP || var6_7 == WktStepDuration.Time && var7_8 == WktStepTarget.FTP || var6_7 == WktStepDuration.Time && var7_8 == WktStepTarget.LTHR || var6_7 == WktStepDuration.Time && var7_8 == WktStepTarget.MHR || var6_7 == WktStepDuration.Time && var7_8 == WktStepTarget.Power || var6_7 == WktStepDuration.Time && var7_8 == WktStepTarget.Speed || var6_7 == WktStepDuration.Time && var7_8 == WktStepTarget.HEART_RATE) ** GOTO lbl33
                        var8_9 = var7_8;
                        if (var6_7 != WktStepDuration.Time) break block53;
                        var8_9 = var7_8;
                        if (var7_8 != WktStepTarget.INVALID) break block53;
lbl33:
                        // 2 sources

                        this.mDurationTimeFactor = 1000.0;
                        var8_9 = var7_8;
                    }
                    if (this.mWorkoutStepMesgList.get(var4_5).getWktStepName() != null && !this.mWorkoutStepMesgList.get(var4_5).getWktStepName().equals("null")) {
                        var5_6.put("wkt_step_name", (Object)this.mWorkoutStepMesgList.get(var4_5).getWktStepName());
                    }
                    if (var6_7 != (var7_8 = WktStepDuration.Time)) ** GOTO lbl49
                    if (this.mWorkoutStepMesgList.get(var4_5).getDurationTime() != null) {
                        var5_6.put("duration_time", (double)((float)((double)this.mWorkoutStepMesgList.get(var4_5).getDurationTime().floatValue() / this.mDurationTimeFactor)));
                    }
                    if (var8_9 == WktStepTarget.Cadence && this.mWorkoutStepMesgList.get(var4_5).getTargetValue() != null) {
                        var5_6.put("target_value", (Object)this.mWorkoutStepMesgList.get(var4_5).getTargetValue());
                    }
                    break block55;
lbl49:
                    // 1 sources

                    if (var6_7 == WktStepDuration.Distance) {
                        if (this.mWorkoutStepMesgList.get(var4_5).getDurationDistance() != null) {
                            var5_6.put("duration_distance", (double)((float)((double)this.mWorkoutStepMesgList.get(var4_5).getDurationDistance().floatValue() / 100.0)));
                        }
                        if (var8_9 == WktStepTarget.HEART_RATE) {
                            if (this.mWorkoutStepMesgList.get(var4_5).getTargetValue() != null) {
                                var5_6.put("target_hr_zone", (Object)this.mWorkoutStepMesgList.get(var4_5).getTargetHrZone());
                            }
                        } else if (this.mWorkoutStepMesgList.get(var4_5).getTargetValue() != null) {
                            var5_6.put("target_value", (Object)this.mWorkoutStepMesgList.get(var4_5).getTargetValue());
                        }
                    } else if (var6_7 == WktStepDuration.REPEAT_UNTIL_STEPS_CMPLT) {
                        if (this.mWorkoutStepMesgList.get(var4_5).getDurationStep() != null) {
                            var5_6.put("duration_step", (Object)this.mWorkoutStepMesgList.get(var4_5).getDurationStep());
                        }
                        if (this.mWorkoutStepMesgList.get(var4_5).getRepeatSteps() != null) {
                            var5_6.put("repeat_steps", (Object)this.mWorkoutStepMesgList.get(var4_5).getRepeatSteps());
                        }
                    }
                }
                if (var8_9 != WktStepTarget.INVALID) {
                    if (var8_9 != WktStepTarget.Power) {
                        if (var8_9 == WktStepTarget.HEART_RATE) {
                            if (this.mWorkoutStepMesgList.get(var4_5).getCustomTargetHeartRateLow() != null) {
                                var5_6.put("custom_target_heart_rate_low", (Object)this.mWorkoutStepMesgList.get(var4_5).getCustomTargetHeartRateLow());
                            }
                            if (this.mWorkoutStepMesgList.get(var4_5).getCustomTargetHeartRateHigh() != null) {
                                var5_6.put("custom_target_heart_rate_high", (Object)this.mWorkoutStepMesgList.get(var4_5).getCustomTargetHeartRateHigh());
                            }
                        } else if (var8_9 == WktStepTarget.Speed) {
                            if (this.mWorkoutStepMesgList.get(var4_5).getCustomTargetSpeedLow() != null) {
                                var5_6.put("custom_target_speed_low", (double)this.mWorkoutStepMesgList.get(var4_5).getCustomTargetSpeedLow().floatValue() / 1000.0);
                            }
                            if (this.mWorkoutStepMesgList.get(var4_5).getCustomTargetSpeedHigh() != null) {
                                var5_6.put("custom_target_speed_high", (double)this.mWorkoutStepMesgList.get(var4_5).getCustomTargetSpeedHigh().floatValue() / 1000.0);
                            }
                        } else if (var8_9 == WktStepTarget.Cadence) {
                            if (this.mWorkoutStepMesgList.get(var4_5).getCustomTargetCadenceLow() != null) {
                                var5_6.put("custom_target_cadence_low", (Object)this.mWorkoutStepMesgList.get(var4_5).getCustomTargetCadenceLow());
                            }
                            if (this.mWorkoutStepMesgList.get(var4_5).getCustomTargetCadenceHigh() != null) {
                                var5_6.put("custom_target_cadence_high", (Object)this.mWorkoutStepMesgList.get(var4_5).getCustomTargetCadenceHigh());
                            }
                        } else {
                            if (this.mWorkoutStepMesgList.get(var4_5).getTargetValue() != null) {
                                var5_6.put("target_value", (Object)this.mWorkoutStepMesgList.get(var4_5).getTargetValue());
                            }
                            if (this.mWorkoutStepMesgList.get(var4_5).getCustomTargetValueLow() != null) {
                                var5_6.put("custom_target_value_low", (Object)this.mWorkoutStepMesgList.get(var4_5).getCustomTargetValueLow());
                            }
                            if (this.mWorkoutStepMesgList.get(var4_5).getCustomTargetValueHigh() != null) {
                                var5_6.put("custom_target_value_high", (Object)this.mWorkoutStepMesgList.get(var4_5).getCustomTargetValueHigh());
                            }
                        }
                    } else if (var8_9 == WktStepTarget.Power) {
                        if (this.mWorkoutStepMesgList.get(var4_5).getTargetPowerZone() != null) {
                            var5_6.put("target_power_zone", (Object)this.mWorkoutStepMesgList.get(var4_5).getTargetPowerZone());
                        }
                        if (this.mWorkoutStepMesgList.get(var4_5).getCustomTargetPowerLow() != null) {
                            var5_6.put("custom_target_power_low", (Object)this.mWorkoutStepMesgList.get(var4_5).getCustomTargetPowerLow());
                        }
                        if (this.mWorkoutStepMesgList.get(var4_5).getCustomTargetPowerHigh() != null) {
                            var5_6.put("custom_target_power_high", (Object)this.mWorkoutStepMesgList.get(var4_5).getCustomTargetPowerHigh());
                        }
                    }
                }
                if (this.mWorkoutStepMesgList.get(var4_5).getMessageIndex() != null) {
                    var5_6.put("message_index", (Object)this.mWorkoutStepMesgList.get(var4_5).getMessageIndex());
                }
                if (this.mWorkoutStepMesgList.get(var4_5).getDurationType() != null) {
                    var5_6.put("duration_type", (Object)BrytonWorkout.getWktStepDurationStringValue(var6_7));
                }
                if (var6_7 == WktStepDuration.Time || var6_7 == WktStepDuration.Distance || var6_7 == WktStepDuration.OPEN) {
                    if (var6_7 != WktStepDuration.OPEN && this.mWorkoutStepMesgList.get(var4_5).getTargetType() != null) {
                        var5_6.put("target_type", (Object)BrytonWorkout.getWktStepTargetStringValue(this.mWorkoutStepMesgList.get(var4_5).getTargetType()));
                    }
                    if (this.mWorkoutStepMesgList.get(var4_5).getIntensity() != null) {
                        var5_6.put("intensity", (Object)this.intensityToString(this.mWorkoutStepMesgList.get(var4_5).getIntensity()));
                    }
                }
                var2_3.put((Object)var5_6);
                continue;
            }
            try {
                var1_1.put("workout_steps", (Object)var2_3);
            }
            catch (JSONException var1_2) {
                var1_2.printStackTrace();
            }
        }
    }

    public boolean decode(JSONObject jSONObject) {
        MyListener myListener;
        FileInputStream fileInputStream;
        if (!new java.io.File(this.fitFileName).exists()) {
            Log.d((String)"Grad Debug", (String)"decode() fit file no exist.");
            return false;
        }
        try {
            fileInputStream = new FileInputStream(this.fitFileName);
            myListener = new MyListener();
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error opening file ");
            stringBuilder.append(this.fitFileName);
            stringBuilder.append(" [2]");
            throw new RuntimeException(stringBuilder.toString());
        }
        this.decode = new Decode();
        MesgBroadcaster mesgBroadcaster = new MesgBroadcaster(this.decode);
        mesgBroadcaster.addListener((FileIdMesgListener)myListener);
        mesgBroadcaster.addListener((WorkoutMesgListener)myListener);
        mesgBroadcaster.addListener((WorkoutStepMesgListener)myListener);
        try {
            mesgBroadcaster.run((InputStream)fileInputStream);
        }
        catch (FitRuntimeException fitRuntimeException) {
            System.err.print("Exception decoding file: ");
            System.err.println(fitRuntimeException.getMessage());
            try {
                fileInputStream.close();
                return false;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        try {
            fileInputStream.close();
            this.workout_get(jSONObject);
            this.workout_steps_get(jSONObject);
            this.manufacturer_id_get(jSONObject);
            this.type_get(jSONObject);
            this.time_create_get(jSONObject);
            this.release();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        mesgBroadcaster.clear();
        Runtime.getRuntime().gc();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encode() {
        FileEncoder fileEncoder;
        try {
            java.io.File file = new java.io.File(this.fitFileName);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            this.encode = fileEncoder = new FileEncoder(file, Fit.ProtocolVersion.V1_0);
        }
        catch (IOException iOException) {
            System.err.println("File create failed!");
            return;
        }
        catch (FitRuntimeException fitRuntimeException) {
            System.err.println("Error opening file BrytonActivity.fit");
            return;
        }
        fileEncoder.write((Mesg)this.mFileIdMesg);
        this.encode.writeForWorkout((Mesg)this.mWorkoutMesg);
        for (int i = 0; i < this.mWorkoutStepMesgEncodeList.size(); ++i) {
            this.encode.writeForWorkout((Mesg)this.mWorkoutStepMesgEncodeList.get(i));
        }
        try {
            this.encode.close();
            System.out.println("Encoded FIT file Workout.fit.");
            this.release();
        }
        catch (FitRuntimeException fitRuntimeException) {
            System.err.println("Error closing encode.");
            return;
        }
        Log.d((String)"Grad Debug", (String)"Bryton Workout encode() is complete.");
    }

    public void encode(JSONObject jSONObject) {
        this.fileIdMesgFind(jSONObject);
        this.workoutMesgFind(jSONObject);
        this.workoutStepMesgFind(jSONObject);
        this.encode();
    }

    public void encodeFileSet(String string2) {
        this.fitFileName = string2;
    }

    private class MyListener
    implements FileIdMesgListener,
    WorkoutMesgListener,
    WorkoutStepMesgListener {
        private MyListener() {
        }

        public void onMesg(FileIdMesg fileIdMesg) {
            BrytonWorkout.this.mFileIdMesg = fileIdMesg;
        }

        public void onMesg(WorkoutMesg workoutMesg) {
            BrytonWorkout.this.mWorkoutMesg = workoutMesg;
        }

        public void onMesg(WorkoutStepMesg workoutStepMesg) {
            BrytonWorkout.this.mWorkoutStepMesgList.add(workoutStepMesg);
            if (workoutStepMesg.getDurationTime() != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("getDurationTime = ");
                stringBuilder.append(String.valueOf(workoutStepMesg.getDurationTime()));
                Log.d((String)"Grad Debug", (String)stringBuilder.toString());
            }
        }
    }
}

