/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.fwupdate;

import android.text.TextUtils;
import android.util.Log;
import com.brytonsport.active.fwupdate.GetFileURL;
import com.brytonsport.active.fwupdate.JIniFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class UpdateFW {
    private static final String TAG = "DickDebug";
    int DOWNLOAD_FIRMWARE = 1;
    int DOWNLOAD_INI = 0;
    public String DownloadURL_LANG = "https://corp.brytonsport.com/lang/";
    public String DownloadUrl_DEVICE = "https://corp.brytonsport.com/device/";
    public String Rider320_Lang = "";
    DEVICEINFO deviceInfo;
    public String dirPath = "";
    ArrayList<String> mDownloadUrl;
    ArrayList<String> mFwParts = new ArrayList();
    ArrayList<String> mIniDownloadUrl;
    ArrayList<String> mIniFiles;
    private OnUpdateStateListener onUpdateStateListener;
    SERVERINFO serverInfo;

    public UpdateFW(OnUpdateStateListener onUpdateStateListener) {
        this.mDownloadUrl = new ArrayList();
        this.mIniFiles = new ArrayList();
        this.mIniDownloadUrl = new ArrayList();
        this.deviceInfo = new DEVICEINFO();
        this.serverInfo = new SERVERINFO();
        this.onUpdateStateListener = onUpdateStateListener;
    }

    private void getReleaseIniFormServer(String charSequence, String string2) {
        CharSequence charSequence2 = new StringBuilder();
        charSequence2.append(this.dirPath);
        charSequence2.append(File.separator);
        charSequence2.append(string2);
        charSequence2.append(File.separator);
        charSequence2.append("release.ini");
        charSequence2 = charSequence2.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.DownloadUrl_DEVICE);
        stringBuilder.append(((String)charSequence).toLowerCase());
        stringBuilder.append(File.separator);
        stringBuilder.append("release.ini");
        charSequence = stringBuilder.toString();
        this.mIniDownloadUrl.add((String)charSequence);
        this.mIniFiles.add((String)charSequence2);
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(this.DownloadUrl_DEVICE);
        ((StringBuilder)charSequence).append("AllProjectsImage.rel");
        charSequence = ((StringBuilder)charSequence).toString();
        this.mIniDownloadUrl.add((String)charSequence);
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(this.dirPath);
        ((StringBuilder)charSequence).append(File.separator);
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(File.separator);
        ((StringBuilder)charSequence).append("AllProjectsImage.rel");
        charSequence = ((StringBuilder)charSequence).toString();
        this.mIniFiles.add((String)charSequence);
        new GetFileURL(this).DownloadMultiFile(this.mIniDownloadUrl, this.mIniFiles, this.DOWNLOAD_INI);
    }

    public void DownloadMultiCallBack(int n, boolean bl) {
        if (n == this.DOWNLOAD_INI) {
            this.checkDownloadAllProjectImageINI();
            this.checkDownloadReleaseINI();
        } else if (n == this.DOWNLOAD_FIRMWARE) {
            if (bl) {
                Log.d((String)TAG, (String)"Download bin size is zero");
                this.NotifyFirmwareStatus(UPDATEFW.No_Files_Update);
            } else {
                Log.d((String)TAG, (String)"Download bin finished");
                this.NotifyFirmwareStatus(UPDATEFW.Download_Files_Finished);
            }
        }
    }

    void DownloadMultiFiles() {
        new GetFileURL(this).DownloadMultiFile(this.mDownloadUrl, this.mFwParts, this.DOWNLOAD_FIRMWARE);
    }

    public void NotifyFirmwareStatus(UPDATEFW uPDATEFW) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append("NotifyFirmwareStatus: state = ");
        ((StringBuilder)object).append((Object)uPDATEFW);
        Log.d((String)TAG, (String)((StringBuilder)object).toString());
        object = this.onUpdateStateListener;
        if (object != null) {
            object.fwUpdateState(uPDATEFW);
        }
    }

    boolean VersionCompareWithR(String string2, String string3) {
        return !TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3) && Integer.valueOf(string2.replace('R', '0')) > Integer.valueOf(string3.replace('R', '0'));
    }

    boolean VersionCompareWithoutR(String string2, String string3) {
        return string2 != null && string3 != null && Integer.valueOf(string2) > Integer.valueOf(string3);
    }

    /*
     * WARNING - combined exceptions agressively - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkDownloadAllProjectImageINI() {
        try {
            Object object = new FileReader(this.mIniFiles.get(1));
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            object = bufferedReader.readLine();
            while (object != null) {
                object = object.split("=|\\.");
                int n = ((String[])object).length;
                for (int i = 0; i < n; ++i) {
                    String string2 = object[i];
                    System.out.println(string2);
                }
                if (object[0].equals(this.deviceInfo.model)) {
                    this.serverInfo.OS = object[1];
                    this.serverInfo.BootLoader = object[2];
                    this.serverInfo.DeviceLang = object[3];
                    this.serverInfo.Bluetooth = object[4];
                    this.serverInfo.TimeZone = object[5];
                    this.serverInfo.NotificationLang = object[6];
                    break;
                }
                object = bufferedReader.readLine();
            }
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void checkDownloadReleaseINI() {
        JIniFile jIniFile = new JIniFile(this.mIniFiles.get(0));
        if (jIniFile.size() != 0) {
            this.serverInfo.OS_Name = jIniFile.ReadString("OS", "Name", "IMG.bin");
            this.serverInfo.OS_Size = jIniFile.ReadInteger("OS", "Size", 0);
            this.serverInfo.BootLoader_Name = jIniFile.ReadString("BootLoader", "Name", "IAP.bin");
            this.serverInfo.BootLoader_Size = jIniFile.ReadInteger("BootLoader", "Size", 0);
            this.serverInfo.DeviceLang_Name = jIniFile.ReadString("DeviceLang", "Name", "DeviceLangs.bin");
            this.serverInfo.DeviceLang_Size = jIniFile.ReadInteger("DeviceLang", "Size", 0);
            this.serverInfo.NotificationLang_Name = jIniFile.ReadString("NotificationLang", "Name", "Langs.bin");
            this.serverInfo.NotificationLang_Size = jIniFile.ReadInteger("NotificationLang", "Size", 0);
            this.serverInfo.TimeZone_Name = jIniFile.ReadString("TimeZone", "Name", "TimeZone.bin");
            this.serverInfo.TimeZone_Size = jIniFile.ReadInteger("TimeZone", "Size", 0);
            this.serverInfo.Bluetooth_Name = jIniFile.ReadString("Bluetooth", "Name", "Nordic.bin");
            this.serverInfo.Bluetooth_Size = jIniFile.ReadInteger("Bluetooth", "Size", 0);
            this.combineServerVersionAndCallback(this.serverInfo);
            this.getUpdateParts();
            if (this.mFwParts.size() != 0) {
                this.DownloadMultiFiles();
            } else {
                this.NotifyFirmwareStatus(UPDATEFW.No_Files_Update);
            }
        } else {
            this.NotifyFirmwareStatus(UPDATEFW.Network_Fail);
        }
    }

    public void checkVersion(String string2, String string3) {
        this.getReleaseIniFormServer(string2, string3);
        Log.d((String)TAG, (String)"getReleaseIniFormServer");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void combineServerVersionAndCallback(SERVERINFO object) {
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append("%s");
        ((StringBuilder)object2).append(".");
        ((StringBuilder)object2).append("%s");
        ((StringBuilder)object2).append(".");
        ((StringBuilder)object2).append("%s");
        ((StringBuilder)object2).append(".");
        ((StringBuilder)object2).append("%s");
        ((StringBuilder)object2).append(".");
        ((StringBuilder)object2).append("%s");
        ((StringBuilder)object2).append(".");
        ((StringBuilder)object2).append("%s");
        String string2 = ((StringBuilder)object2).toString();
        try {
            boolean bl = ((SERVERINFO)object).OS.isEmpty();
            String string3 = "0";
            object2 = bl ? "0" : ((SERVERINFO)object).OS.substring(1);
            String string4 = String.format("%03d", Integer.valueOf((String)object2));
            object2 = ((SERVERINFO)object).BootLoader.isEmpty() ? string3 : ((SERVERINFO)object).BootLoader.substring(1);
            object = String.format(string2, string4, String.format("%03d", Integer.valueOf((String)object2)), String.format("%04d", Integer.valueOf(((SERVERINFO)object).DeviceLang)), String.format("%02d", Integer.valueOf(((SERVERINFO)object).Bluetooth)), String.format("%03d", Integer.valueOf(((SERVERINFO)object).TimeZone)), String.format("%03d", Integer.valueOf(((SERVERINFO)object).NotificationLang)));
        }
        catch (Exception exception) {
            object = "";
        }
        object2 = this.onUpdateStateListener;
        if (object2 != null) {
            object2.latestVersion((String)object);
        }
    }

    void createFolder(String fileArray) {
        StringBuilder comparable2 = new StringBuilder();
        comparable2.append(this.dirPath);
        comparable2.append(File.separator);
        comparable2.append((String)fileArray);
        fileArray = new File(comparable2.toString());
        if (!((File)fileArray).exists()) {
            ((File)fileArray).mkdirs();
        } else {
            for (File file : ((File)fileArray).listFiles()) {
                if (file.isDirectory()) continue;
                file.delete();
            }
        }
    }

    public void getUUID(String string2) {
        this.deviceInfo.uuid = string2;
    }

    void getUpdateParts() {
        CharSequence charSequence;
        CharSequence charSequence2 = this.deviceInfo.model;
        CharSequence charSequence3 = new StringBuilder();
        charSequence3.append(this.DownloadUrl_DEVICE);
        charSequence3.append(((String)charSequence2).toLowerCase());
        charSequence3.append(File.separator);
        charSequence3 = charSequence3.toString();
        CharSequence charSequence4 = new StringBuilder();
        ((StringBuilder)charSequence4).append(this.DownloadURL_LANG);
        ((StringBuilder)charSequence4).append((String)charSequence2);
        ((StringBuilder)charSequence4).append(File.separator);
        ((StringBuilder)charSequence4).append(this.serverInfo.DeviceLang);
        ((StringBuilder)charSequence4).append(File.separator);
        CharSequence charSequence5 = ((StringBuilder)charSequence4).toString();
        charSequence4 = new StringBuilder();
        ((StringBuilder)charSequence4).append(this.dirPath);
        ((StringBuilder)charSequence4).append(File.separator);
        ((StringBuilder)charSequence4).append(this.deviceInfo.uuid);
        ((StringBuilder)charSequence4).append(File.separator);
        charSequence4 = ((StringBuilder)charSequence4).toString();
        if (this.VersionCompareWithR(this.serverInfo.OS, this.deviceInfo.OS)) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence4);
            ((StringBuilder)charSequence).append(this.serverInfo.OS_Name.toLowerCase());
            charSequence = ((StringBuilder)charSequence).toString();
            this.mFwParts.add((String)charSequence);
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence3);
            ((StringBuilder)charSequence).append(this.serverInfo.OS_Name.toLowerCase());
            charSequence = ((StringBuilder)charSequence).toString();
            this.mDownloadUrl.add((String)charSequence);
        }
        if (this.VersionCompareWithoutR(this.serverInfo.BootLoader, this.deviceInfo.BootLoader)) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence4);
            ((StringBuilder)charSequence).append(this.serverInfo.BootLoader_Name.toLowerCase());
            charSequence = ((StringBuilder)charSequence).toString();
            this.mFwParts.add((String)charSequence);
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence3);
            ((StringBuilder)charSequence).append(this.serverInfo.BootLoader_Name.toLowerCase());
            charSequence = ((StringBuilder)charSequence).toString();
            this.mDownloadUrl.add((String)charSequence);
        }
        if (this.VersionCompareWithoutR(this.serverInfo.Bluetooth, this.deviceInfo.Bluetooth)) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence4);
            ((StringBuilder)charSequence).append(this.serverInfo.Bluetooth_Name.toLowerCase());
            charSequence = ((StringBuilder)charSequence).toString();
            this.mFwParts.add((String)charSequence);
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence3);
            ((StringBuilder)charSequence).append(this.serverInfo.Bluetooth_Name.toLowerCase());
            charSequence = ((StringBuilder)charSequence).toString();
            this.mDownloadUrl.add((String)charSequence);
        }
        if (this.VersionCompareWithoutR(this.serverInfo.DeviceLang, this.deviceInfo.DeviceLang)) {
            if (((String)charSequence2).equals("Rider320")) {
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append((String)charSequence4);
                ((StringBuilder)charSequence2).append(this.Rider320_Lang);
                charSequence2 = ((StringBuilder)charSequence2).toString();
                this.mFwParts.add((String)charSequence2);
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append((String)charSequence5);
                ((StringBuilder)charSequence2).append(this.Rider320_Lang);
                charSequence5 = ((StringBuilder)charSequence2).toString();
                this.mDownloadUrl.add((String)charSequence5);
            } else {
                charSequence5 = new StringBuilder();
                ((StringBuilder)charSequence5).append((String)charSequence4);
                ((StringBuilder)charSequence5).append(this.serverInfo.DeviceLang_Name.toLowerCase());
                charSequence5 = ((StringBuilder)charSequence5).toString();
                this.mFwParts.add((String)charSequence5);
                charSequence5 = new StringBuilder();
                ((StringBuilder)charSequence5).append((String)charSequence3);
                ((StringBuilder)charSequence5).append(this.serverInfo.DeviceLang_Name.toLowerCase());
                charSequence5 = ((StringBuilder)charSequence5).toString();
                this.mDownloadUrl.add((String)charSequence5);
            }
        }
        if (this.VersionCompareWithoutR(this.serverInfo.NotificationLang, this.deviceInfo.NotificationLang)) {
            charSequence5 = new StringBuilder();
            ((StringBuilder)charSequence5).append((String)charSequence4);
            ((StringBuilder)charSequence5).append(this.serverInfo.NotificationLang_Name.toLowerCase());
            charSequence5 = ((StringBuilder)charSequence5).toString();
            this.mFwParts.add((String)charSequence5);
            charSequence5 = new StringBuilder();
            ((StringBuilder)charSequence5).append((String)charSequence3);
            ((StringBuilder)charSequence5).append(this.serverInfo.NotificationLang_Name.toLowerCase());
            charSequence5 = ((StringBuilder)charSequence5).toString();
            this.mDownloadUrl.add((String)charSequence5);
        }
        if (this.VersionCompareWithoutR(this.serverInfo.TimeZone, this.deviceInfo.TimeZone)) {
            charSequence5 = new StringBuilder();
            ((StringBuilder)charSequence5).append((String)charSequence4);
            ((StringBuilder)charSequence5).append(this.serverInfo.TimeZone_Name.toLowerCase());
            charSequence4 = ((StringBuilder)charSequence5).toString();
            this.mFwParts.add((String)charSequence4);
            charSequence4 = new StringBuilder();
            ((StringBuilder)charSequence4).append((String)charSequence3);
            ((StringBuilder)charSequence4).append(this.serverInfo.TimeZone_Name.toLowerCase());
            charSequence3 = ((StringBuilder)charSequence4).toString();
            this.mDownloadUrl.add((String)charSequence3);
        }
        for (int i = 0; i < this.mFwParts.size(); ++i) {
            Log.d((String)TAG, (String)this.mDownloadUrl.get(i));
            Log.d((String)TAG, (String)this.mFwParts.get(i));
            Log.d((String)TAG, (String)"--");
        }
    }

    public void getdevVer(String string2) {
        String[] stringArray = string2.split("\\.");
        this.deviceInfo.OS = stringArray[0];
        this.deviceInfo.BootLoader = stringArray[1];
        this.deviceInfo.DeviceLang = stringArray[2];
        this.deviceInfo.Bluetooth = stringArray[3];
        this.deviceInfo.TimeZone = stringArray[4];
        this.deviceInfo.NotificationLang = stringArray[5];
        this.deviceInfo.devVer = string2;
    }

    public void getmodel(String stringArray) {
        stringArray = stringArray.split("\\.|\\,");
        this.deviceInfo.model = stringArray[0];
        this.deviceInfo.CAP = stringArray[1];
    }

    public void setDeviceInfoString(String stringArray) {
        stringArray = stringArray.split("UD|.IV|.MN");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            System.out.println(string2);
        }
        this.getUUID(stringArray[1]);
        this.getdevVer(stringArray[2]);
        this.getmodel(stringArray[3]);
        this.mFwParts.clear();
        this.mDownloadUrl.clear();
        this.mIniFiles.clear();
        this.mIniDownloadUrl.clear();
        this.createFolder(this.deviceInfo.uuid);
        this.checkVersion(this.deviceInfo.model, this.deviceInfo.uuid);
    }

    class DEVICEINFO {
        String Bluetooth;
        String BootLoader;
        String CAP;
        String DeviceLang;
        String NotificationLang;
        String OS;
        String TimeZone;
        String devVer;
        String model;
        String uuid;

        DEVICEINFO() {
        }
    }

    public static interface OnUpdateStateListener {
        public void fwUpdateState(UPDATEFW var1);

        public void latestVersion(String var1);
    }

    class SERVERINFO {
        String Bluetooth;
        String Bluetooth_Name;
        int Bluetooth_Size;
        String BootLoader;
        String BootLoader_Name;
        int BootLoader_Size;
        String DeviceLang;
        String DeviceLang_Name;
        int DeviceLang_Size;
        String NotificationLang;
        String NotificationLang_Name;
        int NotificationLang_Size;
        String OS;
        String OS_Name;
        int OS_Size;
        String TimeZone;
        String TimeZone_Name;
        int TimeZone_Size;

        SERVERINFO() {
        }
    }

    public static final class UPDATEFW
    extends Enum<UPDATEFW> {
        private static final /* synthetic */ UPDATEFW[] $VALUES;
        public static final /* enum */ UPDATEFW Download_Files_Finished;
        public static final /* enum */ UPDATEFW Network_Fail;
        public static final /* enum */ UPDATEFW No_Files_Update;

        static {
            UPDATEFW uPDATEFW;
            UPDATEFW uPDATEFW2;
            UPDATEFW uPDATEFW3;
            No_Files_Update = uPDATEFW3 = new UPDATEFW();
            Network_Fail = uPDATEFW2 = new UPDATEFW();
            Download_Files_Finished = uPDATEFW = new UPDATEFW();
            $VALUES = new UPDATEFW[]{uPDATEFW3, uPDATEFW2, uPDATEFW};
        }

        public static UPDATEFW valueOf(String string2) {
            return Enum.valueOf(UPDATEFW.class, string2);
        }

        public static UPDATEFW[] values() {
            return (UPDATEFW[])$VALUES.clone();
        }
    }
}

